/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.util.Vector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PickList
extends Composite
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Table availableTable;
    private Table selectedTable;
    private Button addButton;
    private Button addAllButton;
    private Button removeButton;
    private Button removeAllButton;
    private Vector<ModifyListener> modifyListeners;
    private int leftButtonNumerator = 45;
    private int rightButtonNumerator = 55;
    private final int marginNumerator = 1;
    private final int buttonMargin = 5;
    private boolean isReadOnly;

    public PickList(Composite parent, int style, boolean isReadOnly) {
        super(parent, 0);
        this.isReadOnly = isReadOnly;
        this.setLayout((Layout)new FormLayout());
        this.availableTable = new Table((Composite)this, style);
        FormData fd = new FormData();
        fd.height = 200;
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(this.leftButtonNumerator - 1);
        this.availableTable.setLayoutData((Object)fd);
        this.selectedTable = new Table((Composite)this, style);
        fd = new FormData();
        fd.height = 200;
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment(this.rightButtonNumerator + 1);
        fd.right = new FormAttachment(100);
        this.selectedTable.setLayoutData((Object)fd);
        this.addButton = new Button((Composite)this, 8);
        this.addButton.setText(">");
        this.addButton.setEnabled(false);
        this.addButton.setToolTipText(WorkbenchModelBundle.getLabel().getString("WB009"));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.availableTable, 20, 128);
        fd.bottom = null;
        fd.left = new FormAttachment(this.leftButtonNumerator + 1);
        fd.right = new FormAttachment(this.rightButtonNumerator - 1);
        this.addButton.setLayoutData((Object)fd);
        this.removeButton = new Button((Composite)this, 8);
        this.removeButton.setText("<");
        this.removeButton.setEnabled(false);
        this.removeButton.setToolTipText(WorkbenchModelBundle.getLabel().getString("WB009A"));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.addButton, 5);
        fd.bottom = null;
        fd.left = new FormAttachment(this.leftButtonNumerator + 1);
        fd.right = new FormAttachment(this.rightButtonNumerator - 1);
        this.removeButton.setLayoutData((Object)fd);
        this.addAllButton = new Button((Composite)this, 8);
        this.addAllButton.setText(">>");
        this.addAllButton.setToolTipText(WorkbenchModelBundle.getLabel().getString("WB050A"));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.removeButton, 15);
        fd.bottom = null;
        fd.left = new FormAttachment(this.leftButtonNumerator + 1);
        fd.right = new FormAttachment(this.rightButtonNumerator - 1);
        this.addAllButton.setLayoutData((Object)fd);
        this.removeAllButton = new Button((Composite)this, 8);
        this.removeAllButton.setText("<<");
        this.removeAllButton.setToolTipText(WorkbenchModelBundle.getLabel().getString("WB050B"));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.addAllButton, 5);
        fd.bottom = null;
        fd.left = new FormAttachment(this.leftButtonNumerator + 1);
        fd.right = new FormAttachment(this.rightButtonNumerator - 1);
        this.removeAllButton.setLayoutData((Object)fd);
        if (isReadOnly) {
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        }
        this.addListeners();
    }

    public PickList(Composite parent, int style, boolean isReadOnly, String availText, String selectedText) {
        super(parent, 0);
        this.isReadOnly = isReadOnly;
        this.setLayout((Layout)new FormLayout());
        Label availLabel = new Label((Composite)this, 0);
        availLabel.setText(availText);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(this.leftButtonNumerator - 1);
        availLabel.setLayoutData((Object)fd);
        Label selectedLabel = new Label((Composite)this, 0);
        selectedLabel.setText(selectedText);
        fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.left = new FormAttachment(this.rightButtonNumerator + 1);
        fd.right = new FormAttachment(100);
        selectedLabel.setLayoutData((Object)fd);
        this.availableTable = new Table((Composite)this, style);
        fd = new FormData();
        fd.height = 200;
        fd.top = new FormAttachment((Control)availLabel);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(this.leftButtonNumerator - 1);
        this.availableTable.setLayoutData((Object)fd);
        this.selectedTable = new Table((Composite)this, style);
        fd = new FormData();
        fd.height = 200;
        fd.top = new FormAttachment((Control)selectedLabel);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment(this.rightButtonNumerator + 1);
        fd.right = new FormAttachment(100);
        this.selectedTable.setLayoutData((Object)fd);
        this.addButton = new Button((Composite)this, 8);
        this.addButton.setText(">");
        this.addButton.setEnabled(false);
        this.addButton.setToolTipText(WorkbenchModelBundle.getLabel().getString("WB009"));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.availableTable, 20, 128);
        fd.bottom = null;
        fd.left = new FormAttachment(this.leftButtonNumerator + 1);
        fd.right = new FormAttachment(this.rightButtonNumerator - 1);
        this.addButton.setLayoutData((Object)fd);
        this.removeButton = new Button((Composite)this, 8);
        this.removeButton.setText("<");
        this.removeButton.setEnabled(false);
        this.removeButton.setToolTipText(WorkbenchModelBundle.getLabel().getString("WB009A"));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.addButton, 5);
        fd.bottom = null;
        fd.left = new FormAttachment(this.leftButtonNumerator + 1);
        fd.right = new FormAttachment(this.rightButtonNumerator - 1);
        this.removeButton.setLayoutData((Object)fd);
        this.addAllButton = new Button((Composite)this, 8);
        this.addAllButton.setText(">>");
        this.addAllButton.setToolTipText(WorkbenchModelBundle.getLabel().getString("WB050A"));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.removeButton, 15);
        fd.bottom = null;
        fd.left = new FormAttachment(this.leftButtonNumerator + 1);
        fd.right = new FormAttachment(this.rightButtonNumerator - 1);
        this.addAllButton.setLayoutData((Object)fd);
        this.removeAllButton = new Button((Composite)this, 8);
        this.removeAllButton.setText("<<");
        this.removeAllButton.setToolTipText(WorkbenchModelBundle.getLabel().getString("WB050B"));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.addAllButton, 5);
        fd.bottom = null;
        fd.left = new FormAttachment(this.leftButtonNumerator + 1);
        fd.right = new FormAttachment(this.rightButtonNumerator - 1);
        this.removeAllButton.setLayoutData((Object)fd);
        this.setColumns(new String[]{availText, selectedText});
        if (isReadOnly) {
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        }
        this.addListeners();
    }

    private void addListeners() {
        this.availableTable.addSelectionListener((SelectionListener)this);
        this.selectedTable.addSelectionListener((SelectionListener)this);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.addAllButton.addSelectionListener((SelectionListener)this);
        this.removeAllButton.addSelectionListener((SelectionListener)this);
    }

    public void setColumns(String[] columnLabels) {
        int i = 0;
        while (i < columnLabels.length) {
            this.setColumn(this.availableTable, columnLabels[i]);
            this.setColumn(this.selectedTable, columnLabels[i]);
            ++i;
        }
    }

    public void setAvailableColumnHeader(String columnLabel) {
        this.setColumn(this.availableTable, columnLabel);
    }

    public void setSelectedColumnHeader(String columnLabel) {
        this.setColumn(this.selectedTable, columnLabel);
    }

    private void setColumn(Table table, String columnLabel) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
    }

    public void setAvailableItems(Object[][] itemArray) {
        this.availableTable.removeAll();
        int numCols = this.availableTable.getColumnCount();
        int i = 0;
        while (i < itemArray.length) {
            TableItem newTableItem = new TableItem(this.availableTable, 0);
            int j = 0;
            while (j < itemArray[i].length) {
                if (j < numCols) {
                    newTableItem.setText(j, itemArray[i][j].toString());
                } else {
                    newTableItem.setData(Integer.toString(j), itemArray[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public void setSelectedItems(Object[][] itemArray) {
        this.selectedTable.removeAll();
        int numCols = this.selectedTable.getColumnCount();
        int i = 0;
        while (i < itemArray.length) {
            TableItem newTableItem = new TableItem(this.selectedTable, 0);
            int j = 0;
            while (j < itemArray[i].length) {
                if (j < numCols) {
                    newTableItem.setText(itemArray[i][j].toString());
                } else {
                    newTableItem.setData(Integer.toString(j), itemArray[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public void setLinesVisible(boolean value) {
        this.availableTable.setLinesVisible(value);
        this.selectedTable.setLinesVisible(value);
    }

    public void setHeaderVisible(boolean value) {
        this.availableTable.setHeaderVisible(value);
        this.selectedTable.setHeaderVisible(value);
    }

    public void pack() {
        this.packAvailableTable();
        this.packSelectedTable();
        super.pack();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.availableTable || e.widget == this.selectedTable) {
            this.enableButtons();
        } else {
            if (e.widget == this.addButton) {
                this.handleAdd(false);
                this.enableButtons();
            } else if (e.widget == this.removeButton) {
                this.handleRemove(false);
                this.enableButtons();
            } else if (e.widget == this.addAllButton) {
                this.handleAdd(true);
                this.enableButtons();
            } else if (e.widget == this.removeAllButton) {
                this.handleRemove(true);
                this.enableButtons();
            }
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        if (this.modifyListeners != null && this.modifyListeners.size() > 0) {
            Event event = new Event();
            event.widget = this;
            ModifyEvent e = new ModifyEvent(event);
            int i = 0;
            while (i < this.modifyListeners.size()) {
                this.modifyListeners.get(i).modifyText(e);
                ++i;
            }
        }
    }

    private void handleAdd(boolean addAll) {
        if (addAll) {
            int numItems = this.availableTable.getItemCount();
            this.availableTable.setSelection(0, numItems - 1);
        }
        int[] selIndices = this.availableTable.getSelectionIndices();
        int numCols = this.availableTable.getColumnCount();
        int i = 0;
        while (i < selIndices.length) {
            TableItem oldItem = this.availableTable.getItem(selIndices[i]);
            TableItem newItem = new TableItem(this.selectedTable, 0);
            int j = 0;
            while (j < numCols) {
                newItem.setText(j, oldItem.getText(j));
                ++j;
            }
            boolean dataNotNull = true;
            while (dataNotNull) {
                Object currData = oldItem.getData(Integer.toString(j));
                if (currData == null) {
                    dataNotNull = false;
                    continue;
                }
                newItem.setData(Integer.toString(j), currData);
                ++j;
            }
            ++i;
        }
        this.packSelectedTable();
        this.availableTable.remove(selIndices);
    }

    public void handleRemove(boolean removeAll) {
        if (removeAll) {
            int numItems = this.selectedTable.getItemCount();
            this.selectedTable.setSelection(0, numItems - 1);
        }
        int[] selIndices = this.selectedTable.getSelectionIndices();
        int numCols = this.selectedTable.getColumnCount();
        int i = 0;
        while (i < selIndices.length) {
            TableItem oldItem = this.selectedTable.getItem(selIndices[i]);
            TableItem newItem = new TableItem(this.availableTable, 0);
            int j = 0;
            while (j < numCols) {
                newItem.setText(j, oldItem.getText(j));
                ++j;
            }
            boolean dataNotNull = true;
            while (dataNotNull) {
                Object currData = oldItem.getData(Integer.toString(j));
                if (currData == null) {
                    dataNotNull = false;
                    continue;
                }
                newItem.setData(Integer.toString(j), currData);
                ++j;
            }
            ++i;
        }
        this.packAvailableTable();
        this.selectedTable.remove(selIndices);
    }

    public void clearAll() {
        this.availableTable.clearAll();
        this.selectedTable.clearAll();
    }

    public void removeAll() {
        this.availableTable.removeAll();
        this.selectedTable.removeAll();
    }

    public void packSelectedTable() {
        TableColumn[] cols = this.selectedTable.getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].setWidth(this.selectedTable.getSize().x / cols.length);
            ++i;
        }
    }

    public void packAvailableTable() {
        TableColumn[] cols = this.availableTable.getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].setWidth(this.availableTable.getSize().x / cols.length);
            ++i;
        }
    }

    public void refreshAllButtons() {
        int availCount = this.availableTable.getItemCount();
        int selCount = this.selectedTable.getItemCount();
        if (availCount > 0) {
            this.addAllButton.setEnabled(true);
        } else {
            this.addAllButton.setEnabled(false);
        }
        if (selCount > 0) {
            this.removeAllButton.setEnabled(true);
        } else {
            this.removeAllButton.setEnabled(false);
        }
        if (this.isReadOnly) {
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        }
    }

    private void enableButtons() {
        int availSelCount = this.availableTable.getSelectionCount();
        int selSelCount = this.selectedTable.getSelectionCount();
        if (availSelCount > 0) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
        if (selSelCount > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
        if (this.isReadOnly) {
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new Vector();
        }
        this.modifyListeners.add(listener);
    }

    public TableItem[] getSelectedItems() {
        return this.selectedTable.getItems();
    }

    public int getLeftButtonNumerator() {
        return this.leftButtonNumerator;
    }

    public void setLeftButtonNumerator(int leftButtonNumerator) {
        this.leftButtonNumerator = leftButtonNumerator;
    }

    public int getRightButtonNumerator() {
        return this.rightButtonNumerator;
    }

    public void setRightButtonNumerator(int rightButtonNumerator) {
        this.rightButtonNumerator = rightButtonNumerator;
    }

    public int getSelectedTableLeftNumerator() {
        return this.rightButtonNumerator + 1;
    }
}

