/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.utilities.SaxHandler;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MigrateHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public static void mig0to1(InputStream is, DbdModel dbdModel) throws ParserConfigurationException, SAXException, IOException {
        SaxHandler saxHandler = new SaxHandler(dbdModel);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(is, (DefaultHandler)saxHandler);
        MigrateHelper.changeFieldsToSysRelFields(dbdModel);
        dbdModel.setXMLSchemaVersion("1");
    }

    private static void changeFieldsToSysRelFields(DbdModel dbdModel) {
        SegmentModel rootSegment = dbdModel.getRootSegment();
        try {
            MigrateHelper.recursiveUpdateFields(rootSegment);
        }
        catch (ModelException e) {
            logger.error((Throwable)e);
        }
    }

    private static void recursiveUpdateFields(SegmentModel segment) throws ModelException {
        segment.changeFieldsToSysRelFields();
        for (SegmentModel currSegment : segment.getChildSegments()) {
            MigrateHelper.recursiveUpdateFields(currSegment);
        }
    }
}

