/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.utilities.AbstractExpandTableEditor;
import com.ibm.im.ims.workbench.utilities.RowExpansionListener;
import com.ibm.im.ims.workbench.utilities.Utility;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ExpandTable {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Vector<RowExpansionListener> rowExpansionListeners = null;
    private Composite composite;
    private Table table;
    private Button addButton;
    private Button delButton;
    private TableItem addButtonRow;
    private TableItem expandedRow;
    private AbstractExpandTableEditor editor;
    private ScrollBar verticalBar;
    private ScrollBar horizontalBar;
    private Image imageExpanded;
    private Image imageCollapsed;
    private int itemX;
    private int itemHeight;
    private int gridLineWidth;
    private Rectangle recTableBounds;
    private int addButtonRowCount;
    private int expandedRowCount;
    private boolean verticalBarVisible;
    private int verticalBarSelection;
    private boolean horizontalBarVisible;
    private int horizontalBarSelection;
    private int imageWidth = 0;
    private boolean keyEvent;

    public ExpandTable(Composite parent, int style) {
        this.init(parent, style);
    }

    private void init(Composite parent, int style) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FormLayout());
        FormData tableFD = new FormData();
        tableFD.top = new FormAttachment(0, 0);
        tableFD.left = new FormAttachment(0, 0);
        tableFD.right = new FormAttachment(100, 0);
        tableFD.bottom = new FormAttachment(100, 0);
        this.table = new Table(this.composite, style);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)tableFD);
        ImageDescriptor imgDesc = Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("togexpanded"));
        this.imageExpanded = imgDesc.createImage();
        ImageDescriptor imgDesc2 = Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("togcollapsed"));
        this.imageCollapsed = imgDesc2.createImage();
        TableItem item = this.addItem("");
        Rectangle recItem = item.getBounds();
        this.itemX = recItem.x - this.imageCollapsed.getImageData().width;
        this.itemHeight = recItem.height;
        this.gridLineWidth = this.table.getGridLineWidth();
        this.table.remove(this.table.indexOf(item));
        this.verticalBar = this.table.getVerticalBar();
        this.verticalBarVisible = this.verticalBar.isVisible();
        this.verticalBarSelection = this.verticalBar.getSelection();
        this.horizontalBar = this.table.getHorizontalBar();
        this.horizontalBarVisible = this.horizontalBar.isVisible();
        this.horizontalBarSelection = this.horizontalBar.getSelection();
        this.keyEvent = false;
        this.addTableInitListener();
        this.addTableSelectionListener();
        this.addTableKeyListener();
        this.addTableResizeListener();
        this.addTableScrollBarListener();
        this.addTableScrolledListener();
    }

    public void setColumnToolTipText(String[] text) {
        TableColumn[] tabCol = this.table.getColumns();
        int i = 0;
        while (i < tabCol.length) {
            tabCol[i].setToolTipText(text[i]);
            ++i;
        }
    }

    public void removeAddButton() {
        if (this.addButton != null) {
            this.addButton.dispose();
            int i = 0;
            while (i < this.addButtonRowCount - 1) {
                this.table.remove(this.table.indexOf(this.addButtonRow) + 1);
                ++i;
            }
            this.table.remove(this.table.indexOf(this.addButtonRow));
        }
    }

    public void createAddButton(String addButtonText, String delButtonText) {
        if (this.addButton == null && this.delButton == null) {
            this.addButton = new Button(this.composite, 0x1000000);
            this.addButton.setText(addButtonText);
            this.delButton = new Button(this.composite, 0x1000000);
            this.delButton.setText(delButtonText);
            this.setLayout(131072);
            if (this.getItemCount() == 0) {
                this.delButton.setEnabled(false);
            }
            this.layoutChildren();
            this.addAddDelButtonClickListener();
        }
    }

    public void createAddButton(String addButtonText, String delButtonText, int style) {
        if (this.addButton == null && this.delButton == null) {
            this.addButton = new Button(this.composite, 0x1000000);
            this.addButton.setText(addButtonText);
            this.delButton = new Button(this.composite, 0x1000000);
            this.delButton.setText(delButtonText);
            this.setLayout(style);
            if (this.getItemCount() == 0) {
                this.delButton.setEnabled(false);
            }
            this.layoutChildren();
            this.addAddDelButtonClickListener();
        }
    }

    private void setLayout(int style) {
        FormData addButtonFD = new FormData();
        if (style == 16384) {
            addButtonFD.left = new FormAttachment(0, 0);
        } else {
            addButtonFD.right = new FormAttachment((Control)this.delButton, -10);
        }
        addButtonFD.bottom = new FormAttachment(100, -10);
        FormData delButtonFD = new FormData();
        if (style == 16384) {
            delButtonFD.left = new FormAttachment((Control)this.addButton, 10);
        } else {
            delButtonFD.right = new FormAttachment(100, 0);
        }
        delButtonFD.bottom = new FormAttachment(100, -10);
        FormData tableFD = (FormData)this.table.getLayoutData();
        tableFD.bottom = new FormAttachment((Control)this.addButton, -10);
        this.delButton.setLayoutData((Object)delButtonFD);
        this.addButton.setLayoutData((Object)addButtonFD);
        this.table.setLayoutData((Object)tableFD);
    }

    public TableItem addItem(String text) {
        TableItem tableItem;
        if (this.addButtonRow != null) {
            tableItem = this.addItem(text, this.table.indexOf(this.addButtonRow));
        } else {
            tableItem = new TableItem(this.table, 0);
            tableItem.setImage(this.imageCollapsed);
            tableItem.setText(text);
            this.layoutChildren();
        }
        if (this.delButton != null && !this.delButton.isEnabled()) {
            this.delButton.setEnabled(true);
        }
        return tableItem;
    }

    public TableItem addItem(String text, int index) {
        TableItem tableItem = new TableItem(this.table, 0, index);
        tableItem.setImage(0, this.imageCollapsed);
        tableItem.setText(text);
        if (this.delButton != null && !this.delButton.isEnabled()) {
            this.delButton.setEnabled(true);
        }
        this.layoutChildren();
        return tableItem;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getDelButton() {
        return this.delButton;
    }

    public AbstractExpandTableEditor getEditor() {
        return this.editor;
    }

    public Composite getEditorParent() {
        return this.table;
    }

    public TableColumn[] getColumns() {
        return this.table.getColumns();
    }

    public TableItem getItem(int index) {
        if (this.expandedRow != null && index > this.table.indexOf(this.expandedRow)) {
            return this.table.getItem(index + this.expandedRowCount);
        }
        return this.table.getItem(index);
    }

    public int getItemCount() {
        int itemCount = this.expandedRow != null ? this.table.getItemCount() - this.expandedRowCount : this.table.getItemCount();
        return itemCount;
    }

    public TableItem[] getItems() {
        if (this.getItemCount() < 1) {
            return null;
        }
        TableItem[] items = new TableItem[this.getItemCount()];
        int i = 0;
        while (i < this.getItemCount()) {
            items[i] = this.getItem(i);
            ++i;
        }
        return items;
    }

    public Table getTable() {
        return this.table;
    }

    public void setActionBarBackground(Color color) {
        this.composite.setBackground(color);
    }

    public void setColumn(String columnLabel) {
        TableColumn tableColumn = new TableColumn(this.table, 16384);
        tableColumn.setMoveable(false);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
    }

    public void setColumns(String[] columnsLabels) {
        int i = 0;
        while (i < columnsLabels.length) {
            this.setColumn(columnsLabels[i]);
            ++i;
        }
    }

    public void setEditor(AbstractExpandTableEditor editor) {
        this.editor = editor;
        editor.setExpandTable(this);
        if (this.expandedRow != null) {
            this.collapseRow();
            this.expandRow(this.expandedRow);
        } else {
            editor.setVisible(false);
        }
    }

    public void setLayoutData(Object layoutData) {
        this.composite.setLayoutData(layoutData);
    }

    public TableItem addFillerItem() {
        TableItem tableItem = new TableItem(this.table, 0);
        return tableItem;
    }

    public TableItem addFillerItem(int index) {
        TableItem tableItem = new TableItem(this.table, 0, index);
        return tableItem;
    }

    private void collapseRow() {
        if (this.expandedRow != null) {
            int i = 0;
            while (i < this.expandedRowCount) {
                this.table.remove(this.table.indexOf(this.expandedRow) + 1);
                ++i;
            }
            this.editor.setVisible(false);
            this.expandedRow.setImage(0, this.imageCollapsed);
            this.expandedRow = null;
            this.layoutChildren();
        }
    }

    private void expandRow(TableItem item) {
        this.notifyRowExpansionListeners(0);
        if (this.editor != null) {
            Rectangle recTable = this.table.getBounds();
            this.expandedRow = item;
            this.expandedRowCount = (int)Math.ceil((double)this.editor.computeSize((int)recTable.width, (int)-1).y / (double)this.itemHeight);
            int i = 0;
            while (i < this.expandedRowCount) {
                this.addFillerItem(this.table.indexOf(this.expandedRow) + 1);
                ++i;
            }
            this.editor.setVisible(true);
            this.table.setSelection(this.table.indexOf(this.expandedRow));
            this.editor.setEditorData(this.expandedRow);
            this.expandedRow.setImage(0, this.imageExpanded);
            this.layoutChildren();
        }
        this.notifyRowExpansionListeners(1);
    }

    private void layoutChildren() {
        Rectangle recTable = this.table.getBounds();
        if (recTable.width > 0 && this.expandedRow != null) {
            this.layoutEditor();
        }
    }

    private void layoutColumns() {
        Rectangle recTable = this.table.getBounds();
        TableColumn[] tableColumns = this.table.getColumns();
        if (recTable.width > 0 && tableColumns.length > 0) {
            int tableWidth = this.table.getBounds().width;
            int columnWidth = tableWidth / tableColumns.length - this.table.getBorderWidth();
            int i = 0;
            while (i < tableColumns.length) {
                tableColumns[i].setWidth(columnWidth);
                ++i;
            }
        }
    }

    private void layoutEditor() {
        int width;
        Rectangle recTable = this.table.getBounds();
        Rectangle recRow = this.expandedRow.getBounds();
        int x = 0;
        int y = recRow.y + recRow.height + this.gridLineWidth;
        int height = this.itemHeight * this.expandedRowCount + (this.expandedRowCount - 1) * this.gridLineWidth;
        if (this.verticalBarVisible || this.horizontalBarVisible) {
            if (this.horizontalBar.getIncrement() * this.horizontalBar.getMaximum() < recTable.width - this.itemX - this.verticalBar.getSize().x) {
                width = recTable.width - this.itemX;
                if (this.verticalBarVisible) {
                    width -= this.verticalBar.getSize().x;
                }
            } else {
                width = this.horizontalBar.getIncrement() * this.horizontalBar.getMaximum();
            }
        } else {
            width = recTable.width - this.itemX;
        }
        this.editor.setBounds(x, y, width, height);
    }

    private void addTableInitListener() {
        this.table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Rectangle rec;
                ExpandTable.this.recTableBounds = rec = ExpandTable.this.table.getBounds();
                if (rec.width > 0) {
                    ExpandTable.this.layoutColumns();
                    ExpandTable.this.layoutChildren();
                    ExpandTable.this.table.removeControlListener((ControlListener)this);
                }
            }
        });
    }

    private void addTableResizeListener() {
        this.table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Rectangle rec = ExpandTable.this.table.getBounds();
                if (!ExpandTable.this.recTableBounds.equals((Object)rec)) {
                    ExpandTable.this.recTableBounds = rec;
                    ExpandTable.this.layoutChildren();
                }
            }
        });
    }

    private void addTableKeyListener() {
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.keyCode == 0x1000001 || e.keyCode == 0x1000002 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004) && ExpandTable.this.expandedRow != null) {
                    ExpandTable.this.collapseRow();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f' || e.character == '\b') {
                    if (ExpandTable.this.expandedRow != null) {
                        ExpandTable.this.collapseRow();
                    }
                    ExpandTable.this.table.remove(ExpandTable.this.table.getSelectionIndices());
                    ExpandTable.this.layoutChildren();
                } else if (e.keyCode == 0x1000009) {
                    ExpandTable.this.collapseRow();
                    TableItem tableItem = ExpandTable.this.addItem("");
                    ExpandTable.this.expandRow(tableItem);
                    ExpandTable.this.editor.restoreInputDefault();
                    ExpandTable.this.editor.setTableItemData();
                    ExpandTable.this.table.forceFocus();
                }
            }
        });
    }

    private void addTableScrollBarListener() {
        this.table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (ExpandTable.this.verticalBar.isVisible() != ExpandTable.this.verticalBarVisible) {
                    ExpandTable.this.layoutChildren();
                    ExpandTable.this.verticalBarVisible = ExpandTable.this.verticalBar.getVisible();
                    ExpandTable.this.verticalBarSelection = ExpandTable.this.verticalBar.getSelection();
                }
                if (ExpandTable.this.horizontalBar.isVisible() != ExpandTable.this.horizontalBarVisible) {
                    ExpandTable.this.layoutChildren();
                    ExpandTable.this.horizontalBarVisible = ExpandTable.this.horizontalBar.getVisible();
                    ExpandTable.this.horizontalBarSelection = ExpandTable.this.horizontalBar.getSelection();
                }
            }
        });
    }

    private void addTableScrolledListener() {
        this.verticalBar.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ExpandTable.this.verticalBar.getSelection() != ExpandTable.this.verticalBarSelection) {
                    ExpandTable.this.layoutChildren();
                    ExpandTable.this.verticalBarSelection = ExpandTable.this.verticalBar.getSelection();
                }
            }
        });
        this.horizontalBar.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ExpandTable.this.horizontalBar.getSelection() != ExpandTable.this.horizontalBarSelection) {
                    ExpandTable.this.layoutChildren();
                    ExpandTable.this.horizontalBarSelection = ExpandTable.this.horizontalBar.getSelection();
                }
            }
        });
    }

    private void addTableSelectionListener() {
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ExpandTable.this.editor != null && ExpandTable.this.table.getSelectionCount() == 1 && !ExpandTable.this.keyEvent) {
                    if (ExpandTable.this.expandedRow != null) {
                        int expandedRowIndex;
                        int selIndex = ExpandTable.this.table.getSelectionIndex();
                        if (selIndex == (expandedRowIndex = ExpandTable.this.table.indexOf(ExpandTable.this.expandedRow))) {
                            ExpandTable.this.collapseRow();
                        } else if (selIndex > expandedRowIndex && selIndex <= expandedRowIndex + ExpandTable.this.expandedRowCount) {
                            ExpandTable.this.table.select(expandedRowIndex);
                            ExpandTable.this.layoutChildren();
                            ExpandTable.this.collapseRow();
                        } else {
                            ExpandTable.this.collapseRow();
                            ExpandTable.this.expandRow((TableItem)e.item);
                        }
                    } else {
                        ExpandTable.this.expandRow((TableItem)e.item);
                    }
                }
                ExpandTable.this.keyEvent = false;
            }
        });
    }

    private void addAddDelButtonClickListener() {
        this.addButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                ExpandTable.this.collapseRow();
                TableItem tableItem = ExpandTable.this.addItem("");
                ExpandTable.this.expandRow(tableItem);
                ExpandTable.this.editor.restoreInputDefault();
                ExpandTable.this.editor.setTableItemData();
                ExpandTable.this.table.forceFocus();
            }
        });
        this.delButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                int[] selIndices = ExpandTable.this.table.getSelectionIndices();
                if (ExpandTable.this.expandedRow != null) {
                    int i = 0;
                    while (i < selIndices.length) {
                        if (selIndices[i] > ExpandTable.this.table.indexOf(ExpandTable.this.expandedRow)) {
                            selIndices[i] = selIndices[i] - ExpandTable.this.expandedRowCount;
                        }
                        ++i;
                    }
                    ExpandTable.this.collapseRow();
                }
                ExpandTable.this.table.remove(selIndices);
                ExpandTable.this.layoutChildren();
                if (ExpandTable.this.getItemCount() == 0 && ExpandTable.this.delButton != null & ExpandTable.this.delButton.isEnabled()) {
                    ExpandTable.this.delButton.setEnabled(false);
                }
            }
        });
    }

    public void addRowExpansionListener(RowExpansionListener listener) {
        if (this.rowExpansionListeners == null) {
            this.rowExpansionListeners = new Vector();
        }
        this.rowExpansionListeners.add(listener);
    }

    private void notifyRowExpansionListeners(int expansionEventType) {
        if (this.rowExpansionListeners != null) {
            int i = 0;
            while (i < this.rowExpansionListeners.size()) {
                Event event = new Event();
                event.type = expansionEventType;
                event.data = this;
                this.rowExpansionListeners.get(i).handleRowExpansionEvent(event);
                ++i;
            }
        }
    }

    public void okClicked() {
        this.editor.setTableItemData();
        this.collapseRow();
    }

    public void cancelClicked() {
        this.collapseRow();
    }
}

