/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditVersionDialog
extends TitleAreaDialog
implements ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text version;
    private Text dbVer;
    private DbdModel dbdModel;
    private boolean isReadOnly;

    public EditVersionDialog(Shell parentShell, DbdModel dbdModel, boolean isReadOnly) {
        super(parentShell);
        this.dbdModel = dbdModel;
        this.isReadOnly = isReadOnly;
    }

    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        this.getShell().setText(WorkbenchPlugin.labels.getString("DBVER_DIALOG_TITLE"));
        this.setTitle(WorkbenchPlugin.labels.getString("DBVER_DIALOG_MSG"));
        this.setMessage(WorkbenchPlugin.labels.getString("DBVER_DIALOG_DESC"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FormLayout());
        container.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        FormData fd_composite = new FormData();
        fd_composite.top = new FormAttachment(0, 5);
        fd_composite.left = new FormAttachment(0, 5);
        fd_composite.right = new FormAttachment(100, -5);
        composite.setLayoutData((Object)fd_composite);
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText(WorkbenchPlugin.labels.getString("DBVER_DIALOG_LABEL") + WorkbenchPlugin.colon.getString("COLON"));
        versionLabel.setToolTipText(WorkbenchPlugin.labels.getString("DBVER_DIALOG_LABEL_HOVER"));
        this.version = new Text(composite, 2048);
        this.version.setLayoutData((Object)new GridData(768));
        this.version.setToolTipText(WorkbenchPlugin.labels.getString("DBVER_DIALOG_TEXT_HOVER"));
        this.version.setTextLimit(255);
        this.version.setEnabled(!this.isReadOnly);
        String versionStr = this.dbdModel.getVersion();
        if (versionStr != null) {
            this.version.setText(versionStr);
        }
        Label dbVerLabel = new Label(composite, 0);
        dbVerLabel.setText(WorkbenchPlugin.labels.getString("DBVER_DIALOG_LABEL1") + WorkbenchPlugin.colon.getString("COLON"));
        dbVerLabel.setToolTipText(WorkbenchPlugin.labels.getString("DBVER_DIALOG_LABEL1_HOVER"));
        this.dbVer = new Text(composite, 2048);
        this.dbVer.setLayoutData((Object)new GridData(768));
        this.dbVer.setToolTipText(WorkbenchPlugin.labels.getString("DBVER_DIALOG_TEXT1_HOVER"));
        this.dbVer.setTextLimit(10);
        DBDConstants dbdAccessType = this.dbdModel.getAccessType();
        if (!(dbdAccessType.equals((Object)DBDConstants.DEDB) || dbdAccessType.equals((Object)DBDConstants.HDAM) || dbdAccessType.equals((Object)DBDConstants.HIDAM) || dbdAccessType.equals((Object)DBDConstants.PHDAM) || dbdAccessType.equals((Object)DBDConstants.PHIDAM))) {
            this.dbVer.setEnabled(false);
        } else {
            Integer dbVerValue = this.dbdModel.getUserVersion();
            if (dbVerValue != null) {
                this.dbVer.setText(String.valueOf(dbVerValue));
            }
            this.dbVer.setEnabled(!this.isReadOnly);
        }
        this.version.addModifyListener((ModifyListener)this);
        this.dbVer.addModifyListener((ModifyListener)this);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public void modifyText(ModifyEvent arg0) {
        String dbVerText;
        this.setErrorMessage(null);
        if (arg0.widget == this.dbVer && !(dbVerText = this.dbVer.getText()).isEmpty()) {
            try {
                Integer.valueOf(dbVerText);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(WorkbenchPlugin.errors.getString("EISRC9A"));
            }
        }
        this.getButton(0).setEnabled(this.getErrorMessage() == null);
    }

    protected void okPressed() {
        this.dbdModel.setVersion(this.version.getText());
        String dbVerStr = this.dbVer.getText();
        if (dbVerStr.isEmpty()) {
            this.dbdModel.setUserVersion(null);
        } else {
            this.dbdModel.setUserVersion(Integer.valueOf(dbVerStr));
        }
        super.okPressed();
    }
}

