/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.editor.EditSegmentController;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EditSegmInfoDialog
extends StatusDialog
implements ModifyListener,
VerifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EditSegmentController segmentController;
    private boolean isReadOnly;
    private static final String BIDIRECTIONAL = "BIDIRECTIONAL";
    private static final String[] rulesInserts = new String[]{DBDConstants.LOGICAL.value(), DBDConstants.PHYSICAL.value(), DBDConstants.VIRTUAL.value()};
    private static final String[] rulesDeletes = new String[]{DBDConstants.LOGICAL.value(), DBDConstants.PHYSICAL.value(), DBDConstants.VIRTUAL.value(), "BIDIRECTIONAL"};
    private static final String[] rulesReplaces = new String[]{DBDConstants.LOGICAL.value(), DBDConstants.PHYSICAL.value(), DBDConstants.VIRTUAL.value()};
    private static final String[] rulesAmInserts = new String[]{DBDConstants.LAST.value(), DBDConstants.FIRST.value(), DBDConstants.HERE.value()};
    private static final String[] rulesAmInsertsDedb = new String[]{DBDConstants.HERE.value(), DBDConstants.LAST.value(), DBDConstants.FIRST.value()};
    private static final String DATA = "DATA";
    private static final String KEY = "KEY";
    private static final String[] rtnCompTypes = new String[]{"DATA", "KEY"};
    private static final String INIT = "INIT";
    private static final String[] rtnDedbCompTypes = new String[]{"INIT", "DATA", "DATA,INIT"};
    private static final String[] rtnInitComps = new String[]{"", "INIT"};
    private static final String PAD = "PAD";
    private static final String[] rtnMaxPad = new String[]{"", "PAD"};
    private static final String[] sourceData = new String[]{"DATA"};
    private static final String[] sourceLData = new String[]{"DATA", "KEY"};
    private static final String[] dsGroups = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J"};
    private static final String[] subsetPointers = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8"};
    private static final int EXIT_ATTR = 1;
    private static final int DSGROUP_ATTR = 2;
    private static final int RULES_ATTR = 3;
    private static final int BYTES_ATTR = 4;
    private static final int SOURCE_ATTR = 5;
    private static final String NAME = WorkbenchPlugin.labels.getString("WB450") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB415") + ")";
    private static final String PARENT = WorkbenchPlugin.labels.getString("WB451") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB433") + ")";
    private static final String BYTES = WorkbenchPlugin.labels.getString("WB013A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB055").substring(0, 7);
    private Text bytes;
    private static final String BYTES_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_BYTES_MAX"));
    private Text minBytes;
    private static final String MINBYTES_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_BYTES_MIN"));
    private Label bytesError;
    private static final String SOURCE = WorkbenchPlugin.labels.getString("WB463") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB437") + ")";
    private static final String SOURCE_LABEL_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_SOURCE_LABEL"));
    private static final String SOURCE_COL1_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_SOURCE_COL1"));
    private Text sourceSeg1;
    private static final String SOURCE_COL2_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_SOURCE_COL2"));
    private Combo dataSeg1;
    private static final String SOURCE_COL3_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_SOURCE_COL3"));
    private Text sourceDbd1;
    private static final String SOURCE_COL4_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_SOURCE_COL4"));
    private Text sourceSeg2;
    private static final String SOURCE_COL5_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_SOURCE_COL5"));
    private Combo dataSeg2;
    private static final String SOURCE_COL6_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_SOURCE_COL6"));
    private Text sourceDbd2;
    private Label sourceError;
    private static final String FREQ = WorkbenchPlugin.labels.getString("WB474") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB438") + ")";
    private static final String FREQ_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_FREQ"));
    private Text freq;
    private Label freqError;
    private static final String POINTER = WorkbenchPlugin.labels.getString("WB475") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB439") + ")";
    private static final String PTR_LABEL_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_POINTER_OPTIONS"));
    private Text ptrType;
    private static final String RULES = WorkbenchPlugin.labels.getString("WB476") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB440") + ")";
    private static final String RULES_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_LOGICAL_REL_RULES"));
    private Combo rulesInsert;
    private Combo rulesDelete;
    private Combo rulesReplace;
    private static final String RULES_INSERT_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_NO_KEY_INSERT_RULE"));
    private Combo rulesAmbiguousInsert;
    private Label rulesError;
    private static final String EXIT = WorkbenchPlugin.labels.getString("WB477") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB441") + ")";
    private static final String EXIT_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_DATA_CAP_EXITS"));
    private Text exit;
    private Label exitError;
    private static final String COMPRTN = WorkbenchPlugin.labels.getString("WB478") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB442") + ")";
    private static final String COMPRTN_LABEL_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_COMPRTN_EXIT"));
    private static final String COMPRTN_NAME_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_COMPRTN_NAME"));
    private Text rtnName;
    private static final String COMPRTN_TYPE_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_COMPRTN_DATA"));
    private Combo rtnCompType;
    private static final String COMPRTN_INIT_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_COMPRTN_INIT"));
    private Combo rtnInitComp;
    private static final String COMPRTN_MAX_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_COMPRTN_MAX"));
    private Text rtnMax;
    private static final String COMPRTN_PAD_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_COMPRTN_PAD"));
    private Combo rtnPad;
    private Label rtnError;
    private static final String DSGROUP = WorkbenchPlugin.labels.getString("WB479") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB443") + ")";
    private static final String DSGROUP_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_DSGROUP"));
    private Combo dsGroup;
    private Label dsGroupError;
    private static final String TYPE = WorkbenchPlugin.labels.getString("WB480") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB444") + ")";
    private static final String SSPTR = WorkbenchPlugin.labels.getString("WB481") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB434") + ")";
    private static final String SSPTR_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_SSPTR"));
    private Combo subsetPointer;
    private Label ssptrError;
    private static final String ALIAS = WorkbenchPlugin.labels.getString("WB211") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB479") + ")";
    private static final String ENCODING = WorkbenchPlugin.labels.getString("WB027A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB477") + ")";
    private static final String ENCODING_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("WB23A", (Object[])new String[]{new String(Character.toChars(8482)), WorkbenchPlugin.colon.getString("COLON")}));
    private Text alias;
    private Text encoding;
    private Label encodingError;
    private static final String REMARKS = WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String REMARKS_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_SEGM_REMARKS"));
    private Text remarks;
    private Label remarksError;
    private static final String SEGM_KC = "https://www.ibm.com/support/knowledgecenter/search/%22System%20utilities%22%20%22SEGM%20statements%22?scope=SSEPH2&lang=en";
    private static final String EXIT_KC = "https://www.ibm.com/support/knowledgecenter/search/%22Data%20Capture%20exit%20routines%20and%20logically%20related%20databases%22?scope=SSEPH2&lang=en";
    private boolean genericSegmMessage = true;
    private Link link;
    private static final String description = WorkbenchPlugin.labels.getString("EDIT_SEGM_DIALOG_DESC");
    private static final String errorMessage = WorkbenchPlugin.errors.getString("EDIT_DBDSEGM_ERROR_MESSAGE");
    private static final Image errorImg = ErrorDialog.getImage((String)"dialog_message_error_image");
    private static final Image bannerImg = Utility.getImageDescriptor("edit_metadata.gif").createImage();
    private Label dialogLabel;

    public EditSegmInfoDialog(String projectName, Shell parentShell, SegmentModel segmentModel, boolean isReadOnly) throws ModelException {
        super(parentShell);
        this.segmentController = new EditSegmentController(segmentModel);
        this.isReadOnly = isReadOnly;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private GridData getGridData(int cols) {
        GridData retVal = new GridData(4, 4, true, false, cols, 1);
        return retVal;
    }

    protected Control createDialogArea(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent) ", new Object[]{this.segmentController.getImsName()});
        this.getShell().setText(WorkbenchPlugin.labels.getString("EDIT_SEGM_DIALOG_TITLE"));
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl_container = new GridLayout(9, false);
        gl_container.verticalSpacing = 0;
        gl_container.marginWidth = 0;
        gl_container.horizontalSpacing = 0;
        gl_container.marginHeight = 0;
        container.setLayout((Layout)gl_container);
        container.setLayoutData((Object)new GridData(1808));
        GridData gd = this.getGridData(9);
        gd.verticalAlignment = 4;
        Composite comp = new Composite(container, 2048);
        GridLayout gLayout = new GridLayout(9, false);
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.horizontalSpacing = 0;
        gLayout.verticalSpacing = 0;
        comp.setLayout((Layout)gLayout);
        comp.setLayoutData((Object)gd);
        comp.setBackground(container.getDisplay().getSystemColor(1));
        Composite comp1 = new Composite(comp, 0);
        comp1.setLayout((Layout)new GridLayout(9, false));
        comp1.setBackground(container.getDisplay().getSystemColor(1));
        GridData gd1 = new GridData();
        gd1.grabExcessHorizontalSpace = true;
        gd1.minimumHeight = gd.minimumHeight;
        gd1.horizontalSpan = 8;
        gd1.horizontalAlignment = 4;
        comp1.setLayoutData((Object)gd1);
        this.dialogLabel = new Label(comp1, 0);
        this.dialogLabel.setBackground(container.getDisplay().getSystemColor(1));
        this.dialogLabel.setImage(parent.getDisplay().getSystemImage(1));
        this.dialogLabel.setVisible(false);
        this.link = new Link(comp1, 586);
        this.link.setText(errorMessage);
        this.link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (EditSegmInfoDialog.this.genericSegmMessage) {
                    Program.launch((String)EditSegmInfoDialog.SEGM_KC);
                } else {
                    Program.launch((String)EditSegmInfoDialog.EXIT_KC);
                }
            }
        });
        this.link.setBackground(container.getDisplay().getSystemColor(1));
        this.link.setVisible(false);
        GridData gd_link = new GridData(8);
        gd_link.grabExcessVerticalSpace = true;
        gd_link.minimumHeight = EditSegmInfoDialog.bannerImg.getImageData().height + 10;
        gd_link.grabExcessHorizontalSpace = true;
        gd_link.verticalAlignment = 4;
        gd_link.horizontalSpan = 8;
        gd_link.horizontalAlignment = 4;
        this.link.setLayoutData((Object)gd_link);
        Label bannerLabel = new Label(comp, 0);
        bannerLabel.setBackground(container.getDisplay().getSystemColor(1));
        bannerLabel.setImage(bannerImg);
        GridData gd_bannerLabel = new GridData(128);
        gd_bannerLabel.grabExcessVerticalSpace = true;
        gd_bannerLabel.verticalAlignment = 1024;
        gd_bannerLabel.horizontalAlignment = 131072;
        bannerLabel.setLayoutData((Object)gd_bannerLabel);
        try {
            Composite mainComp = new Composite(parent, 0);
            GridLayout gl_mainComp = new GridLayout(9, false);
            gl_mainComp.verticalSpacing = 5;
            gl_mainComp.marginWidth = 5;
            gl_mainComp.horizontalSpacing = 5;
            gl_mainComp.marginHeight = 5;
            mainComp.setLayout((Layout)gl_mainComp);
            mainComp.setLayoutData((Object)new GridData(1808));
            mainComp.setLayoutData((Object)new GridData(1808));
            DBDConstants accessType = DBDConstants.valueOf((String)this.segmentController.getDBDAccessType());
            if (accessType != DBDConstants.GSAM) {
                new Label(mainComp, 0);
                Label nameLabel = new Label(mainComp, 0);
                nameLabel.setText(NAME);
                Text nameText = new Text(mainComp, 8);
                String name = this.segmentController.getImsName();
                if (name == null) {
                    name = this.segmentController.getName();
                }
                nameText.setText(name);
                nameText.setLayoutData((Object)this.getGridData(6));
                new Label(mainComp, 0);
            }
            if (accessType != DBDConstants.MSDB && accessType != DBDConstants.GSAM) {
                new Label(mainComp, 0);
                Label parentLabel = new Label(mainComp, 0);
                parentLabel.setText(PARENT);
                Text parentText = new Text(mainComp, 8);
                parentText.setText(this.segmentController.getParent());
                parentText.setLayoutData((Object)this.getGridData(6));
                new Label(mainComp, 0);
            }
            if (accessType != DBDConstants.GSAM) {
                new Label(mainComp, 0);
                aliasLabel = new Label(mainComp, 0);
                aliasLabel.setText(ALIAS);
                this.alias = new Text(mainComp, 8);
                aliasStr = this.segmentController.getName();
                if (aliasStr == null) {
                    aliasStr = this.segmentController.getImsName();
                }
                this.alias.setText(aliasStr);
                this.alias.setLayoutData((Object)this.getGridData(6));
                new Label(mainComp, 0);
            } else {
                new Label(mainComp, 0);
                aliasLabel = new Label(mainComp, 0);
                aliasLabel.setText(ALIAS);
                this.alias = new Text(mainComp, 2052);
                this.alias.setLayoutData((Object)new GridData(768));
                aliasStr = this.segmentController.getName();
                if (aliasStr == null) {
                    aliasStr = this.segmentController.getImsName();
                }
                this.alias.setText(aliasStr);
                this.alias.setLayoutData((Object)this.getGridData(6));
                new Label(mainComp, 0);
                this.alias.setEnabled(!this.isReadOnly);
                this.alias.addModifyListener((ModifyListener)this);
                this.alias.setLayoutData((Object)this.getGridData(6));
            }
            if (accessType.equals((Object)DBDConstants.MSDB)) {
                this.createBytes(mainComp, accessType);
            } else if (accessType.equals((Object)DBDConstants.LOGICAL)) {
                this.createSource(mainComp, accessType);
            } else if (accessType.equals((Object)DBDConstants.PSINDEX)) {
                this.createBytes(mainComp, accessType);
                this.createFreq(mainComp);
            } else if (accessType.equals((Object)DBDConstants.INDEX) || accessType.equals((Object)DBDConstants.HSAM)) {
                this.createBytes(mainComp, accessType);
                this.createFreq(mainComp);
            } else if (accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.HIDAM)) {
                if (this.segmentController.getSegmentSourceSegName() == null) {
                    this.createBytes(mainComp, accessType);
                } else {
                    this.createSource(mainComp, accessType);
                }
                this.createFreq(mainComp);
                this.createPointer(mainComp);
                this.createRules(mainComp);
                this.createExit(mainComp);
                this.createCompressionRoutine(mainComp);
            } else if (accessType.equals((Object)DBDConstants.HISAM) || accessType.equals((Object)DBDConstants.SHSAM) || accessType.equals((Object)DBDConstants.SHISAM)) {
                if (this.segmentController.getSegmentSourceSegName() == null) {
                    this.createBytes(mainComp, accessType);
                } else {
                    this.createSource(mainComp, accessType);
                }
                this.createFreq(mainComp);
                this.createPointer(mainComp);
                this.createRules(mainComp);
                this.createExit(mainComp);
                this.createCompressionRoutine(mainComp);
            } else if (accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.PHIDAM)) {
                this.createBytes(mainComp, accessType);
                this.createFreq(mainComp);
                this.createPointer(mainComp);
                this.createRules(mainComp);
                this.createExit(mainComp);
                this.createCompressionRoutine(mainComp);
                this.createDsGroup(mainComp);
            } else if (accessType.equals((Object)DBDConstants.DEDB)) {
                this.createType(mainComp);
                this.createBytes(mainComp, accessType);
                this.createRules(mainComp);
                this.createExit(mainComp);
                this.createCompressionRoutine(mainComp);
                this.createSubsetPointer(mainComp);
            }
            new Label(mainComp, 0);
            Label encodingLabel = new Label(mainComp, 0);
            encodingLabel.setText(ENCODING);
            this.encoding = new Text(mainComp, 2052);
            this.encoding.setLayoutData((Object)new GridData(768));
            Object[] args = new Object[]{new String(Character.toChars(8482)), WorkbenchPlugin.colon.getString("COLON")};
            this.encoding.setToolTipText(ENCODING_HOVER);
            String encodingStr = this.segmentController.getEncoding();
            if (encodingStr != null && !encodingStr.isEmpty()) {
                this.encoding.setText(encodingStr);
            } else {
                encodingStr = WorkbenchPlugin.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection");
                if (encodingStr == null || encodingStr.isEmpty()) {
                    this.encoding.setText("Cp1047");
                }
            }
            this.encoding.setEnabled(!this.isReadOnly);
            this.encoding.addModifyListener((ModifyListener)this);
            this.encoding.setLayoutData((Object)this.getGridData(6));
            this.encodingError = new Label(mainComp, 0);
            this.encodingError.setImage(errorImg);
            this.encodingError.setVisible(false);
            new Label(mainComp, 0);
            Label remarkLabel = new Label(mainComp, 0);
            remarkLabel.setText(REMARKS);
            remarkLabel.setLayoutData((Object)new GridData(2));
            this.remarks = new Text(mainComp, 2882);
            this.remarks.setTextLimit(255);
            this.remarks.setToolTipText(REMARKS_HOVER);
            String remarksStr = this.segmentController.getRemarks();
            if (remarksStr != null && !remarksStr.isEmpty()) {
                this.remarks.setText(remarksStr);
            }
            this.remarks.setEnabled(!this.isReadOnly);
            this.remarks.addModifyListener((ModifyListener)this);
            this.remarks.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (e.character == '\t') {
                        e.text = null;
                        EditSegmInfoDialog.this.remarks.traverse(16);
                    } else if (e.character == '\r') {
                        e.text = null;
                        EditSegmInfoDialog.this.remarks.traverse(4, (KeyEvent)e);
                    }
                }
            });
            GridData gData1 = new GridData(1808);
            gData1.minimumHeight = 75;
            gData1.horizontalSpan = 6;
            this.remarks.setLayoutData((Object)gData1);
            this.remarksError = new Label(mainComp, 0);
            this.remarksError.setImage(errorImg);
            this.remarksError.setVisible(false);
            parent.setSize(container.computeSize(-1, -1));
            this.link.setText(description);
            this.link.setVisible(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.im.ims.workbench.infopop_edit_segm_attributes");
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent)", (Throwable)e);
            logger.error((Throwable)e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent)", new Object[]{this.segmentController.getName()});
        return parent;
    }

    private void createSubsetPointer(Composite container) {
        new Label(container, 0);
        Label ssPtrLabel = new Label(container, 0);
        ssPtrLabel.setText(SSPTR);
        this.subsetPointer = new Combo(container, 2060);
        this.subsetPointer.setToolTipText(SSPTR_HOVER);
        this.subsetPointer.setItems(subsetPointers);
        String ssPtrValue = this.segmentController.getSsptr();
        if (ssPtrValue != null) {
            this.subsetPointer.setText(ssPtrValue);
        }
        this.subsetPointer.setEnabled(!this.isReadOnly);
        this.subsetPointer.addModifyListener((ModifyListener)this);
        this.subsetPointer.setLayoutData((Object)this.getGridData(6));
        this.ssptrError = new Label(container, 0);
        this.ssptrError.setImage(errorImg);
        this.ssptrError.setVisible(false);
    }

    private void createType(Composite container) {
        new Label(container, 0);
        Label typeLabel = new Label(container, 0);
        typeLabel.setText(TYPE);
        Text type = new Text(container, 8);
        String typeStr = this.segmentController.getDedbDependentSegmentType();
        if (typeStr != null && !typeStr.isEmpty()) {
            if (typeStr.equals(DBDConstants.SEQ)) {
                type.setText("SEQUENTIAL DEPENDENT");
            } else {
                type.setText("DIRECT DEPENDENT");
            }
        }
        type.setLayoutData((Object)this.getGridData(6));
        new Label(container, 0);
    }

    private void createDsGroup(Composite container) {
        new Label(container, 0);
        Label dsGroupLabel = new Label(container, 0);
        dsGroupLabel.setText(DSGROUP);
        this.dsGroup = new Combo(container, 8);
        this.dsGroup.setToolTipText(DSGROUP_HOVER);
        if (this.segmentController.isRootSegment()) {
            this.dsGroup.setItems(new String[]{"A"});
        } else {
            this.dsGroup.setItems(dsGroups);
        }
        String dsGroupStr = this.segmentController.getDsgroup();
        if (dsGroupStr != null && !dsGroupStr.isEmpty()) {
            this.dsGroup.setText(dsGroupStr);
        }
        this.dsGroup.setEnabled(!this.isReadOnly);
        this.dsGroup.addModifyListener((ModifyListener)this);
        this.dsGroup.setLayoutData((Object)this.getGridData(6));
        this.dsGroupError = new Label(container, 0);
        this.dsGroupError.setImage(errorImg);
        this.dsGroupError.setVisible(false);
    }

    private void createCompressionRoutine(Composite container) {
        String rtnNameStr = null;
        new Label(container, 0);
        Label rtnNameLabel = new Label(container, 0);
        rtnNameLabel.setToolTipText(COMPRTN_LABEL_HOVER);
        rtnNameLabel.setText(COMPRTN);
        this.rtnName = new Text(container, 2052);
        this.rtnName.setTextLimit(8);
        this.rtnName.setToolTipText(COMPRTN_NAME_HOVER);
        rtnNameStr = this.segmentController.getComprtnRoutineName();
        if (rtnNameStr != null && !rtnNameStr.isEmpty()) {
            this.rtnName.setText(rtnNameStr);
        }
        this.rtnName.setEnabled(!this.isReadOnly);
        this.rtnName.addModifyListener((ModifyListener)this);
        this.rtnName.addVerifyListener((VerifyListener)this);
        this.rtnName.setLayoutData((Object)new GridData(768));
        if (this.segmentController.getDBDAccessType().equals(DBDConstants.DEDB.value())) {
            this.rtnCompType = new Combo(container, 8);
            this.rtnCompType.setToolTipText(COMPRTN_TYPE_HOVER);
            this.rtnCompType.setItems(rtnDedbCompTypes);
            if (rtnNameStr != null && !rtnNameStr.isEmpty()) {
                String rtnCompDataStr = this.segmentController.getDedbComprtnData();
                String rtnComptInitStr = this.segmentController.getDedbComprtnInit();
                if (rtnCompDataStr != null) {
                    if (rtnCompDataStr.equals(DBDConstants.Y.value())) {
                        if (rtnComptInitStr != null && rtnComptInitStr.equals(DBDConstants.Y.value())) {
                            this.rtnCompType.setText(rtnDedbCompTypes[2]);
                        } else {
                            this.rtnCompType.setText(rtnDedbCompTypes[1]);
                        }
                    } else {
                        this.rtnCompType.setText(rtnDedbCompTypes[0]);
                    }
                } else if (rtnComptInitStr != null && rtnComptInitStr.equals(DBDConstants.Y.value())) {
                    this.rtnCompType.setText(rtnDedbCompTypes[0]);
                }
            }
            this.rtnCompType.setEnabled(!this.isReadOnly && rtnNameStr != null && !rtnNameStr.isEmpty());
            this.rtnCompType.addModifyListener((ModifyListener)this);
            this.rtnCompType.setLayoutData((Object)this.getGridData(5));
        } else {
            this.rtnCompType = new Combo(container, 8);
            this.rtnCompType.setToolTipText(COMPRTN_TYPE_HOVER);
            this.rtnCompType.setItems(rtnCompTypes);
            String rtnCompTypeStr = this.segmentController.getComprtnModify();
            if (rtnCompTypeStr != null && !rtnCompTypeStr.isEmpty()) {
                this.rtnCompType.setText(rtnCompTypeStr);
            } else {
                this.rtnCompType.setText(DATA);
            }
            this.rtnCompType.setEnabled(!this.isReadOnly && rtnNameStr != null && !rtnNameStr.isEmpty());
            this.rtnCompType.addModifyListener((ModifyListener)this);
            this.rtnCompType.setLayoutData((Object)new GridData(768));
            this.rtnInitComp = new Combo(container, 8);
            this.rtnInitComp.setToolTipText(COMPRTN_INIT_HOVER);
            this.rtnInitComp.setItems(rtnInitComps);
            String init = this.segmentController.getComprtnInit();
            if (init != null && init.equals(DBDConstants.Y.value())) {
                this.rtnInitComp.setText(INIT);
            }
            this.rtnInitComp.setEnabled(!this.isReadOnly && rtnNameStr != null && !rtnNameStr.isEmpty());
            this.rtnInitComp.addModifyListener((ModifyListener)this);
            this.rtnInitComp.setLayoutData((Object)new GridData(768));
            this.rtnMax = new Text(container, 2048);
            this.rtnMax.setTextLimit(5);
            this.rtnMax.setToolTipText(COMPRTN_MAX_HOVER);
            String rtnMaxStr = this.segmentController.getComprtnMaxBytesNumber();
            if (rtnMaxStr != null && !rtnMaxStr.isEmpty()) {
                this.rtnMax.setText(rtnMaxStr);
            }
            this.rtnMax.setEnabled(!this.isReadOnly && rtnNameStr != null && !rtnNameStr.isEmpty());
            this.rtnMax.addModifyListener((ModifyListener)this);
            this.rtnMax.setLayoutData((Object)new GridData(768));
            this.rtnPad = new Combo(container, 2056);
            this.rtnPad.setItems(rtnMaxPad);
            this.rtnPad.setToolTipText(COMPRTN_PAD_HOVER);
            String rtnPadStr = this.segmentController.getComprtnMaxBytesPad();
            if (rtnPadStr != null && rtnPadStr.equals(DBDConstants.Y.value())) {
                this.rtnPad.setText(PAD);
            }
            this.rtnPad.setEnabled(!this.isReadOnly && rtnNameStr != null && !rtnNameStr.isEmpty() && rtnMaxStr != null && !rtnMaxStr.isEmpty());
            this.rtnPad.addModifyListener((ModifyListener)this);
            this.rtnPad.setLayoutData((Object)this.getGridData(2));
        }
        this.rtnError = new Label(container, 0);
        this.rtnError.setImage(errorImg);
        this.rtnError.setVisible(false);
    }

    private void createPointer(Composite container) {
        String pairedVal;
        String ctrVal;
        String lparntVal;
        String logicalPtr;
        new Label(container, 0);
        Label prefixLabel = new Label(container, 0);
        prefixLabel.setToolTipText(PTR_LABEL_HOVER);
        prefixLabel.setText(POINTER);
        this.ptrType = new Text(container, 8);
        this.ptrType.setLayoutData((Object)this.getGridData(6));
        String physPtr = this.segmentController.getPhysicalPointer();
        Object ptrValue = "";
        String separator = "";
        if (physPtr != null) {
            ptrValue = (String)ptrValue + physPtr;
            separator = ", ";
        }
        if ((logicalPtr = this.segmentController.getLogicalPointer()) != null) {
            ptrValue = (String)ptrValue + separator + logicalPtr;
            if (separator.isEmpty()) {
                separator = ", ";
            }
        }
        if ((lparntVal = this.segmentController.getLparnt()) != null && lparntVal.equals(DBDConstants.Y.value())) {
            ptrValue = (String)ptrValue + separator + DBDConstants.LPARNT.value();
            if (separator.isEmpty()) {
                separator = ", ";
            }
        }
        if ((ctrVal = this.segmentController.getCtr()) != null && ctrVal.equals(DBDConstants.Y.value())) {
            ptrValue = (String)ptrValue + separator + DBDConstants.CTR.value();
            if (separator.isEmpty()) {
                separator = ", ";
            }
        }
        if ((pairedVal = this.segmentController.getPaired()) != null && pairedVal.equals(DBDConstants.Y.value())) {
            ptrValue = (String)ptrValue + separator + DBDConstants.PAIRED.value();
        }
        this.ptrType.setText((String)ptrValue);
        new Label(container, 0);
    }

    private void createRules(Composite container) {
        String ambiguousInsert;
        boolean isDedb = this.segmentController.getDBDAccessType().equals(DBDConstants.DEDB.value());
        new Label(container, 0);
        Label insertLabel = new Label(container, 0);
        insertLabel.setToolTipText(RULES_HOVER);
        insertLabel.setText(RULES);
        this.rulesInsert = new Combo(container, 8);
        this.rulesInsert.setToolTipText(RULES_HOVER);
        this.rulesInsert.setItems(rulesInserts);
        String insertRule = this.segmentController.getInsertionRule();
        if (insertRule != null) {
            this.rulesInsert.setText(this.getLongName(insertRule));
        }
        this.rulesInsert.setEnabled(!this.isReadOnly && !isDedb);
        this.rulesInsert.addModifyListener((ModifyListener)this);
        this.rulesInsert.setLayoutData((Object)new GridData(768));
        this.rulesDelete = new Combo(container, 8);
        this.rulesDelete.setToolTipText(RULES_HOVER);
        this.rulesDelete.setItems(rulesDeletes);
        String deleteRule = this.segmentController.getDeletionRule();
        if (deleteRule != null) {
            this.rulesDelete.setText(this.getLongName(deleteRule));
        }
        this.rulesDelete.setEnabled(!this.isReadOnly && !isDedb);
        this.rulesDelete.addModifyListener((ModifyListener)this);
        this.rulesDelete.setLayoutData((Object)new GridData(768));
        this.rulesReplace = new Combo(container, 8);
        this.rulesReplace.setToolTipText(RULES_HOVER);
        this.rulesReplace.setItems(rulesReplaces);
        String replaceRule = this.segmentController.getReplacementRule();
        if (replaceRule != null) {
            this.rulesReplace.setText(this.getLongName(replaceRule));
        }
        this.rulesReplace.setEnabled(!this.isReadOnly && !isDedb);
        this.rulesReplace.addModifyListener((ModifyListener)this);
        this.rulesReplace.setLayoutData((Object)new GridData(768));
        this.rulesAmbiguousInsert = new Combo(container, 8);
        this.rulesAmbiguousInsert.setToolTipText(RULES_INSERT_HOVER);
        this.rulesAmbiguousInsert.setItems(rulesAmInserts);
        if (isDedb) {
            this.rulesAmbiguousInsert.setItems(rulesAmInsertsDedb);
        }
        if ((ambiguousInsert = this.segmentController.getInsertionLocation()) != null) {
            this.rulesAmbiguousInsert.setText(ambiguousInsert);
        }
        this.rulesAmbiguousInsert.setEnabled(!this.isReadOnly);
        this.rulesAmbiguousInsert.addModifyListener((ModifyListener)this);
        this.rulesAmbiguousInsert.setLayoutData((Object)this.getGridData(3));
        this.rulesError = new Label(container, 0);
        this.rulesError.setImage(errorImg);
        this.rulesError.setVisible(false);
    }

    private void createSource(Composite container, DBDConstants accessType) {
        int span = 1;
        if (accessType != DBDConstants.LOGICAL) {
            span = 2;
        }
        new Label(container, 0);
        Label sourceLabel = new Label(container, 0);
        sourceLabel.setToolTipText(SOURCE_LABEL_HOVER);
        sourceLabel.setText(SOURCE);
        this.sourceSeg1 = new Text(container, 2060);
        this.sourceSeg1.setToolTipText(SOURCE_COL1_HOVER);
        this.sourceSeg1.setTextLimit(8);
        this.sourceSeg1.setEnabled(!this.isReadOnly);
        this.sourceSeg1.setLayoutData((Object)this.getGridData(span));
        this.dataSeg1 = new Combo(container, 8);
        this.dataSeg1.setToolTipText(SOURCE_COL2_HOVER);
        if (accessType == DBDConstants.LOGICAL) {
            this.dataSeg1.setItems(sourceLData);
        } else {
            this.dataSeg1.setItems(sourceData);
        }
        this.dataSeg1.setEnabled(!this.isReadOnly);
        this.dataSeg1.setLayoutData((Object)this.getGridData(span));
        this.sourceDbd1 = new Text(container, 2060);
        this.sourceDbd1.setToolTipText(SOURCE_COL3_HOVER);
        this.sourceDbd1.setTextLimit(8);
        this.sourceDbd1.setEnabled(!this.isReadOnly);
        this.sourceDbd1.setLayoutData((Object)this.getGridData(span));
        if (accessType == DBDConstants.LOGICAL) {
            this.sourceSeg2 = new Text(container, 2060);
            this.sourceSeg2.setToolTipText(SOURCE_COL4_HOVER);
            this.sourceSeg2.setTextLimit(8);
            this.sourceSeg2.setEnabled(false);
            this.dataSeg2 = new Combo(container, 8);
            this.dataSeg2.setToolTipText(SOURCE_COL5_HOVER);
            this.dataSeg2.setItems(sourceLData);
            this.dataSeg2.setEnabled(false);
            this.sourceDbd2 = new Text(container, 2060);
            this.sourceDbd2.setToolTipText(SOURCE_COL6_HOVER);
            this.sourceDbd2.setTextLimit(8);
            this.sourceDbd2.setEnabled(false);
            this.sourceDbd2.setLayoutData((Object)new GridData(256));
            String sourceSeg1Str = this.segmentController.getLogicalChildSourceSegName();
            if (sourceSeg1Str == null) {
                this.sourceSeg1.setText(this.segmentController.getSegmentSourceSegName());
                String sourceChildData = this.segmentController.getSegmentSourceData();
                if (sourceChildData != null) {
                    if (sourceChildData.equals(DBDConstants.Y.value())) {
                        this.dataSeg1.setText(DATA);
                    } else {
                        this.dataSeg1.setText(KEY);
                    }
                }
                this.sourceDbd1.setText(this.segmentController.getSegmentSourceDBName());
            } else {
                this.sourceSeg1.setText(sourceSeg1Str);
                String sourceChildData = this.segmentController.getLogicalChildSourceData();
                if (sourceChildData != null) {
                    if (sourceChildData.equals(DBDConstants.Y.value())) {
                        this.dataSeg1.setText(DATA);
                    } else {
                        this.dataSeg1.setText(KEY);
                    }
                }
                this.sourceDbd1.setText(this.segmentController.getLogicalChildSourceDBName());
                String sourceSeg2Str = this.segmentController.getTargetParentSourceSegName();
                if (sourceSeg2Str != null) {
                    this.sourceSeg2.setText(sourceSeg2Str);
                    String targetParentData = this.segmentController.getTargetParentSourceData();
                    if (targetParentData != null) {
                        if (targetParentData.equals(DBDConstants.Y.value())) {
                            this.dataSeg2.setText(DATA);
                        } else {
                            this.dataSeg2.setText(KEY);
                        }
                    }
                    this.sourceDbd2.setText(this.segmentController.getTargetParentSourceDBName());
                    this.sourceSeg2.setEnabled(!this.isReadOnly);
                    this.dataSeg2.setEnabled(!this.isReadOnly);
                    this.sourceDbd2.setEnabled(!this.isReadOnly);
                }
            }
            this.dataSeg1.addModifyListener((ModifyListener)this);
            this.dataSeg2.addModifyListener((ModifyListener)this);
        } else {
            this.sourceSeg1.setText(this.segmentController.getSegmentSourceSegName());
            String sourceChildData = this.segmentController.getSegmentSourceData();
            if (sourceChildData != null) {
                if (sourceChildData.equals(DBDConstants.Y.value())) {
                    this.dataSeg1.setText(DATA);
                } else {
                    this.dataSeg1.setText(KEY);
                }
            }
            this.sourceDbd1.setText(this.segmentController.getSegmentSourceDBName());
        }
        this.sourceError = new Label(container, 0);
        this.sourceError.setImage(errorImg);
        this.sourceError.setVisible(false);
    }

    private void createBytes(Composite container, DBDConstants accessType) {
        int colSpan = 1;
        int maxBytes = Integer.valueOf(this.segmentController.getMaxBytes());
        int mBytes = Integer.valueOf(this.segmentController.getMinBytes());
        if ((accessType == DBDConstants.DEDB || accessType == DBDConstants.HDAM || accessType == DBDConstants.HIDAM || accessType == DBDConstants.HISAM || accessType == DBDConstants.SHISAM || accessType == DBDConstants.PHDAM || accessType == DBDConstants.PHIDAM) && mBytes > 0) {
            colSpan = 3;
        }
        Label bytesReq = new Label(container, 0);
        bytesReq.setText("*");
        bytesReq.setForeground(container.getDisplay().getSystemColor(3));
        Label bytesLabel = new Label(container, 0);
        bytesLabel.setText(BYTES);
        this.bytes = new Text(container, 2052);
        this.bytes.setTextLimit(5);
        this.bytes.setToolTipText(BYTES_HOVER);
        if (maxBytes > 0) {
            this.bytes.setText(String.valueOf(maxBytes));
        }
        this.bytes.setEnabled(!this.isReadOnly);
        this.bytes.addModifyListener((ModifyListener)this);
        this.bytes.setLayoutData((Object)this.getGridData(6 / colSpan));
        if (colSpan == 3) {
            this.minBytes = new Text(container, 2052);
            this.minBytes.setTextLimit(5);
            this.minBytes.setToolTipText(MINBYTES_HOVER);
            if (mBytes > 0) {
                this.minBytes.setText(String.valueOf(mBytes));
            }
            this.minBytes.setEnabled(!this.isReadOnly);
            this.minBytes.addModifyListener((ModifyListener)this);
            this.minBytes.setLayoutData((Object)this.getGridData(4));
        }
        this.bytesError = new Label(container, 0);
        this.bytesError.setImage(errorImg);
        this.bytesError.setVisible(false);
    }

    private void createFreq(Composite container) {
        new Label(container, 0);
        Label freqLabel = new Label(container, 0);
        freqLabel.setText(FREQ);
        this.freq = new Text(container, 2052);
        this.freq.setTextLimit(11);
        this.freq.setToolTipText(FREQ_HOVER);
        this.freq.setLayoutData((Object)new GridData(768));
        this.freq.setEnabled(!this.isReadOnly);
        String freqStr = this.segmentController.getFreq();
        if (freqStr != null && !freqStr.isEmpty()) {
            this.freq.setText(freqStr);
        }
        this.freq.addModifyListener((ModifyListener)this);
        this.freq.setLayoutData((Object)this.getGridData(6));
        this.freqError = new Label(container, 0);
        this.freqError.setImage(errorImg);
        this.freqError.setVisible(false);
    }

    private void createExit(Composite container) {
        String exits;
        new Label(container, 0);
        Label exitLabel = new Label(container, 0);
        exitLabel.setText(EXIT);
        this.exit = new Text(container, 2052);
        this.exit.setToolTipText(EXIT_HOVER);
        if (!this.segmentController.isVirtualLogicalChild() && (exits = this.segmentController.getInitialExitString()) != null && !exits.trim().isEmpty()) {
            this.exit.setText(exits);
        }
        this.exit.setLayoutData((Object)new GridData(768));
        this.exit.setEnabled(!this.isReadOnly && !this.segmentController.isVirtualLogicalChild());
        this.exit.addVerifyListener((VerifyListener)this);
        this.exit.addModifyListener((ModifyListener)this);
        this.exit.setLayoutData((Object)this.getGridData(6));
        this.exitError = new Label(container, 0);
        this.exitError.setImage(errorImg);
        this.exitError.setVisible(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    private String getLongName(String shortName) {
        String retVal = "";
        if (shortName != null) {
            if (shortName.equals("L")) {
                retVal = DBDConstants.LOGICAL.value();
            } else if (shortName.equals("P")) {
                retVal = DBDConstants.PHYSICAL.value();
            } else if (shortName.equals("V")) {
                retVal = DBDConstants.VIRTUAL.value();
            } else if (shortName.equals("B")) {
                retVal = BIDIRECTIONAL;
            }
        }
        return retVal;
    }

    private void handleEncoding() {
        this.encodingError.setVisible(false);
        try {
            this.segmentController.setEncoding(this.encoding.getText().trim());
        }
        catch (InvalidInputException e) {
            this.encodingError.setVisible(true);
            this.encodingError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleAlias() {
        this.segmentController.setName(this.alias.getText().trim());
    }

    private void handleRemarks() {
        this.remarksError.setVisible(false);
        try {
            this.segmentController.setRemarks(this.remarks.getText().trim());
        }
        catch (InvalidInputException e) {
            this.remarksError.setVisible(true);
            this.remarksError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleExit() {
        this.exitError.setVisible(false);
        this.exitError.setToolTipText(null);
        try {
            this.segmentController.setExit(this.exit.getText().trim(), false);
            this.rulesError.setVisible(false);
            this.rulesError.setToolTipText(null);
        }
        catch (InvalidInputException e) {
            this.exitError.setVisible(true);
            this.exitError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
        catch (ModelException e) {
            this.exitError.setVisible(true);
            this.exitError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleBytes() {
        this.bytesError.setVisible(false);
        try {
            this.segmentController.setMaxBytes(this.bytes.getText().trim());
        }
        catch (InvalidInputException e) {
            this.bytesError.setVisible(true);
            this.bytesError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleMinBytes() {
        this.bytesError.setVisible(false);
        try {
            this.segmentController.setMinBytes(this.minBytes.getText().trim());
        }
        catch (InvalidInputException e) {
            this.bytesError.setVisible(true);
            this.bytesError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleSourceData1() {
        String data = this.dataSeg1.getText();
        if (data.equals(DATA)) {
            this.segmentController.setSourceData(DBDConstants.Y.value(), true);
        } else {
            this.segmentController.setSourceData(DBDConstants.N.value(), true);
        }
    }

    private void handleSourceData2() {
        String data = this.dataSeg2.getText();
        if (data.equals(DATA)) {
            this.segmentController.setSourceData(DBDConstants.Y.value(), false);
        } else {
            this.segmentController.setSourceData(DBDConstants.N.value(), false);
        }
    }

    private void handleInsertRule() {
        this.rulesError.setVisible(false);
        try {
            this.segmentController.setInsertionRule(this.rulesInsert.getText());
            if (this.rulesDelete.getText().isEmpty()) {
                this.rulesDelete.setText(DBDConstants.LOGICAL.value());
            }
            if (this.rulesReplace.getText().isEmpty()) {
                this.rulesReplace.setText(DBDConstants.LOGICAL.value());
            }
        }
        catch (InvalidInputException e) {
            this.rulesError.setVisible(true);
            this.rulesError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleDeleteRule() {
        this.rulesError.setVisible(false);
        this.rulesError.setToolTipText(null);
        try {
            String rule = this.rulesDelete.getText();
            this.segmentController.setDeletionRule(rule);
            if (this.rulesInsert.getText().isEmpty()) {
                this.rulesInsert.setText(DBDConstants.LOGICAL.value());
            }
            if (this.rulesReplace.getText().isEmpty()) {
                this.rulesReplace.setText(DBDConstants.LOGICAL.value());
            }
            if (this.exit != null) {
                if (this.exit.getText().isEmpty()) {
                    this.exitError.setVisible(false);
                    this.exitError.setToolTipText(null);
                } else if (this.segmentController.isLogicalChild() && rule.equals(DBDConstants.VIRTUAL.value())) {
                    this.handleExit();
                } else if (this.segmentController.isLogicalParent() && (rule.equals(DBDConstants.LOGICAL.value()) || rule.equals(DBDConstants.PHYSICAL.value()))) {
                    this.handleExit();
                }
            }
        }
        catch (InvalidInputException e) {
            this.rulesError.setVisible(true);
            this.rulesError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleReplaceRule() {
        this.rulesError.setVisible(false);
        try {
            this.segmentController.setReplacementRule(this.rulesReplace.getText());
            if (this.rulesInsert.getText().isEmpty()) {
                this.rulesInsert.setText(DBDConstants.LOGICAL.value());
            }
            if (this.rulesDelete.getText().isEmpty()) {
                this.rulesDelete.setText(DBDConstants.LOGICAL.value());
            }
        }
        catch (InvalidInputException e) {
            this.rulesError.setVisible(true);
            this.rulesError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleAmbiguousInsertRule() {
        this.rulesError.setVisible(false);
        try {
            this.segmentController.setAmbiguousInsertRule(this.rulesAmbiguousInsert.getText());
        }
        catch (InvalidInputException e) {
            this.rulesError.setVisible(true);
            this.rulesError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleCompRtn() {
        this.rtnError.setVisible(false);
        try {
            String rtnNameStr = this.rtnName.getText();
            if (this.segmentController.getDBDAccessType().equals(DBDConstants.DEDB.value())) {
                this.rtnCompType.setEnabled(!rtnNameStr.isEmpty());
                if (rtnNameStr.isEmpty()) {
                    this.segmentController.setDedbComprtn(new String[3]);
                    this.rtnCompType.removeModifyListener((ModifyListener)this);
                    this.rtnCompType.setItems(new String[0]);
                    this.rtnCompType.addModifyListener((ModifyListener)this);
                } else {
                    String[] values;
                    if (this.rtnCompType.getItemCount() == 0) {
                        this.rtnCompType.removeModifyListener((ModifyListener)this);
                        this.rtnCompType.setItems(rtnDedbCompTypes);
                        this.rtnCompType.addModifyListener((ModifyListener)this);
                    }
                    if ((values = this.rtnCompType.getText().split(",")).length == 0) {
                        String[] stringArray = new String[3];
                        stringArray[0] = rtnNameStr;
                        this.segmentController.setDedbComprtn(stringArray);
                    } else if (values.length == 1) {
                        if (values[0].isEmpty()) {
                            values[0] = null;
                        }
                        String[] stringArray = new String[3];
                        stringArray[0] = rtnNameStr;
                        stringArray[1] = values[0];
                        this.segmentController.setDedbComprtn(stringArray);
                    } else if (values.length == 2) {
                        this.segmentController.setDedbComprtn(new String[]{rtnNameStr, values[0], values[1]});
                    }
                }
            } else {
                String rtnMaxStr = this.rtnMax.getText();
                this.rtnCompType.setEnabled(!rtnNameStr.isEmpty());
                this.rtnInitComp.setEnabled(!rtnNameStr.isEmpty());
                this.rtnMax.setEnabled(!rtnNameStr.isEmpty());
                this.rtnPad.setEnabled(!rtnNameStr.isEmpty() && !rtnMaxStr.isEmpty());
                if (rtnNameStr.isEmpty()) {
                    this.segmentController.setComprtn(new String[5]);
                    this.rtnCompType.removeModifyListener((ModifyListener)this);
                    this.rtnCompType.setItems(new String[0]);
                    this.rtnCompType.addModifyListener((ModifyListener)this);
                    this.rtnInitComp.removeModifyListener((ModifyListener)this);
                    this.rtnInitComp.setText("");
                    this.rtnInitComp.addModifyListener((ModifyListener)this);
                    this.rtnMax.removeModifyListener((ModifyListener)this);
                    this.rtnMax.setText("");
                    this.rtnMax.addModifyListener((ModifyListener)this);
                    this.rtnPad.removeModifyListener((ModifyListener)this);
                    this.rtnPad.setText("");
                    this.rtnPad.addModifyListener((ModifyListener)this);
                } else {
                    String init;
                    String compType;
                    if (this.rtnCompType.getItemCount() == 0) {
                        this.rtnCompType.removeModifyListener((ModifyListener)this);
                        this.rtnCompType.setItems(rtnCompTypes);
                        this.rtnCompType.addModifyListener((ModifyListener)this);
                    }
                    if ((compType = this.rtnCompType.getText()).isEmpty()) {
                        compType = null;
                    }
                    if ((init = this.rtnInitComp.getText()).isEmpty()) {
                        init = null;
                    }
                    String max = this.rtnMax.getText();
                    String pad = this.rtnPad.getText();
                    if (max.isEmpty()) {
                        max = null;
                        if (!pad.isEmpty()) {
                            pad = null;
                            this.rtnPad.removeModifyListener((ModifyListener)this);
                            this.rtnPad.setText("");
                            this.rtnPad.addModifyListener((ModifyListener)this);
                        }
                    } else if (pad.isEmpty()) {
                        pad = null;
                    }
                    this.segmentController.setComprtn(new String[]{this.rtnName.getText(), compType, init, max, pad});
                }
            }
        }
        catch (InvalidInputException e) {
            this.rtnError.setVisible(true);
            this.rtnError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleFreq() {
        this.freqError.setVisible(false);
        try {
            this.segmentController.setFreq(this.freq.getText());
        }
        catch (InvalidInputException e) {
            this.freqError.setVisible(true);
            this.freqError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleDsGroup() {
        this.segmentController.setDsgroup(this.dsGroup.getText());
    }

    private void handleSsptr() {
        this.ssptrError.setVisible(false);
        try {
            this.segmentController.setSsptr(this.subsetPointer.getText());
        }
        catch (InvalidInputException e) {
            this.ssptrError.setVisible(true);
            this.ssptrError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    public void verifyText(VerifyEvent arg0) {
        try {
            if (arg0.character >= 'a' && arg0.character <= 'z') {
                arg0.text = arg0.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    public void modifyText(ModifyEvent arg0) {
        this.dialogLabel.setVisible(false);
        this.link.setText(description);
        this.genericSegmMessage = true;
        Widget widget = arg0.widget;
        try {
            if (widget == this.encoding) {
                this.handleEncoding();
            } else if (widget == this.alias) {
                this.handleAlias();
            } else if (widget == this.remarks) {
                this.handleRemarks();
            } else if (widget == this.bytes) {
                this.handleBytes();
            } else if (widget == this.minBytes) {
                this.handleMinBytes();
            } else if (widget == this.dataSeg1) {
                this.handleSourceData1();
            } else if (widget == this.dataSeg2) {
                this.handleSourceData2();
            } else if (widget == this.rulesInsert) {
                this.handleInsertRule();
            } else if (widget == this.rulesDelete) {
                this.handleDeleteRule();
            } else if (widget == this.rulesReplace) {
                this.handleReplaceRule();
            } else if (widget == this.rulesAmbiguousInsert) {
                this.handleAmbiguousInsertRule();
            } else if (widget == this.rtnName || widget == this.rtnCompType || widget == this.rtnInitComp || widget == this.rtnMax || widget == this.rtnPad) {
                this.handleCompRtn();
            } else if (widget == this.freq) {
                this.handleFreq();
            } else if (widget == this.dsGroup) {
                this.handleDsGroup();
            } else if (widget == this.subsetPointer) {
                this.handleSsptr();
            } else if (widget == this.exit) {
                this.handleExit();
            }
            if (this.encoding != null && this.encodingError.isVisible() || this.exit != null && this.exitError.isVisible() || this.remarks != null && this.remarksError.isVisible() || this.bytes != null && this.bytesError.isVisible() || this.freq != null && this.freqError.isVisible() || this.rtnName != null && this.rtnError.isVisible() || this.subsetPointer != null && this.ssptrError.isVisible() || this.rulesInsert != null && this.rulesError.isVisible()) {
                this.dialogLabel.setVisible(true);
                this.link.setText(errorMessage);
            }
            this.segmentController.semanticCheck();
            if (widget == this.exit) {
                this.exitError.setToolTipText(null);
                this.exitError.setVisible(false);
            } else if (widget == this.rulesDelete || widget == this.rulesInsert || widget == this.rulesReplace) {
                this.rulesError.setToolTipText(null);
                this.rulesError.setVisible(false);
            } else if (widget == this.bytes || widget == this.minBytes) {
                this.bytesError.setToolTipText(null);
                this.bytesError.setVisible(false);
            } else if (widget == this.dataSeg1 || widget == this.dataSeg2) {
                this.sourceError.setToolTipText(null);
                this.sourceError.setVisible(false);
            } else if (widget == this.dsGroup) {
                this.dsGroupError.setToolTipText(null);
                this.dsGroupError.setVisible(false);
            }
        }
        catch (InvalidInputException e) {
            this.dialogLabel.setVisible(true);
            this.link.setText(errorMessage);
            int attrValue = this.getAttributeValue(e.getAttrNames());
            if (attrValue == 1) {
                this.exitError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.exitError.setVisible(true);
                this.genericSegmMessage = false;
            } else if (attrValue == 3) {
                this.rulesError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.rulesError.setVisible(true);
                this.genericSegmMessage = false;
            } else if (attrValue == 4) {
                this.bytesError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.bytesError.setVisible(true);
            } else if (attrValue == 5) {
                this.sourceError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.sourceError.setVisible(true);
            } else if (attrValue == 2) {
                this.dsGroupError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.dsGroupError.setVisible(true);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent arg0)", e);
            logger.error(e);
            this.getButton(0).setEnabled(false);
        }
        this.getButton(0).setEnabled(!this.dialogLabel.getVisible());
    }

    private int getAttributeValue(String[] attrs) {
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].equals("BYTES")) {
                return 4;
            }
            if (attrs[i].equals("SOURCE")) {
                return 5;
            }
            if (attrs[i].equals("EXIT")) {
                return 1;
            }
            if (attrs[i].equals("RULES")) {
                return 3;
            }
            if (attrs[i].equals("DSGROUP")) {
                return 2;
            }
            ++i;
        }
        return -1;
    }

    protected void okPressed() {
        try {
            if (this.exit != null) {
                this.segmentController.setExit(this.exit.getText().trim(), true);
            }
            this.segmentController.performFinish();
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "okPressed()", (Throwable)e);
            logger.error((Throwable)e);
        }
        super.okPressed();
    }
}

