/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.editor.EditDatabaseController;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.DBDSourceGenerator;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EditDbdInfoDialog
extends StatusDialog
implements ModifyListener,
VerifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EditDatabaseController controller;
    private boolean isReadOnly;
    private static String[] yesNo = new String[]{WorkbenchPlugin.labels.getString("YES"), WorkbenchPlugin.labels.getString("NO")};
    private static String[] rmNameXCIs = new String[]{"", "XCI"};
    private static final String NAME = WorkbenchPlugin.labels.getString("WB022") + " " + WorkbenchPlugin.noxlatlabels.getString("WB001").substring(0, 6) + WorkbenchPlugin.colon.getString("COLON");
    private static final String ACCESS = WorkbenchPlugin.labels.getString("WB023") + " " + WorkbenchPlugin.noxlatlabels.getString("WB002").substring(0, 8) + WorkbenchPlugin.colon.getString("COLON");
    private static final String PROT = WorkbenchPlugin.labels.getString("EDIT_DATABASE_PROT") + " (PROT)" + WorkbenchPlugin.colon.getString("COLON");
    private static final String PROT_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_PROT"));
    private Combo pointerProt;
    private static final String DOSCOMP = WorkbenchPlugin.labels.getString("EDIT_DATABASE_DOSCOMP") + " (DOSCOMP)" + WorkbenchPlugin.colon.getString("COLON");
    private static final String DOSCOMP_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_DOSCOMP"));
    private Combo useDos;
    private static final String DATXEXIT = WorkbenchPlugin.labels.getString("WB019") + " " + WorkbenchPlugin.noxlatlabels.getString("WB011").substring(0, 19) + WorkbenchPlugin.colon.getString("COLON");
    private static final String DATXEXIT_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_DATXEXIT"));
    private Combo datXExit;
    private static final String PASSWD = WorkbenchPlugin.labels.getString("WB027") + " " + WorkbenchPlugin.noxlatlabels.getString("WB003").substring(0, 8) + WorkbenchPlugin.colon.getString("COLON");
    private static final String PASSWD_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_PASSWORD"));
    private Combo passWord;
    private static final String VERSION = WorkbenchPlugin.labels.getString("WB003") + " " + WorkbenchPlugin.noxlatlabels.getString("WB004").substring(0, 9) + WorkbenchPlugin.colon.getString("COLON");
    private static final String VERSION_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_VERSION"));
    private Text version;
    private static final String FPINDEX = WorkbenchPlugin.labels.getString("EDIT_DATABASE_FPINDEX") + " (FPINDEX)" + WorkbenchPlugin.colon.getString("COLON");
    private static final String FPINDEX_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_FPINDEX"));
    private Combo fpIndex;
    private static final String SHAREDINDEXDBS = WorkbenchPlugin.labels.getString("EDIT_DATABASE_SHAREDINDEXDBS") + WorkbenchPlugin.colon.getString("COLON");
    private Text sharedIdxNames;
    private static final String EXIT = WorkbenchPlugin.labels.getString("WB028") + " " + WorkbenchPlugin.noxlatlabels.getString("WB005") + WorkbenchPlugin.colon.getString("COLON");
    private static final String EXIT_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_DATA_CAP_EXIT"));
    private Text exit;
    private Label exitError;
    private static final String RMNAME = WorkbenchPlugin.labels.getString("WB041") + " " + WorkbenchPlugin.noxlatlabels.getString("WB007").substring(0, 8) + WorkbenchPlugin.colon.getString("COLON");
    private static final String RMNAME_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_RANDOMIZER"));
    private static final String RMANCH_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_RNDMZR_ANCH"));
    private static final String RMRBN_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_RNDMZR_RBN"));
    private static final String RMBYTES_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_RNDMZR_BYTES"));
    private static final String RMXCI_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_RNDMZR_XCI"));
    private Text rmName;
    private Text rmAnch;
    private Text rmRbn;
    private Text rmBytes;
    private Combo rmXCI;
    private Label rmNameError;
    private static final String PSNAME = WorkbenchPlugin.labels.getString("WB018") + " " + WorkbenchPlugin.noxlatlabels.getString("WB006").substring(0, 8) + WorkbenchPlugin.colon.getString("COLON");
    private static final String PSNAME_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_PSNAME"));
    private Text psName;
    private static final String ENCODING = WorkbenchPlugin.labels.getString("WB027A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB477") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String ENCODING_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_ENCODING"));
    private Text encoding;
    private Label encodingError;
    private static final String REMARKS = WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String REMARKS_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_RMRKS"));
    private Text remarks;
    private Label remarksError;
    private static final String DBVER = WorkbenchPlugin.labels.getString("WB120") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB500") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String DBVER_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DBD_DBVER"));
    private Text dbVer;
    private Label dbVerError;
    private Link link;
    private static final String description = WorkbenchPlugin.labels.getString("EDIT_DATABASE_DIALOG_DESC");
    private static final String errorMessage = WorkbenchPlugin.errors.getString("EDIT_DBDSEGM_ERROR_MESSAGE");
    private static final Image errorImg = ErrorDialog.getImage((String)"dialog_message_error_image");
    private static final Image bannerImg = Utility.getImageDescriptor("edit_metadata.gif").createImage();
    private Label dialogLabel;
    private boolean randWarned = false;

    public EditDbdInfoDialog(Shell parentShell, DbdModel dbdModel, boolean isReadOnly) throws ModelException {
        super(parentShell);
        this.controller = new EditDatabaseController(dbdModel);
        this.isReadOnly = isReadOnly;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent) ", new Object[]{this.controller.getDBDName()});
        this.getShell().setText(WorkbenchPlugin.labels.getString("EDIT_DATABASE_DIALOG_TITLE"));
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl_container = new GridLayout(7, false);
        gl_container.verticalSpacing = 0;
        gl_container.marginWidth = 0;
        gl_container.horizontalSpacing = 0;
        gl_container.marginHeight = 0;
        container.setLayout((Layout)gl_container);
        container.setLayoutData((Object)new GridData(1794));
        GridData gd = this.getGridData(7);
        gd.verticalAlignment = 4;
        Composite comp = new Composite(container, 2048);
        GridLayout gLayout = new GridLayout(7, false);
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.horizontalSpacing = 0;
        gLayout.verticalSpacing = 0;
        comp.setLayout((Layout)gLayout);
        comp.setLayoutData((Object)gd);
        comp.setBackground(container.getDisplay().getSystemColor(1));
        Composite comp1 = new Composite(comp, 0);
        comp1.setLayout((Layout)new GridLayout(6, false));
        comp1.setBackground(container.getDisplay().getSystemColor(1));
        GridData gd1 = new GridData();
        gd1.grabExcessHorizontalSpace = true;
        gd1.minimumHeight = gd.minimumHeight;
        gd1.horizontalSpan = 6;
        gd1.horizontalAlignment = 4;
        comp1.setLayoutData((Object)gd1);
        this.dialogLabel = new Label(comp1, 0);
        this.dialogLabel.setBackground(container.getDisplay().getSystemColor(1));
        this.dialogLabel.setImage(parent.getDisplay().getSystemImage(1));
        this.dialogLabel.setVisible(false);
        this.link = new Link(comp1, 586);
        this.link.setText(errorMessage);
        this.link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)"https://www.ibm.com/support/knowledgecenter/search/%22System%20utilities%22%20%22DBD%20statements%22?scope=SSEPH2&lang=en");
            }
        });
        this.link.setBackground(container.getDisplay().getSystemColor(1));
        this.link.setVisible(false);
        GridData gd_link = new GridData(5);
        gd_link.grabExcessVerticalSpace = true;
        gd_link.minimumHeight = EditDbdInfoDialog.bannerImg.getImageData().height + 10;
        gd_link.grabExcessHorizontalSpace = true;
        gd_link.verticalAlignment = 4;
        gd_link.horizontalSpan = 5;
        gd_link.horizontalAlignment = 4;
        this.link.setLayoutData((Object)gd_link);
        Label bannerLabel = new Label(comp, 0);
        bannerLabel.setBackground(container.getDisplay().getSystemColor(1));
        bannerLabel.setImage(bannerImg);
        GridData gd_bannerLabel = new GridData(128);
        gd_bannerLabel.grabExcessVerticalSpace = true;
        gd_bannerLabel.verticalAlignment = 1024;
        gd_bannerLabel.horizontalAlignment = 131072;
        bannerLabel.setLayoutData((Object)gd_bannerLabel);
        try {
            Composite mainComp = new Composite(parent, 0);
            GridLayout gl_mainComp = new GridLayout(7, false);
            gl_mainComp.verticalSpacing = 5;
            gl_mainComp.marginWidth = 5;
            gl_mainComp.horizontalSpacing = 5;
            gl_mainComp.marginHeight = 5;
            mainComp.setLayout((Layout)gl_mainComp);
            mainComp.setLayoutData((Object)new GridData(1808));
            mainComp.setLayoutData((Object)new GridData(1794));
            new Label(mainComp, 0);
            Label nameLabel = new Label(mainComp, 0);
            nameLabel.setText(NAME);
            Text nameText = new Text(mainComp, 8);
            nameText.setText(this.controller.getDBDName());
            nameText.setLayoutData((Object)this.getGridData(4));
            new Label(mainComp, 0);
            new Label(mainComp, 0);
            Label accessLabel = new Label(mainComp, 0);
            accessLabel.setText(ACCESS);
            Text accessText = new Text(mainComp, 8);
            String accessStr = this.controller.getACCESSString();
            if (accessStr != null && !accessStr.isEmpty()) {
                accessText.setText(accessStr);
            }
            accessText.setLayoutData((Object)this.getGridData(4));
            new Label(mainComp, 0);
            DBDConstants accessType = this.controller.getAccessType();
            if (accessType.equals((Object)DBDConstants.HIDAM) || accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.PHIDAM) || accessType.equals((Object)DBDConstants.DEDB)) {
                this.createDbVer(mainComp);
            }
            if (accessType.equals((Object)DBDConstants.HSAM)) {
                this.createDatXExit(mainComp);
            } else if (accessType.equals((Object)DBDConstants.INDEX) || accessType.equals((Object)DBDConstants.PSINDEX)) {
                this.createIndexType(mainComp);
                this.createDatXExit(mainComp);
                this.createPassword(mainComp);
                if (accessType.equals((Object)DBDConstants.INDEX)) {
                    this.createFpIndex(mainComp);
                    this.createSharedIdxDb(mainComp);
                } else {
                    this.createPsName(mainComp);
                }
            } else if (accessType.equals((Object)DBDConstants.HIDAM) || accessType.equals((Object)DBDConstants.HISAM) || accessType.equals((Object)DBDConstants.SHSAM) || accessType.equals((Object)DBDConstants.SHISAM)) {
                this.createDatXExit(mainComp);
                this.createPassword(mainComp);
                this.createExit(mainComp);
            } else if (accessType.equals((Object)DBDConstants.DEDB)) {
                this.createExit(mainComp);
                this.createRandomizer(mainComp, accessType);
            } else if (accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.PHIDAM)) {
                this.createDatXExit(mainComp);
                this.createPassword(mainComp);
                this.createExit(mainComp);
                if (accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.PHDAM)) {
                    this.createRandomizer(mainComp, accessType);
                }
                if (accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.PHIDAM)) {
                    this.createPsName(mainComp);
                }
            }
            new Label(mainComp, 0);
            Label encodingLabel = new Label(mainComp, 0);
            encodingLabel.setText(ENCODING);
            this.encoding = new Text(mainComp, 2052);
            this.encoding.setToolTipText(ENCODING_HOVER);
            this.encoding.setLayoutData((Object)new GridData(768));
            Object[] args = new Object[]{new String(Character.toChars(8482)), WorkbenchPlugin.colon.getString("COLON")};
            this.encoding.setToolTipText(WorkbenchPlugin.descriptions.getString("WB23A", args));
            String encodingStr = this.controller.getEncoding();
            if (encodingStr != null && !encodingStr.isEmpty()) {
                this.encoding.setText(encodingStr);
            } else {
                encodingStr = WorkbenchPlugin.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection");
                if (encodingStr == null || encodingStr.isEmpty()) {
                    this.encoding.setText("Cp1047");
                }
            }
            this.encoding.setEnabled(!this.isReadOnly);
            this.encoding.addModifyListener((ModifyListener)this);
            this.encoding.setLayoutData((Object)this.getGridData(4));
            this.encodingError = new Label(mainComp, 0);
            this.encodingError.setImage(errorImg);
            this.encodingError.setVisible(false);
            new Label(mainComp, 0);
            Label remarkLabel = new Label(mainComp, 0);
            remarkLabel.setText(REMARKS);
            remarkLabel.setLayoutData((Object)new GridData(2));
            this.remarks = new Text(mainComp, 2882);
            this.remarks.setTextLimit(255);
            this.remarks.setToolTipText(REMARKS_HOVER);
            String remarksStr = this.controller.getRemarks();
            if (remarksStr != null && !remarksStr.isEmpty()) {
                this.remarks.setText(remarksStr);
            }
            this.remarks.setEnabled(!this.isReadOnly);
            this.remarks.addModifyListener((ModifyListener)this);
            this.remarks.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (e.character == '\t') {
                        e.text = null;
                        EditDbdInfoDialog.this.remarks.traverse(16);
                    } else if (e.character == '\r') {
                        e.text = null;
                        EditDbdInfoDialog.this.remarks.traverse(4, (KeyEvent)e);
                    }
                }
            });
            GridData gData1 = new GridData(1808);
            gData1.minimumHeight = 75;
            gData1.horizontalSpan = 4;
            this.remarks.setLayoutData((Object)gData1);
            this.remarksError = new Label(mainComp, 0);
            this.remarksError.setImage(errorImg);
            this.remarksError.setVisible(false);
            new Label(mainComp, 0);
            Label versionLabel = new Label(mainComp, 0);
            versionLabel.setText(VERSION);
            this.version = new Text(mainComp, 2052);
            this.version.setToolTipText(VERSION_HOVER);
            this.version.setTextLimit(255);
            String versionStr = this.controller.getVersion();
            if (versionStr != null && !versionStr.isEmpty()) {
                this.version.setText(versionStr);
            }
            this.version.setLayoutData((Object)new GridData(768));
            this.version.setEnabled(!this.isReadOnly);
            this.version.addVerifyListener((VerifyListener)this);
            this.version.addModifyListener((ModifyListener)this);
            this.version.setLayoutData((Object)this.getGridData(4));
            new Label(mainComp, 0);
            parent.setSize(container.computeSize(-1, -1));
            this.link.setText(description);
            this.link.setVisible(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.im.ims.workbench.infopop_edit_db_attributes");
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent)", (Throwable)e);
            logger.error((Throwable)e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent)", new Object[]{this.controller.getDBDName()});
        return container;
    }

    private void createDbVer(Composite container) {
        new Label(container, 0);
        Label dbVerLabel = new Label(container, 0);
        dbVerLabel.setText(DBVER);
        this.dbVer = new Text(container, 2052);
        this.dbVer.setToolTipText(DBVER_HOVER);
        this.dbVer.setTextLimit(10);
        String dbVerStr = this.controller.getUserVersion();
        if (dbVerStr != null) {
            this.dbVer.setText(dbVerStr);
        }
        this.dbVer.setLayoutData((Object)new GridData(768));
        this.dbVer.addModifyListener((ModifyListener)this);
        this.dbVer.setEnabled(!this.isReadOnly);
        this.dbVer.setLayoutData((Object)this.getGridData(4));
        this.dbVerError = new Label(container, 0);
        this.dbVerError.setImage(errorImg);
        this.dbVerError.setVisible(false);
    }

    private void createIndexType(Composite container) {
        new Label(container, 0);
        Label protLabel = new Label(container, 0);
        protLabel.setText(PROT);
        this.pointerProt = new Combo(container, 2060);
        this.pointerProt.setToolTipText(PROT_HOVER);
        this.pointerProt.setItems(yesNo);
        this.pointerProt.setText(this.getYesNoString(this.controller.getProt()));
        this.pointerProt.setLayoutData((Object)new GridData(768));
        this.pointerProt.setEnabled(!this.isReadOnly);
        this.pointerProt.addModifyListener((ModifyListener)this);
        this.pointerProt.setLayoutData((Object)this.getGridData(4));
        new Label(container, 0);
        if (this.controller.getAccessType() == DBDConstants.INDEX) {
            new Label(container, 0);
            Label useDosLabel = new Label(container, 0);
            useDosLabel.setText(DOSCOMP);
            this.useDos = new Combo(container, 2060);
            this.useDos.setToolTipText(DOSCOMP_HOVER);
            this.useDos.setItems(new String[]{"", yesNo[0]});
            this.useDos.setText(this.getYesNoString(this.controller.getDoscomp()));
            this.useDos.setLayoutData((Object)new GridData(768));
            this.useDos.setEnabled(!this.isReadOnly);
            this.useDos.addModifyListener((ModifyListener)this);
            this.useDos.setLayoutData((Object)this.getGridData(4));
            new Label(container, 0);
        }
    }

    private void createFpIndex(Composite container) {
        new Label(container, 0);
        Label fpIndexLabel = new Label(container, 0);
        fpIndexLabel.setText(FPINDEX);
        this.fpIndex = new Combo(container, 2060);
        this.fpIndex.setToolTipText(FPINDEX_HOVER);
        this.fpIndex.setItems(new String[]{"", yesNo[0]});
        this.fpIndex.setText(this.getYesNoString(this.controller.getFPindex()));
        this.fpIndex.setLayoutData((Object)new GridData(768));
        this.fpIndex.setEnabled(!this.isReadOnly);
        this.fpIndex.addModifyListener((ModifyListener)this);
        this.fpIndex.setLayoutData((Object)this.getGridData(4));
        new Label(container, 0);
    }

    private void createSharedIdxDb(Composite container) {
        new Label(container, 0);
        Label sharedIxDbLabel = new Label(container, 0);
        sharedIxDbLabel.setText(SHAREDINDEXDBS);
        this.sharedIdxNames = new Text(container, 2060);
        List sharedIdxDbs = this.controller.getSecondaryIxDBDNames();
        if (sharedIdxDbs != null && !sharedIdxDbs.isEmpty()) {
            this.sharedIdxNames.setText(DBDSourceGenerator.addSecondaryIxDBDNames((String)"", (DbdModel)this.controller.getDbdModel()).substring(1));
        }
        this.sharedIdxNames.setLayoutData((Object)new GridData(768));
        this.sharedIdxNames.setLayoutData((Object)this.getGridData(4));
        new Label(container, 0);
    }

    private void createDatXExit(Composite container) {
        new Label(container, 0);
        Label datXLabel = new Label(container, 0);
        datXLabel.setText(DATXEXIT);
        this.datXExit = new Combo(container, 2060);
        this.datXExit.setToolTipText(DATXEXIT_HOVER);
        this.datXExit.setItems(yesNo);
        this.datXExit.setText(this.getYesNoString(this.controller.getDatxexit()));
        this.datXExit.setLayoutData((Object)new GridData(768));
        this.datXExit.setEnabled(!this.isReadOnly);
        this.datXExit.addModifyListener((ModifyListener)this);
        this.datXExit.setLayoutData((Object)this.getGridData(4));
        new Label(container, 0);
    }

    private void createPassword(Composite container) {
        new Label(container, 0);
        Label passwdLabel = new Label(container, 0);
        passwdLabel.setText(PASSWD);
        this.passWord = new Combo(container, 2060);
        this.passWord.setToolTipText(PASSWD_HOVER);
        this.passWord.setItems(yesNo);
        this.passWord.setText(this.getYesNoString(this.controller.getPassword()));
        this.passWord.setLayoutData((Object)new GridData(768));
        this.passWord.setEnabled(!this.isReadOnly);
        this.passWord.addModifyListener((ModifyListener)this);
        this.passWord.setLayoutData((Object)this.getGridData(4));
        new Label(container, 0);
    }

    private void createExit(Composite container) {
        new Label(container, 0);
        Label exitLabel = new Label(container, 0);
        exitLabel.setText(EXIT);
        this.exit = new Text(container, 2052);
        this.exit.setToolTipText(EXIT_HOVER);
        String exits = this.controller.getEXITString();
        if (exits != null) {
            this.exit.setText(exits);
        }
        this.exit.setLayoutData((Object)new GridData(768));
        this.exit.setEnabled(!this.isReadOnly);
        this.exit.addVerifyListener((VerifyListener)this);
        this.exit.addModifyListener((ModifyListener)this);
        this.exit.setLayoutData((Object)this.getGridData(4));
        this.exitError = new Label(container, 0);
        this.exitError.setImage(errorImg);
        this.exitError.setVisible(false);
    }

    private void createRandomizer(Composite container, DBDConstants accessType) {
        Label rmNameReq = new Label(container, 0);
        rmNameReq.setText("*");
        rmNameReq.setForeground(container.getDisplay().getSystemColor(3));
        Label rmNameLabel = new Label(container, 0);
        rmNameLabel.setText(RMNAME);
        this.rmName = new Text(container, 2052);
        this.rmName.setToolTipText(RMNAME_HOVER);
        this.rmName.setTextLimit(8);
        this.rmName.setText(this.controller.getRMName());
        this.rmName.addModifyListener((ModifyListener)this);
        this.rmName.addVerifyListener((VerifyListener)this);
        this.rmName.setLayoutData((Object)new GridData(768));
        this.rmName.setEnabled(!this.isReadOnly);
        this.rmAnch = new Text(container, 2052);
        this.rmAnch.setToolTipText(RMANCH_HOVER);
        String newRmAnch = this.controller.getRmNameAnchorPoints();
        if (newRmAnch != null) {
            this.rmAnch.setText(newRmAnch);
        }
        this.rmAnch.addModifyListener((ModifyListener)this);
        this.rmAnch.setTextLimit(3);
        this.rmAnch.setLayoutData((Object)new GridData(768));
        this.rmAnch.setEnabled(!this.isReadOnly);
        if (accessType == DBDConstants.DEDB) {
            this.rmXCI = new Combo(container, 8);
            this.rmXCI.setToolTipText(RMXCI_HOVER);
            this.rmXCI.setItems(rmNameXCIs);
            String xci = this.controller.getXCI();
            if (xci != null && xci.equals(DBDConstants.Y.value())) {
                this.rmXCI.setText(rmNameXCIs[1]);
            }
            this.rmXCI.addModifyListener((ModifyListener)this);
            this.rmXCI.setLayoutData((Object)this.getGridData(2));
            this.rmXCI.setEnabled(!this.isReadOnly);
        } else {
            this.rmRbn = new Text(container, 2052);
            this.rmRbn.setToolTipText(RMRBN_HOVER);
            String newRmRbn = this.controller.getRmNameMaxRBN();
            if (newRmRbn != null) {
                this.rmRbn.setText(newRmRbn);
            }
            this.rmRbn.addModifyListener((ModifyListener)this);
            this.rmRbn.setTextLimit(8);
            this.rmRbn.setLayoutData((Object)new GridData(768));
            this.rmRbn.setEnabled(!this.isReadOnly);
            this.rmBytes = new Text(container, 2052);
            this.rmBytes.setToolTipText(RMBYTES_HOVER);
            String newRmBytes = this.controller.getRmNameBytes();
            if (newRmBytes != null) {
                this.rmBytes.setText(newRmBytes);
            }
            this.rmBytes.addModifyListener((ModifyListener)this);
            this.rmBytes.setTextLimit(8);
            this.rmBytes.setLayoutData((Object)new GridData(768));
            this.rmBytes.setEnabled(!this.isReadOnly);
        }
        this.rmNameError = new Label(container, 0);
        this.rmNameError.setImage(errorImg);
        this.rmNameError.setVisible(false);
    }

    private void createPsName(Composite container) {
        new Label(container, 0);
        Label psNameLabel = new Label(container, 0);
        psNameLabel.setText(PSNAME);
        this.psName = new Text(container, 2052);
        this.psName.setToolTipText(PSNAME_HOVER);
        this.psName.setTextLimit(8);
        String psNameStr = this.controller.getPsname();
        if (psNameStr != null) {
            this.psName.setText(psNameStr);
        }
        this.psName.setEnabled(!this.isReadOnly);
        this.psName.addVerifyListener((VerifyListener)this);
        this.psName.addModifyListener((ModifyListener)this);
        this.psName.setLayoutData((Object)new GridData(768));
        this.psName.setLayoutData((Object)this.getGridData(4));
        new Label(container, 0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    private void handleRmXCI() {
        this.rmNameError.setVisible(false);
        try {
            String xci = this.rmXCI.getText();
            xci = xci != null && xci.equals(rmNameXCIs[1]) ? YesnoType.Y.value() : YesnoType.N.value();
            this.controller.setXci(xci);
        }
        catch (InvalidInputException e) {
            if (e.getErrorCode() == 12) {
                if (!this.randWarned) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("EISRC27"), (String)e.getMessage());
                    this.randWarned = true;
                }
            } else {
                this.rmNameError.setVisible(true);
                this.rmNameError.setToolTipText(Utility.formatMessage(e.getMessage()));
            }
        }
        catch (ModelException e) {
            this.rmNameError.setVisible(true);
            this.rmNameError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleBytes() {
        this.rmNameError.setVisible(false);
        try {
            this.controller.setRmNameBytes(this.rmBytes.getText().trim());
        }
        catch (InvalidInputException e) {
            if (e.getErrorCode() == 12) {
                if (!this.randWarned) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("EISRC27"), (String)e.getMessage());
                    this.randWarned = true;
                }
            } else {
                this.rmNameError.setVisible(true);
                this.rmNameError.setToolTipText(Utility.formatMessage(e.getMessage()));
            }
        }
        catch (ModelException e) {
            this.rmNameError.setVisible(true);
            this.rmNameError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleRmRbn() {
        this.rmNameError.setVisible(false);
        try {
            this.controller.setRmNameMaxRBN(this.rmRbn.getText().trim());
        }
        catch (InvalidInputException e) {
            if (e.getErrorCode() == 12) {
                if (!this.randWarned) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("EISRC27"), (String)e.getMessage());
                    this.randWarned = true;
                }
            } else {
                this.rmNameError.setVisible(true);
                this.rmNameError.setToolTipText(Utility.formatMessage(e.getMessage()));
            }
        }
        catch (ModelException e) {
            this.rmNameError.setVisible(true);
            this.rmNameError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleRmAnch() {
        this.rmNameError.setVisible(false);
        try {
            this.controller.setRmNameAnchorPoints(this.rmAnch.getText().trim());
        }
        catch (InvalidInputException e) {
            if (e.getErrorCode() == 12) {
                if (!this.randWarned) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("EISRC27"), (String)e.getMessage());
                    this.randWarned = true;
                }
            } else {
                this.rmNameError.setVisible(true);
                this.rmNameError.setToolTipText(Utility.formatMessage(e.getMessage()));
            }
        }
        catch (ModelException e) {
            this.rmNameError.setVisible(true);
            this.rmNameError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleRmName() {
        this.rmNameError.setVisible(false);
        try {
            this.controller.setRMName(this.rmName.getText().trim());
        }
        catch (InvalidInputException e) {
            if (e.getErrorCode() == 12) {
                if (!this.randWarned) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("EISRC27"), (String)e.getMessage());
                    this.randWarned = true;
                }
            } else {
                this.rmNameError.setVisible(true);
                this.rmNameError.setToolTipText(Utility.formatMessage(e.getMessage()));
            }
        }
        catch (ModelException e) {
            this.rmNameError.setVisible(true);
            this.rmNameError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleEncoding() {
        this.encodingError.setVisible(false);
        try {
            this.controller.setEncoding(this.encoding.getText().trim());
        }
        catch (InvalidInputException e) {
            this.encodingError.setVisible(true);
            this.encodingError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleRemarks() {
        this.remarksError.setVisible(false);
        try {
            this.controller.setRemarks(this.remarks.getText().trim());
        }
        catch (InvalidInputException e) {
            this.remarksError.setVisible(true);
            this.remarksError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleVersion() {
        try {
            this.controller.setVersion(this.version.getText().trim());
        }
        catch (InvalidInputException invalidInputException) {}
    }

    private void handleDbVer() {
        this.dbVerError.setVisible(false);
        try {
            this.controller.setDbVer(this.dbVer.getText().trim());
        }
        catch (InvalidInputException e) {
            this.dbVerError.setVisible(true);
            this.dbVerError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handlePsName() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)WorkbenchPlugin.errors.getString("EDIT_DBDSEGM_INFO_MESSAGE_1", (Object[])new String[]{"PSNAME"}));
        this.psName.removeModifyListener((ModifyListener)this);
        String origName = this.controller.getPsname();
        if (origName == null) {
            origName = "";
        }
        this.psName.setText(origName);
        this.psName.addModifyListener((ModifyListener)this);
    }

    private void handleDatXExit() {
        this.controller.setDatxExit(this.getYNString(this.datXExit.getText()));
    }

    private void handleFpIndex() {
        this.controller.setFpIndex(this.getYNString(this.fpIndex.getText()));
    }

    private void handleDos() {
        this.controller.setDoscomp(this.getYNString(this.useDos.getText()));
    }

    private void handleProt() {
        this.controller.setProt(this.getYNString(this.pointerProt.getText()));
    }

    private void handlePassword() {
        this.controller.setPassword(this.getYNString(this.passWord.getText()));
    }

    private void handleExit() {
        this.exitError.setVisible(false);
        try {
            this.controller.setExit(this.exit.getText().trim(), false);
        }
        catch (InvalidInputException e) {
            this.exitError.setVisible(true);
            this.exitError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
        catch (ModelException e) {
            this.exitError.setVisible(true);
            this.exitError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    public void verifyText(VerifyEvent arg0) {
        try {
            if (arg0.character >= 'a' && arg0.character <= 'z') {
                arg0.text = arg0.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    public void modifyText(ModifyEvent event) {
        this.dialogLabel.setVisible(false);
        this.link.setText(description);
        Widget widget = event.widget;
        try {
            if (widget == this.rmName) {
                this.handleRmName();
            } else if (widget == this.rmAnch) {
                this.handleRmAnch();
            } else if (widget == this.rmRbn) {
                this.handleRmRbn();
            } else if (widget == this.rmBytes) {
                this.handleBytes();
            } else if (widget == this.rmXCI) {
                this.handleRmXCI();
            } else if (widget == this.remarks) {
                this.handleRemarks();
            } else if (widget == this.encoding) {
                this.handleEncoding();
            } else if (widget == this.pointerProt) {
                this.handleProt();
            } else if (widget == this.useDos) {
                this.handleDos();
            } else if (widget == this.datXExit) {
                this.handleDatXExit();
            } else if (widget == this.version) {
                this.handleVersion();
            } else if (widget == this.passWord) {
                this.handlePassword();
            } else if (widget == this.fpIndex) {
                this.handleFpIndex();
            } else if (widget == this.dbVer) {
                this.handleDbVer();
            } else if (widget == this.psName) {
                this.handlePsName();
            } else if (widget == this.exit) {
                this.handleExit();
            }
            this.dialogLabel.setVisible(this.exitError != null && this.exitError.isVisible() || this.rmNameError != null && this.rmNameError.isVisible() || this.encodingError != null && this.encodingError.isVisible() || this.remarksError != null && this.remarksError.isVisible() || this.dbVerError != null && this.dbVerError.isVisible());
            if (!this.dialogLabel.isVisible()) {
                this.controller.semanticCheck();
            } else {
                this.link.setText(errorMessage);
            }
        }
        catch (InvalidInputException invalidInputException) {
            this.dialogLabel.setVisible(true);
            this.link.setText(errorMessage);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent arg0)", e);
            logger.error(e);
            this.getButton(0).setEnabled(false);
        }
        this.getButton(0).setEnabled(!this.dialogLabel.getVisible());
    }

    protected void okPressed() {
        try {
            if (this.exit != null) {
                this.controller.setExit(this.exit.getText().trim(), true);
            }
            this.controller.performFinish();
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "okPressed()", (Throwable)e);
            logger.error((Throwable)e);
        }
        super.okPressed();
    }

    private GridData getGridData(int cols) {
        GridData retVal = new GridData(4, 4, true, false, cols, 1);
        return retVal;
    }

    private String getYesNoString(String name) {
        String retVal = "";
        if (name != null) {
            if (name.equals(DBDConstants.Y.value())) {
                retVal = yesNo[0];
            } else if (name.equals(DBDConstants.N.value())) {
                retVal = yesNo[1];
            }
        }
        return retVal;
    }

    private String getYNString(String name) {
        String retVal = null;
        if (name != null) {
            if (name.equals(yesNo[0])) {
                retVal = DBDConstants.Y.value();
            } else if (name.equals(yesNo[1])) {
                retVal = DBDConstants.N.value();
            }
        }
        return retVal;
    }
}

