/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.metadata.dbd.RelType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.editor.DatasetModel;
import com.ibm.im.ims.workbench.controller.editor.EditDatasetController;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EditDatasetInfoDialog
extends StatusDialog
implements ModifyListener,
VerifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EditDatasetController controller;
    private boolean isReadOnly;
    private boolean isUpdated = false;
    private boolean stmtAvail = false;
    private static final int NAME_ATTR = 0;
    private static final int SIZE_ATTR = 1;
    private static final int BLOCK_ATTR = 2;
    private static final int ROOT_ATTR = 3;
    private static final int RECORD_ATTR = 4;
    private static final int UOW_ATTR = 5;
    private static final int FRSPC_ATTR = 6;
    private static final int SCAN_ATTR = 7;
    private static final int OVFL_ATTR = 8;
    private static final String DD1 = WorkbenchPlugin.labels.getString("WB495A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB019") + WorkbenchPlugin.colon.getString("COLON");
    private static final String DD1_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_DD1", (Object[])new String[]{IDialogConstants.OK_LABEL}));
    private static final String AREA = WorkbenchPlugin.labels.getString("WB051") + " " + WorkbenchPlugin.noxlatlabels.getString("WB019") + WorkbenchPlugin.colon.getString("COLON");
    private Combo dsName;
    private static final String LABEL = WorkbenchPlugin.labels.getString("WB495P") + WorkbenchPlugin.colon.getString("COLON");
    private Text dsLabel;
    private static final String DEVICE = WorkbenchPlugin.labels.getString("WB052") + " " + WorkbenchPlugin.noxlatlabels.getString("WB020") + WorkbenchPlugin.colon.getString("COLON");
    private static final String DEVICE_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_DEVICE"));
    private Text device;
    private static final String OUTPUT = WorkbenchPlugin.labels.getString("WB495B") + " " + WorkbenchPlugin.noxlatlabels.getString("WB029") + WorkbenchPlugin.colon.getString("COLON");
    private static final String OVFLW = WorkbenchPlugin.labels.getString("WB495C") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB463") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String DD2_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_DD2"));
    private static final String OVFLW_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_OVFLW"));
    private Text outputOrOverflow;
    private Label outputOrOverflowError;
    private static final String CISIZE = WorkbenchPlugin.labels.getString("WB053") + " " + WorkbenchPlugin.noxlatlabels.getString("WB021") + WorkbenchPlugin.colon.getString("COLON");
    private static final String BLKSIZE = WorkbenchPlugin.labels.getString("WB495E") + " " + WorkbenchPlugin.noxlatlabels.getString("WB021") + WorkbenchPlugin.colon.getString("COLON");
    private static final String SIZE_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_SIZE"));
    private static final String SIZE_HOVER_1 = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_SIZE_1"));
    private static final String SIZE_HOVER_2 = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_SIZE_2"));
    private Text size1;
    private Text size2;
    private Label sizeError;
    private static final String ROOT = WorkbenchPlugin.labels.getString("WB057") + " " + WorkbenchPlugin.noxlatlabels.getString("WB025") + WorkbenchPlugin.colon.getString("COLON");
    private static final String BLOCK = WorkbenchPlugin.labels.getString("WB495D") + " " + WorkbenchPlugin.noxlatlabels.getString("WB030") + WorkbenchPlugin.colon.getString("COLON");
    private static final String ROOT_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_ROOT"));
    private static final String ROOT_HOVER_1 = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_ROOT_1"));
    private static final String BLOCK_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_BLOCK"));
    private static final String BLOCK_HOVER_1 = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_BLOCK_1"));
    private Text rootOrBlock1;
    private Text rootOrBlock2;
    private Label rootOrBlockError;
    private static final String UOW = WorkbenchPlugin.labels.getString("WB055") + " " + WorkbenchPlugin.noxlatlabels.getString("WB022") + WorkbenchPlugin.colon.getString("COLON");
    private static final String RECORD = WorkbenchPlugin.labels.getString("WB495F") + " " + WorkbenchPlugin.noxlatlabels.getString("WB028") + WorkbenchPlugin.colon.getString("COLON");
    private static final String UOW_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_UOW"));
    private static final String UOW_HOVER_1 = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_UOW_1"));
    private static final String RECORD_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_RECORD"));
    private static final String RECORD_HOVER_1 = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_RECORD_1"));
    private Text uowOrRecord1;
    private Text uowOrRecord2;
    private Label uowOrRecordError;
    private static final String FORMAT = WorkbenchPlugin.labels.getString("WB495G") + " " + WorkbenchPlugin.noxlatlabels.getString("WB033") + WorkbenchPlugin.colon.getString("COLON");
    private static final String[] FORMATS = new String[]{DBDConstants.F.value() + " (" + WorkbenchPlugin.labels.getString("WB078") + ")", DBDConstants.FB.value() + " (" + WorkbenchPlugin.labels.getString("WB079") + ")", DBDConstants.V.value() + " (" + WorkbenchPlugin.labels.getString("WB080") + ")", DBDConstants.VB.value() + " (" + WorkbenchPlugin.labels.getString("WB081") + ")", DBDConstants.U.value() + " (" + WorkbenchPlugin.labels.getString("WB082") + ")"};
    private static final String RECFM_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_RECFM"));
    private Combo recFm;
    private static final String FRSPC = WorkbenchPlugin.labels.getString("WB495I") + " " + WorkbenchPlugin.noxlatlabels.getString("WB047") + WorkbenchPlugin.colon.getString("COLON");
    private Text fbff;
    private Text fspf;
    private static final String FRSPC_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_FRSPC"));
    private static final String FRSPC_HOVER_1 = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_FRSPC_1"));
    private Label frspcError;
    private static final String SCAN = WorkbenchPlugin.labels.getString("WB495H") + " " + WorkbenchPlugin.noxlatlabels.getString("WB046") + WorkbenchPlugin.colon.getString("COLON");
    private Text scan;
    private static final String SCAN_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_SCAN"));
    private Label scanError;
    private static final String SEARCHA = WorkbenchPlugin.labels.getString("WB495J") + " " + WorkbenchPlugin.noxlatlabels.getString("WB050") + WorkbenchPlugin.colon.getString("COLON");
    private static final String[] SEARCHAS = new String[]{"0", "1", "2"};
    private Combo searchA;
    private static final String SEARCHA_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_SEARCHA"));
    private static final String REL = WorkbenchPlugin.labels.getString("WB495K") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB471") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String REMARKS = WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String REMARKS_HOVER = Utility.formatMessage(WorkbenchPlugin.descriptions.getString("EDIT_DATASET_REMARKS"));
    private Text remarks;
    private Label remarksError;
    private Link link;
    private static final String description = WorkbenchPlugin.labels.getString("EDIT_DATABASE_DIALOG_DESC");
    private static final String errorMessage = WorkbenchPlugin.errors.getString("EDIT_DBDSEGM_ERROR_MESSAGE");
    private static final Image errorImg = ErrorDialog.getImage((String)"dialog_message_error_image");
    private static final Image bannerImg = Utility.getImageDescriptor("edit_metadata.gif").createImage();
    private Label dialogLabel;
    private DatasetModel dsModel;
    private DBDConstants accessType;

    public EditDatasetInfoDialog(Shell parentShell, DbdModel dbdModel, boolean isReadOnly) throws ModelException {
        super(parentShell);
        this.controller = new EditDatasetController(dbdModel);
        this.accessType = dbdModel.getAccessType();
        if (this.accessType != DBDConstants.PSINDEX && this.accessType != DBDConstants.PHDAM && this.accessType != DBDConstants.PHIDAM && this.accessType != DBDConstants.LOGICAL) {
            this.stmtAvail = true;
            this.isReadOnly = this.accessType == DBDConstants.MSDB ? true : isReadOnly;
            this.setShellStyle(this.getShellStyle() | 0x10);
        }
    }

    protected Control createDialogArea(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent) ", new Object[]{this.controller.getDBDName()});
        this.getShell().setText(WorkbenchPlugin.labels.getString("WFM_EDIT_DATASET_ATTRIBUTES"));
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl_container = new GridLayout(7, false);
        gl_container.verticalSpacing = 0;
        gl_container.marginWidth = 0;
        gl_container.horizontalSpacing = 0;
        gl_container.marginHeight = 0;
        container.setLayout((Layout)gl_container);
        container.setLayoutData((Object)new GridData(1794));
        GridData gd = this.getGridData(7);
        gd.verticalAlignment = 4;
        Composite comp = new Composite(container, this.stmtAvail ? 2048 : 0);
        GridLayout gLayout = new GridLayout(7, false);
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.horizontalSpacing = 0;
        gLayout.verticalSpacing = 0;
        comp.setLayout((Layout)gLayout);
        comp.setLayoutData((Object)gd);
        Composite comp1 = new Composite(comp, 0);
        comp1.setLayout((Layout)new GridLayout(6, false));
        GridData gd1 = new GridData();
        gd1.grabExcessHorizontalSpace = true;
        gd1.minimumHeight = gd.minimumHeight;
        gd1.horizontalSpan = 6;
        gd1.horizontalAlignment = 4;
        comp1.setLayoutData((Object)gd1);
        this.dialogLabel = new Label(comp1, 0);
        this.dialogLabel.setBackground(container.getDisplay().getSystemColor(1));
        this.dialogLabel.setImage(parent.getDisplay().getSystemImage(1));
        this.dialogLabel.setVisible(false);
        this.link = new Link(comp1, 586);
        if (!this.stmtAvail) {
            this.link.setText(WorkbenchPlugin.errors.getString("EISRC61", (Object[])new String[]{this.accessType.value()}));
            this.setHelpAvailable(false);
        } else {
            comp.setBackgroundMode(2048);
            comp.setBackground(container.getDisplay().getSystemColor(1));
            comp1.setBackground(container.getDisplay().getSystemColor(1));
            this.link.setBackground(container.getDisplay().getSystemColor(1));
            this.link.setText(errorMessage);
            this.link.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (EditDatasetInfoDialog.this.accessType == DBDConstants.DEDB) {
                        Program.launch((String)"https://www.ibm.com/support/knowledgecenter/search/%22System%20utilities%22%20%22AREA%20statement%22?scope=SSEPH2&lang=en");
                    } else {
                        Program.launch((String)"https://www.ibm.com/support/knowledgecenter/search/%22System%20utilities%22%20%22DATASET%20statements%22?scope=SSEPH2&lang=en");
                    }
                }
            });
            this.link.setVisible(false);
            GridData gd_link = new GridData(5);
            gd_link.grabExcessVerticalSpace = true;
            gd_link.minimumHeight = EditDatasetInfoDialog.bannerImg.getImageData().height + 10;
            gd_link.grabExcessHorizontalSpace = true;
            gd_link.verticalAlignment = 4;
            gd_link.horizontalSpan = 5;
            gd_link.horizontalAlignment = 4;
            this.link.setLayoutData((Object)gd_link);
            Label bannerLabel = new Label(comp, 0);
            bannerLabel.setBackground(container.getDisplay().getSystemColor(1));
            bannerLabel.setImage(bannerImg);
            GridData gd_bannerLabel = new GridData(128);
            gd_bannerLabel.grabExcessVerticalSpace = true;
            gd_bannerLabel.verticalAlignment = 1024;
            gd_bannerLabel.horizontalAlignment = 131072;
            bannerLabel.setLayoutData((Object)gd_bannerLabel);
            try {
                Composite mainComp = new Composite(parent, 0);
                GridLayout gl_mainComp = new GridLayout(5, false);
                gl_mainComp.verticalSpacing = 5;
                gl_mainComp.marginWidth = 5;
                gl_mainComp.horizontalSpacing = 5;
                gl_mainComp.marginHeight = 5;
                mainComp.setLayout((Layout)gl_mainComp);
                mainComp.setLayoutData((Object)new GridData(1808));
                mainComp.setLayoutData((Object)new GridData(1794));
                DatasetModel ds = this.controller.getDsModel();
                if (this.accessType != DBDConstants.MSDB) {
                    new Label(mainComp, 0);
                    Label label = new Label(mainComp, 0);
                    if (this.accessType == DBDConstants.DEDB) {
                        label.setText(AREA);
                    } else {
                        label.setText(DD1);
                    }
                    this.dsName = new Combo(mainComp, 8);
                    this.dsName.setToolTipText(DD1_HOVER);
                    this.dsName.setItems(this.controller.getDsNames());
                    this.dsName.select(0);
                    this.dsName.setEnabled(true);
                    this.dsName.setLayoutData((Object)this.getGridData(2));
                    this.dsName.addModifyListener((ModifyListener)this);
                    new Label(mainComp, 0);
                }
                if (this.accessType == DBDConstants.DEDB) {
                    this.createSize(mainComp, this.accessType, ds);
                    this.createUowOrRecord(mainComp, this.accessType, ds);
                    this.createRootOrBlock(mainComp, this.accessType, ds);
                } else if (this.accessType == DBDConstants.HSAM || this.accessType == DBDConstants.SHSAM) {
                    this.createOutputOrOverflowDS(mainComp, this.accessType, ds);
                    this.createUowOrRecord(mainComp, this.accessType, ds);
                    this.createRootOrBlock(mainComp, this.accessType, ds);
                } else if (this.accessType == DBDConstants.GSAM) {
                    this.createOutputOrOverflowDS(mainComp, this.accessType, ds);
                    this.createUowOrRecord(mainComp, this.accessType, ds);
                    if (ds.getRootOrBlock1() > 0) {
                        this.createRootOrBlock(mainComp, this.accessType, ds);
                    } else {
                        this.createSize(mainComp, this.accessType, ds);
                    }
                    this.createRecordFormat(mainComp, this.accessType, ds);
                } else if (this.accessType == DBDConstants.HISAM || this.accessType == DBDConstants.INDEX) {
                    this.createOutputOrOverflowDS(mainComp, this.accessType, ds);
                    this.createUowOrRecord(mainComp, this.accessType, ds);
                    if (ds.getRootOrBlock1() > 0) {
                        this.createRootOrBlock(mainComp, this.accessType, ds);
                    } else {
                        this.createSize(mainComp, this.accessType, ds);
                    }
                } else if (this.accessType == DBDConstants.SHISAM) {
                    this.createUowOrRecord(mainComp, this.accessType, ds);
                    if (ds.getRootOrBlock1() > 0) {
                        this.createRootOrBlock(mainComp, this.accessType, ds);
                    } else {
                        this.createSize(mainComp, this.accessType, ds);
                    }
                } else if (this.accessType == DBDConstants.HDAM || this.accessType == DBDConstants.HIDAM) {
                    this.createLabel(mainComp, this.accessType, ds);
                    if (ds.getRootOrBlock1() > 0) {
                        this.createRootOrBlock(mainComp, this.accessType, ds);
                    } else {
                        this.createSize(mainComp, this.accessType, ds);
                    }
                    this.createFreeSpace(mainComp, this.accessType, ds);
                    this.createScan(mainComp, this.accessType, ds);
                    this.createSearchAlgorithm(mainComp, this.accessType, ds);
                } else if (this.accessType == DBDConstants.MSDB) {
                    this.createMsdb(mainComp, this.accessType, ds);
                }
                new Label(mainComp, 0);
                Label deviceLabel = new Label(mainComp, 0);
                deviceLabel.setText(DEVICE);
                this.device = new Text(mainComp, 8);
                this.device.setToolTipText(DEVICE_HOVER);
                String deviceStr = ds.getDevice();
                if (deviceStr != null && !deviceStr.isEmpty()) {
                    this.device.setText(deviceStr);
                }
                this.device.setEnabled(!this.isReadOnly);
                this.device.setLayoutData((Object)this.getGridData(2));
                new Label(mainComp, 0);
                new Label(mainComp, 0);
                Label remarkLabel = new Label(mainComp, 0);
                remarkLabel.setText(REMARKS);
                remarkLabel.setLayoutData((Object)new GridData(2));
                this.remarks = new Text(mainComp, 2882);
                this.remarks.setToolTipText(REMARKS_HOVER);
                this.remarks.setTextLimit(255);
                String remarksStr = ds.getRemarks();
                if (remarksStr != null && !remarksStr.isEmpty()) {
                    this.remarks.setText(remarksStr);
                }
                this.remarks.setEnabled(!this.isReadOnly);
                this.remarks.addModifyListener((ModifyListener)this);
                this.remarks.addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent e) {
                        if (e.character == '\t') {
                            e.text = null;
                            EditDatasetInfoDialog.this.remarks.traverse(16);
                        } else if (e.character == '\r') {
                            e.text = null;
                            EditDatasetInfoDialog.this.remarks.traverse(4, (KeyEvent)e);
                        }
                    }
                });
                GridData gData1 = new GridData(1808);
                gData1.minimumHeight = 75;
                gData1.horizontalSpan = 2;
                this.remarks.setLayoutData((Object)gData1);
                this.remarksError = new Label(mainComp, 0);
                this.remarksError.setImage(errorImg);
                this.remarksError.setVisible(false);
                parent.setSize(container.computeSize(-1, -1));
                this.link.setText(description);
                this.link.setVisible(true);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.im.ims.workbench.infopop_edit_dataset_attributes");
            }
            catch (Exception e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent)", (Throwable)e);
                logger.error((Throwable)e);
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent)", new Object[]{this.controller.getDBDName()});
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    private void createLabel(Composite mainComp, DBDConstants accessType, DatasetModel ds) {
        new Label(mainComp, 0);
        Label label = new Label(mainComp, 0);
        label.setText(LABEL);
        this.dsLabel = new Text(mainComp, 2056);
        String labelStr = ds.getLabel();
        if (labelStr != null) {
            this.dsLabel.setText(labelStr);
        }
        this.dsLabel.setEnabled(false);
        this.dsLabel.setLayoutData((Object)this.getGridData(2));
        new Label(mainComp, 0);
    }

    private void createSize(Composite mainComp, DBDConstants accessType, DatasetModel ds) {
        Label reqLabel = new Label(mainComp, 0);
        Label label = new Label(mainComp, 0);
        if (accessType == DBDConstants.DEDB) {
            reqLabel.setText("*");
            reqLabel.setForeground(mainComp.getDisplay().getSystemColor(3));
            label.setText(CISIZE);
            this.size1 = new Text(mainComp, 2048);
            this.size1.setEnabled(!this.isReadOnly);
            this.size1.setLayoutData((Object)this.getGridData(2));
            Integer size1Int = ds.getSize1();
            if (size1Int != null && size1Int > 0) {
                this.size1.setText(String.valueOf(size1Int));
            }
            this.size1.addModifyListener((ModifyListener)this);
        } else {
            label.setText(BLKSIZE);
            if (accessType == DBDConstants.GSAM || accessType == DBDConstants.HDAM || accessType == DBDConstants.HIDAM) {
                this.size1 = new Text(mainComp, 2048);
                this.size1.setToolTipText(SIZE_HOVER);
                this.size1.setEnabled(!this.isReadOnly);
                this.size1.setLayoutData((Object)this.getGridData(2));
                Integer size1Int = ds.getSize1();
                if (size1Int != null && size1Int > 0) {
                    this.size1.setText(String.valueOf(size1Int));
                }
                this.size1.addModifyListener((ModifyListener)this);
            } else {
                this.size1 = new Text(mainComp, 2048);
                this.size1.setToolTipText(SIZE_HOVER_1);
                this.size1.setEnabled(!this.isReadOnly);
                this.size1.setLayoutData((Object)this.getGridData(1));
                Integer size1Int = ds.getSize1();
                if (size1Int != null && size1Int > 0) {
                    this.size1.setText(String.valueOf(size1Int));
                }
                this.size1.addModifyListener((ModifyListener)this);
                this.size2 = new Text(mainComp, 2048);
                this.size2.setToolTipText(SIZE_HOVER_2);
                this.size2.setEnabled(!this.isReadOnly);
                this.size2.setLayoutData((Object)this.getGridData(1));
                Integer size2Int = ds.getSize2();
                if (size2Int != null && size2Int > 0) {
                    this.size2.setText(String.valueOf(size2Int));
                }
                this.size2.addModifyListener((ModifyListener)this);
            }
        }
        this.sizeError = new Label(mainComp, 0);
        this.sizeError.setImage(errorImg);
        this.sizeError.setVisible(false);
    }

    private void createUowOrRecord(Composite mainComp, DBDConstants accessType, DatasetModel ds) {
        Label reqLabel = new Label(mainComp, 0);
        Label label = new Label(mainComp, 0);
        if (accessType == DBDConstants.DEDB) {
            reqLabel.setText("*");
            reqLabel.setForeground(mainComp.getDisplay().getSystemColor(3));
            label.setText(UOW);
            this.uowOrRecord1 = new Text(mainComp, 2048);
            this.uowOrRecord1.setToolTipText(UOW_HOVER);
            this.uowOrRecord1.setEnabled(!this.isReadOnly);
            this.uowOrRecord1.setLayoutData((Object)this.getGridData(1));
            Integer uowOrRecord1Int = ds.getUowOrRecord1();
            if (uowOrRecord1Int != null && uowOrRecord1Int > 0) {
                this.uowOrRecord1.setText(String.valueOf(uowOrRecord1Int));
            }
            this.uowOrRecord1.addModifyListener((ModifyListener)this);
            this.uowOrRecord2 = new Text(mainComp, 2048);
            this.uowOrRecord2.setToolTipText(UOW_HOVER_1);
            this.uowOrRecord2.setEnabled(!this.isReadOnly);
            this.uowOrRecord2.setLayoutData((Object)this.getGridData(1));
            Integer uowOrRecord2Int = ds.getUowOrRecord2();
            if (uowOrRecord2Int != null && uowOrRecord2Int > 0) {
                this.uowOrRecord2.setText(String.valueOf(uowOrRecord2Int));
            }
            this.uowOrRecord2.addModifyListener((ModifyListener)this);
        } else {
            label.setText(RECORD);
            this.uowOrRecord1 = new Text(mainComp, 2048);
            this.uowOrRecord1.setToolTipText(RECORD_HOVER);
            this.uowOrRecord1.setEnabled(!this.isReadOnly);
            this.uowOrRecord1.setLayoutData((Object)this.getGridData(1));
            Integer uowOrRecord1Int = ds.getUowOrRecord1();
            if (uowOrRecord1Int != null && uowOrRecord1Int > 0) {
                this.uowOrRecord1.setText(String.valueOf(uowOrRecord1Int));
            }
            this.uowOrRecord1.addModifyListener((ModifyListener)this);
            this.uowOrRecord2 = new Text(mainComp, 2048);
            this.uowOrRecord2.setToolTipText(RECORD_HOVER_1);
            this.uowOrRecord2.setEnabled(!this.isReadOnly);
            this.uowOrRecord2.setLayoutData((Object)this.getGridData(1));
            Integer uowOrRecord2Int = ds.getUowOrRecord2();
            if (uowOrRecord2Int != null && uowOrRecord2Int > 0) {
                this.uowOrRecord2.setText(String.valueOf(uowOrRecord2Int));
            }
            this.uowOrRecord2.addModifyListener((ModifyListener)this);
        }
        this.uowOrRecordError = new Label(mainComp, 0);
        this.uowOrRecordError.setImage(errorImg);
        this.uowOrRecordError.setVisible(false);
    }

    private void createRootOrBlock(Composite mainComp, DBDConstants accessType, DatasetModel ds) {
        Label reqLabel = new Label(mainComp, 0);
        if (accessType == DBDConstants.DEDB) {
            reqLabel.setText("*");
            reqLabel.setForeground(mainComp.getDisplay().getSystemColor(3));
        }
        Label label = new Label(mainComp, 0);
        if (accessType == DBDConstants.DEDB) {
            label.setText(ROOT);
            this.rootOrBlock1 = new Text(mainComp, 2048);
            this.rootOrBlock1.setToolTipText(ROOT_HOVER);
            this.rootOrBlock1.setEnabled(!this.isReadOnly);
            this.rootOrBlock1.setLayoutData((Object)this.getGridData(1));
            Integer rootOrBlock1Int = ds.getRootOrBlock1();
            if (rootOrBlock1Int != null && rootOrBlock1Int > 0) {
                this.rootOrBlock1.setText(String.valueOf(rootOrBlock1Int));
            }
            this.rootOrBlock1.addModifyListener((ModifyListener)this);
            this.rootOrBlock2 = new Text(mainComp, 2048);
            this.rootOrBlock2.setToolTipText(ROOT_HOVER_1);
            this.rootOrBlock2.setEnabled(!this.isReadOnly);
            this.rootOrBlock2.setLayoutData((Object)this.getGridData(1));
            Integer rootOrBlock2Int = ds.getRootOrBlock2();
            if (rootOrBlock2Int != null && rootOrBlock2Int > 0) {
                this.rootOrBlock2.setText(String.valueOf(rootOrBlock2Int));
            }
            this.rootOrBlock2.addModifyListener((ModifyListener)this);
        } else {
            label.setText(BLOCK);
            if (accessType == DBDConstants.HSAM || accessType == DBDConstants.SHSAM || accessType == DBDConstants.HISAM || accessType == DBDConstants.INDEX || accessType == DBDConstants.SHISAM) {
                this.rootOrBlock1 = new Text(mainComp, 2048);
                this.rootOrBlock1.setToolTipText(BLOCK_HOVER);
                if (accessType == DBDConstants.HSAM || accessType == DBDConstants.SHSAM) {
                    this.rootOrBlock1.setEnabled(false);
                } else {
                    this.rootOrBlock1.setEnabled(!this.isReadOnly);
                }
                this.rootOrBlock1.setLayoutData((Object)this.getGridData(1));
                Integer rootOrBlock1Int = ds.getRootOrBlock1();
                if (rootOrBlock1Int != null && rootOrBlock1Int > 0) {
                    this.rootOrBlock1.setText(String.valueOf(rootOrBlock1Int));
                }
                this.rootOrBlock1.addModifyListener((ModifyListener)this);
                this.rootOrBlock2 = new Text(mainComp, 2048);
                this.rootOrBlock2.setToolTipText(BLOCK_HOVER_1);
                if (accessType == DBDConstants.HSAM || accessType == DBDConstants.SHSAM) {
                    this.rootOrBlock2.setEnabled(false);
                } else {
                    this.rootOrBlock2.setEnabled(!this.isReadOnly);
                }
                this.rootOrBlock2.setLayoutData((Object)this.getGridData(1));
                Integer rootOrBlock2Int = ds.getRootOrBlock2();
                if (rootOrBlock2Int != null && rootOrBlock2Int > 0) {
                    this.rootOrBlock2.setText(String.valueOf(rootOrBlock2Int));
                }
                this.rootOrBlock2.addModifyListener((ModifyListener)this);
            } else {
                this.rootOrBlock1 = new Text(mainComp, 2048);
                this.rootOrBlock1.setToolTipText(BLOCK_HOVER);
                this.rootOrBlock1.setEnabled(!this.isReadOnly);
                this.rootOrBlock1.setLayoutData((Object)this.getGridData(2));
                Integer rootOrBlock1Int = ds.getRootOrBlock1();
                if (rootOrBlock1Int != null && rootOrBlock1Int > 0) {
                    this.rootOrBlock1.setText(String.valueOf(rootOrBlock1Int));
                }
                this.rootOrBlock1.addModifyListener((ModifyListener)this);
            }
        }
        this.rootOrBlockError = new Label(mainComp, 0);
        this.rootOrBlockError.setImage(errorImg);
        this.rootOrBlockError.setVisible(false);
    }

    private void createOutputOrOverflowDS(Composite mainComp, DBDConstants accessType, DatasetModel ds) {
        Label reqLabel = new Label(mainComp, 0);
        if (accessType != DBDConstants.GSAM) {
            reqLabel.setText("*");
            reqLabel.setForeground(mainComp.getDisplay().getSystemColor(3));
        }
        Label label = new Label(mainComp, 0);
        this.outputOrOverflow = new Text(mainComp, 2048);
        if (accessType == DBDConstants.HISAM || accessType == DBDConstants.INDEX) {
            label.setText(OVFLW);
            this.outputOrOverflow.setToolTipText(OVFLW_HOVER);
        } else {
            label.setText(OUTPUT);
            this.outputOrOverflow.setToolTipText(DD2_HOVER);
        }
        this.outputOrOverflow.setTextLimit(8);
        String dd2Str = ds.getOutPutOrOverflow();
        if (dd2Str != null) {
            this.outputOrOverflow.setText(dd2Str);
        }
        this.outputOrOverflow.setEnabled(!this.isReadOnly);
        this.outputOrOverflow.setLayoutData((Object)this.getGridData(2));
        this.outputOrOverflow.addModifyListener((ModifyListener)this);
        this.outputOrOverflow.addVerifyListener((VerifyListener)this);
        this.outputOrOverflowError = new Label(mainComp, 0);
        this.outputOrOverflowError.setImage(errorImg);
        this.outputOrOverflowError.setVisible(false);
    }

    private void createRecordFormat(Composite mainComp, DBDConstants accessType, DatasetModel ds) {
        new Label(mainComp, 0);
        Label label = new Label(mainComp, 0);
        label.setText(FORMAT);
        this.recFm = new Combo(mainComp, 2056);
        this.recFm.setToolTipText(RECFM_HOVER);
        this.recFm.setItems(FORMATS);
        String formatStr = this.getFormatString(ds.getRecordFormat());
        if (formatStr != null) {
            this.recFm.setText(formatStr);
        }
        this.recFm.setEnabled(!this.isReadOnly);
        this.recFm.setLayoutData((Object)this.getGridData(2));
        this.recFm.addModifyListener((ModifyListener)this);
        new Label(mainComp, 0);
    }

    private void createFreeSpace(Composite mainComp, DBDConstants accessType, DatasetModel ds) {
        new Label(mainComp, 0);
        Label label = new Label(mainComp, 0);
        label.setText(FRSPC);
        this.fbff = new Text(mainComp, 2048);
        this.fbff.setToolTipText(FRSPC_HOVER);
        this.fbff.setEnabled(!this.isReadOnly);
        this.fbff.setLayoutData((Object)this.getGridData(1));
        Integer fbffInt = ds.getFreeBlock();
        if (fbffInt != null && fbffInt > 0) {
            this.fbff.setText(String.valueOf(fbffInt));
        }
        this.fbff.addModifyListener((ModifyListener)this);
        this.fspf = new Text(mainComp, 2048);
        this.fspf.setToolTipText(FRSPC_HOVER_1);
        this.fspf.setEnabled(!this.isReadOnly);
        this.fspf.setLayoutData((Object)this.getGridData(1));
        Integer fspfInt = ds.getFreeSpace();
        if (fspfInt != null && fspfInt > 0) {
            this.fspf.setText(String.valueOf(fspfInt));
        }
        this.fspf.addModifyListener((ModifyListener)this);
        this.frspcError = new Label(mainComp, 0);
        this.frspcError.setImage(errorImg);
        this.frspcError.setVisible(false);
    }

    private void createScan(Composite mainComp, DBDConstants accessType, DatasetModel ds) {
        new Label(mainComp, 0);
        Label label = new Label(mainComp, 0);
        label.setText(SCAN);
        this.scan = new Text(mainComp, 2048);
        this.scan.setToolTipText(SCAN_HOVER);
        Integer scanInt = ds.getScan();
        if (scanInt != null && scanInt > 0) {
            this.scan.setText(String.valueOf(scanInt));
        }
        this.scan.setEnabled(!this.isReadOnly);
        this.scan.setLayoutData((Object)this.getGridData(2));
        this.scan.addModifyListener((ModifyListener)this);
        this.scanError = new Label(mainComp, 0);
        this.scanError.setImage(errorImg);
        this.scanError.setVisible(false);
    }

    private void createSearchAlgorithm(Composite mainComp, DBDConstants accessType, DatasetModel ds) {
        new Label(mainComp, 0);
        Label label = new Label(mainComp, 0);
        label.setText(SEARCHA);
        this.searchA = new Combo(mainComp, 2056);
        this.searchA.setToolTipText(SEARCHA_HOVER);
        this.searchA.setItems(SEARCHAS);
        int searchAInt = ds.getSearchAlgorithm();
        if (searchAInt >= 0 && searchAInt <= 2) {
            this.searchA.select(searchAInt);
        }
        this.searchA.setEnabled(!this.isReadOnly);
        this.searchA.setLayoutData((Object)this.getGridData(2));
        this.searchA.addModifyListener((ModifyListener)this);
        new Label(mainComp, 0);
    }

    private void createMsdb(Composite mainComp, DBDConstants accessType, DatasetModel ds) {
        new Label(mainComp, 0);
        Label label = new Label(mainComp, 0);
        label.setText(REL);
        Text msdb = new Text(mainComp, 2056);
        msdb.setText(this.getLongName(ds.getRelType(), ds.getRelName()));
        msdb.setEnabled(false);
        msdb.setLayoutData((Object)this.getGridData(2));
        new Label(mainComp, 0);
    }

    private String getFormatString(DBDConstants format) {
        String retVal = null;
        if (format == DBDConstants.F) {
            retVal = FORMATS[0];
        } else if (format == DBDConstants.FB) {
            retVal = FORMATS[1];
        } else if (format == DBDConstants.V) {
            retVal = FORMATS[2];
        } else if (format == DBDConstants.VB) {
            retVal = FORMATS[3];
        } else if (format == DBDConstants.U) {
            retVal = FORMATS[4];
        }
        return retVal;
    }

    private String getLongName(String relType, String relName) {
        Object longName = relType;
        if (longName != null) {
            Object fldnm = relName;
            fldnm = fldnm == null ? "" : "," + (String)fldnm;
            if (((String)longName).equalsIgnoreCase(RelType.NO.value())) {
                longName = (String)longName + (String)fldnm + " (" + WorkbenchPlugin.labels.getString("WB495L") + ")";
            } else if (((String)longName).equalsIgnoreCase(RelType.TERM.value())) {
                longName = (String)longName + (String)fldnm + " (" + WorkbenchPlugin.labels.getString("WB495M") + ")";
            } else if (((String)longName).equalsIgnoreCase(RelType.FIXED.value())) {
                longName = (String)longName + (String)fldnm + " (" + WorkbenchPlugin.labels.getString("WB495N") + ")";
            } else if (((String)longName).equalsIgnoreCase(RelType.DYNAMIC.value())) {
                longName = (String)longName + (String)fldnm + " (" + WorkbenchPlugin.labels.getString("WB495O") + ")";
            }
        }
        return longName;
    }

    private void refresh() {
        Integer newValue;
        String newVal;
        boolean update = this.isUpdated;
        if (this.outputOrOverflow != null) {
            newVal = this.dsModel.getOutPutOrOverflow();
            if (newVal != null) {
                this.outputOrOverflow.setText(newVal);
            } else {
                this.outputOrOverflow.setText("");
            }
        }
        if (this.dsLabel != null) {
            newVal = this.dsModel.getLabel();
            if (newVal != null) {
                this.dsLabel.setText(newVal);
            } else {
                this.dsLabel.setText("");
            }
        }
        if (this.device != null) {
            newVal = this.dsModel.getDevice();
            if (newVal != null) {
                this.device.setText(newVal);
            } else {
                this.device.setText("");
            }
        }
        if (this.size1 != null) {
            newValue = this.dsModel.getSize1();
            if (newValue != null && newValue >= 0) {
                this.size1.setText(String.valueOf(newValue));
            } else {
                this.size1.setText("");
            }
        }
        if (this.size2 != null) {
            newValue = this.dsModel.getSize2();
            if (newValue != null && newValue >= 0) {
                this.size2.setText(String.valueOf(newValue));
            } else {
                this.size2.setText("");
            }
        }
        if (this.uowOrRecord1 != null) {
            newValue = this.dsModel.getUowOrRecord1();
            if (newValue != null && newValue >= 0) {
                this.uowOrRecord1.setText(String.valueOf(newValue));
            } else {
                this.uowOrRecord1.setText("");
            }
        }
        if (this.uowOrRecord2 != null) {
            newValue = this.dsModel.getUowOrRecord2();
            if (newValue != null && newValue >= 0) {
                this.uowOrRecord2.setText(String.valueOf(newValue));
            } else {
                this.uowOrRecord2.setText("");
            }
        }
        if (this.rootOrBlock1 != null) {
            int newValue2 = this.dsModel.getRootOrBlock1();
            if (newValue2 >= 0) {
                this.rootOrBlock1.setText(String.valueOf(newValue2));
            } else {
                this.rootOrBlock1.setText("");
            }
        }
        if (this.rootOrBlock2 != null) {
            int newValue3 = this.dsModel.getRootOrBlock2();
            if (newValue3 >= 0) {
                this.rootOrBlock2.setText(String.valueOf(newValue3));
            } else {
                this.rootOrBlock2.setText("");
            }
        }
        if (this.recFm != null) {
            DBDConstants newValue4 = this.dsModel.getRecordFormat();
            if (newValue4 != null) {
                this.recFm.setText(newValue4.value());
            } else {
                this.recFm.setText("");
            }
        }
        if (this.fbff != null) {
            Integer newValue5 = this.dsModel.getFreeBlock();
            if (newValue5 != null && newValue5 >= 0) {
                this.fbff.setText(String.valueOf(newValue5));
            } else {
                this.fbff.setText("");
            }
        }
        if (this.fspf != null) {
            Integer newValue6 = this.dsModel.getFreeSpace();
            if (newValue6 != null && newValue6 >= 0) {
                this.fspf.setText(String.valueOf(newValue6));
            } else {
                this.fspf.setText("");
            }
        }
        if (this.scan != null) {
            int newValue7 = this.dsModel.getScan();
            if (newValue7 >= 0) {
                this.scan.setText(String.valueOf(newValue7));
            } else {
                this.scan.setText("");
            }
        }
        if (this.searchA != null) {
            int newValue8 = this.dsModel.getSearchAlgorithm();
            if (newValue8 >= 0) {
                this.searchA.setText(String.valueOf(newValue8));
            } else {
                this.searchA.setText("");
            }
        }
        if (this.remarks != null) {
            String newValue9 = this.dsModel.getRemarks();
            if (newValue9 != null) {
                this.remarks.setText(newValue9);
            } else {
                this.remarks.setText("");
            }
        }
        this.isUpdated = update;
    }

    private void handleOutputOrOverflow() {
        this.outputOrOverflowError.setVisible(false);
        try {
            this.controller.setOutputOrOverflow(this.dsName.getText(), this.outputOrOverflow.getText().trim());
        }
        catch (InvalidInputException e) {
            this.outputOrOverflowError.setVisible(true);
            this.outputOrOverflowError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleSize1() {
        this.sizeError.setVisible(false);
        try {
            this.controller.setSize1(this.dsName.getText(), this.size1.getText().trim());
        }
        catch (InvalidInputException e) {
            this.sizeError.setVisible(true);
            this.sizeError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleSize2() {
        this.sizeError.setVisible(false);
        try {
            this.controller.setSize2(this.dsName.getText(), this.size2.getText().trim());
        }
        catch (InvalidInputException e) {
            this.sizeError.setVisible(true);
            this.sizeError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleRootOrBlock1() {
        this.rootOrBlockError.setVisible(false);
        try {
            this.controller.setRootOrBlock1(this.dsName.getText(), this.rootOrBlock1.getText().trim());
        }
        catch (InvalidInputException e) {
            this.rootOrBlockError.setVisible(true);
            this.rootOrBlockError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleRootOrBlock2() {
        this.rootOrBlockError.setVisible(false);
        try {
            this.controller.setRootOrBlock2(this.dsName.getText(), this.rootOrBlock2.getText().trim());
        }
        catch (InvalidInputException e) {
            this.rootOrBlockError.setVisible(true);
            this.rootOrBlockError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleUowOrRecord1() {
        this.uowOrRecordError.setVisible(false);
        try {
            this.controller.setUowOrRecord1(this.dsName.getText(), this.uowOrRecord1.getText().trim());
        }
        catch (InvalidInputException e) {
            this.uowOrRecordError.setVisible(true);
            this.uowOrRecordError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleUowOrRecord2() {
        this.uowOrRecordError.setVisible(false);
        try {
            this.controller.setUowOrRecord2(this.dsName.getText(), this.uowOrRecord2.getText().trim());
        }
        catch (InvalidInputException e) {
            this.uowOrRecordError.setVisible(true);
            this.uowOrRecordError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleRecordFormat() {
        String longName = this.recFm.getText().trim();
        try {
            this.controller.setRecordFormat(this.dsName.getText(), longName.substring(0, longName.indexOf(" ")));
        }
        catch (InvalidInputException e) {
            e.printStackTrace();
        }
    }

    private void handleFreeBlock() {
        this.frspcError.setVisible(false);
        try {
            this.controller.setFreeBlock(this.dsName.getText(), this.fbff.getText().trim());
        }
        catch (InvalidInputException e) {
            this.frspcError.setVisible(true);
            this.frspcError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleFreeSpace() {
        this.frspcError.setVisible(false);
        try {
            this.controller.setFreeSpace(this.dsName.getText(), this.fspf.getText().trim());
        }
        catch (InvalidInputException e) {
            this.frspcError.setVisible(true);
            this.frspcError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleScan() {
        this.scanError.setVisible(false);
        try {
            this.controller.setScan(this.dsName.getText(), this.scan.getText().trim());
        }
        catch (InvalidInputException e) {
            this.scanError.setVisible(true);
            this.scanError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleSearchA() {
        try {
            this.controller.setSearchA(this.dsName.getText(), this.searchA.getText().trim());
        }
        catch (InvalidInputException e) {
            e.printStackTrace();
        }
    }

    private void handleRemarks() {
        this.remarksError.setVisible(false);
        try {
            this.controller.setRemarks(this.dsName.getText(), this.remarks.getText().trim());
        }
        catch (InvalidInputException e) {
            this.remarksError.setVisible(true);
            this.remarksError.setToolTipText(Utility.formatMessage(e.getMessage()));
        }
    }

    private void handleName() {
        this.dsModel = this.controller.getDsModel(this.dsName.getText());
        this.refresh();
    }

    public void verifyText(VerifyEvent arg0) {
        try {
            if (arg0.character >= 'a' && arg0.character <= 'z') {
                arg0.text = arg0.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    public void modifyText(ModifyEvent event) {
        this.dialogLabel.setVisible(false);
        this.link.setText(description);
        Widget widget = event.widget;
        if (!this.isUpdated && widget != this.dsName) {
            this.isUpdated = true;
        }
        try {
            if (widget == this.remarks) {
                this.handleRemarks();
            } else if (widget == this.dsName) {
                this.handleName();
            } else if (widget == this.outputOrOverflow) {
                this.handleOutputOrOverflow();
            } else if (widget == this.size1) {
                this.handleSize1();
            } else if (widget == this.size2) {
                this.handleSize2();
            } else if (widget == this.rootOrBlock1) {
                this.handleRootOrBlock1();
            } else if (widget == this.rootOrBlock2) {
                this.handleRootOrBlock2();
            } else if (widget == this.uowOrRecord1) {
                this.handleUowOrRecord1();
            } else if (widget == this.uowOrRecord2) {
                this.handleUowOrRecord2();
            } else if (widget == this.recFm) {
                this.handleRecordFormat();
            } else if (widget == this.fbff) {
                this.handleFreeBlock();
            } else if (widget == this.fspf) {
                this.handleFreeSpace();
            } else if (widget == this.scan) {
                this.handleScan();
            } else if (widget == this.searchA) {
                this.handleSearchA();
            }
            this.dialogLabel.setVisible(this.remarksError != null && this.remarksError.isVisible() || this.sizeError != null && this.sizeError.isVisible() || this.rootOrBlockError != null && this.rootOrBlockError.isVisible() || this.uowOrRecordError != null && this.uowOrRecordError.isVisible() || this.outputOrOverflowError != null && this.outputOrOverflowError.isVisible() || this.frspcError != null && this.frspcError.isVisible() || this.scanError != null && this.scanError.isVisible());
            if (this.remarksError != null && this.remarksError.isVisible() || this.sizeError != null && this.sizeError.isVisible() || this.rootOrBlockError != null && this.rootOrBlockError.isVisible() || this.uowOrRecordError != null && this.uowOrRecordError.isVisible() || this.outputOrOverflowError != null && this.outputOrOverflowError.isVisible() || this.frspcError != null && this.frspcError.isVisible() || this.scanError != null && this.scanError.isVisible()) {
                this.dialogLabel.setVisible(true);
                this.link.setText(errorMessage);
            }
            this.controller.semanticCheck(this.dsName.getText().trim());
            if (!this.dialogLabel.isVisible()) {
                if (widget == this.outputOrOverflow) {
                    this.outputOrOverflowError.setToolTipText(null);
                    this.outputOrOverflowError.setVisible(false);
                } else if (widget == this.size1 || widget == this.size2) {
                    this.sizeError.setToolTipText(null);
                    this.sizeError.setVisible(false);
                } else if (widget == this.rootOrBlock1 || widget == this.rootOrBlock2) {
                    this.rootOrBlockError.setToolTipText(null);
                    this.rootOrBlockError.setVisible(false);
                } else if (widget == this.uowOrRecord1 || widget == this.uowOrRecord2) {
                    this.uowOrRecordError.setToolTipText(null);
                    this.uowOrRecordError.setVisible(false);
                } else if (widget == this.fbff || widget == this.fspf) {
                    this.frspcError.setToolTipText(null);
                    this.frspcError.setVisible(false);
                } else if (widget == this.scan) {
                    this.scanError.setToolTipText(null);
                    this.scanError.setVisible(false);
                }
            }
        }
        catch (InvalidInputException e) {
            this.dialogLabel.setVisible(true);
            this.link.setText(errorMessage);
            int attrValue = this.getAttributeValue(e.getAttrNames());
            if (attrValue == 0 || attrValue == 8) {
                this.outputOrOverflowError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.outputOrOverflowError.setVisible(true);
            } else if (attrValue == 1) {
                this.sizeError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.sizeError.setVisible(true);
            } else if (attrValue == 3 || attrValue == 2) {
                this.rootOrBlockError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.rootOrBlockError.setVisible(true);
            } else if (attrValue == 5 || attrValue == 4) {
                this.uowOrRecordError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.uowOrRecordError.setVisible(true);
            } else if (attrValue == 6) {
                this.frspcError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.frspcError.setVisible(true);
            } else if (attrValue == 7) {
                this.scanError.setToolTipText(Utility.formatMessage(e.getMessage()));
                this.scanError.setVisible(true);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent arg0)", e);
            logger.error(e);
            this.getButton(0).setEnabled(false);
        }
        this.dsName.setEnabled(!this.dialogLabel.getVisible());
        this.getButton(0).setEnabled(!this.dialogLabel.getVisible() && this.isUpdated);
    }

    private int getAttributeValue(String[] attrs) {
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].equals("DD2NAME")) {
                return 0;
            }
            if (attrs[i].equals("SIZE")) {
                return 1;
            }
            if (attrs[i].equals("BLOCK")) {
                return 2;
            }
            if (attrs[i].equals("ROOT")) {
                return 3;
            }
            if (attrs[i].equals("RECORD")) {
                return 4;
            }
            if (attrs[i].equals("UOW")) {
                return 5;
            }
            if (attrs[i].equals("FRSPC-fbff") || attrs[i].equals("FRSPC-fspf")) {
                return 6;
            }
            if (attrs[i].equals("SCAN")) {
                return 7;
            }
            if (attrs[i].equals("OVERFLOW")) {
                return 8;
            }
            ++i;
        }
        return -1;
    }

    protected void okPressed() {
        try {
            if (this.stmtAvail) {
                this.controller.performFinish();
                super.okPressed();
            } else {
                super.cancelPressed();
            }
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "okPressed()", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    private GridData getGridData(int cols) {
        GridData retVal = new GridData(4, 4, true, false, cols, 1);
        return retVal;
    }
}

