/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.ui.core.Utility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EAInputControl
extends Composite {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Display display = this.getDisplay();
    private Label requiredLabel;
    private Label mainLabel;
    private Label iconLabel;
    private Image infoImg;
    private Image warningImg;
    private Image errorImg;
    private Control[] inputControls;
    private EAInputControl syncControl;
    private boolean hasMainLabel = true;
    private boolean isRequired = false;
    private boolean hasImage = false;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    int x0 = 0;
    int x1 = 0;
    int commonOffset = 2;
    int defaultICWidth = 120;

    public EAInputControl(Composite parent, int style) {
        super(parent, style);
        this.hasMainLabel = false;
        this.init();
    }

    public EAInputControl(Composite parent, int style, boolean isRequired) {
        super(parent, style);
        this.hasMainLabel = false;
        this.isRequired = isRequired;
        this.init();
    }

    public EAInputControl(Composite parent, int style, boolean isRequired, Control inputControl) {
        super(parent, style);
        this.hasMainLabel = false;
        this.isRequired = isRequired;
        this.init();
        this.setInputControl(inputControl);
    }

    public EAInputControl(Composite parent, int style, String labelInput, boolean isRequired) {
        super(parent, style);
        this.isRequired = isRequired;
        this.init();
        this.setMainLabelText(labelInput);
    }

    public EAInputControl(Composite parent, int style, String labelInput, boolean isRequired, Control inputControl) {
        super(parent, style);
        this.isRequired = isRequired;
        this.init();
        this.setInputControl(inputControl);
        this.setMainLabelText(labelInput);
    }

    public EAInputControl(Composite parent, int style, String labelInput, boolean isRequired, int x1) {
        super(parent, style);
        this.isRequired = isRequired;
        this.x1 = x1;
        this.init();
        this.setMainLabelText(labelInput);
    }

    public EAInputControl(Composite parent, int style, String labelInput, boolean isRequired, Control inputControl, int x1) {
        super(parent, style);
        this.isRequired = isRequired;
        this.x1 = x1;
        this.init();
        this.setInputControl(inputControl);
        this.setMainLabelText(labelInput);
    }

    public EAInputControl(EAInputControl syncCtrl, String labelInput, boolean isRequired) {
        super(syncCtrl.getParent(), syncCtrl.getStyle());
        this.syncControl = syncCtrl;
        this.isRequired = isRequired;
        this.commonOffset = this.syncControl.getOffsets()[0];
        this.x0 = this.syncControl.getOffsets()[1];
        this.x1 = this.syncControl.getOffsets()[2];
        this.init();
        this.setMainLabelText(labelInput);
        this.syncControl.getMainLabel().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                EAInputControl.this.x0 = EAInputControl.this.syncControl.getOffsets()[1];
            }
        });
    }

    public EAInputControl(EAInputControl syncCtrl, String labelInput, boolean isRequired, Control inputControl) {
        super(syncCtrl.getParent(), syncCtrl.getStyle());
        this.syncControl = syncCtrl;
        this.isRequired = isRequired;
        this.commonOffset = this.syncControl.getOffsets()[0];
        this.x0 = this.syncControl.getOffsets()[1];
        this.x1 = this.syncControl.getOffsets()[2];
        this.init();
        Control[] newInputControls = new Control[]{inputControl};
        this.setInputControls(newInputControls);
        this.setMainLabelText(labelInput);
        this.syncControl.getMainLabel().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                EAInputControl.this.x0 = EAInputControl.this.syncControl.getOffsets()[1];
            }
        });
    }

    private void init() {
        this.requiredLabel = new Label((Composite)this, 16448);
        this.requiredLabel.setForeground(this.display.getSystemColor(3));
        this.requiredLabel.setText("*");
        this.requiredLabel.pack();
        this.x0 = this.requiredLabel.getSize().x + this.commonOffset;
        this.setLayout((Layout)new FormLayout());
        if (!this.isRequired) {
            this.requiredLabel.dispose();
            this.requiredLabel = null;
        }
        if (this.hasMainLabel) {
            this.mainLabel = new Label((Composite)this, 16448);
        }
        this.inputControls = new Control[1];
        Text inputTextBox = new Text((Composite)this, 18432);
        inputTextBox.setSize(this.defaultICWidth, inputTextBox.getSize().y);
        this.inputControls[0] = inputTextBox;
        this.layoutAll();
        this.iconLabel = new Label((Composite)this, 16448);
        ImageDescriptor informationID = Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("infoImg"));
        ImageDescriptor warningID = Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("warningImg"));
        ImageDescriptor errorID = Utility.getImageDescriptor("error_16.gif");
        this.setIcons(informationID.createImage(), warningID.createImage(), errorID.createImage());
        if (this.hasMainLabel) {
            this.mainLabel.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent arg0) {
                    EAInputControl.this.layoutAll();
                }
            });
        }
    }

    public Control[] getInputControls() {
        return this.inputControls;
    }

    public Label getMainLabel() {
        if (this.hasMainLabel) {
            return this.mainLabel;
        }
        return null;
    }

    public int[] getOffsets() {
        int[] offsets = new int[]{this.commonOffset, this.x0, this.x1};
        return offsets;
    }

    public int getPreferredX0() {
        int x;
        if (this.isRequired) {
            x = this.requiredLabel.getSize().x + this.commonOffset;
        } else {
            this.requiredLabel = new Label((Composite)this, 16384);
            this.requiredLabel.setForeground(this.display.getSystemColor(3));
            this.requiredLabel.setText("*");
            this.requiredLabel.pack();
            x = this.requiredLabel.getSize().x + this.commonOffset;
            this.requiredLabel.dispose();
            this.requiredLabel = null;
        }
        return x;
    }

    public void setCommonOffset(int offset) {
        this.commonOffset = offset;
        this.layoutAll();
    }

    public void setIcons(Image infoImg, Image warningImg, Image errorImg) {
        if (infoImg != null && warningImg != null && errorImg != null) {
            this.infoImg = infoImg;
            this.warningImg = warningImg;
            this.errorImg = errorImg;
            this.hasImage = true;
        } else {
            this.hasImage = false;
        }
    }

    public void setInputControl(Control newInputControl) {
        if (newInputControl != null) {
            int i = 0;
            while (i < this.inputControls.length) {
                this.inputControls[i].dispose();
                ++i;
            }
            newInputControl.setParent((Composite)this);
            if (newInputControl.getSize().x == 0) {
                newInputControl.setSize(this.defaultICWidth, newInputControl.getSize().y);
            }
            this.inputControls = new Control[1];
            this.inputControls[0] = newInputControl;
            this.layoutAll();
        }
    }

    public void setInputControls(Control[] newInputControls) {
        if (newInputControls != null) {
            int i = 0;
            while (i < this.inputControls.length) {
                this.inputControls[i].dispose();
                ++i;
            }
            i = 0;
            while (i < newInputControls.length) {
                newInputControls[i].setParent((Composite)this);
                if (newInputControls[i].getSize().x == 0) {
                    newInputControls[i].setSize(this.defaultICWidth, newInputControls[i].getSize().y);
                }
                ++i;
            }
            this.inputControls = newInputControls;
            this.layoutAll();
        }
    }

    public void setMainLabelText(String labelText) {
        if (labelText != null && this.hasMainLabel) {
            this.mainLabel.setText(labelText);
            this.mainLabel.pack();
        }
    }

    public void setMainLabelToolTipText(String labelToolTip) {
        if (labelToolTip != null && this.hasMainLabel) {
            this.mainLabel.setToolTipText(labelToolTip);
            this.mainLabel.pack();
        }
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
        if (this.isRequired && this.requiredLabel == null) {
            this.requiredLabel = new Label((Composite)this, 16384);
            this.requiredLabel.setForeground(this.display.getSystemColor(3));
            this.requiredLabel.setText("*");
        } else if (!this.isRequired && this.requiredLabel != null) {
            this.requiredLabel.dispose();
            this.requiredLabel = null;
        }
        this.layoutAll();
    }

    public void setValidationMessage(String messageText, int messageType) {
        if (messageText != null) {
            if (this.hasImage) {
                switch (messageType) {
                    case 1: {
                        this.iconLabel.setImage(this.infoImg);
                        break;
                    }
                    case 2: {
                        this.iconLabel.setImage(this.warningImg);
                        break;
                    }
                    case 3: {
                        this.iconLabel.setImage(this.errorImg);
                    }
                }
                this.iconLabel.setToolTipText(messageText);
            }
        } else {
            this.iconLabel.setImage(null);
        }
        this.pack();
    }

    public void setX0(int x0) {
        this.x0 = x0;
        this.layoutAll();
    }

    public void setX1(int x1) {
        this.x1 = x1;
        this.layoutAll();
    }

    private void layoutAll() {
        this.layoutInputControls(false);
        this.layoutRequiredLabel();
        this.layoutMainLabel();
        this.layoutIconLabel();
        this.pack();
        this.layoutInputControls(true);
        this.pack();
    }

    private void layoutIconLabel() {
        if (this.iconLabel != null && this.inputControls != null && this.inputControls.length > 0) {
            FormData iconFD = new FormData();
            iconFD.top = new FormAttachment(this.inputControls[0], 0, 0x1000000);
            iconFD.left = new FormAttachment(this.inputControls[this.inputControls.length - 1], this.commonOffset, 131072);
            this.iconLabel.setLayoutData((Object)iconFD);
        }
    }

    private void layoutInputControls(boolean alignX1) {
        if (this.inputControls != null && this.inputControls.length > 0) {
            int x = 0;
            FormData iCFD = new FormData();
            iCFD.top = new FormAttachment(0, 0);
            if (this.hasMainLabel) {
                Rectangle recMainLabel = this.mainLabel.getBounds();
                x = recMainLabel.x + recMainLabel.width + this.commonOffset;
            } else if (this.isRequired) {
                Rectangle recRequiredLabel = this.requiredLabel.getBounds();
                x = recRequiredLabel.x + recRequiredLabel.width + this.commonOffset;
            } else {
                x = this.x0;
            }
            if (x > this.x1 || !alignX1) {
                if (this.hasMainLabel) {
                    iCFD.left = new FormAttachment((Control)this.mainLabel, this.commonOffset, 131072);
                    iCFD.right = new FormAttachment((Control)this.mainLabel, this.commonOffset + this.inputControls[0].getSize().x, 131072);
                } else if (this.isRequired) {
                    iCFD.left = new FormAttachment((Control)this.requiredLabel, this.commonOffset, 131072);
                    iCFD.right = new FormAttachment((Control)this.requiredLabel, this.commonOffset + this.inputControls[0].getSize().x, 131072);
                } else {
                    iCFD.left = new FormAttachment(0, 0);
                    iCFD.right = new FormAttachment(0, this.inputControls[0].getSize().x);
                }
            } else {
                iCFD.left = new FormAttachment(0, this.x1);
                iCFD.right = new FormAttachment(0, this.x1 + this.inputControls[0].getSize().x);
            }
            if (this.inputControls[0].getSize().y != 0) {
                iCFD.bottom = new FormAttachment(0, this.inputControls[0].getSize().y);
            }
            this.inputControls[0].setLayoutData((Object)iCFD);
            int i = 1;
            while (i < this.inputControls.length) {
                iCFD = new FormData();
                iCFD.top = new FormAttachment(0, 0);
                iCFD.left = new FormAttachment(this.inputControls[i - 1], this.commonOffset, 131072);
                iCFD.right = new FormAttachment(this.inputControls[i - 1], this.commonOffset + this.inputControls[0].getSize().x, 131072);
                if (this.inputControls[0].getSize().y != 0) {
                    iCFD.bottom = new FormAttachment(0, this.inputControls[0].getSize().y);
                }
                this.inputControls[i].setLayoutData((Object)iCFD);
                ++i;
            }
        }
    }

    private void layoutMainLabel() {
        if (this.hasMainLabel && this.inputControls != null && this.inputControls.length > 0) {
            FormData labelFD = new FormData();
            labelFD.top = new FormAttachment(this.inputControls[0], 0, 0x1000000);
            labelFD.left = this.isRequired ? new FormAttachment((Control)this.requiredLabel, this.commonOffset, 131072) : new FormAttachment(0, this.x0);
            this.mainLabel.setLayoutData((Object)labelFD);
        }
    }

    private void layoutRequiredLabel() {
        if (this.isRequired && this.inputControls != null && this.inputControls.length > 0) {
            FormData requiredFD = new FormData();
            requiredFD.left = new FormAttachment(0, 0);
            requiredFD.top = new FormAttachment(this.inputControls[0], 0, 0x1000000);
            this.requiredLabel.setLayoutData((Object)requiredFD);
        }
    }
}

