/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.FieldModelImpl;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.utilities.MdlFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DmuToWbMigration {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static Document parseMDLFile(String sourceWorkspace, String sourceProject) throws ParserConfigurationException, SAXException, IOException {
        File mdlDir = new File(sourceWorkspace + File.separator + sourceProject + File.separator + "Diagrams");
        File[] mdlFiles = mdlDir.listFiles(new MdlFileFilter());
        Document document = null;
        if (mdlFiles != null && mdlFiles.length == 1) {
            FileInputStream is = new FileInputStream(mdlFiles[0]);
            DocumentBuilderFactory docBuildFac = DocumentBuilderFactory.newInstance();
            docBuildFac.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = docBuildFac.newDocumentBuilder();
            document = docBuilder.parse(is);
        }
        return document;
    }

    public static void augmentDbdWithMDLAttrs(DbdModel dbd, Document mdlDoc) throws ModelException {
        Node pcbNode = DmuToWbMigration.getPcbNodeForDBD(dbd, mdlDoc);
        if (pcbNode != null) {
            DmuToWbMigration.augmentDbdWithPcbAttrs(dbd, pcbNode);
        }
    }

    public static void augmentPsbWithMDLAttrs(PsbModel psb, Document mdlDoc) {
        NodeList pcbNodes = mdlDoc.getElementsByTagName("PCB");
        int i = 0;
        while (i < pcbNodes.getLength()) {
            NamedNodeMap nodeMap = pcbNodes.item(i).getAttributes();
            String pcbIMSName = nodeMap.getNamedItem("name").getTextContent();
            String pcbAlias = nodeMap.getNamedItem("alias").getTextContent();
            PcbDBModel wbPcb = psb.getDBPcb(pcbIMSName);
            if (wbPcb != null) {
                wbPcb.setPcbAlias(pcbAlias);
            }
            ++i;
        }
    }

    private static Node getPcbNodeForDBD(DbdModel dbd, Document mdlDoc) {
        NodeList pcbNodes = mdlDoc.getElementsByTagName("PCB");
        Node pcbNode = null;
        int i = 0;
        while (i < pcbNodes.getLength()) {
            NamedNodeMap nodeMap = pcbNodes.item(i).getAttributes();
            Node dbdNode = nodeMap.getNamedItem("dbd");
            String dbdName = dbdNode.getTextContent();
            if (dbd.getDBDName().equalsIgnoreCase(dbdName)) {
                pcbNode = pcbNodes.item(i);
                break;
            }
            ++i;
        }
        return pcbNode;
    }

    private static void augmentDbdWithPcbAttrs(DbdModel dbd, Node pcbNode) throws ModelException {
        NodeList segmentNodes = pcbNode.getChildNodes();
        int i = 0;
        while (i < segmentNodes.getLength()) {
            NamedNodeMap nodeMap;
            Node nameNode;
            Node rootSegmentNode = segmentNodes.item(i);
            if (rootSegmentNode.getNodeType() == 1 && (rootSegmentNode.getNodeName().equalsIgnoreCase("Segment") || rootSegmentNode.getNodeName().equalsIgnoreCase("GSAMRecord")) && (nameNode = (nodeMap = rootSegmentNode.getAttributes()).getNamedItem("name")) != null) {
                String rootSegName = nameNode.getTextContent();
                SegmentModel wbSeg = dbd.getSegment(rootSegName);
                DmuToWbMigration.augmentWbSegWithMdlSeg(wbSeg, rootSegmentNode);
            }
            ++i;
        }
    }

    private static void augmentWbSegWithMdlSeg(SegmentModel wbSeg, Node mdlSeg) throws ModelException {
        wbSeg.setName(mdlSeg.getAttributes().getNamedItem("alias").getTextContent());
        DmuToWbMigration.augmentWbFieldsWithMdlFields(wbSeg, mdlSeg);
        NodeList childMdlSegs = mdlSeg.getChildNodes();
        int i = 0;
        while (i < childMdlSegs.getLength()) {
            NamedNodeMap nodeMap;
            Node nameNode;
            String mdlSegName;
            SegmentModel childWbSeg;
            Node childMdlSeg = childMdlSegs.item(i);
            if (childMdlSeg.getNodeType() == 1 && (childMdlSeg.getNodeName().equalsIgnoreCase("Segment") || childMdlSeg.getNodeName().equalsIgnoreCase("GSAMRecord")) && (childWbSeg = wbSeg.getChildSegment(mdlSegName = (nameNode = (nodeMap = childMdlSeg.getAttributes()).getNamedItem("name")).getTextContent())) != null) {
                DmuToWbMigration.augmentWbSegWithMdlSeg(childWbSeg, childMdlSeg);
            }
            ++i;
        }
    }

    private static void augmentWbFieldsWithMdlFields(SegmentModel wbSeg, Node mdlSeg) throws ModelException {
        NodeList mdlFields = mdlSeg.getChildNodes();
        int i = 0;
        while (i < mdlFields.getLength()) {
            Node mdlField = mdlFields.item(i);
            if (mdlField.getNodeType() == 1 && mdlField.getNodeName().equalsIgnoreCase("Field")) {
                DBDConstants dataType;
                NamedNodeMap nodeMap = mdlField.getAttributes();
                Node nameNode = nodeMap.getNamedItem("name");
                String mdlFieldName = nameNode.getTextContent();
                FieldModel wbField = wbSeg.getFieldWithImsNameOrAlias(mdlFieldName);
                if (wbField == null) {
                    wbField = new FieldModelImpl();
                    wbField.setStartPos(Integer.parseInt(nodeMap.getNamedItem("startpos").getTextContent()));
                    wbField.setBytes(Integer.parseInt(nodeMap.getNamedItem("bytes").getTextContent()));
                    wbSeg.addField(wbField);
                }
                wbField.setName(nodeMap.getNamedItem("alias").getTextContent());
                String mdlDatatype = nodeMap.getNamedItem("type").getTextContent();
                if (mdlDatatype != null && mdlDatatype.length() > 0) {
                    if (mdlDatatype.equalsIgnoreCase("BIGINT")) {
                        wbField.setAppDatatype(DBDConstants.LONG);
                    } else if (mdlDatatype.equalsIgnoreCase("INTEGER")) {
                        wbField.setAppDatatype(DBDConstants.INT);
                    } else if (mdlDatatype.equalsIgnoreCase("SMALLINT")) {
                        wbField.setAppDatatype(DBDConstants.SHORT);
                    } else if (mdlDatatype.equalsIgnoreCase("TINYINT")) {
                        wbField.setAppDatatype(DBDConstants.BYTE);
                    } else if (mdlDatatype.equalsIgnoreCase("PACKEDDECIMAL")) {
                        wbField.setAppDatatype(DBDConstants.DECIMAL);
                        wbField.setPhysicalDataType(DBDConstants.PACKEDDECIMAL);
                        wbField.setPackeddecimalSubparms(nodeMap.getNamedItem("typeQualifier").getTextContent());
                    } else if (mdlDatatype.equalsIgnoreCase("ZONEDDECIMAL")) {
                        wbField.setAppDatatype(DBDConstants.DECIMAL);
                        wbField.setPhysicalDataType(DBDConstants.ZONEDDECIMAL);
                        wbField.setZoneddecimalSubparms(nodeMap.getNamedItem("typeQualifier").getTextContent());
                    } else if (mdlDatatype.equalsIgnoreCase("VARCHAR")) {
                        wbField.setAppDatatype(DBDConstants.CHAR);
                    } else {
                        wbField.setAppDatatype(DBDConstants.fromValue((String)mdlDatatype));
                    }
                }
                if ((dataType = wbField.getAppDatatype()) == DBDConstants.DATE || dataType == DBDConstants.TIME || dataType == DBDConstants.TIMESTAMP) {
                    wbField.setPattern(nodeMap.getNamedItem("typeQualifier").getTextContent());
                }
            }
            ++i;
        }
    }
}

