/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class DMUProjectHelp {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private File projectDir;
    private final String PROJECT_FILE = ".project";
    private final String DMU_NATURE_ID = "com.ibm.ims.dlimodel.ui.DLIModelNature";

    public DMUProjectHelp(File projectDir) {
        this.projectDir = projectDir;
    }

    public boolean isDMUProject() {
        File pFile;
        if (this.projectDir != null && this.projectDir.exists() && this.projectDir.isDirectory() && (pFile = new File(this.projectDir.getAbsolutePath() + File.separator + ".project")) != null && pFile.exists() && pFile.isFile()) {
            try {
                return this.checkProjectNature(pFile);
            }
            catch (IOException iOException) {
                return false;
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
        return false;
    }

    private boolean checkProjectNature(File projectFile) throws IOException {
        String strContent = "";
        try (FileInputStream fis = new FileInputStream(projectFile);){
            FileChannel fc = fis.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            strContent = Charset.defaultCharset().decode(bb).toString();
        }
        return strContent.lastIndexOf("com.ibm.ims.dlimodel.ui.DLIModelNature") != -1;
    }
}

