/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.ExpandTable;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractExpandTableEditor
extends Composite
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final String ID = "ID";
    public static final String DEFAULT = "DEFAULT";
    public static final int WIDGET_BUFFER = 10;
    public static final int BUTTON_WIDTH = 80;
    private Button cancelButton;
    private Button okButton;
    protected Composite mainComp;
    protected Composite actionComp;
    protected TableItem tableItem;
    protected TableColumn[] tableColumns;
    protected ArrayList<String> tableColumnNames;
    protected Button cloneButton;
    private ExpandTable parentExpandTable;
    private ArrayList<Control> arrayMainCompInputs;

    public AbstractExpandTableEditor(Composite parent) {
        super(parent, 524288);
        this.init();
    }

    public AbstractExpandTableEditor(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    private void init() {
        super.setLayout((Layout)new FormLayout());
        super.setBackground(new Color(this.getFont().getDevice(), 255, 255, 255));
        this.mainComp = new Composite((Composite)this, 2048);
        FormData fd1 = new FormData();
        fd1.top = new FormAttachment(0, 5);
        fd1.left = new FormAttachment(0, 10);
        fd1.bottom = new FormAttachment(100, -15);
        fd1.right = new FormAttachment(100, -10);
        this.createMainControl(this.mainComp);
        this.mainComp.setLayoutData((Object)fd1);
        this.actionComp = new Composite((Composite)this, 2048);
        FormData fd2 = new FormData();
        fd2 = new FormData();
        fd2.left = new FormAttachment(0, 10);
        fd2.bottom = new FormAttachment(100, -15);
        fd2.right = new FormAttachment(100, -10);
        this.createActionControl(this.actionComp);
        this.actionComp.setLayout((Layout)new FormLayout());
        this.actionComp.setLayoutData((Object)fd2);
        fd1.bottom = new FormAttachment((Control)this.actionComp, 0, 128);
        this.mainComp.setLayoutData((Object)fd1);
        this.setArrayMainCompInputs();
        this.addEditorListeners();
    }

    public abstract void createMainControl(Composite var1);

    public void createActionControl(Composite actionControl) {
        UIHelper uih = new UIHelper();
        Display display = actionControl.getDisplay();
        uih.setDisplay(display);
        FormData fd = new FormData();
        fd = uih.genFormData(null, null, null, new FormAttachment(100, -10));
        this.cancelButton = new Button(actionControl, 8);
        this.cancelButton.setText("Cancel");
        fd.width = 80;
        this.cancelButton.setLayoutData((Object)fd);
        this.cancelButton.addSelectionListener((SelectionListener)this);
        fd = uih.genFormData(null, null, null, new FormAttachment((Control)this.cancelButton, -10));
        this.okButton = new Button(actionControl, 8);
        this.okButton.setText("OK");
        fd.width = 80;
        this.okButton.setLayoutData((Object)fd);
        this.okButton.addSelectionListener((SelectionListener)this);
    }

    public ExpandTable getExpandTable() {
        if (this.parentExpandTable != null) {
            return this.parentExpandTable;
        }
        return null;
    }

    public String getInputDefault(Control control) {
        if (control != null) {
            return (String)control.getData(DEFAULT);
        }
        return null;
    }

    public void restoreInputDefault() {
        int i = 0;
        while (i < this.arrayMainCompInputs.size()) {
            if (this.arrayMainCompInputs.get(i) instanceof Text) {
                Text text = (Text)this.arrayMainCompInputs.get(i);
                defaultInputStr = this.getInputDefault((Control)text);
                if (defaultInputStr != null) {
                    text.setText(defaultInputStr);
                }
            } else if (this.arrayMainCompInputs.get(i) instanceof Combo) {
                Combo combo = (Combo)this.arrayMainCompInputs.get(i);
                defaultInputStr = this.getInputDefault((Control)combo);
                if (defaultInputStr != null) {
                    combo.setText(defaultInputStr);
                }
            } else if (this.arrayMainCompInputs.get(i) instanceof Button) {
                Button button = (Button)this.arrayMainCompInputs.get(i);
                String defaultBoolean = this.getInputDefault((Control)button);
                if (defaultBoolean != null && defaultBoolean.equals("true")) {
                    button.setSelection(true);
                } else {
                    button.setSelection(false);
                }
            }
            ++i;
        }
    }

    public void loaded() {
    }

    public void setEditorData() {
        Control[] children = this.mainComp.getChildren();
        this.setEditorData(children);
    }

    public void setExpandTable(ExpandTable expandTable) {
        this.parentExpandTable = expandTable;
    }

    public void setLayout(Layout layout) {
    }

    public void setEditorData(TableItem item) {
        this.tableItem = item;
        if (this.tableColumns == null) {
            this.tableColumns = this.tableItem.getParent().getColumns();
        }
        this.tableColumnNames = new ArrayList(this.tableColumns.length);
        int i = 0;
        while (i < this.tableColumns.length) {
            this.tableColumnNames.add(i, this.tableColumns[i].getText());
            ++i;
        }
        this.setEditorData(this.mainComp.getChildren());
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    public Button createCloneButton() {
        this.cloneButton = new Button(this.actionComp, 0x1000000);
        this.cloneButton.setText(WorkbenchPlugin.labels.getString("WB090"));
        this.cloneButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                AbstractExpandTableEditor.this.cloneTabItem(AbstractExpandTableEditor.this.tableItem);
            }
        });
        return this.cloneButton;
    }

    public void cloneTabItem(TableItem item) {
        TableItem item2 = this.getExpandTable().addItem("");
        Control[] children = this.mainComp.getChildren();
        this.cloneTabItem(item, item2, children);
        this.setEditorData();
    }

    private void cloneTabItem(TableItem item, TableItem item2, Control[] children) {
        if (children.length > 0 && item != null && item2 != null && this.tableColumns != null) {
            int k = 0;
            while (k < children.length) {
                if (children[k] instanceof Text) {
                    Text text = (Text)children[k];
                    ID = (String)text.getData(ID);
                    if (ID != null) {
                        if (this.tableColumnNames.contains(text.getData(ID))) {
                            item2.setText(this.tableColumnNames.indexOf(text.getData(ID)), item.getText(this.tableColumnNames.indexOf(text.getData(ID))));
                        } else {
                            string = (String)item.getData((String)text.getData(ID));
                            if (string != null) {
                                text.setText(string);
                            } else {
                                text.setText("");
                            }
                            item2.setData(ID, (Object)string);
                        }
                    }
                } else if (children[k] instanceof Combo) {
                    Combo combo = (Combo)children[k];
                    ID = (String)combo.getData(ID);
                    if (ID != null) {
                        string = this.tableColumnNames.contains(combo.getData(ID)) ? item.getText(this.tableColumnNames.indexOf(combo.getData(ID))) : (String)item.getData((String)combo.getData(ID));
                        item2.setText(this.tableColumnNames.indexOf(combo.getData(ID)), string);
                        if (string != null) {
                            combo.setText(string);
                        }
                    }
                } else if (children[k] instanceof Composite) {
                    Composite composite = (Composite)children[k];
                    this.cloneTabItem(item, item2, composite.getChildren());
                }
                ++k;
            }
        }
    }

    protected void setInputDefault(Control control, String controlId, Object defaultString) {
        if (control != null) {
            if (control instanceof Text) {
                Text text = (Text)control;
                text.setData(ID, (Object)controlId);
                text.setData(DEFAULT, defaultString);
            } else if (control instanceof Combo) {
                Combo combo = (Combo)control;
                combo.setData(ID, (Object)controlId);
                combo.setData(DEFAULT, defaultString);
            } else if (control instanceof Button) {
                Button button = (Button)control;
                button.setData(ID, (Object)controlId);
                button.setData(DEFAULT, defaultString);
            }
        }
    }

    private void setArrayMainCompInputs() {
        if (this.arrayMainCompInputs == null) {
            this.arrayMainCompInputs = new ArrayList(0);
        }
        Control[] children = this.mainComp.getChildren();
        this.setArrayMainCompInputs(children);
    }

    private void setArrayMainCompInputs(Control[] children) {
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Text) {
                this.arrayMainCompInputs.add((Control)((Text)children[i]));
            } else if (children[i] instanceof Combo) {
                this.arrayMainCompInputs.add((Control)((Combo)children[i]));
            } else if (children[i] instanceof Button) {
                this.arrayMainCompInputs.add((Control)((Button)children[i]));
            } else if (children[i] instanceof Composite) {
                this.setArrayMainCompInputs(((Composite)children[i]).getChildren());
            }
            ++i;
        }
    }

    private void setEditorData(Control[] children) {
        if (children.length > 0 && this.tableItem != null && this.tableColumns != null) {
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Text) {
                    Text text = (Text)children[i];
                    controlId = (String)text.getData(ID);
                    if (controlId != null) {
                        if (this.tableColumnNames.contains(controlId)) {
                            text.setText(this.tableItem.getText(this.tableColumnNames.indexOf(controlId)));
                        } else {
                            dataStr = (String)this.tableItem.getData(controlId);
                            if (dataStr != null) {
                                text.setText(dataStr);
                            } else {
                                text.setText("");
                            }
                        }
                    }
                } else if (children[i] instanceof Combo) {
                    Combo combo = (Combo)children[i];
                    controlId = (String)combo.getData(ID);
                    if (controlId != null && (dataStr = this.tableColumnNames.contains(controlId) ? this.tableItem.getText(this.tableColumnNames.indexOf(controlId)) : (String)this.tableItem.getData(controlId)) != null) {
                        combo.setText(dataStr);
                    }
                } else if (children[i] instanceof Button) {
                    Button button = (Button)children[i];
                    controlId = (String)button.getData(ID);
                    if (controlId != null) {
                        String buttonLabelStr = null;
                        if (this.tableColumnNames.contains(controlId)) {
                            int colIndex = this.tableColumnNames.indexOf(controlId);
                            buttonLabelStr = this.tableItem.getText(colIndex);
                        } else {
                            buttonLabelStr = (String)this.tableItem.getData(controlId);
                        }
                        if (button.getText().equals(buttonLabelStr)) {
                            button.setSelection(true);
                        } else {
                            button.setSelection(false);
                        }
                    }
                } else if (children[i] instanceof Composite) {
                    Composite composite = (Composite)children[i];
                    this.setEditorData(composite.getChildren());
                }
                ++i;
            }
        }
    }

    public void setTableItemData() {
        Control[] children = this.mainComp.getChildren();
        this.setTableItemData(children);
    }

    private void setTableItemData(Control[] children) {
        if (children.length > 0 && this.tableItem != null && this.tableColumns != null) {
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Text) {
                    Text text = (Text)children[i];
                    widgetId = text.getData(ID);
                    if (this.tableColumnNames.contains(widgetId)) {
                        String widgetValueStr = text.getText();
                        int widgetIndex = this.tableColumnNames.indexOf(widgetId);
                        this.tableItem.setText(widgetIndex, widgetValueStr);
                    } else {
                        String string = text.getText();
                        if (string != null) {
                            this.tableItem.setData((String)widgetId, (Object)string);
                        }
                    }
                } else if (children[i] instanceof Combo) {
                    Combo combo = (Combo)children[i];
                    widgetId = combo.getData(ID);
                    if (this.tableColumnNames.contains(widgetId)) {
                        int widgetIndex = this.tableColumnNames.indexOf(widgetId);
                        String widgetValueStr = combo.getText();
                        this.tableItem.setText(widgetIndex, widgetValueStr);
                    } else if (widgetId != null) {
                        String widgetValueStr = combo.getText();
                        this.tableItem.setData((String)widgetId, (Object)widgetValueStr);
                    }
                } else if (children[i] instanceof Button) {
                    boolean selected;
                    Button button = (Button)children[i];
                    widgetId = (String)button.getData(ID);
                    if (widgetId != null && (selected = button.getSelection())) {
                        String buttonLabelStr = button.getText();
                        if (this.tableColumnNames.contains(widgetId)) {
                            int widgetIndex = this.tableColumnNames.indexOf(widgetId);
                            this.tableItem.setText(widgetIndex, buttonLabelStr);
                        } else {
                            this.tableItem.setData((String)widgetId, (Object)buttonLabelStr);
                        }
                    }
                } else if (children[i] instanceof Composite) {
                    Composite composite = (Composite)children[i];
                    this.setTableItemData(composite.getChildren());
                }
                ++i;
            }
        }
    }

    private void addEditorListeners() {
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                if (AbstractExpandTableEditor.this.getExpandTable() != null) {
                    AbstractExpandTableEditor.this.loaded();
                }
            }

            public void controlResized(ControlEvent e) {
            }
        });
    }

    protected void comboFocusGained(FocusEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.cancelButton) {
            this.parentExpandTable.cancelClicked();
        } else if (e.widget == this.okButton) {
            this.parentExpandTable.okClicked();
        }
    }
}

