/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.navigator.actions;

import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.parts.SegmentEditPart;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerPCBTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerSensegTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeFolder;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.actions.ManageGraphicalAction;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.part.FileEditorInput;

public class ManageSensegAction
extends ActionDelegate {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IMSExplorerSensegTreeObject selectSenSegment;
    public static final String ResourceMultiPageEditorPsbId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorPsb";
    private static final String SensegActionId = "com.ibm.im.ims.workbench.popup.actions.EditSenseg";
    private static final String SenFldActionId = "com.ibm.im.ims.workbench.popup.actions.EditSenFld";
    private String actionId;

    public void init(IAction action) {
        super.init(action);
    }

    public void run(IAction action) {
        try {
            if (this.selectSenSegment == null) {
                return;
            }
            this.actionId = action.getId();
            IFile psbFile = this.getPsbFile(this.selectSenSegment);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            ResourceMultiPageEditor psbEditor = null;
            IViewPart vp = page.findView(ResourceMultiPageEditorPsbId);
            psbEditor = vp == null ? (ResourceMultiPageEditor)page.openEditor((IEditorInput)new FileEditorInput(psbFile), ResourceMultiPageEditorPsbId) : (ResourceMultiPageEditor)vp;
            if (this.actionId.equals(SensegActionId) || this.actionId.equals(SenFldActionId)) {
                ManageGraphicalAction.openPcbGraphicalEditor(psbEditor, window, this.getPcbName(this.selectSenSegment));
                this.openSensegSenFldWizard(psbEditor, window);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "execute(ExecutionEvent event)", e);
            logger.error(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            this.selectSenSegment = obj instanceof IMSExplorerSensegTreeObject ? (IMSExplorerSensegTreeObject)obj : null;
        }
    }

    private String getPcbName(IMSExplorerSensegTreeObject senSegTO) {
        Object parent = senSegTO.getParent();
        while (parent != null) {
            if (parent instanceof IMSExplorerPCBTreeObject) {
                return ((IMSExplorerPCBTreeObject)parent).getName();
            }
            if (!(parent instanceof IMSExplorerTreeObject)) break;
            parent = ((IMSExplorerTreeObject)parent).getParent();
        }
        return null;
    }

    private void openSensegSenFldWizard(ResourceMultiPageEditor psbEditor, IWorkbenchWindow window) throws ModelException {
        SegmentGEFModel gefSegment = this.getSegGEFModel(psbEditor);
        if (gefSegment != null) {
            if (this.actionId.equals(SensegActionId)) {
                psbEditor.launchEditSenSegSenField(gefSegment, window);
            }
            if (this.actionId.equals(SenFldActionId)) {
                psbEditor.launchManageSenflds(gefSegment, window);
            }
        }
    }

    private SegmentGEFModel getSegGEFModel(ResourceMultiPageEditor psbEditor) {
        EditPart editPart_parent = psbEditor.getCurrentPage().getEditPart();
        List editParts2 = editPart_parent.getChildren();
        for (Object child : editParts2) {
            SegmentEditPart sep;
            SegmentGEFModel gefSegment;
            if (!(child instanceof SegmentEditPart) || !(gefSegment = (SegmentGEFModel)(sep = (SegmentEditPart)child).getModel()).getSegmentName().equals(this.selectSenSegment.getName())) continue;
            return gefSegment;
        }
        return null;
    }

    public IFile getPsbFile(IMSExplorerTreeObject pcbTreeObject) {
        Object parent = pcbTreeObject.getParent();
        if (parent instanceof IFile && ((IFile)parent).getFileExtension().equalsIgnoreCase("psb")) {
            return (IFile)parent;
        }
        if (parent instanceof IMSExplorerTreeFolder) {
            if (((IMSExplorerTreeFolder)parent).getParent() instanceof PsbModel) {
                IFile psbFile = ((IMSExplorerTreeFolder)parent).getParentFile();
                return psbFile;
            }
        } else if (parent instanceof IMSExplorerTreeObject) {
            return this.getPsbFile((IMSExplorerTreeObject)parent);
        }
        return null;
    }
}

