/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.navigator.actions;

import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.form.PsbSummaryPage;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PcbTPModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerPCBTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerSensegTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeFolder;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeObject;
import com.ibm.im.ims.workbench.wizard.editpcb.EditDbPcbWizard;
import com.ibm.im.ims.workbench.wizard.editpcb.EditGsamPcbWizard;
import com.ibm.im.ims.workbench.wizard.editpcb.EditTpPcbWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.part.FileEditorInput;

public class ManagePCBAction
extends ActionDelegate {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IMSExplorerPCBTreeObject selectedPCB;
    public static final String ResourceMultiPageEditorPsbId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorPsb";
    public static final String EditPcbId = "com.ibm.im.ims.workbench.popup.actions.EditPcb";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private String actionId;

    public void init(IAction action) {
        super.init(action);
    }

    public void run(IAction action) {
        if (this.selectedPCB == null) {
            return;
        }
        this.actionId = action.getId();
        IFile psbFile = this.getPsbFile(this.selectedPCB);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            ResourceMultiPageEditor psbEditor = null;
            IViewPart vp = page.findView(ResourceMultiPageEditorPsbId);
            if (vp == null) {
                psbEditor = (ResourceMultiPageEditor)page.openEditor((IEditorInput)new FileEditorInput(psbFile), ResourceMultiPageEditorPsbId);
                if (this.actionId.equals(EditPcbId)) {
                    this.openEditPcb(psbEditor, this.selectedPCB.getPcbModel());
                }
            } else {
                psbEditor = (ResourceMultiPageEditor)vp;
            }
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "Run PCB Action", (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IMSExplorerPCBTreeObject) {
                this.selectedPCB = (IMSExplorerPCBTreeObject)obj;
            } else if (obj instanceof IMSExplorerSensegTreeObject) {
                IMSExplorerSensegTreeObject selectedSenseg = (IMSExplorerSensegTreeObject)obj;
                IMSExplorerTreeObject parent = (IMSExplorerTreeObject)selectedSenseg.getParent();
                this.selectedPCB = null;
                while (parent instanceof IMSExplorerTreeObject && !(parent instanceof IMSExplorerPCBTreeObject)) {
                    parent = (IMSExplorerTreeObject)parent.getParent();
                }
                if (parent instanceof IMSExplorerPCBTreeObject) {
                    this.selectedPCB = (IMSExplorerPCBTreeObject)parent;
                }
            } else {
                this.selectedPCB = null;
            }
        }
    }

    public IFile getPsbFile(IMSExplorerTreeObject pcbTreeObject) {
        Object parent = pcbTreeObject.getParent();
        if (parent instanceof IFile && ((IFile)parent).getFileExtension().equalsIgnoreCase("psb")) {
            return (IFile)parent;
        }
        if (parent instanceof IMSExplorerTreeFolder) {
            if (((IMSExplorerTreeFolder)parent).getParent() instanceof PsbModel) {
                IFile psbFile = ((IMSExplorerTreeFolder)parent).getParentFile();
                return psbFile;
            }
        } else if (parent instanceof IMSExplorerTreeObject) {
            return this.getPsbFile((IMSExplorerTreeObject)parent);
        }
        return null;
    }

    public void openEditPcb(ResourceMultiPageEditor psbEditor, Object pcbModel) throws ModelException, CoreException {
        PsbSummaryPage summaryPage = psbEditor.getSummaryPage();
        if (summaryPage != null) {
            WizardDialog dialog;
            TableItem ti;
            if (pcbModel instanceof PcbTPModel) {
                Table tbPcbTable = summaryPage.getTpPcbTable();
                int i = 0;
                while (i < tbPcbTable.getItemCount()) {
                    ti = tbPcbTable.getItem(i);
                    String tbPcbName = ti.getText(1);
                    if (tbPcbName.equals(this.selectedPCB.getName())) {
                        try {
                            EditTpPcbWizard editTbPcbWizard = new EditTpPcbWizard(ti, summaryPage, false, false);
                            dialog = new WizardDialog(summaryPage.getPage().getShell(), (IWizard)editTbPcbWizard);
                            dialog.create();
                            dialog.getShell().setSize(editTbPcbWizard.getShell().getMinimumSize());
                            dialog.open();
                            if (dialog.getReturnCode() == 0) {
                                summaryPage.getRMEParent().setDirty(true);
                                summaryPage.refreshTpPcbTableItems();
                                summaryPage.enableTpPcbButtons();
                            }
                        }
                        catch (Exception e) {
                            logger.throwing(((Object)((Object)this)).getClass().getName(), "open Edit TP PCB Action", (Throwable)e);
                        }
                    }
                    ++i;
                }
            }
            if (pcbModel instanceof PcbDBModel) {
                String pcbNumStr = "";
                String pcbName = this.selectedPCB.getName();
                int poundIx = pcbName.indexOf("#");
                if (poundIx == 4 && pcbName.length() >= 7) {
                    pcbNumStr = pcbName.substring(poundIx + 1, pcbName.length() - 1);
                }
                boolean pcbFound = false;
                Table dbPcbTable = summaryPage.getDbPcbTable();
                int i = 0;
                while (i < dbPcbTable.getItemCount()) {
                    TableItem ti2 = dbPcbTable.getItem(i);
                    String dbPcbName = ti2.getText(1);
                    if (dbPcbName.isEmpty()) {
                        String currPcbNumStr = ti2.getText(0);
                        if (currPcbNumStr.equals(pcbNumStr)) {
                            dbPcbTable.deselectAll();
                            dbPcbTable.select(i);
                            pcbFound = true;
                        }
                    } else if (dbPcbName.equals(pcbName)) {
                        dbPcbTable.deselectAll();
                        dbPcbTable.select(i);
                        pcbFound = true;
                    }
                    if (pcbFound) {
                        EditDbPcbWizard editDbPcbWizard = new EditDbPcbWizard(ti2, summaryPage, false, false);
                        WizardDialog dialog2 = new WizardDialog(summaryPage.getPage().getShell(), (IWizard)editDbPcbWizard);
                        dialog2.create();
                        dialog2.getShell().setSize(editDbPcbWizard.getShell().getMinimumSize());
                        dialog2.open();
                        if (dialog2.getReturnCode() != 0) break;
                        summaryPage.getRMEParent().setDirty(true);
                        summaryPage.refreshDbPcbTableItems();
                        summaryPage.enableDbPcbButtons();
                        break;
                    }
                    ++i;
                }
            }
            if (pcbModel instanceof PcbGsamModel) {
                Table gsamPcbTable = summaryPage.getGsamPcbTable();
                int i = 0;
                while (i < gsamPcbTable.getItemCount()) {
                    ti = gsamPcbTable.getItem(i);
                    String gsamPcbName = ti.getText(1);
                    if (gsamPcbName.equals(this.selectedPCB.getName())) {
                        gsamPcbTable.deselectAll();
                        gsamPcbTable.select(i);
                        try {
                            EditGsamPcbWizard editGsamPcbWizard = new EditGsamPcbWizard(ti, summaryPage, false, false);
                            dialog = new WizardDialog(summaryPage.getPage().getShell(), (IWizard)editGsamPcbWizard);
                            dialog.create();
                            dialog.getShell().setSize(editGsamPcbWizard.getShell().getMinimumSize());
                            dialog.open();
                            if (dialog.getReturnCode() == 0) {
                                summaryPage.getRMEParent().setDirty(true);
                                summaryPage.refreshGsamPcbTableItems();
                                summaryPage.enableGsamPcbButtons();
                            }
                        }
                        catch (Exception e) {
                            logger.throwing(((Object)((Object)this)).getClass().getName(), "open Edit GSAM PCB Action", (Throwable)e);
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

