/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.navigator.actions;

import com.ibm.im.ims.workbench.editors.InvalidDBDSourceException;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.form.PsbSummaryPage;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerPCBTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeFolder;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeObject;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.part.FileEditorInput;

public class ManageGraphicalAction
extends ActionDelegate {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IMSExplorerPCBTreeObject selectedDbPcb;
    public static final String LAUNCH_PSB_SUMMARY_EDITOR_ID = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorPsb";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public void init(IAction action) {
        super.init(action);
    }

    public void run(IAction action) {
        if (this.selectedDbPcb == null) {
            return;
        }
        IFile psbFile = this.getPsbFile(this.selectedDbPcb);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            ResourceMultiPageEditor psbEditor = null;
            IViewPart vp = page.findView(LAUNCH_PSB_SUMMARY_EDITOR_ID);
            psbEditor = vp == null ? (ResourceMultiPageEditor)page.openEditor((IEditorInput)new FileEditorInput(psbFile), LAUNCH_PSB_SUMMARY_EDITOR_ID) : (ResourceMultiPageEditor)vp;
            ManageGraphicalAction.openPcbGraphicalEditor(psbEditor, window, this.selectedDbPcb.getName());
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "execute(ExecutionEvent event)", e);
            logger.error(e);
        }
    }

    public static void openPcbGraphicalEditor(ResourceMultiPageEditor psbEditor, IWorkbenchWindow window, String pcbName) throws ModelException, CoreException, InvalidDBDSourceException {
        String pcbNumStr = "";
        int poundIx = pcbName.indexOf("#");
        if (poundIx == 4 && pcbName.length() >= 7) {
            pcbNumStr = pcbName.substring(poundIx + 1, pcbName.length() - 1);
        }
        PsbSummaryPage summaryPage = psbEditor.getSummaryPage();
        boolean pcbFound = false;
        if (summaryPage != null) {
            Table dbPcbTable = summaryPage.getDbPcbTable();
            int i = 0;
            while (i < dbPcbTable.getItemCount()) {
                TableItem ti = dbPcbTable.getItem(i);
                String dbPcbName = ti.getText(1);
                if (dbPcbName.isEmpty()) {
                    String currPcbNumStr = ti.getText(0);
                    if (currPcbNumStr.equals(pcbNumStr)) {
                        dbPcbTable.deselectAll();
                        dbPcbTable.select(i);
                        pcbFound = true;
                    }
                } else if (dbPcbName.equals(pcbName)) {
                    dbPcbTable.deselectAll();
                    dbPcbTable.select(i);
                    pcbFound = true;
                }
                if (pcbFound) {
                    summaryPage.setActivePage();
                    break;
                }
                ++i;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            this.selectedDbPcb = obj instanceof IMSExplorerPCBTreeObject ? (IMSExplorerPCBTreeObject)obj : null;
        }
    }

    public IFile getPsbFile(IMSExplorerTreeObject pcbTreeObject) {
        Object parent = pcbTreeObject.getParent();
        if (parent instanceof IFile && ((IFile)parent).getFileExtension().equalsIgnoreCase("psb")) {
            return (IFile)parent;
        }
        if (parent instanceof IMSExplorerTreeFolder) {
            if (((IMSExplorerTreeFolder)parent).getParent() instanceof PsbModel) {
                IFile psbFile = ((IMSExplorerTreeFolder)parent).getParentFile();
                return psbFile;
            }
        } else if (parent instanceof IMSExplorerTreeObject) {
            return this.getPsbFile((IMSExplorerTreeObject)parent);
        }
        return null;
    }
}

