/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.navigator.actions;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.editors.InvalidDBDSourceException;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.parts.DbEditPart;
import com.ibm.im.ims.workbench.editors.parts.SegmentEditPart;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerSegmentTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeObject;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.part.FileEditorInput;

public class ManageArtifactAction
extends ActionDelegate {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final String ResourceMultiPageEditorDbdId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd";
    public static final String ManageSegmentActionId = "com.ibm.im.ims.workbench.popup.actions.ManageSegmentAction";
    public static final String ManageMappingActionId = "com.ibm.im.ims.workbench.popup.actions.ManageMappingAction";
    public static final String ImportCobolActionId = "com.ibm.im.ims.workbench.popup.actions.ImportCobolAction";
    public static final String EditSegmentAttributes = "com.ibm.im.ims.workbench.editEncoding";
    private IMSExplorerSegmentTreeObject selectedSegment;
    private String actionId;

    public void init(IAction action) {
        super.init(action);
    }

    public void run(IAction action) {
        if (this.selectedSegment == null) {
            return;
        }
        this.actionId = action.getId();
        IFile dbdFile = ManageArtifactAction.getDbdFile(this.selectedSegment);
        try {
            String projectName = dbdFile.getProject().getName();
            String dbdName = this.selectedSegment.getDbdName();
            String segmentName = this.selectedSegment.getName();
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            boolean isProjectWFMEnabled = FieldImportWorkflowModelUtil.isProjectWorkflowEnabled((String)projectName);
            if (isProjectWFMEnabled && this.actionId.equals(ImportCobolActionId)) {
                Utility.selectSegmentInWfmEditor(Utility.launchWfmEditor(projectName, dbdName, segmentName), dbdName, segmentName, ImportCobolActionId);
                if (!store.getBoolean("WFM_DS_IMPORT_WARNING")) {
                    Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("WFM_IMPORT_COBOL"), WorkbenchModelBundle.getLabel().getString("WFM_TITLE")};
                    String msg = WorkbenchModelBundle.getDescription().getString("IDSWM_ACTION_DISALLOWED_FROM_EXPLORER_VIEW", inserts);
                    Utility.openInformationDialog(msg, inserts);
                }
            } else if (isProjectWFMEnabled && this.actionId.equals(ManageMappingActionId)) {
                Utility.selectSegmentInWfmEditor(Utility.launchWfmEditor(projectName, dbdName, segmentName), dbdName, segmentName, ManageMappingActionId);
                if (!store.getBoolean("WFM_DS_IMPORT_WARNING")) {
                    Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("WFM_ADDEDIT_MAP"), WorkbenchModelBundle.getLabel().getString("WFM_TITLE")};
                    String msg = WorkbenchModelBundle.getDescription().getString("IDSWM_ACTION_DISALLOWED_FROM_EXPLORER_VIEW", inserts);
                    Utility.openInformationDialog(msg, inserts);
                }
            } else if (isProjectWFMEnabled && this.actionId.equals(ManageSegmentActionId)) {
                Utility.selectSegmentInWfmEditor(Utility.launchWfmEditor(projectName, dbdName, segmentName), dbdName, segmentName, ManageSegmentActionId);
                if (!store.getBoolean("WFM_DS_IMPORT_WARNING")) {
                    Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("WFM_ADD_EDIT_FIELD"), WorkbenchModelBundle.getLabel().getString("WFM_TITLE")};
                    String msg = WorkbenchModelBundle.getDescription().getString("IDSWM_ACTION_DISALLOWED_FROM_EXPLORER_VIEW", inserts);
                    Utility.openInformationDialog(msg, inserts);
                }
            } else if (isProjectWFMEnabled && this.actionId.equals(EditSegmentAttributes)) {
                Utility.selectSegmentInWfmEditor(Utility.launchWfmEditor(projectName, dbdName, segmentName), dbdName, segmentName, EditSegmentAttributes);
                if (!store.getBoolean("WFM_DS_IMPORT_WARNING")) {
                    Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("WFM_ADD_EDIT_FIELD"), WorkbenchModelBundle.getLabel().getString("WFM_TITLE")};
                    String msg = WorkbenchModelBundle.getDescription().getString("IDSWM_ACTION_DISALLOWED_FROM_EXPLORER_VIEW", inserts);
                    Utility.openInformationDialog(msg, inserts);
                }
            } else if (this.actionId.equals(EditSegmentAttributes)) {
                SegmentGEFModel segGEFModel;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                ResourceMultiPageEditor dbdEditor = null;
                page.findView(ResourceMultiPageEditorDbdId);
                dbdEditor = (ResourceMultiPageEditor)page.openEditor((IEditorInput)new FileEditorInput(dbdFile), ResourceMultiPageEditorDbdId);
                ResourceEditorPage editorPage = dbdEditor.getCurrentPage();
                DbGEFModel dbGEFModel = editorPage.getDbGEFModel();
                if (dbGEFModel != null && (segGEFModel = dbGEFModel.getSegmentGEFModel(segmentName)) != null) {
                    SegmentEditPart segEditPart = ManageArtifactAction.getSelectedSegment(editorPage, segmentName);
                    if (segEditPart != null) {
                        ManageArtifactAction.revealEditPart(editorPage, (GraphicalEditPart)segEditPart);
                        editorPage.setSelectedPart((EditPart)segEditPart);
                    }
                    dbGEFModel.launchEditEncoding(segGEFModel, window, false);
                }
            } else {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                ResourceMultiPageEditor dbdEditor = null;
                page.findView(ResourceMultiPageEditorDbdId);
                dbdEditor = (ResourceMultiPageEditor)page.openEditor((IEditorInput)new FileEditorInput(dbdFile), ResourceMultiPageEditorDbdId);
                this.openManageWizard(dbdEditor, window);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "Manage Field and Mapping Action", e);
        }
    }

    private void openManageWizard(ResourceMultiPageEditor dbdEditor, IWorkbenchWindow window) throws ModelException, InvalidDBDSourceException {
        SegmentGEFModel gefSegment = this.getSegGEFModel(dbdEditor);
        if (gefSegment != null) {
            if (this.actionId.equals(ManageSegmentActionId)) {
                if (gefSegment.getSegmentModel().isVirtualLogicalChild()) {
                    MessageDialog.openError((Shell)window.getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("NO_LAUNCH_MNG_FIELDS_VLC"));
                } else {
                    dbdEditor.launchManageField(gefSegment, window);
                }
            }
            if (this.actionId.equals(ManageMappingActionId)) {
                if (gefSegment.getSegmentModel().isVirtualLogicalChild()) {
                    MessageDialog.openError((Shell)window.getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("NO_LAUNCH_MNG_FIELDS_VLC"));
                } else {
                    dbdEditor.launchManageMappings(gefSegment, window);
                }
            }
            if (this.actionId.equals(ImportCobolActionId)) {
                if (gefSegment.getSegmentModel().isVirtualLogicalChild()) {
                    MessageDialog.openError((Shell)window.getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("NO_LAUNCH_MNG_FIELDS_VLC"));
                } else {
                    dbdEditor.launchImportDataStructure(gefSegment, window);
                }
            }
        }
    }

    private SegmentGEFModel getSegGEFModel(ResourceMultiPageEditor dbdEditor) {
        EditPart editPart_parent = dbdEditor.getCurrentPage().getEditPart();
        List editParts2 = editPart_parent.getChildren();
        for (Object child : editParts2) {
            SegmentEditPart sep;
            SegmentGEFModel gefSegment;
            if (!(child instanceof SegmentEditPart) || !(gefSegment = (SegmentGEFModel)(sep = (SegmentEditPart)child).getModel()).getSegmentName().equals(this.selectedSegment.getName()) && !gefSegment.getSegmentAlias().equals(this.selectedSegment.getName())) continue;
            return gefSegment;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            this.selectedSegment = obj instanceof IMSExplorerSegmentTreeObject ? (IMSExplorerSegmentTreeObject)obj : null;
        }
    }

    public static IFile getDbdFile(IMSExplorerTreeObject treeObject) {
        Object parent = treeObject.getParent();
        if (parent instanceof IFile && ((IFile)parent).getFileExtension().equalsIgnoreCase("dbd")) {
            return (IFile)parent;
        }
        if (parent instanceof IMSExplorerTreeObject) {
            return ManageArtifactAction.getDbdFile((IMSExplorerTreeObject)parent);
        }
        return null;
    }

    public static SegmentEditPart getSelectedSegment(ResourceEditorPage editorPage, String segmentName) {
        SegmentEditPart retVal = null;
        DbEditPart dbEditPart = (DbEditPart)editorPage.getEditPart();
        List children = dbEditPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            SegmentEditPart segEditPart;
            SegmentGEFModel segmentGEFModel;
            if (children.get(i) instanceof SegmentEditPart && ((segmentGEFModel = (SegmentGEFModel)(segEditPart = (SegmentEditPart)children.get(i)).getModel()).getSegmentName().contains(segmentName) || segmentGEFModel.getSegmentAlias().contains(segmentName))) {
                retVal = segEditPart;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public static void revealEditPart(ResourceEditorPage editorPage, GraphicalEditPart editPart) {
        IFigure target = editPart.getFigure();
        FigureCanvas figureCanvas = (FigureCanvas)editorPage.getViewer().getControl();
        figureCanvas.scrollTo(target.getBounds().x - 100, target.getBounds().y - 100);
    }
}

