/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.navigator.actions;

import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.parts.SegmentEditPart;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerSegmentTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.actions.ManageArtifactAction;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.logging.Level;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class LaunchDBDFromDSE
implements IHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ResourceMultiPageEditorPsbId = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd";
    public static final String EditPcbId = "com.ibm.im.ims.workbench.popup.actions.EditPcb";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "execute(ExecutionEvent event)", new Object[0]);
        }
        try {
            Object obj;
            TreeSelection currSel;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && (currSel = (TreeSelection)selection).size() == 1 && (obj = currSel.getFirstElement()) instanceof IMSExplorerSegmentTreeObject) {
                SegmentEditPart segEditPart;
                SegmentGEFModel segGEFModel;
                IMSExplorerSegmentTreeObject selectedSegment = (IMSExplorerSegmentTreeObject)obj;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                page.findView(ResourceMultiPageEditorPsbId);
                IFile dbdFile = ManageArtifactAction.getDbdFile(selectedSegment);
                String segmentName = selectedSegment.getName();
                ResourceMultiPageEditor dbdEditor = (ResourceMultiPageEditor)page.openEditor((IEditorInput)new FileEditorInput(dbdFile), ResourceMultiPageEditorPsbId);
                ResourceEditorPage editorPage = dbdEditor.getCurrentPage();
                DbGEFModel dbGEFModel = editorPage.getDbGEFModel();
                if (dbGEFModel != null && (segGEFModel = dbGEFModel.getSegmentGEFModel(segmentName)) != null && (segEditPart = ManageArtifactAction.getSelectedSegment(editorPage, segmentName)) != null) {
                    ManageArtifactAction.revealEditPart(editorPage, (GraphicalEditPart)segEditPart);
                    editorPage.setSelectedPart((EditPart)segEditPart);
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "Run PCB Action", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "execute(ExecutionEvent event)", new Object[0]);
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

