/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.navigator;

import com.ibm.im.ims.workbench.controller.editor.ResourceEditorController;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.ModelControl;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class ResourceManager {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static HashMap<String, ModelControl> resourcesCache = new HashMap();

    public static void putDbdModel(String projectName, DbdModel model) {
        String key = ResourceManager.getKey(projectName, model.getDBDName());
        if (!resourcesCache.containsKey(key)) {
            ModelControl modelResource = new ModelControl(model);
            resourcesCache.put(key, modelResource);
        }
    }

    private static void putPsbModel(String projectName, PsbModel psbModel) {
        String key = ResourceManager.getKey(projectName, psbModel.getPsbName());
        if (!resourcesCache.containsKey(key)) {
            ModelControl modelResource = new ModelControl(psbModel);
            resourcesCache.put(key, modelResource);
        }
    }

    public static DbdModel getDbdModel(String projectName, String dbdName, IMSExplorerTreeObject to) {
        String key = ResourceManager.getKey(projectName, dbdName);
        ModelControl modelCtrl = resourcesCache.get(key);
        if (modelCtrl != null) {
            DbdModel dbdModel = (DbdModel)modelCtrl.getModel();
            modelCtrl.addClientTreeObject(to);
            return dbdModel;
        }
        return null;
    }

    public static DbdModel getDbdModel(IFile dbdFile) throws ModelException, CoreException {
        String dbdFileName;
        String dbdFileNameNoExt;
        String projectName = dbdFile.getProject().getName();
        String key = ResourceManager.getKey(projectName, dbdFileNameNoExt = (dbdFileName = dbdFile.getName()).substring(0, dbdFileName.lastIndexOf(46)));
        if (resourcesCache.containsKey(key)) {
            return (DbdModel)resourcesCache.get(key).getModel();
        }
        ResourceEditorController reController = new ResourceEditorController(dbdFile.getContents(), false, projectName);
        return reController.getDbdModel();
    }

    public static PsbModel getPsbModel(IFile psbFile) throws ModelException, CoreException {
        String psbFileName;
        String psbFileNameNoExt;
        String projectName = psbFile.getProject().getName();
        String key = ResourceManager.getKey(projectName, psbFileNameNoExt = (psbFileName = psbFile.getName()).substring(0, psbFileName.lastIndexOf(46)));
        if (resourcesCache.containsKey(key)) {
            return (PsbModel)resourcesCache.get(key).getModel();
        }
        PsbModel psbModel = (PsbModel)ResourceManager.loadModel(psbFile);
        ResourceManager.putPsbModel(projectName, psbModel);
        return psbModel;
    }

    private static String getKey(String projectName, String modelName) {
        return projectName + "." + modelName;
    }

    public static void refresh(IFile resource) {
        String fileName;
        String modelName;
        String projName = resource.getProject().getName();
        if (!resourcesCache.containsKey(ResourceManager.getKey(projName, modelName = (fileName = resource.getName()).substring(0, fileName.lastIndexOf(46))))) {
            return;
        }
        Object model = null;
        try {
            model = ResourceManager.loadModel(resource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ModelControl modelCtrl = resourcesCache.get(ResourceManager.getKey(projName, modelName));
        modelCtrl.setModel(model);
    }

    public static void removeResourceFromCache(IFile modelFile) {
        String projName = modelFile.getProject().getName();
        String fileName = modelFile.getName();
        String modelName = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) : "";
        resourcesCache.remove(ResourceManager.getKey(projName, modelName));
    }

    private static Object loadModel(IFile resource) throws ModelException, CoreException {
        String projectName = resource.getProject().getName();
        if (IMSExplorerTreeObject.isDBDFile(resource)) {
            ResourceEditorController reController = new ResourceEditorController(resource.getContents(), false, projectName);
            return reController.getDbdModel();
        }
        if (IMSExplorerTreeObject.isPSBFile(resource)) {
            ResourceEditorController reController = new ResourceEditorController(resource.getContents(), true, projectName);
            return reController.getPsbModel();
        }
        return null;
    }
}

