/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.navigator;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PcbTPModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerPCBTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeParent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class IMSExplorerTreeFolder
extends IMSExplorerTreeParent {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String PCB_TP = WorkbenchPlugin.labels.getString("PCB_TP");
    public static String PCB_DB = WorkbenchPlugin.labels.getString("PCB_DB");
    public static String PCB_GSAM = WorkbenchPlugin.labels.getString("PCB_GSAM");
    private Object parent;
    private IFile parentFile;

    public IMSExplorerTreeFolder(Object parent, String name) {
        super(parent, name);
        this.parent = parent;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public List<IMSExplorerTreeObject> getChildren() {
        List childGSAMs;
        if (this.name.equals(PCB_TP)) {
            List childTPs = ((PsbModel)this.parent).getTPPcbList();
            if (childTPs != null) {
                ArrayList<IMSExplorerTreeObject> childTP_treeObjects = new ArrayList<IMSExplorerTreeObject>();
                for (PcbTPModel tpModel : childTPs) {
                    childTP_treeObjects.add(new IMSExplorerPCBTreeObject((Object)this, tpModel));
                }
                return childTP_treeObjects;
            }
        } else if (this.name.equals(PCB_DB)) {
            List childDBs = ((PsbModel)this.parent).getDBPcbList();
            if (childDBs != null) {
                ArrayList<IMSExplorerTreeObject> childDB_treeObjects = new ArrayList<IMSExplorerTreeObject>();
                for (PcbDBModel dbModel : childDBs) {
                    childDB_treeObjects.add(new IMSExplorerPCBTreeObject((Object)this, dbModel));
                }
                return childDB_treeObjects;
            }
        } else if (this.name.equals(PCB_GSAM) && (childGSAMs = ((PsbModel)this.parent).getGsamPcbList()) != null) {
            ArrayList<IMSExplorerTreeObject> childGSAM_treeObjects = new ArrayList<IMSExplorerTreeObject>();
            for (PcbGsamModel gsamModel : childGSAMs) {
                childGSAM_treeObjects.add(new IMSExplorerPCBTreeObject((Object)this, gsamModel));
            }
            return childGSAM_treeObjects;
        }
        return new ArrayList<IMSExplorerTreeObject>();
    }

    public IFile getParentFile() {
        return this.parentFile;
    }

    public void setParentFile(IFile parentFile) {
        this.parentFile = parentFile;
    }
}

