/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.navigator;

import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerSegmentTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeFolder;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerTreeParent;
import com.ibm.im.ims.workbench.ui.navigator.ResourceManager;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.resources.ProjectExplorer;

public class IMSExplorerContentProvider
implements ITreeContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public IMSExplorerContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public Object[] getChildren(Object obj) {
        if (IMSExplorerTreeObject.isPSBFile(obj)) {
            PsbModel psbModel = null;
            try {
                psbModel = ResourceManager.getPsbModel((IFile)obj);
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "getChildren(Object obj)", e);
            }
            if (psbModel != null) {
                IMSExplorerTreeFolder tpFolder = new IMSExplorerTreeFolder(psbModel, IMSExplorerTreeFolder.PCB_TP);
                tpFolder.setParentFile((IFile)obj);
                IMSExplorerTreeFolder dbFolder = new IMSExplorerTreeFolder(psbModel, IMSExplorerTreeFolder.PCB_DB);
                dbFolder.setParentFile((IFile)obj);
                IMSExplorerTreeFolder gsamFolder = new IMSExplorerTreeFolder(psbModel, IMSExplorerTreeFolder.PCB_GSAM);
                gsamFolder.setParentFile((IFile)obj);
                return new IMSExplorerTreeFolder[]{tpFolder, dbFolder, gsamFolder};
            }
        } else {
            if (IMSExplorerTreeObject.isDBDFile(obj)) {
                return this.getDbdChildren((IFile)obj);
            }
            if (obj instanceof IMSExplorerTreeParent) {
                return ((IMSExplorerTreeParent)obj).getChildren().toArray();
            }
        }
        return new Object[0];
    }

    public Object[] getElements(Object arg0) {
        return this.getChildren(arg0);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object obj) {
        return true;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }

    public void resourceChanged(IResourceChangeEvent rscEvent) {
        IResourceDelta delta = rscEvent.getDelta();
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            logger.throwing(this.getClass().getName(), "resourceChanged(IResourceChangeEvent rscEvent)", (Throwable)e);
        }
    }

    private Object[] getDbdChildren(IFile dbdFile) {
        if (dbdFile != null) {
            try {
                DbdModel dbdModel = ResourceManager.getDbdModel(dbdFile);
                SegmentModel root = dbdModel.getRootSegment();
                if (root != null) {
                    return new Object[]{new IMSExplorerSegmentTreeObject((Object)dbdFile, root)};
                }
            }
            catch (Exception e) {
                logger.throwing(this.getClass().getName(), "getDbdChildren(IFile dbdFile)", (Throwable)e);
            }
        }
        return new Object[0];
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
            case 1: {
                final IFile file = (IFile)resource;
                ResourceManager.removeResourceFromCache(file);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PlatformUI.getWorkbench().isClosing()) {
                            return;
                        }
                        IWorkbenchWindow iw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IViewPart peView = iw.getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
                        ((ProjectExplorer)peView).getCommonViewer().refresh((Object)file);
                    }
                });
                return true;
            }
        }
        return false;
    }
}

