/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.decorator;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.ui.core.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ResourceDecorator
extends LabelProvider
implements ILabelDecorator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Image topDbdFolder = null;
    private Image topPsbFolder = null;
    private Image sourceFolder = null;
    private Image transactionFolder = null;
    private Image testCaseFolder = null;
    private Image messageFolder = null;
    private Image inputMessageFolder = null;
    private Image outputMessageFolder = null;
    private Image segmentFolder = null;
    private Image dataStructureFolder = null;
    private Image newTransaction = null;
    private Image newMessage = null;
    private Image newSegment = null;
    private Image newDataStructure = null;
    private Image newTestCase = null;

    public Image decorateImage(Image image, Object element) {
        try {
            if (element instanceof IFolder) {
                IFolder folder = (IFolder)element;
                String folderName = folder.getName();
                if (folderName.equals("DBD")) {
                    if (this.topDbdFolder == null) {
                        ImageDescriptor imageDesc = Utility.getImageDescriptor("database_folder_open_16.gif");
                        this.topDbdFolder = imageDesc.createImage();
                    }
                    image = this.topDbdFolder;
                } else if (folderName.equals("PSB")) {
                    if (this.topPsbFolder == null) {
                        ImageDescriptor imageDesc = Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("program_folder_open"));
                        this.topPsbFolder = imageDesc.createImage();
                    }
                    image = this.topPsbFolder;
                } else if (folderName.equals(ProjectTreeFileHelper.TOP_DBD_SOURCE_FOLDER) || folderName.equals(ProjectTreeFileHelper.TOP_PSB_SOURCE_FOLDER) || folderName.equals(ProjectTreeFileHelper.GENED_SOURCE_FOLDER) || folderName.equals(ProjectTreeFileHelper.IMPORTED_SOURCE_FOLDER)) {
                    if (this.sourceFolder == null) {
                        ImageDescriptor imageDesc = Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("source_folder_open"));
                        this.sourceFolder = imageDesc.createImage();
                    }
                    image = this.sourceFolder;
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "decorateImage(Image image, Object element)", e);
            logger.error(e);
        }
        return image;
    }

    public String decorateText(String label, Object element) {
        return label;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void refreshDecoration(Object[] elements) {
        this.fireLabelChangedEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, elements));
    }

    protected void fireLabelChangedEvent(final LabelProviderChangedEvent event) {
        try {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ResourceDecorator.this.fireLabelProviderChanged(event);
                }
            });
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "fireLabelChangedEvent(final LabelProviderChangedEvent event)", e);
            logger.error(e);
        }
    }
}

