/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.decorator;

import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ImageDescriptor imageDescriptor;
    private ImageDescriptor overlayImage;
    Point size;
    Point overlaySize;
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public OverlayImageDescriptor(ImageDescriptor imgDescriptor, ImageDescriptor overlayImage) {
        this.setImageDescriptor(imgDescriptor);
        this.setOverlayImage(overlayImage);
    }

    protected void drawCompositeImage(int arg0, int arg1) {
        try {
            this.drawImage(this.getImageDescriptor().getImageData(), 0, 0);
            ImageData overlayImageData = this.getOverlayImage().getImageData();
            int xValue = this.size.x - this.overlaySize.x;
            int yValue = this.size.y - this.overlaySize.y;
            this.drawImage(overlayImageData, xValue, yValue);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "drawCompositeImage(int arg0, int arg1)", e);
            logger.error(e);
        }
    }

    protected Point getSize() {
        return this.size;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
        Rectangle bounds = imageDescriptor.createImage().getBounds();
        this.size = new Point(bounds.width, bounds.height);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public void setOverlayImage(ImageDescriptor overlayImage) {
        this.overlayImage = overlayImage;
        Rectangle bounds = overlayImage.createImage().getBounds();
        this.overlaySize = new Point(bounds.width, bounds.height);
    }

    public ImageDescriptor getOverlayImage() {
        return this.overlayImage;
    }
}

