/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.ui.core;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import java.io.File;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class Utility {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map imageCache;
    private static final ImageRegistry imageRegistry;
    private static final String ICON_PATH = "icons/";
    private static final String HELP_PATH = "docs/";

    static {
        imageRegistry = new ImageRegistry();
    }

    public static String preparePSBds(String file) {
        int index = file.lastIndexOf(File.separator);
        return file.substring(index + 1);
    }

    public static Vector makeVectorFromString(String source) {
        String token = "#";
        int lastIndex = 0;
        Vector<String> result = new Vector<String>();
        if (source.length() > 0) {
            while (source.indexOf(token, lastIndex) != -1) {
                result.add(source.substring(lastIndex, source.indexOf(token, lastIndex)));
                lastIndex = source.indexOf(token, lastIndex) + 1;
            }
        }
        return result;
    }

    public static String removeFileExt(String name) {
        int marker = name.indexOf(".");
        if (marker > -1) {
            return name.substring(0, marker);
        }
        return name;
    }

    public static boolean isDuplicatePcbAlias(DbGEFModel pcb, String newAlias) {
        if (!pcb.getPcbAlias().equals(newAlias)) {
            return pcb.isDuplicateAlias(newAlias);
        }
        return false;
    }

    public static boolean isDuplicateSegmentAlias(SegmentGEFModel segment, String newAlias) {
        if (!segment.getSegmentAlias().equals(newAlias)) {
            Vector segmentList = segment.getDbGEFModel().getNonSelectedSegments(segment.getSegmentAlias());
            int i = 0;
            while (i < segmentList.size()) {
                SegmentGEFModel dliSegmentModel = (SegmentGEFModel)segmentList.get(i);
                if (dliSegmentModel.getSegmentAlias().equals(newAlias)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isDuplicateFieldAlias(FieldGEFModel field, String newAlias) {
        if (!field.getAlias().equals(newAlias)) {
            Vector<FieldGEFModel> fieldList = field.getSegmentGEFModel().getNonSelectedFields(field.getAlias());
            int i = 0;
            while (i < fieldList.size()) {
                FieldGEFModel dliFieldModel = fieldList.get(i);
                if (dliFieldModel.getAlias().equals(newAlias) || dliFieldModel.getIMSName().equals(newAlias)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isDuplicateFieldAlias(SegmentGEFModel dliSegmentModel, String newAlias) {
        Vector<FieldGEFModel> fieldList = dliSegmentModel.getFieldsList();
        int i = 0;
        while (i < fieldList.size()) {
            FieldGEFModel dliFieldModel = fieldList.get(i);
            if (dliFieldModel.getAlias().equals(newAlias) || dliFieldModel.getIMSName().equals(newAlias)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int fieldFitsInSegment(String startInput, String lengthInput, SegmentGEFModel segment) {
        int start = 0;
        int length = 0;
        if (startInput.length() > 0) {
            start = Integer.parseInt(startInput);
        }
        if (lengthInput.length() > 0) {
            length = Integer.parseInt(lengthInput);
        }
        int segLen = segment.getSegLen();
        if (start > 0 && length > 0 && segLen < start + length - 1 || (start == 0 || length == 0) && segLen < start + length) {
            return segLen;
        }
        return 0;
    }

    public static int getDataTypeInt(String dataType) {
        if (dataType.equalsIgnoreCase("CHAR")) {
            return 3;
        }
        if (dataType.equalsIgnoreCase("FLOAT")) {
            return 5;
        }
        if (dataType.equalsIgnoreCase("DOUBLE")) {
            return 4;
        }
        if (dataType.equalsIgnoreCase("SMALLINT")) {
            return 9;
        }
        if (dataType.equalsIgnoreCase("INTEGER")) {
            return 2;
        }
        if (dataType.equalsIgnoreCase("BIGINT")) {
            return 8;
        }
        if (dataType.equalsIgnoreCase("ZONEDDECIMAL")) {
            return 12;
        }
        if (dataType.equalsIgnoreCase("TIME")) {
            return 14;
        }
        if (dataType.equalsIgnoreCase("VARCHAR")) {
            return 10;
        }
        if (dataType.equalsIgnoreCase("TINYINT")) {
            return 1;
        }
        if (dataType.equalsIgnoreCase("BIT")) {
            return 6;
        }
        if (dataType.equalsIgnoreCase("BINARY")) {
            return 17;
        }
        if (dataType.equalsIgnoreCase("PACKEDDECIMAL")) {
            return 11;
        }
        if (dataType.equalsIgnoreCase("DATE")) {
            return 13;
        }
        if (dataType.equalsIgnoreCase("TIMESTAMP")) {
            return 15;
        }
        if (dataType.equalsIgnoreCase("CLOB")) {
            return 19;
        }
        return -1;
    }

    public static String getDataTypeString(int dataType) {
        if (dataType == 3) {
            return "CHAR";
        }
        if (dataType == 5) {
            return "FLOAT";
        }
        if (dataType == 4) {
            return "DOUBLE";
        }
        if (dataType == 9) {
            return "SMALLINT";
        }
        if (dataType == 2) {
            return "INTEGER";
        }
        if (dataType == 8) {
            return "BIGINT";
        }
        if (dataType == 12) {
            return "ZONEDDECIMAL";
        }
        if (dataType == 14) {
            return "TIME";
        }
        if (dataType == 10) {
            return "VARCHAR";
        }
        if (dataType == 1) {
            return "TINYINT";
        }
        if (dataType == 6) {
            return "BIT";
        }
        if (dataType == 17) {
            return "BINARY";
        }
        if (dataType == 11) {
            return "PACKEDDECIMAL";
        }
        if (dataType == 13) {
            return "DATE";
        }
        if (dataType == 15) {
            return "TIMESTAMP";
        }
        if (dataType == 19) {
            return "CLOB";
        }
        return "";
    }

    public static FieldGEFModel getFieldGEFModel(SegmentGEFModel dliSegmentModel, String fieldAlias) {
        Vector<FieldGEFModel> fieldList = dliSegmentModel.getFieldsList();
        int i = 0;
        while (i < fieldList.size()) {
            FieldGEFModel field = fieldList.get(i);
            if (field.getAlias().equals(fieldAlias) || field.getFieldType() != 2203 && field.getIMSName().equals(fieldAlias)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public static ArrayList stringToArray(String dirName, String[] string) {
        ArrayList<CallSite> array = new ArrayList<CallSite>();
        int i = 0;
        while (i < string.length) {
            array.add((CallSite)((Object)(dirName + File.separator + string[i])));
            ++i;
        }
        return array;
    }

    public static IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static Image getImage(String fileName) {
        Image retVal = imageRegistry.get(fileName);
        if (retVal == null) {
            retVal = Utility.getImageDescriptor(fileName).createImage();
            imageRegistry.put(fileName, retVal);
        }
        return retVal;
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        ImageDescriptor img;
        if (imageCache == null) {
            imageCache = new HashMap();
        }
        if ((img = (ImageDescriptor)imageCache.get(fileName)) == null) {
            Bundle bundle = WorkbenchPlugin.getDefault().getBundle();
            Path iconPath = new Path(ICON_PATH + fileName);
            URL url = FileLocator.find((Bundle)bundle, (IPath)iconPath, null);
            img = ImageDescriptor.createFromURL((URL)url);
            imageCache.put(fileName, img);
        }
        return img;
    }
}

