/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.project.wizard;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.importWizards.ImportIMSSourceWizardPage;
import com.ibm.im.ims.workbench.importWizards.ImportIMSSourceWizardPage2;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.project.wizard.IMSWorkbenchNewProjectWizardPage;
import com.ibm.im.ims.workbench.utilities.GetProjectInfo;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class IMSWorkbenchNewProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IConfigurationElement config;
    private IMSWorkbenchNewProjectWizardPage newProjectPage;
    private ImportIMSSourceWizardPage importIMSSourcePage;
    private ImportIMSSourceWizardPage2 importIMSSourcePage2;
    private String projectName = null;
    private boolean projectAlreadyCreated = false;
    private boolean importPagesComplete;
    private IStructuredSelection selection;

    public IMSWorkbenchNewProjectWizard() {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB101"));
        this.importPagesComplete = false;
    }

    public boolean canFinish() {
        boolean retVal = false;
        try {
            if (this.newProjectPage.isPageComplete()) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
        return retVal;
    }

    public void addPages() {
        try {
            this.newProjectPage = new IMSWorkbenchNewProjectWizardPage("Page0", this.selection);
            this.importIMSSourcePage = new ImportIMSSourceWizardPage("Page1");
            this.importIMSSourcePage2 = new ImportIMSSourceWizardPage2("Page2");
            this.addPage((IWizardPage)this.newProjectPage);
            this.addPage((IWizardPage)this.importIMSSourcePage);
            this.addPage((IWizardPage)this.importIMSSourcePage2);
            this.newProjectPage.setUsage(2);
            this.newProjectPage.setPageComplete(false);
            this.importIMSSourcePage.setPageComplete(false);
            this.importIMSSourcePage2.setPageComplete(false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public String getProjectName() {
        if (this.projectName == null) {
            this.projectName = this.newProjectPage.getProjectName();
        }
        return this.projectName;
    }

    public boolean performFinish() {
        try {
            String containerName = this.newProjectPage.getProjectName();
            try {
                this.doFinish(containerName);
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
                logger.error(e);
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        return true;
    }

    private void doFinish(String containerName) throws InvocationTargetException, InterruptedException, CoreException, IOException {
        String selectedProject = GetProjectInfo.getProjectName(this.selection);
        if (selectedProject == null || !selectedProject.equals(containerName)) {
            this.createNewProject(containerName);
        }
        if (this.importIMSSourcePage2.isPageComplete()) {
            this.importIMSSourcePage2.marshallResources();
        }
    }

    public boolean performCancel() {
        return true;
    }

    public void createNewProject(String projectName) throws CoreException, IOException {
        if (!this.projectAlreadyCreated) {
            ProjectTreeFileHelper.createNewProject((String)projectName);
            this.projectAlreadyCreated = true;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            this.selection = selection;
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "init(IWorkbench workbench, IStructuredSelection selection)", e);
            logger.error(e);
        }
    }

    public void setImportPagesComplete(boolean status) {
        this.importPagesComplete = status;
    }

    public boolean getImportPagesComplete() {
        return this.importPagesComplete;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        try {
            this.config = config;
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setInitializationData(IConfigurationElement config, String propertyName,Object data)", e);
            logger.error(e);
        }
    }

    public ImportIMSSourceWizardPage getImportIMSSourceWizardPage() {
        return this.importIMSSourcePage;
    }
}

