/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.newDBDWizards;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewDBDWizard;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.ims.explorer.common.util.PosixPortablePathValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CreateNewDBDWizardPage1
extends WizardPage {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite composite;
    private Display display;
    private UIHelper uih;
    private IStructuredSelection selection;
    private Label projectNameLabel;
    private Text projectNameField;
    private Combo projectNameCombo;
    private CreateNewDBDWizard newDBDWizard;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean pageComplete = CreateNewDBDWizardPage1.this.validatePage();
            CreateNewDBDWizardPage1.this.setPageComplete(pageComplete);
            if (pageComplete) {
                CreateNewDBDWizardPage1.this.getWizard().canFinish();
            }
        }
    };

    public CreateNewDBDWizardPage1(String pageName, IStructuredSelection selection, CreateNewDBDWizard newDBDWizard) {
        super(pageName);
        this.uih = new UIHelper();
        this.selection = selection;
        this.newDBDWizard = newDBDWizard;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.display = parent.getDisplay();
        this.uih.setDisplay(this.display);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.composite.setLayout((Layout)layout);
        this.composite.setFont(parent.getFont());
        this.createAdvanceNameField(this.composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.ImportResourceWizard");
        this.setControl((Control)this.composite);
    }

    private void createAdvanceNameField(Composite composite) {
        this.setTitle(WorkbenchPlugin.labels.getString("WB021"));
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB103"));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        String[] projectNames = new String[projects.length];
        String selectedName = this.getSelectedProjectName(this.selection);
        int i = 0;
        while (i < projects.length) {
            projectNames[i] = projects[i].getName();
            ++i;
        }
        FormData fd1 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
        this.projectNameLabel = this.uih.genRequiredLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB103"), this.uih.black, fd1);
        FormData fd2 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.projectNameLabel, 20), new FormAttachment(100, 0));
        this.projectNameCombo = new Combo(composite, 12);
        this.projectNameCombo.setItems(projectNames);
        this.projectNameCombo.setText(selectedName);
        this.projectNameCombo.setLayoutData((Object)fd2);
        this.projectNameCombo.addListener(24, this.nameModifyListener);
        this.projectNameCombo.setFocus();
        this.setPageComplete(this.validatePage());
    }

    private boolean validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        ResourcesPlugin.getWorkspace();
        String projectName = this.getProjectName();
        if (projectName == null || projectName.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkbenchPlugin.descriptions.getString("WB103"));
            return false;
        }
        if (!PosixPortablePathValidator.isPortableName((String)projectName)) {
            this.setErrorMessage(WorkbenchPlugin.errors.getString("INVALID_PROJECT_NAME", new Object[]{projectName}));
            this.setMessage(null);
            return false;
        }
        return true;
    }

    public String getProjectName() {
        if (this.projectNameField == null && this.projectNameCombo == null) {
            return "";
        }
        String projectName = this.projectNameCombo.getText().trim();
        if (projectName == null) {
            return "";
        }
        return projectName;
    }

    public String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    private String getSelectedProjectName(IStructuredSelection selection) {
        String selectedProject = "";
        if (selection == null || selection.isEmpty()) {
            return selectedProject;
        }
        if (selection.getFirstElement() instanceof IProject) {
            selectedProject = ((IProject)selection.getFirstElement()).getName();
        } else if (selection.getFirstElement() instanceof IResource) {
            selectedProject = ((IResource)selection.getFirstElement()).getProject().getName();
        } else if (selection.getFirstElement() instanceof IFile) {
            selectedProject = ((IFile)selection.getFirstElement()).getProject().getName();
        } else {
            System.out.println("Selection:" + selection.getFirstElement().toString());
        }
        return selectedProject;
    }
}

