/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.newDBDWizards;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.AreaStmt;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DataExitRoutine;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewDBDWizardPage1;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewDBDWizardPage2;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewDEDBWizardPage1;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewDEDBWizardPage2;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewGSAMWizardPage1;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewGSAMWizardPage2;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewHIDAMWizardPage1;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewHIDAMWizardPage2;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewHSAMWizardPage1;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewHSAMWizardPage2;
import com.ibm.im.ims.workbench.newDBDWizards.CreateNewPHIDAMWizardPage;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class CreateNewDBDWizard
extends Wizard
implements INewWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String PLUGIN_ID = "com.ibm.im.ims.workbench";
    CreateNewDBDWizardPage1 newDBDWizardPage1;
    CreateNewDBDWizardPage2 newDBDWizardPage2;
    CreateNewPHIDAMWizardPage newPHIDAMPage;
    CreateNewDEDBWizardPage1 newDEDBPage1;
    CreateNewDEDBWizardPage2 newDEDBPage2;
    CreateNewHSAMWizardPage1 newHSAMPage1;
    CreateNewHSAMWizardPage2 newHSAMPage2;
    CreateNewGSAMWizardPage1 newGSAMPage1;
    CreateNewGSAMWizardPage2 newGSAMPage2;
    CreateNewHIDAMWizardPage1 newHIDAMPage1;
    CreateNewHIDAMWizardPage2 newHIDAMPage2;
    String dedbDBDName;
    String dedbAccessType;
    String dedbmod;
    String dedbrbn;
    String dedbXCI;
    String dedbanch;
    String dedbbytes;
    String dedbExitName;
    String dedbLog;
    String dedbKey;
    String dedbData;
    String dedbPath;
    String dedbCascade;
    String dedbKeySub;
    String dedbDataSub;
    String dedbPathSub;
    String dedbVersion;
    IWizardPage nextPage;
    IWizardPage currPage;
    private IStructuredSelection selection;
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IConfigurationElement config;
    private DbdModel dbdModel;

    public CreateNewDBDWizard() {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB020"));
        this.setHelpAvailable(false);
    }

    public void addPages() {
        this.newDBDWizardPage1 = new CreateNewDBDWizardPage1("page1", this.selection, this);
        this.newDBDWizardPage2 = new CreateNewDBDWizardPage2("page2", this);
        this.newPHIDAMPage = new CreateNewPHIDAMWizardPage("PHIDAM", this);
        this.newDEDBPage1 = new CreateNewDEDBWizardPage1("DEDB", this);
        this.newDEDBPage2 = new CreateNewDEDBWizardPage2("AREA", this);
        this.newHSAMPage1 = new CreateNewHSAMWizardPage1("HSAM", this);
        this.newHSAMPage2 = new CreateNewHSAMWizardPage2("HSAMDATASET", this);
        this.newGSAMPage1 = new CreateNewGSAMWizardPage1("GSAM", this);
        this.newGSAMPage2 = new CreateNewGSAMWizardPage2("GSAMDATASET", this);
        this.newHIDAMPage1 = new CreateNewHIDAMWizardPage1("HIDAM", this);
        this.newHIDAMPage2 = new CreateNewHIDAMWizardPage2("HIDAMDATASET", this);
        this.addPage((IWizardPage)this.newDBDWizardPage1);
        this.addPage((IWizardPage)this.newDBDWizardPage2);
        this.addPage((IWizardPage)this.newPHIDAMPage);
        this.addPage((IWizardPage)this.newDEDBPage1);
        this.addPage((IWizardPage)this.newDEDBPage2);
        this.addPage((IWizardPage)this.newHSAMPage1);
        this.addPage((IWizardPage)this.newHSAMPage2);
        this.addPage((IWizardPage)this.newGSAMPage1);
        this.addPage((IWizardPage)this.newGSAMPage2);
        this.addPage((IWizardPage)this.newHIDAMPage1);
        this.addPage((IWizardPage)this.newHIDAMPage2);
    }

    public boolean canFinish() {
        boolean retVal = false;
        this.currPage = this.getContainer().getCurrentPage();
        if (this.currPage.equals((Object)this.newPHIDAMPage)) {
            if (this.newPHIDAMPage.pageComplete) {
                retVal = true;
            }
        } else if (this.currPage.equals((Object)this.newDEDBPage2)) {
            retVal = this.newDEDBPage2.pageComplete;
        } else if (this.currPage.equals((Object)this.newHSAMPage2)) {
            retVal = this.newHSAMPage2.pageComplete;
        } else if (this.currPage.equals((Object)this.newGSAMPage2)) {
            retVal = this.newGSAMPage2.pageComplete;
        }
        return retVal;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage;
        IWizardPage currPage = this.getContainer().getCurrentPage();
        if (currPage.equals((Object)this.newHSAMPage2)) {
            return null;
        }
        if (currPage.equals((Object)this.newGSAMPage2)) {
            return null;
        }
        if (currPage.equals((Object)this.newDEDBPage2)) {
            return null;
        }
        if (currPage.equals((Object)this.newPHIDAMPage)) {
            return null;
        }
        if (currPage.equals((Object)this.newHIDAMPage2)) {
            return null;
        }
        if (page instanceof CreateNewDBDWizardPage2) {
            this.newDBDWizardPage2 = (CreateNewDBDWizardPage2)page;
            if (this.newDBDWizardPage2.getAccessType().equalsIgnoreCase("PHIDAM")) {
                this.newPHIDAMPage = (CreateNewPHIDAMWizardPage)this.getPage("PHIDAM");
                return this.newPHIDAMPage;
            }
            if (this.newDBDWizardPage2.getAccessType().equalsIgnoreCase("DEDB")) {
                this.newDEDBPage1 = (CreateNewDEDBWizardPage1)this.getPage("DEDB");
                return this.newDEDBPage1;
            }
            if (this.newDBDWizardPage2.getAccessType().equalsIgnoreCase("HSAM") || this.newDBDWizardPage2.getAccessType().equalsIgnoreCase("SHSAM")) {
                this.newHSAMPage1 = (CreateNewHSAMWizardPage1)this.getPage("HSAM");
                return this.newHSAMPage1;
            }
            if (this.newDBDWizardPage2.getAccessType().equalsIgnoreCase("GSAM")) {
                this.newGSAMPage1 = (CreateNewGSAMWizardPage1)this.getPage("GSAM");
                return this.newGSAMPage1;
            }
            if (this.newDBDWizardPage2.getAccessType().equalsIgnoreCase("HIDAM")) {
                this.newHIDAMPage1 = (CreateNewHIDAMWizardPage1)this.getPage("HIDAM");
                return this.newHIDAMPage1;
            }
        }
        if ((nextPage = super.getNextPage(page)) instanceof CreateNewPHIDAMWizardPage) {
            this.newPHIDAMPage = (CreateNewPHIDAMWizardPage)nextPage;
        } else if (nextPage instanceof CreateNewDEDBWizardPage1) {
            this.newDEDBPage1 = (CreateNewDEDBWizardPage1)nextPage;
        } else if (nextPage instanceof CreateNewHSAMWizardPage1) {
            this.newHSAMPage1 = (CreateNewHSAMWizardPage1)nextPage;
        } else if (nextPage instanceof CreateNewGSAMWizardPage1) {
            this.newGSAMPage1 = (CreateNewGSAMWizardPage1)nextPage;
        } else if (nextPage instanceof CreateNewHIDAMWizardPage1) {
            this.newHIDAMPage1 = (CreateNewHIDAMWizardPage1)nextPage;
        }
        return nextPage;
    }

    public void createPHIDAMObjModel() throws ModelException {
        this.dbdModel = new DbdModel(this.newPHIDAMPage.getDBDName());
        this.dbdModel.setAccessType(this.newPHIDAMPage.getAccessType());
        this.dbdModel.setDatxexit(this.newPHIDAMPage.getDataExit());
        this.dbdModel.setOsAccess(this.newPHIDAMPage.getMethod());
        this.dbdModel.setPassword(this.newPHIDAMPage.getPW());
        this.dbdModel.setPsname(this.newPHIDAMPage.getPSName());
        this.dbdModel.setVersion(this.newPHIDAMPage.getVersion());
        ArrayList<DataExitRoutine> exits = this.newPHIDAMPage.getDataExitValues();
        int i = 0;
        while (i < exits.size()) {
            this.dbdModel.addDataCaptureExitRoutine(exits.get(i));
            ++i;
        }
    }

    public void createDEDBObjModel() throws ModelException {
        this.dbdModel = new DbdModel(this.newDEDBPage1.getDBDName());
        this.dbdModel.setAccessType(this.newDEDBPage1.getAccessType());
        this.dbdModel.setRMName(this.newDEDBPage1.getmod());
        int anchPoint = Integer.valueOf(this.newDEDBPage1.getanch());
        this.dbdModel.setRmNameAnchorPoints(anchPoint);
        this.dbdModel.setXci(this.newDEDBPage1.getXCI());
        this.dbdModel.setVersion(this.newDEDBPage1.getVersion());
        ArrayList<DataExitRoutine> exits = this.newPHIDAMPage.getDataExitValues();
        int i = 0;
        while (i < exits.size()) {
            this.dbdModel.addDataCaptureExitRoutine(exits.get(i));
            ++i;
        }
        List<AreaStmt> areas = this.newDEDBPage2.getAreaValues();
        int i2 = 0;
        while (i2 < areas.size()) {
            this.dbdModel.setArea(areas.get(i2));
            ++i2;
        }
    }

    public void createHSAMObjModel() throws ModelException {
        this.dbdModel = new DbdModel(this.newHSAMPage1.getDBDName());
        this.dbdModel.setAccessType(this.newHSAMPage1.getAccessType());
        this.dbdModel.setDatxexit(this.newHSAMPage1.getDatxExit());
        this.dbdModel.setDdname1(this.newHSAMPage2.getDD1());
        this.dbdModel.setDdname2(this.newHSAMPage2.getDD2());
        int blkfact1 = Integer.parseInt(this.newHSAMPage2.getBlk1().trim());
        int blkfact2 = Integer.parseInt(this.newHSAMPage2.getBlk2().trim());
        this.dbdModel.setBLOCKBlkfact1(Integer.valueOf(blkfact1));
        this.dbdModel.setBLOCKBlkfact2(Integer.valueOf(blkfact2));
        String reclen1 = this.newHSAMPage2.getRecLen1().trim();
        String reclen2 = this.newHSAMPage2.getRecLen2().trim();
        if (reclen1 != "" && reclen1.length() != 0) {
            int reclen1int = Integer.parseInt(reclen1);
            this.dbdModel.setRECORDReclen1(Integer.valueOf(reclen1int));
        }
        if (reclen2 != "" && reclen2.length() != 0) {
            int reclen2int = Integer.parseInt(reclen2);
            this.dbdModel.setRECORDReclen2(Integer.valueOf(reclen2int));
        }
    }

    public void createGSAMObjModel() throws ModelException {
        String reclen2;
        String reclen1;
        String blkSize;
        this.dbdModel = new DbdModel(this.newGSAMPage1.getDBDName());
        this.dbdModel.setAccessType(this.newGSAMPage1.getAccessType());
        this.dbdModel.setDatxexit(this.newGSAMPage1.getDatxExit());
        this.dbdModel.setOsAccess(this.newGSAMPage1.getMethod());
        this.dbdModel.setPassword(this.newGSAMPage1.getPW());
        this.dbdModel.setDdname1(this.newGSAMPage2.getDD1());
        this.dbdModel.setDdname2(this.newGSAMPage2.getDD2());
        String blkfact1 = this.newGSAMPage2.getBlk1().trim();
        if (blkfact1 != "" && blkfact1.length() != 0) {
            int blkfact1int = Integer.parseInt(blkfact1);
            this.dbdModel.setBLOCKBlkfact1(Integer.valueOf(blkfact1int));
        }
        if ((blkSize = this.newGSAMPage2.getBlkSize().trim()) != "" && blkSize.length() != 0) {
            int blkSizeint = Integer.parseInt(blkSize);
            this.dbdModel.setSize1(Integer.valueOf(blkSizeint));
        }
        if ((reclen1 = this.newGSAMPage2.getRecLen1().trim()) != "" && reclen1.length() != 0) {
            int reclen1int = Integer.parseInt(reclen1);
            this.dbdModel.setRECORDReclen1(Integer.valueOf(reclen1int));
        }
        if ((reclen2 = this.newGSAMPage2.getRecLen2().trim()) != "" && reclen2.length() != 0) {
            int reclen2int = Integer.parseInt(reclen2);
            this.dbdModel.setRECORDReclen2(Integer.valueOf(reclen2int));
        }
        String recformat = null;
        String inputRecformat = this.newGSAMPage2.getRecFm();
        if (!inputRecformat.equals("") || inputRecformat.length() != 0) {
            recformat = inputRecformat.substring(0, 2).trim();
            this.dbdModel.setRecfm(DBDConstants.valueOf((String)recformat));
        }
    }

    public boolean performFinish() {
        try {
            if (this.newPHIDAMPage.getAccessType().equalsIgnoreCase("PHIDAM")) {
                this.createPHIDAMObjModel();
            } else if (this.newDEDBPage1.getAccessType().equalsIgnoreCase("DEDB")) {
                this.createDEDBObjModel();
            } else if (this.newHSAMPage1.getAccessType().equalsIgnoreCase("HSAM") || this.newHSAMPage1.getAccessType().equalsIgnoreCase("SHSAM")) {
                this.createHSAMObjModel();
            } else if (this.newGSAMPage1.getAccessType().equalsIgnoreCase("GSAM")) {
                this.createGSAMObjModel();
            }
        }
        catch (ModelException e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", (Throwable)e);
            logger.error((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish(", e);
        }
        final String containerName = this.newDBDWizardPage1.getProjectName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        CreateNewDBDWizard.this.doFinish(containerName, monitor);
                    }
                    catch (CoreException e) {
                        logger.throwing(this.getClass().getName(), "performFinish()", (Throwable)e);
                        logger.error((Throwable)e);
                        monitor.done();
                    }
                    catch (Throwable e) {
                        logger.throwing(this.getClass().getName(), "performFinish()", e);
                        logger.error(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        return true;
    }

    private void doFinish(String containerName, IProgressMonitor monitor) throws CoreException, IOException, ModelException {
        monitor.beginTask(WorkbenchPlugin.labels.getString("WB002"), 1);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(" \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        monitor.worked(1);
        this.marshallResources(container, monitor);
    }

    private void marshallResources(IContainer container, IProgressMonitor monitor) throws IOException, ModelException, CoreException {
        String projectName = container.getName();
        ByteArrayOutputStream dbdOutputStream = new ByteArrayOutputStream();
        this.dbdModel.marshall(dbdOutputStream);
        ByteArrayInputStream dbdInputStream = new ByteArrayInputStream(dbdOutputStream.toByteArray());
        IFile dbdMetadataFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)this.dbdModel.getDBDName());
        if (!dbdMetadataFile.exists()) {
            dbdMetadataFile.create((InputStream)dbdInputStream, true, monitor);
        } else {
            dbdMetadataFile.setContents((InputStream)dbdInputStream, true, true, monitor);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, PLUGIN_ID, 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
    }
}

