/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.importWizards;

import com.ibm.im.ims.workbench.importWizards.ReferencedDbdDef;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ResourceMap {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, ReferencedDbdDef> resourceMap = new HashMap<String, ReferencedDbdDef>();

    public void add(String referencerObject, boolean type, HashSet<String> refList) {
        if (!this.keyExists(referencerObject)) {
            ReferencedDbdDef dbdRef = new ReferencedDbdDef();
            dbdRef.initialize(refList, type);
            this.resourceMap.put(referencerObject, dbdRef);
        }
    }

    public void remove(String referencerObject) {
        if (this.keyExists(referencerObject)) {
            this.resourceMap.remove(referencerObject);
        }
    }

    public boolean keyExists(String referencerObject) {
        return this.resourceMap.containsKey(referencerObject);
    }

    public boolean valueExists(String value) {
        boolean valueFound = false;
        Collection<ReferencedDbdDef> tempDbdObj = this.resourceMap.values();
        if (tempDbdObj.contains(value)) {
            valueFound = true;
        }
        if (this.resourceMap.containsValue(value)) {
            valueFound = true;
        }
        return valueFound;
    }

    public int length() {
        return this.resourceMap.size();
    }

    public HashSet<String> getRefDbdList(String referencerObject) {
        ReferencedDbdDef tempDbdObj = this.resourceMap.get(referencerObject);
        return tempDbdObj.getDbdList();
    }

    public ReferencedDbdDef getRefDbdDef(String referencerObject) {
        return this.resourceMap.get(referencerObject);
    }

    public void setRefDbdList(String referencerObject, HashSet<String> refList) {
        ReferencedDbdDef tempDbdObj = this.resourceMap.get(referencerObject);
        tempDbdObj.setList(refList);
    }

    public Iterator<String> iterator() {
        Set<String> keys = this.resourceMap.keySet();
        return keys.iterator();
    }

    public HashSet<String> getKeys(String value) {
        HashSet<String> names = new HashSet<String>();
        Set<String> keys = this.resourceMap.keySet();
        Iterator<String> keyIt = keys.iterator();
        while (keyIt.hasNext()) {
            String key = keyIt.next().toString();
            HashSet<String> tempRefList = this.getRefDbdList(key);
            if (!tempRefList.contains(value)) continue;
            names.add(key);
        }
        return names;
    }

    public boolean isPSB(String referencerObject) {
        ReferencedDbdDef tempDbdObj = this.resourceMap.get(referencerObject);
        return tempDbdObj.isPSB();
    }
}

