/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.importWizards;

import java.util.HashSet;

public class ReferencedDbd {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean found = false;
    private boolean searchAlreadyDone = false;
    private String dbdName;
    HashSet<String> referencingPsbs;
    HashSet<String> referencingDbds;

    public ReferencedDbd(String dbdName, String refPsb, String refDbd) {
        this.dbdName = dbdName;
        if (refPsb != null) {
            this.referencingPsbs = new HashSet();
            this.referencingPsbs.add(refPsb);
        }
        if (refDbd != null) {
            this.referencingDbds = new HashSet();
            this.referencingDbds.add(refDbd);
        }
    }

    public boolean isSearchAlreadyDone() {
        return this.searchAlreadyDone;
    }

    public void setSearchAlreadyDone(boolean searchAlreadyDone) {
        this.searchAlreadyDone = searchAlreadyDone;
    }

    public boolean isFound() {
        return this.found;
    }

    public void setFound(boolean found) {
        this.found = found;
    }

    public String getDbdName() {
        return this.dbdName;
    }

    public boolean removePsbReferencer(String psbName) {
        boolean retVal = false;
        if (this.referencingPsbs != null && this.referencingPsbs.contains(psbName)) {
            this.referencingPsbs.remove(psbName);
            if (this.referencingPsbs.size() == 0) {
                retVal = true;
            }
        }
        return retVal;
    }

    public boolean removeDbdReferencer(String dbdName) {
        boolean retVal = false;
        if (this.referencingDbds != null && this.referencingDbds.contains(dbdName)) {
            this.referencingDbds.remove(dbdName);
            if (this.referencingDbds.size() == 0) {
                retVal = true;
            }
        }
        return retVal;
    }

    public void addPsbReferencer(String psbName) {
        if (this.referencingPsbs == null) {
            this.referencingPsbs = new HashSet();
        }
        this.referencingPsbs.add(psbName);
    }

    public void addDbdReferencer(String dbdName) {
        if (this.referencingDbds == null) {
            this.referencingDbds = new HashSet();
        }
        this.referencingDbds.add(dbdName);
    }

    public HashSet<String> getReferencingPsbs() {
        return this.referencingPsbs;
    }

    public HashSet<String> getReferencingDbds() {
        return this.referencingDbds;
    }

    public HashSet<String> getReferencerNames() {
        HashSet<String> retVal = new HashSet<String>();
        if (this.referencingPsbs != null) {
            retVal.addAll(this.referencingPsbs);
        }
        if (this.referencingDbds != null) {
            retVal.addAll(this.referencingDbds);
        }
        return retVal;
    }
}

