/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.importWizards;

import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.IMSSourceImporter;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.StatementSet;
import java.io.ByteArrayOutputStream;

public class PsbToImport {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String psbName;
    private StatementSet sSet;
    private PsbModel psbModel = null;

    public PsbToImport(String psbName, StatementSet sSet) throws ModelException {
        this.sSet = sSet;
        this.psbName = psbName;
    }

    public PsbToImport(PsbModel psbModel, StatementSet sSet) {
        this.psbModel = psbModel;
        this.sSet = sSet;
    }

    public void setPsbModel(PsbModel psbModel) {
        this.psbModel = psbModel;
    }

    public String getName() {
        if (this.psbModel == null) {
            return this.psbName;
        }
        return this.psbModel.getPsbName();
    }

    public String getPath() {
        if (this.sSet == null) {
            return null;
        }
        return this.sSet.filePath;
    }

    public PsbModel getPsbModel() throws ImporterException, ModelException {
        PsbModel retVal = null;
        if (this.psbModel == null) {
            IMSSourceImporter importer = new IMSSourceImporter();
            retVal = (PsbModel)importer.processStatementSet(this.sSet);
        } else {
            retVal = this.psbModel;
        }
        return retVal;
    }

    public ByteArrayOutputStream getContents() {
        return this.sSet.contents;
    }
}

