/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.importWizards;

import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.template.ManageTemplateController;
import com.ibm.im.ims.workbench.dialogs.ConfirmationDialog;
import com.ibm.im.ims.workbench.importWizards.DataEntryWithData;
import com.ibm.im.ims.workbench.importWizards.DbdToImport;
import com.ibm.im.ims.workbench.importWizards.FileExtConstant;
import com.ibm.im.ims.workbench.importWizards.FileInformation;
import com.ibm.im.ims.workbench.importWizards.ImportDataSetWizard;
import com.ibm.im.ims.workbench.importWizards.ImportIMSSourceWizard;
import com.ibm.im.ims.workbench.importWizards.ImportSourceType;
import com.ibm.im.ims.workbench.importWizards.PsbToImport;
import com.ibm.im.ims.workbench.importWizards.ReferencedDbd;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.IImsResourceModel;
import com.ibm.im.ims.workbench.model.MergeDbd;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.DatabaseViewGeneratorExceptionHelper;
import com.ibm.im.ims.workbench.model.utilities.IMSSourceImporter;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.Statement;
import com.ibm.im.ims.workbench.model.utilities.StatementSet;
import com.ibm.im.ims.workbench.project.wizard.IMSWorkbenchNewProjectWizard;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.MessageDialogRunner;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.utilities.Warnings;
import com.ibm.im.ims.workbench.utilities.WizardDialogRunner;
import com.ibm.im.ims.workbench.wizard.importsrc.CatalogImportWizard;
import com.ibm.im.ims.workbench.wizard.managetemplate.ManageTemplateWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ImportIMSSourceWizardPage2
extends WizardPage
implements Listener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private boolean mergeYesToAll = false;
    private Composite composite;
    private UIHelper uih;
    protected TableViewer psbTabViewer;
    protected TableViewer dbdTabViewer;
    protected TableViewer needDBDViewer;
    private Table psbTab;
    private Table dbdTab;
    private Table needDBDTab;
    private TableColumn column;
    private TableColumn psbCol1;
    private TableColumn psbCol2;
    private TableColumn dbdCol1;
    private TableColumn dbdCol2;
    private TableColumn dbdCol3;
    private TableColumn needDBDCol1;
    private TableColumn needDBDCol2;
    private TableItem[] psbTabItem;
    private TableItem[] itemSelected;
    private TableCursor cursor = null;
    private String[] files;
    private String dirPath;
    private Group psbGrp;
    private Group dbdGrp;
    private Label importPSBlbl;
    private Label importDBDlbl;
    private Label warningImgLbl;
    private Label needImportlbl;
    private Label needImportlbl2;
    private Button addPSBButton;
    private Button removePSBButton;
    private Button addDBDButton;
    private Button removeDBDButton;
    private HashMap<String, ReferencedDbd> referenceMap;
    private HashMap<String, PsbToImport> psbToImportList;
    private HashMap<String, DbdToImport> dbdToImportList;
    private IMSSourceImporter importIMSSource;
    private Hashtable<String, FileInformation> fileHashTable = new Hashtable();
    private Vector<ImporterException> importerExceptions = null;
    ImageDescriptor warningImgDesc;
    Image warningImg;
    private int mergeReturnCode = 0;
    private Object[] confirmationInserts;
    private int psbCounter = 0;
    private int dbdCounter = 0;
    private boolean isImportDbd;
    private boolean needTableExists = false;
    private boolean needTableMessageNotShownYet = true;
    private String connProfileNameUsed;
    private DataEntryWithData[] zOSFiles = null;
    private ImportSourceType sourceType = null;
    private ArrayList<StatementSet> sSets;
    public static final int LARGE_IMPORT_THRESHOLD = 500;
    public static final int LARGE_DIR_SEARCH_THRESHOLD = 100;
    public static final int MAX_DEPTH = 1;
    public static final int NUM_WORKED_FOR_FILE_OPEN_STEP = 1000;
    public static final int NUM_WORKED_FOR_MODEL_CREATION_STEP = 7000;
    public static final int NUM_WORKED_FOR_SEARCH_STEP = 1000;
    public static final int NUM_WORKED_FOR_TABLE_REFRESH = 1000;
    private int numWorkedPerFileOpen;
    private int numWorkedPerModelCreated;
    private int numWorkedPerSearchIter = 500;
    private int currNumWorked;
    private ImportSourceType type = ImportSourceType.LOCAL;
    private Listener psbsortListener = new Listener(){

        public void handleEvent(Event e) {
            try {
                ImportIMSSourceWizardPage2.this.column = (TableColumn)e.widget;
                int psbdir = ImportIMSSourceWizardPage2.this.psbTab.getSortDirection();
                ImportIMSSourceWizardPage2.this.columnSorter(psbdir, ImportIMSSourceWizardPage2.this.psbTab, ImportIMSSourceWizardPage2.this.psbCol1, ImportIMSSourceWizardPage2.this.psbCol2, null);
                psbdir = psbdir == 1024 ? 128 : 1024;
                ImportIMSSourceWizardPage2.this.psbTab.setSortDirection(psbdir);
            }
            catch (Throwable ex) {
                logger.throwing(this.getClass().getName(), "handleEvent(Event e)", ex);
                logger.error(ex);
            }
        }
    };
    private Listener dbdsortListener = new Listener(){

        public void handleEvent(Event e) {
            ImportIMSSourceWizardPage2.this.column = (TableColumn)e.widget;
            int dbddir = ImportIMSSourceWizardPage2.this.dbdTab.getSortDirection();
            ImportIMSSourceWizardPage2.this.columnSorter(dbddir, ImportIMSSourceWizardPage2.this.dbdTab, ImportIMSSourceWizardPage2.this.dbdCol1, ImportIMSSourceWizardPage2.this.dbdCol2, ImportIMSSourceWizardPage2.this.dbdCol3);
            dbddir = dbddir == 1024 ? 128 : 1024;
            ImportIMSSourceWizardPage2.this.dbdTab.setSortDirection(dbddir);
        }
    };
    private Listener needDBDsortListener = new Listener(){

        public void handleEvent(Event e) {
            ImportIMSSourceWizardPage2.this.column = (TableColumn)e.widget;
            int dir = ImportIMSSourceWizardPage2.this.needDBDTab.getSortDirection();
            ImportIMSSourceWizardPage2.this.columnSorter(dir, ImportIMSSourceWizardPage2.this.needDBDTab, ImportIMSSourceWizardPage2.this.needDBDCol1, ImportIMSSourceWizardPage2.this.needDBDCol2, null);
            dir = dir == 1024 ? 128 : 1024;
            ImportIMSSourceWizardPage2.this.needDBDTab.setSortDirection(dir);
        }
    };

    public ImportIMSSourceWizardPage2(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.uih = new UIHelper();
        this.importIMSSource = new IMSSourceImporter();
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("vlImportWizard")));
    }

    public void createControl(Composite parent) {
        try {
            this.createControlFunc(parent);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    private void createControlFunc(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.uih.setDisplay(parent.getDisplay());
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.composite.setLayout((Layout)layout);
        FormData psbFD = new FormData();
        psbFD.left = new FormAttachment(0, 0);
        psbFD.right = new FormAttachment(100, 0);
        this.composite.setLayoutData((Object)psbFD);
        this.psbGrp = new Group(this.composite, 0);
        this.psbGrp.setText("PSB " + WorkbenchPlugin.labels.getString("WB007"));
        this.psbGrp.setLayout((Layout)layout);
        this.psbGrp.setLayoutData((Object)psbFD);
        psbFD = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
        this.importPSBlbl = this.uih.genLabel((Composite)this.psbGrp, 16384, WorkbenchPlugin.labels.getString("WB016A"), this.uih.black, psbFD);
        psbFD = this.uih.genFormData(new FormAttachment((Control)this.importPSBlbl, 10), null, new FormAttachment(0, 0), new FormAttachment(75, 0));
        psbFD.height = 80;
        this.psbTabViewer = new TableViewer((Composite)this.psbGrp, 68354);
        this.psbTab = this.psbTabViewer.getTable();
        this.createColumns(this.psbTab);
        this.psbTab.setLinesVisible(false);
        this.psbTab.setHeaderVisible(true);
        TableLayout psbTL = new TableLayout();
        this.psbTab.setLayout((Layout)psbTL);
        this.psbTab.setLayoutData((Object)psbFD);
        this.psbTab.setToolTipText(WorkbenchPlugin.descriptions.getString("WB008"));
        this.psbCol1.addListener(13, this.psbsortListener);
        this.psbCol2.addListener(13, this.psbsortListener);
        this.psbTab.setSortColumn(this.psbCol1);
        this.initListViewer(this.psbTabViewer, this.psbTab, this.psbGrp);
        psbFD = this.uih.genFormData(new FormAttachment((Control)this.importPSBlbl, 10), null, new FormAttachment((Control)this.psbTab, 10), new FormAttachment(100, -10));
        this.addPSBButton = new Button((Composite)this.psbGrp, 8);
        this.computeButtonSize(this.addPSBButton);
        this.addPSBButton.setText(WorkbenchPlugin.labels.getString("ADD_PSB") + "...");
        this.addPSBButton.setLayoutData((Object)psbFD);
        psbFD = this.uih.genFormData(new FormAttachment((Control)this.addPSBButton, 10), null, new FormAttachment((Control)this.psbTab, 10), new FormAttachment(100, -10));
        this.removePSBButton = new Button((Composite)this.psbGrp, 8);
        this.removePSBButton.setText(WorkbenchPlugin.labels.getString("DELETE_PSB"));
        this.computeButtonSize(this.removePSBButton);
        this.removePSBButton.setLayoutData((Object)psbFD);
        this.removePSBButton.setEnabled(false);
        FormLayout dbdFL = new FormLayout();
        dbdFL.marginHeight = 5;
        dbdFL.marginWidth = 5;
        FormData dbdFD = this.uih.genFormData(new FormAttachment((Control)this.psbGrp, 10), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
        this.dbdGrp = new Group(this.composite, 0);
        this.dbdGrp.setText("DBD " + WorkbenchPlugin.labels.getString("WB011"));
        this.dbdGrp.setLayout((Layout)dbdFL);
        this.dbdGrp.setLayoutData((Object)dbdFD);
        dbdFD = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
        this.importDBDlbl = this.uih.genLabel((Composite)this.dbdGrp, 16384, WorkbenchPlugin.labels.getString("WB016B"), this.uih.black, dbdFD);
        dbdFD = this.uih.genFormData(new FormAttachment((Control)this.importDBDlbl, 10), null, new FormAttachment(0, 0), new FormAttachment(75, 0));
        dbdFD.height = 80;
        this.dbdTabViewer = new TableViewer((Composite)this.dbdGrp, 68354);
        this.dbdTab = this.dbdTabViewer.getTable();
        this.createColumns(this.dbdTab);
        this.dbdTab.setLinesVisible(false);
        this.dbdTab.setHeaderVisible(true);
        TableLayout dbdTL = new TableLayout();
        this.dbdTab.setLayout((Layout)dbdTL);
        this.dbdTab.setLayoutData((Object)dbdFD);
        this.dbdTab.setToolTipText(WorkbenchPlugin.descriptions.getString("WB009"));
        this.dbdCol1.addListener(13, this.dbdsortListener);
        this.dbdCol2.addListener(13, this.dbdsortListener);
        this.dbdCol3.addListener(13, this.dbdsortListener);
        this.dbdTab.setSortColumn(this.dbdCol1);
        this.initListViewer(this.dbdTabViewer, this.dbdTab, this.dbdGrp);
        dbdFD = this.uih.genFormData(new FormAttachment((Control)this.importDBDlbl, 10), null, new FormAttachment((Control)this.dbdTab, 10), new FormAttachment(100, -10));
        this.addDBDButton = new Button((Composite)this.dbdGrp, 8);
        this.addDBDButton.setText(WorkbenchPlugin.labels.getString("ADD_DBD") + "...");
        this.addDBDButton.setLayoutData((Object)dbdFD);
        dbdFD = this.uih.genFormData(new FormAttachment((Control)this.addDBDButton, 10), null, new FormAttachment((Control)this.dbdTab, 10), new FormAttachment(100, -10));
        this.removeDBDButton = new Button((Composite)this.dbdGrp, 8);
        this.removeDBDButton.setText(WorkbenchPlugin.labels.getString("DELETE_DBD"));
        this.removeDBDButton.setLayoutData((Object)dbdFD);
        this.removeDBDButton.setEnabled(false);
        this.warningImgDesc = Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("warningImg"));
        this.warningImg = this.warningImgDesc.createImage();
        dbdFD = this.uih.genFormData(new FormAttachment((Control)this.dbdTab, 10), null, new FormAttachment(0, 0), null);
        this.warningImgLbl = this.uih.genLabel((Composite)this.dbdGrp, 16384, "     ", this.uih.black, dbdFD);
        this.warningImgLbl.setVisible(true);
        dbdFD = this.uih.genFormData(new FormAttachment((Control)this.dbdTab, 10), null, new FormAttachment(5, 0), null);
        this.needImportlbl = this.uih.genLabel((Composite)this.dbdGrp, 16384, WorkbenchPlugin.labels.getString("WB602"), this.uih.black, dbdFD);
        this.needImportlbl.setVisible(false);
        dbdFD = this.uih.genFormData(new FormAttachment((Control)this.needImportlbl, 10), null, new FormAttachment(0, 0), null);
        dbdFD.width = 350;
        this.needImportlbl2 = this.uih.genLabel((Composite)this.dbdGrp, 16448, WorkbenchPlugin.descriptions.getString("WB087"), this.uih.black, dbdFD);
        this.needImportlbl2.setVisible(false);
        dbdFD = this.uih.genFormData(new FormAttachment((Control)this.needImportlbl2, 10), null, new FormAttachment(0, 0), new FormAttachment(75, 0));
        dbdFD.height = 80;
        this.needDBDViewer = new TableViewer((Composite)this.dbdGrp, 67586);
        this.needDBDTab = this.needDBDViewer.getTable();
        this.createColumns(this.needDBDTab);
        this.needDBDTab.setLinesVisible(false);
        this.needDBDTab.setHeaderVisible(true);
        TableLayout needDBDTL = new TableLayout();
        this.needDBDTab.setLayout((Layout)needDBDTL);
        this.needDBDTab.setLayoutData((Object)dbdFD);
        this.needDBDTab.setToolTipText(WorkbenchPlugin.descriptions.getString("WB010"));
        this.needDBDCol1.addListener(13, this.needDBDsortListener);
        this.needDBDCol2.addListener(13, this.needDBDsortListener);
        this.needDBDTab.setSortColumn(this.needDBDCol1);
        this.needDBDTab.setVisible(false);
        this.initialize();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.ImportResourceWizard");
        this.setControl((Control)this.composite);
    }

    protected void initListViewer(TableViewer viewer, final Table t, final Group grp) {
        ListViewerProvider listProvider = new ListViewerProvider();
        viewer.setContentProvider((IContentProvider)listProvider);
        viewer.setLabelProvider((IBaseLabelProvider)listProvider);
        this.setCursor(t);
        t.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ImportIMSSourceWizardPage2.this.itemSelected = null;
                    ImportIMSSourceWizardPage2.this.itemSelected = t.getSelection();
                    t.setSelection(ImportIMSSourceWizardPage2.this.itemSelected);
                    ImportIMSSourceWizardPage2.this.cursor.getRow();
                    ImportIMSSourceWizardPage2.this.updateRemoveButtonState(t);
                    ImportIMSSourceWizardPage2.this.updateSelection(t);
                }
                catch (Throwable ex) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", ex);
                    logger.error(ex);
                }
            }
        });
        grp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                try {
                    Rectangle area = grp.getClientArea();
                    Point size = t.computeSize(-1, -1);
                    ScrollBar vBar = t.getVerticalBar();
                    int width = area.width - t.computeTrim((int)0, (int)0, (int)0, (int)0).width;
                    if (size.y > area.height + t.getHeaderHeight()) {
                        Point vBarSize = vBar.getSize();
                        width -= vBarSize.x;
                    }
                    Point oldSize = t.getSize();
                    if (oldSize.x > area.width) {
                        if (t.equals(ImportIMSSourceWizardPage2.this.psbTab)) {
                            ImportIMSSourceWizardPage2.this.psbCol1.setWidth(width / 4);
                            ImportIMSSourceWizardPage2.this.psbCol2.setWidth(width - ImportIMSSourceWizardPage2.this.psbCol1.getWidth());
                        } else if (t.equals(ImportIMSSourceWizardPage2.this.dbdTab)) {
                            ImportIMSSourceWizardPage2.this.dbdCol1.setWidth(width / 4);
                            ImportIMSSourceWizardPage2.this.dbdCol2.setWidth(width / 3);
                            ImportIMSSourceWizardPage2.this.dbdCol3.setWidth(width - (ImportIMSSourceWizardPage2.this.dbdCol1.getWidth() + ImportIMSSourceWizardPage2.this.dbdCol2.getWidth()));
                        } else if (t.equals(ImportIMSSourceWizardPage2.this.needDBDTab)) {
                            ImportIMSSourceWizardPage2.this.needDBDCol1.setWidth(width / 4);
                            ImportIMSSourceWizardPage2.this.needDBDCol2.setWidth(width - ImportIMSSourceWizardPage2.this.needDBDCol1.getWidth());
                        }
                        t.setSize(area.width, area.height);
                    } else {
                        t.setSize(area.width, area.height);
                        if (t.equals(ImportIMSSourceWizardPage2.this.psbTab)) {
                            ImportIMSSourceWizardPage2.this.psbCol1.setWidth(width / 4);
                            ImportIMSSourceWizardPage2.this.psbCol2.setWidth(width - ImportIMSSourceWizardPage2.this.psbCol1.getWidth());
                        } else if (t.equals(ImportIMSSourceWizardPage2.this.dbdTab)) {
                            ImportIMSSourceWizardPage2.this.dbdCol1.setWidth(width / 4);
                            ImportIMSSourceWizardPage2.this.dbdCol2.setWidth(width / 3);
                            ImportIMSSourceWizardPage2.this.dbdCol3.setWidth(width - (ImportIMSSourceWizardPage2.this.dbdCol1.getWidth() + ImportIMSSourceWizardPage2.this.dbdCol2.getWidth()));
                        } else if (t.equals(ImportIMSSourceWizardPage2.this.needDBDTab)) {
                            ImportIMSSourceWizardPage2.this.needDBDCol1.setWidth(width / 4);
                            ImportIMSSourceWizardPage2.this.needDBDCol2.setWidth(width - ImportIMSSourceWizardPage2.this.needDBDCol1.getWidth());
                        }
                    }
                }
                catch (Throwable ex) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "controlResized(ControlEvent e)", ex);
                    logger.error(ex);
                }
            }
        });
    }

    public void updateRemoveButtonState(Table t) {
        int selectionCount = t.getSelectionCount();
        if (selectionCount > 0) {
            if (t.equals(this.psbTab)) {
                this.removePSBButton.setEnabled(true);
            } else if (t.equals(this.dbdTab)) {
                this.removeDBDButton.setEnabled(true);
            }
        } else if (t.equals(this.psbTab)) {
            this.removePSBButton.setEnabled(false);
        } else if (t.equals(this.dbdTab)) {
            this.removeDBDButton.setEnabled(false);
        }
    }

    protected void updateSelection(Table t) {
        if (this.itemSelected.length > 0) {
            int i = 0;
            while (i < this.itemSelected.length) {
                t.setSelection(this.itemSelected);
                ++i;
            }
        }
    }

    private void createColumns(Table table) {
        if (table.equals(this.psbTab)) {
            this.psbCol1 = new TableColumn(this.psbTab, 0);
            this.psbCol1.setText("PSB " + WorkbenchPlugin.labels.getString("WB014"));
            this.psbCol1.setResizable(true);
            this.psbCol1.setMoveable(true);
            this.psbCol2 = new TableColumn(this.psbTab, 0);
            this.psbCol2.setText(WorkbenchPlugin.labels.getString("WB016"));
            this.psbCol2.setResizable(true);
            this.psbCol2.setMoveable(true);
        } else if (table.equals(this.dbdTab)) {
            this.dbdCol1 = new TableColumn(this.dbdTab, 0);
            this.dbdCol1.setText("DBD " + WorkbenchPlugin.labels.getString("WB014"));
            this.dbdCol1.setResizable(true);
            this.dbdCol1.setMoveable(true);
            this.dbdCol2 = new TableColumn(this.dbdTab, 0);
            this.dbdCol2.setText(WorkbenchPlugin.labels.getString("WB001B"));
            this.dbdCol2.setResizable(true);
            this.dbdCol2.setMoveable(true);
            this.dbdCol3 = new TableColumn(this.dbdTab, 0);
            this.dbdCol3.setText(WorkbenchPlugin.labels.getString("WB016"));
            this.dbdCol3.setResizable(true);
            this.dbdCol3.setMoveable(true);
        } else if (table.equals(this.needDBDTab)) {
            this.needDBDCol1 = new TableColumn(this.needDBDTab, 0);
            this.needDBDCol1.setText("DBD " + WorkbenchPlugin.labels.getString("WB014"));
            this.needDBDCol1.setResizable(true);
            this.needDBDCol1.setMoveable(true);
            this.needDBDCol2 = new TableColumn(this.needDBDTab, 0);
            this.needDBDCol2.setText(WorkbenchPlugin.labels.getString("WB001B"));
            this.needDBDCol2.setResizable(true);
            this.needDBDCol2.setMoveable(true);
        }
    }

    private void computeButtonSize(Button button) {
        Point buttonSize = button.computeSize(-1, -1);
        button.setSize(buttonSize);
    }

    private void setCursor(Table t) {
        this.cursor = new TableCursor(t, 27);
    }

    /*
     * Unable to fully structure code
     */
    private DbdModel quickParseDBDFile(String filePath) {
        block15: {
            if (ImportIMSSourceWizardPage2.logger.isLoggable(Level.FINER)) {
                ImportIMSSourceWizardPage2.logger.entering(this.getClass().getName(), "quickParseDBDFile()", new Object[0]);
            }
            dbd = null;
            try {
                fileInfo = this.fileHashTable.get(filePath);
                if (fileInfo == null) {
                    dbd = this.importIMSSource.quickDBDParse(filePath);
                    if (dbd != null) {
                        newFileInfo = new FileInformation(dbd, true);
                        this.fileHashTable.put(filePath, newFileInfo);
                    }
                } else {
                    isValidDBD = fileInfo.isValidSource();
                    if (isValidDBD) {
                        dbd = fileInfo.getDbdModel();
                    }
                }
            }
            catch (FileNotFoundException v0) {
                inserts = new Object[]{filePath};
                this.setErrorMessage(WorkbenchPlugin.errors.getString("EISRC35"));
            }
            catch (IOException e) {
                ImportIMSSourceWizardPage2.logger.throwing(this.getClass().getName(), "parseDBDFile()", (Throwable)e);
                ImportIMSSourceWizardPage2.logger.error((Throwable)e);
            }
            catch (ImporterException e) {
                if (this.importerExceptions == null) {
                    this.importerExceptions = new Vector<E>();
                }
                exceptionExists = false;
                i = 0;
                ** while (i < this.importerExceptions.size() && !exceptionExists)
            }
lbl-1000:
            // 1 sources

            {
                inserts = new Object[]{filePath};
                if (this.importerExceptions.get(i).getMessage().equalsIgnoreCase(WorkbenchPlugin.errors.getString("EISRC34", inserts))) {
                    exceptionExists = true;
                }
                ++i;
                continue;
            }
lbl39:
            // 1 sources

            if (!exceptionExists) {
                this.importerExceptions.add(e);
            }
            break block15;
            catch (Throwable e) {
                ImportIMSSourceWizardPage2.logger.throwing(this.getClass().getName(), "parseDBDFile()", e);
                ImportIMSSourceWizardPage2.logger.error(e);
            }
        }
        if (ImportIMSSourceWizardPage2.logger.isLoggable(Level.FINER)) {
            ImportIMSSourceWizardPage2.logger.exiting(this.getClass().getName(), "quickParseDBDFile()", new Object[0]);
        }
        return dbd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateReferenceMapForDBD(DbdModel dbd) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "updateResourceMapForLogicalDBD(String filePath)", new Object[0]);
        }
        try {
            Iterator refDBDList = dbd.getReferencedDBDs().iterator();
            if (refDBDList == null || !refDBDList.hasNext()) {
                logger.finest("Reference DBD List is null");
            } else {
                while (refDBDList.hasNext()) {
                    String currDbdName = (String)refDBDList.next();
                    ReferencedDbd refDbd = this.referenceMap.get(currDbdName);
                    if (refDbd == null) {
                        refDbd = new ReferencedDbd(currDbdName, null, dbd.getDBDName());
                        this.referenceMap.put(currDbdName, refDbd);
                        continue;
                    }
                    refDbd.addDbdReferencer(dbd.getDBDName());
                }
            }
        }
        catch (ModelException e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "getLogicalDBDList()", (Throwable)e);
            logger.error((Throwable)e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "updateResourceMapForLogicalDBD(String filePath)", new Object[0]);
        }
    }

    private int searchPSBTable(String psbName) {
        boolean foundPSBItem = false;
        int index = -1;
        int i = 0;
        while (i < this.psbTab.getItemCount() && !foundPSBItem) {
            TableItem tItem = this.psbTab.getItem(i);
            String psbnamefromTab = tItem.getText(0);
            if (psbName.equalsIgnoreCase(psbnamefromTab)) {
                foundPSBItem = true;
                index = i;
            }
            ++i;
        }
        return index;
    }

    private void recursiveDBDFileSearch(String dbdName, File root, IMSSourceImporter importer, IProgressMonitor monitor) throws InterruptedException, IOException, ImporterException, ModelException {
        this.listRecursively(root, 0, dbdName, importer, monitor);
    }

    private boolean listRecursively(File fdir, int depth, String dbdName, IMSSourceImporter importer, IProgressMonitor monitor) throws InterruptedException, IOException, ImporterException, ModelException {
        boolean dbdWasFound = false;
        DbdModel dbdModel = null;
        if (fdir.isDirectory() && depth < 1) {
            File[] fileArray = fdir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String parsedDbdNameStr;
                String dbdFullQualifiedFileName;
                File f = fileArray[n2];
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                dbdWasFound = this.listRecursively(f, depth + 1, dbdName, importer, monitor);
                if (dbdWasFound) break;
                if (f.isFile() && this.isFileExtValid(f.getName()) && (dbdModel = this.quickParseDBDFile(dbdFullQualifiedFileName = f.getAbsolutePath())) != null && (parsedDbdNameStr = dbdModel.getDBDName()) != null && this.compareString(dbdName, parsedDbdNameStr)) {
                    ArrayList sSets = importer.createStatementSets(dbdFullQualifiedFileName);
                    dbdModel = importer.importReferencedDBD(dbdFullQualifiedFileName);
                    this.dbdToImportList.put(parsedDbdNameStr, new DbdToImport(parsedDbdNameStr, (StatementSet)sSets.get(0)));
                    this.updateReferenceMapForDBD(dbdModel);
                    dbdWasFound = true;
                    break;
                }
                ++n2;
            }
        }
        return dbdWasFound;
    }

    private void columnSorter(int direction, Table t, TableColumn col1, TableColumn col2, TableColumn col3) {
        TableItem[] items = t.getItems();
        Collator collator = Collator.getInstance(Locale.getDefault());
        int index = 0;
        if (this.column == col1) {
            index = 0;
        } else if (this.column == col2) {
            index = 1;
        } else if (this.column == col3) {
            index = 2;
        }
        int i = 1;
        while (i < items.length) {
            String value1 = items[i].getText(index);
            int j = 0;
            while (j < i) {
                String value2 = items[j].getText(index);
                if (direction == 1024) {
                    if (collator.compare(value1, value2) < 0) {
                        values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2)};
                        items[i].dispose();
                        item1 = new TableItem(t, 0, j);
                        item1.setText(values);
                        items = t.getItems();
                        break;
                    }
                } else if (collator.compare(value1, value2) > 0) {
                    values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2)};
                    items[i].dispose();
                    item1 = new TableItem(t, 0, j);
                    item1.setText(values);
                    items = t.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
        t.setSortColumn(this.column);
    }

    public void marshallResources() throws InvocationTargetException, InterruptedException {
        ImportSourceType type = this.getImportSourceType();
        if (type == ImportSourceType.CATALOG) {
            MarshallCatalogResources op = new MarshallCatalogResources();
            Shell activeShell = this.getWizard().getContainer().getShell();
            new ProgressMonitorDialog(activeShell).run(true, false, (IRunnableWithProgress)op);
        } else {
            MarshallResources op = new MarshallResources();
            Shell activeShell = this.getWizard().getContainer().getShell();
            new ProgressMonitorDialog(activeShell).run(true, false, (IRunnableWithProgress)op);
        }
    }

    private void cleanupWarnings(String projectName, List<String> listDBD) {
        Iterator<String> dbdIter = listDBD.iterator();
        String dbdName = null;
        IFolder dbdFolder = null;
        while (dbdIter.hasNext()) {
            dbdName = dbdIter.next();
            dbdFolder = ProjectTreeFileHelper.getDbdFolder((String)projectName, (String)dbdName);
            try {
                dbdFolder.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            }
            catch (CoreException e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "cleanupWarnings()", (Throwable)e);
                logger.error((Throwable)e);
            }
        }
    }

    private String marshallSinglePsb(String projectName, PsbToImport psbToImport, IProgressMonitor monitor) throws CoreException, ImporterException, IOException {
        String retVal = null;
        try {
            boolean psbFound = false;
            String unqualPsbFileName = null;
            PsbModel psb = psbToImport.getPsbModel();
            psbFound = this.findPSBInProjectTree(psb.getPsbName());
            if (psbFound) {
                Object[] error = new String[]{psb.getPsbName()};
                ImporterException e = new ImporterException(WorkbenchPlugin.errors.getString("DHB1752", error));
                if (this.importerExceptions == null) {
                    this.importerExceptions = new Vector();
                }
                this.importerExceptions.add(e);
            } else {
                if (this.sourceType == ImportSourceType.CATALOG) {
                    monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD004") + ": " + WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL12"));
                } else if (this.sourceType == ImportSourceType.ZOS) {
                    srcFilePath = psbToImport.getPath();
                    monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD004") + ": " + srcFilePath);
                    unqualPsbFileName = psb.getPsbName();
                    IFile newPSBResource = ProjectTreeFileHelper.getImportedPsbSourceFile((String)projectName, (String)unqualPsbFileName);
                    if (newPSBResource.exists()) {
                        newPSBResource.setContents((InputStream)new ByteArrayInputStream(psbToImport.getContents().toByteArray()), 1, null);
                    } else {
                        newPSBResource.create((InputStream)new ByteArrayInputStream(psbToImport.getContents().toByteArray()), true, null);
                    }
                } else if (this.sourceType == ImportSourceType.LOCAL) {
                    srcFilePath = psbToImport.getPath();
                    monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD004") + ": " + srcFilePath);
                    unqualPsbFileName = psb.getPsbName();
                    File srcFile = new File(srcFilePath);
                    FileInputStream is = new FileInputStream(srcFile);
                    unqualPsbFileName = ProjectTreeFileHelper.getUnqualFileName((String)srcFilePath);
                    IFile newPSBResource = ProjectTreeFileHelper.getImportedPsbSourceFile((String)projectName, (String)unqualPsbFileName);
                    if (newPSBResource.exists()) {
                        newPSBResource.setContents((InputStream)is, 1, null);
                    } else {
                        newPSBResource.create((InputStream)is, true, null);
                    }
                    ((InputStream)is).close();
                }
                IFile psbMetaFile = ProjectTreeFileHelper.getPsbMetadataFile((String)projectName, (String)psb.getPsbName());
                String metaFilePath = psbMetaFile.getFullPath().toString();
                monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD004") + ": " + metaFilePath);
                ByteArrayOutputStream psbOutputStream = new ByteArrayOutputStream();
                psb.marshall(psbOutputStream);
                ByteArrayInputStream psbInputStream = new ByteArrayInputStream(psbOutputStream.toByteArray());
                if (!psbMetaFile.exists()) {
                    psbMetaFile.create((InputStream)psbInputStream, true, null);
                } else {
                    psbMetaFile.setContents((InputStream)psbInputStream, true, true, null);
                }
                this.generateImportedPSB(psb, projectName, monitor);
            }
            retVal = psb.getPsbName();
        }
        catch (ModelException e) {
            throw new ImporterException((Throwable)e);
        }
        return retVal;
    }

    private List<String> marshallAllPsbs(String projectName, IProgressMonitor monitor) throws IOException, CoreException {
        ArrayList<String> listPsb = new ArrayList<String>();
        for (PsbToImport psbToImport : this.psbToImportList.values()) {
            if (psbToImport == null) continue;
            try {
                String currPsbName = this.marshallSinglePsb(projectName, psbToImport, monitor);
                listPsb.add(currPsbName);
            }
            catch (ImporterException e) {
                if (this.importerExceptions == null) {
                    this.importerExceptions = new Vector();
                }
                this.importerExceptions.add(e);
            }
            monitor.worked(1);
        }
        return listPsb;
    }

    private void generateImportedPSB(PsbModel psbModel, String projectName, IProgressMonitor monitor) throws CoreException, IOException, ModelException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "generateImportedPSB(PsbModel psbModel, String projectName, IProgressMonitor monitor) ", new Object[0]);
        }
        IFile generatedSrcPsbFile = ProjectTreeFileHelper.getGenedSrcPsbFile((String)projectName, (String)psbModel.getPsbName());
        String genedSrcFilePath = generatedSrcPsbFile.getName();
        monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD005") + ": " + genedSrcFilePath);
        ProjectTreeFileHelper.marshallGeneratedPsbFile((String)projectName, (PsbModel)psbModel);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "generateImportedPSB(PsbModel psbModel, String projectName, IProgressMonitor monitor)  ", new Object[0]);
        }
    }

    private void generateImportedDbd(DbdModel dbdModel, String projectName, IProgressMonitor monitor) throws CoreException, IOException, ModelException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "generateImportedDbd(DbdModel dbdModel, String projectName, IProgressMonitor monitor)", new Object[0]);
        }
        IFile generatedSrcDbdFile = ProjectTreeFileHelper.getGenedSrcDbdFile((String)projectName, (String)dbdModel.getDbd().getDbdName());
        monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD006") + ": " + generatedSrcDbdFile.getFullPath().toString());
        ProjectTreeFileHelper.marshallGeneratedDbdFile((String)projectName, (DbdModel)dbdModel);
        ProjectTreeFileHelper.marshallGeneratedDdlFile((String)projectName, (DbdModel)dbdModel);
        IFile generatedCatSrcDbdFile = ProjectTreeFileHelper.getGenedCatalogSrcDbdFile((String)projectName, (String)dbdModel.getDbd().getDbdName());
        monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD006") + ": " + generatedCatSrcDbdFile.getFullPath().toString());
        ProjectTreeFileHelper.marshallCatalogEnabledGeneratedDbdFile((String)projectName, (DbdModel)dbdModel);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "generateImportedDbd(DbdModel dbdModel, String projectName, IProgressMonitor monitor)", new Object[0]);
        }
    }

    private String marshallSingleDBD(String projectName, DbdToImport dbdToImport, IProgressMonitor monitor) throws CoreException, ImporterException, IOException {
        String retVal = null;
        try {
            DbdModel newDbd = dbdToImport.getDbdModel();
            boolean dbdFound = this.findDBDInProjectTree(newDbd.getDBDName());
            if (dbdFound) {
                if (!this.mergeYesToAll) {
                    String dbdName = newDbd.getDBDName();
                    this.confirmationInserts = new Object[2];
                    this.confirmationInserts[0] = dbdName;
                    this.confirmationInserts[1] = projectName;
                    this.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ConfirmationDialog cd = new ConfirmationDialog(ImportIMSSourceWizardPage2.this.getShell(), WorkbenchPlugin.errors.getString("DIALOG001", ImportIMSSourceWizardPage2.this.confirmationInserts), "DIALOG001");
                            ImportIMSSourceWizardPage2.this.mergeReturnCode = cd.open();
                        }
                    });
                    if (this.mergeReturnCode == 4) {
                        this.mergeYesToAll = true;
                    }
                }
                if (this.mergeYesToAll || this.mergeReturnCode == 2) {
                    DbdModel existingDbd = this.getExistingDbd(projectName, newDbd.getDBDName());
                    MergeDbd merge = new MergeDbd(existingDbd, newDbd);
                    merge.compare();
                    merge.moveAllDiffsRight();
                } else {
                    Object[] error = new String[]{newDbd.getDBDName()};
                    ImporterException e = new ImporterException(WorkbenchPlugin.errors.getString("DHB1752", error));
                    if (this.importerExceptions == null) {
                        this.importerExceptions = new Vector();
                    }
                    this.importerExceptions.add(e);
                }
            }
            if (!dbdFound || this.mergeYesToAll || this.mergeReturnCode == 2) {
                Vector warnings;
                IMSSourceImporter importer = dbdToImport.getImporter();
                if (importer != null && (warnings = importer.getWarnings()) != null && warnings.size() > 0) {
                    if (this.importerExceptions == null) {
                        this.importerExceptions = new Vector();
                    }
                    int i = 0;
                    while (i < warnings.size()) {
                        this.importerExceptions.add((ImporterException)((Object)warnings.get(i)));
                        ++i;
                    }
                }
                Object unqualDbdFileName = null;
                if (this.sourceType == ImportSourceType.ZOS) {
                    unqualDbdFileName = newDbd.getDBDName();
                    logger.finest("DBD Name: " + newDbd.getDBDName());
                    logger.finest("DBD File Name: " + (String)unqualDbdFileName);
                    IFile newDbdResource = ProjectTreeFileHelper.getImportedDbdSourceFile((String)projectName, (String)unqualDbdFileName);
                    monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD004") + ": " + newDbdResource.getFullPath().toString());
                    if (newDbdResource.exists()) {
                        newDbdResource.setContents((InputStream)new ByteArrayInputStream(dbdToImport.getContents().toByteArray()), true, true, null);
                    } else {
                        newDbdResource.create((InputStream)new ByteArrayInputStream(dbdToImport.getContents().toByteArray()), true, null);
                    }
                } else if (this.sourceType == ImportSourceType.LOCAL) {
                    String dbdFileName = dbdToImport.getPath();
                    File srcFile = new File(dbdFileName);
                    FileInputStream is = new FileInputStream(srcFile);
                    unqualDbdFileName = dbdFileName.substring(dbdFileName.lastIndexOf(File.separator) + 1);
                    if (((String)unqualDbdFileName).contains(".")) {
                        int dotPos = ((String)unqualDbdFileName).lastIndexOf(".") + 1;
                        String extension = ((String)unqualDbdFileName).substring(dotPos);
                        unqualDbdFileName = ((String)unqualDbdFileName).substring(0, ((String)unqualDbdFileName).lastIndexOf(".")) + "_" + extension;
                    }
                    logger.finest("DBD Name: " + newDbd.getDBDName());
                    logger.finest("DBD File Name: " + (String)unqualDbdFileName);
                    IFile newDbdResource = ProjectTreeFileHelper.getImportedDbdSourceFile((String)projectName, (String)unqualDbdFileName);
                    monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD004") + ": " + newDbdResource.getFullPath().toString());
                    if (newDbdResource.exists()) {
                        newDbdResource.setContents((InputStream)is, 1, null);
                    } else {
                        newDbdResource.create((InputStream)is, true, null);
                    }
                    ((InputStream)is).close();
                }
                String defaultEncoding = WorkbenchPlugin.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection");
                newDbd.setEncoding(defaultEncoding);
                IFile dbdMetadataFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)newDbd.getDBDName());
                monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD004") + ": " + dbdMetadataFile.getFullPath().toString());
                ByteArrayOutputStream dbdOutputStream = new ByteArrayOutputStream();
                newDbd.marshall(dbdOutputStream);
                ByteArrayInputStream dbdInputStream = new ByteArrayInputStream(dbdOutputStream.toByteArray());
                if (!dbdMetadataFile.exists()) {
                    dbdMetadataFile.create((InputStream)dbdInputStream, true, null);
                } else {
                    dbdMetadataFile.setContents((InputStream)dbdInputStream, true, true, null);
                }
                this.generateImportedDbd(newDbd, projectName, monitor);
            }
            retVal = newDbd.getDBDName();
        }
        catch (ModelException e) {
            throw new ImporterException((Throwable)e);
        }
        return retVal;
    }

    private List<String> marshallAllDbds(String projectName, IProgressMonitor monitor) throws CoreException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "marshallAllDbds(String projectName, IMSSourceImporter importPSB, IProgressMonitor monitor)", new Object[0]);
        }
        ArrayList<String> listDbd = new ArrayList<String>();
        for (DbdToImport dbdToImport : this.dbdToImportList.values()) {
            if (dbdToImport == null) continue;
            try {
                String currDbdName = this.marshallSingleDBD(projectName, dbdToImport, monitor);
                listDbd.add(currDbdName);
            }
            catch (ImporterException e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "marshallAllDbds", (Throwable)e);
                if (this.importerExceptions == null) {
                    this.importerExceptions = new Vector();
                }
                this.importerExceptions.add(e);
            }
            monitor.worked(1);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "marshallAllDbds(String projectName, IMSSourceImporter importPSB, IProgressMonitor monitor)", new Object[0]);
        }
        return listDbd;
    }

    private DbdModel getExistingDbd(String projectName, String dbdName) throws CoreException, ModelException {
        IFile dbdMetadataFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
        DbdModel retVal = new DbdModel(dbdMetadataFile.getContents());
        return retVal;
    }

    private boolean validatePage() {
        boolean retVal = false;
        if (this.psbToImportList != null && this.psbToImportList.size() > 0 || this.dbdToImportList != null && this.dbdToImportList.size() > 0) {
            retVal = true;
        }
        return retVal;
    }

    private void initialize() {
        this.addListeners();
        this.initListViewer(this.needDBDViewer, this.needDBDTab, this.dbdGrp);
    }

    private void addListeners() {
        this.addPSBButton.addListener(13, (Listener)this);
        this.removePSBButton.addListener(13, (Listener)this);
        this.addDBDButton.addListener(13, (Listener)this);
        this.removeDBDButton.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        try {
            this.setMessage(null);
            this.setErrorMessage(null);
            if (event.widget == this.addPSBButton) {
                this.sourceType = this.getImportSourceType();
                this.isImportDbd = false;
                this.addIMSResource();
            } else if (event.widget == this.removePSBButton) {
                this.handleRemovePSB();
                this.refreshTables();
            } else if (event.widget == this.addDBDButton) {
                this.sourceType = this.getImportSourceType();
                this.isImportDbd = true;
                this.addIMSResource();
            } else if (event.widget == this.removeDBDButton) {
                this.handleRemoveDBD();
                this.refreshTables();
            }
            if (this.importerExceptions != null && this.importerExceptions.size() > 0) {
                final StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < this.importerExceptions.size()) {
                    buf.append(this.importerExceptions.get(i).getMessage());
                    buf.append("\n\n");
                    ++i;
                }
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                            if (!store.getBoolean("explorer_wizard_skip_warning_flag")) {
                                Warnings warnings = new Warnings(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.errors.getString("EISRC27"), null, WorkbenchPlugin.errors.getString("IOGWB0058"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                                warnings.setWarnings(buf.toString());
                                warnings.open();
                            }
                        }
                        catch (Throwable e) {
                            logger.throwing(this.getClass().getName(), "handleEvent(Event event)", e);
                            logger.error(e);
                        }
                    }
                });
                this.importerExceptions.removeAllElements();
            }
            if (this.needTableExists && this.needTableMessageNotShownYet) {
                try {
                    MessageDialog infoDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.errors.getString("EISRC25"), null, WorkbenchPlugin.descriptions.getString("WB087A"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    infoDialog.open();
                    this.needTableMessageNotShownYet = false;
                }
                catch (Throwable e) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
                    logger.error(e);
                }
            }
            this.setPageComplete(this.validatePage());
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
            logger.error(e);
        }
    }

    private void updateReferenceMapForPSB(PsbModel psbModel) {
        PcbDBModel pcbDB;
        List pcbDBList = psbModel.getDBPcbList();
        List gsamPcbDBList = psbModel.getGsamPcbList();
        Vector<String> refDbdList = new Vector<String>();
        int i = 0;
        while (pcbDBList != null && i < pcbDBList.size()) {
            pcbDB = (PcbDBModel)pcbDBList.get(i);
            refDbdList.add(pcbDB.getDbdName());
            ++i;
        }
        i = 0;
        while (gsamPcbDBList != null && i < gsamPcbDBList.size()) {
            pcbDB = (PcbGsamModel)gsamPcbDBList.get(i);
            refDbdList.add(pcbDB.getDbdName());
            ++i;
        }
        int totalNumReferenced = refDbdList.size();
        if (totalNumReferenced > 0) {
            int i2 = 0;
            while (i2 < refDbdList.size()) {
                String currDbdName = (String)refDbdList.get(i2);
                ReferencedDbd refDbd = this.referenceMap.get(currDbdName);
                if (refDbd == null) {
                    refDbd = new ReferencedDbd(currDbdName, psbModel.getPsbName(), null);
                    this.referenceMap.put(currDbdName, refDbd);
                } else {
                    refDbd.addPsbReferencer(psbModel.getPsbName());
                }
                ++i2;
            }
        }
    }

    private void handleRemovePSB() {
        TableItem[] psbTabItem = this.psbTab.getSelection();
        int i = 0;
        while (i < psbTabItem.length) {
            String psbToBeRemoved = psbTabItem[i].getText(0);
            this.removePsb(psbToBeRemoved);
            ++i;
        }
    }

    private void removePsb(String psbName) {
        this.psbToImportList.remove(psbName);
        if (this.referenceMap != null) {
            Vector<String> refsToRemove = null;
            for (ReferencedDbd currRefDbd : this.referenceMap.values()) {
                boolean noReferencersRemain = currRefDbd.removePsbReferencer(psbName);
                if (!noReferencersRemain) continue;
                if (refsToRemove == null) {
                    refsToRemove = new Vector<String>();
                }
                refsToRemove.add(currRefDbd.getDbdName());
            }
            if (refsToRemove != null) {
                int i = 0;
                while (i < refsToRemove.size()) {
                    String currRefToRemove = (String)refsToRemove.get(i);
                    this.referenceMap.remove(currRefToRemove);
                    ++i;
                }
            }
        }
    }

    private void addIMSResource() throws InvocationTargetException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "addIMSResource()", new Object[0]);
        }
        try {
            this.type = this.getImportSourceType();
            if (this.type == ImportSourceType.ZOS) {
                ImportDataSetWizard importDataSetWizard = new ImportDataSetWizard();
                WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)importDataSetWizard);
                dialog.open();
                this.zOSFiles = importDataSetWizard.getDataEntries();
                if (this.zOSFiles == null || this.zOSFiles.length == 0 || this.zOSFiles[0].dataEntry instanceof PartitionedDataSet) {
                    return;
                }
                this.dirPath = this.zOSFiles[0].getParentPath();
            } else if (this.type == ImportSourceType.LOCAL) {
                FileDialog fDialog = this.browse();
                this.files = fDialog.getFileNames();
                if (this.files.length == 0) {
                    return;
                }
                this.dirPath = fDialog.getFilterPath();
            } else if (this.type == ImportSourceType.CATALOG) {
                this.getWizard();
                List connProfiles = ImsDbUtils.getConnectionProfileNames();
                if (connProfiles.size() == 0) {
                    MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("CATALOG_IMPORT_ERROR03"));
                } else {
                    boolean sourceAlreadySelected = false;
                    if (this.dbdToImportList != null && !this.dbdToImportList.isEmpty() || this.psbToImportList != null && !this.psbToImportList.isEmpty()) {
                        sourceAlreadySelected = true;
                    }
                    CatalogImportWizard catImportWiz = new CatalogImportWizard(this.isImportDbd, sourceAlreadySelected);
                    catImportWiz.setConnProfileNameUsed(this.connProfileNameUsed);
                    WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)catImportWiz);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        this.connProfileNameUsed = catImportWiz.getConnProfileNameUsed();
                        Vector<String> sourceList = catImportWiz.getSourceNames();
                        Iterator<String> it = sourceList.iterator();
                        if (sourceList != null) {
                            if (this.isImportDbd) {
                                if (this.dbdToImportList == null) {
                                    this.dbdToImportList = new HashMap(sourceList.size());
                                }
                                while (it.hasNext()) {
                                    String name = it.next();
                                    this.dbdToImportList.put(name, new DbdToImport(name, null));
                                }
                            } else {
                                if (this.psbToImportList == null) {
                                    this.psbToImportList = new HashMap(sourceList.size());
                                }
                                while (it.hasNext()) {
                                    String name = it.next();
                                    this.psbToImportList.put(name, new PsbToImport(name, null));
                                }
                            }
                        }
                    } else {
                        dialog.getReturnCode();
                    }
                }
            }
            if (this.type == ImportSourceType.CATALOG) {
                this.refreshTables();
            } else if (this.type == ImportSourceType.ZOS || this.type == ImportSourceType.LOCAL) {
                ImportSource op = new ImportSource();
                Shell activeShell = this.getWizard().getContainer().getShell();
                try {
                    new ProgressMonitorDialog(activeShell).run(true, true, (IRunnableWithProgress)op);
                    long freeMemory = Runtime.getRuntime().freeMemory();
                    logger.fine("Free memory after add processing: " + freeMemory);
                    this.refreshTables();
                }
                catch (InterruptedException interruptedException) {
                    this.refreshTables();
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addIMSResource()", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "addIMSResource()", new Object[0]);
        }
    }

    private void handleRemoveDBD() {
        TableItem[] dbdTabItem = this.dbdTab.getSelection();
        int i = 0;
        while (i < dbdTabItem.length) {
            String dbdToBeRemoved = dbdTabItem[i].getText(0);
            this.removeDbd(dbdToBeRemoved);
            ++i;
        }
    }

    private void removeDbd(String dbdName) {
        this.dbdToImportList.remove(dbdName);
        if (this.referenceMap != null) {
            Vector<String> refsToRemove = null;
            for (ReferencedDbd currRefDbd : this.referenceMap.values()) {
                boolean noReferencersRemain = currRefDbd.removeDbdReferencer(dbdName);
                if (!noReferencersRemain) continue;
                if (refsToRemove == null) {
                    refsToRemove = new Vector<String>();
                }
                refsToRemove.add(currRefDbd.getDbdName());
            }
            if (refsToRemove != null) {
                int i = 0;
                while (i < refsToRemove.size()) {
                    String currRefToRemove = (String)refsToRemove.get(i);
                    this.referenceMap.remove(currRefToRemove);
                    ++i;
                }
            }
        }
    }

    protected void refreshTables() {
        this.refreshPSBTable();
        this.refreshDBDTable();
        this.refreshNeedTable();
    }

    private void refreshPSBTable() {
        this.psbTab.removeAll();
        if (this.psbToImportList != null) {
            for (PsbToImport localPsbToImport : this.psbToImportList.values()) {
                if (localPsbToImport == null) continue;
                String psbName = localPsbToImport.getName();
                String localPath = localPsbToImport.getPath();
                this.psbTabItem = this.psbTab.getItems();
                int index = this.searchPSBTable(psbName);
                if (index < 0) {
                    this.addPsbOrNeedTableItem(this.psbTab, psbName, localPath);
                    continue;
                }
                this.psbTabItem[index].setText(1, localPath);
            }
            this.psbTab.setSelection(0);
            this.psbTab.showSelection();
            this.updateRemoveButtonState(this.psbTab);
        }
    }

    private void refreshDBDTable() {
        this.dbdTab.removeAll();
        if (this.dbdToImportList != null) {
            List<Object> refPsbList = new ArrayList();
            Iterator<DbdToImport> dbdListIt = this.dbdToImportList.values().iterator();
            int counter = 0;
            while (dbdListIt.hasNext()) {
                ReferencedDbd refDbd;
                ++counter;
                DbdToImport localDbdToImport = dbdListIt.next();
                if (localDbdToImport == null) continue;
                Object psbName = "";
                String localPath = localDbdToImport.getPath();
                String localDbdName = localDbdToImport.getDbdName();
                if (this.referenceMap != null && (refDbd = this.referenceMap.get(localDbdToImport.getDbdName())) != null) {
                    HashSet<String> referencerNames = refDbd.getReferencerNames();
                    for (String referencerName : referencerNames) {
                        refPsbList = this.splitPSBList((String)psbName);
                        if (refPsbList.contains(referencerName)) continue;
                        psbName = (String)psbName + "," + referencerName;
                        psbName = this.formatString((String)psbName);
                    }
                }
                this.addDbdTableItem(this.dbdTab, localDbdName, (String)psbName, localPath);
                if (counter % 10 == 0) {
                    logger.fine("Added TableItem for DBD: " + localDbdName + " counter: " + counter);
                    long freeMemory = Runtime.getRuntime().freeMemory();
                    logger.fine("Free memory: " + freeMemory);
                }
                this.dbdTab.setSelection(0);
                this.dbdTab.showSelection();
            }
            this.updateRemoveButtonState(this.dbdTab);
        }
    }

    private void refreshNeedTable() {
        Collection<ReferencedDbd> collection;
        this.needTableExists = false;
        if (this.referenceMap != null && (collection = this.referenceMap.values()) != null) {
            Iterator<ReferencedDbd> iter = collection.iterator();
            this.needDBDTab.removeAll();
            while (iter.hasNext()) {
                ReferencedDbd refDbd = iter.next();
                String dbdName = refDbd.getDbdName();
                boolean dbdInProjectTree = this.findDBDInProjectTree(dbdName);
                if (this.dbdToImportList == null || this.dbdToImportList.containsKey(dbdName) || dbdInProjectTree) continue;
                Object referencerNameList = null;
                for (String currRef : refDbd.getReferencerNames()) {
                    referencerNameList = referencerNameList != null ? (String)referencerNameList + "," + currRef : currRef;
                }
                this.addPsbOrNeedTableItem(this.needDBDTab, dbdName, (String)referencerNameList);
            }
            this.needDBDTab.setSelection(0);
            this.needDBDTab.showSelection();
            this.updateRemoveButtonState(this.needDBDTab);
            if (this.needDBDTab.getItems().length <= 0) {
                this.needImportlbl.setVisible(false);
                this.needImportlbl2.setVisible(false);
                this.needDBDTab.setVisible(false);
                this.warningImgLbl.setVisible(false);
            } else {
                this.needTableExists = true;
                this.needDBDTab.setVisible(true);
                this.needImportlbl2.setVisible(true);
                this.needImportlbl.setVisible(true);
                this.warningImgLbl.setImage(this.warningImg);
                this.warningImgLbl.setVisible(true);
            }
        }
    }

    private List<String> splitPSBList(String psbName) {
        ArrayList<String> refPSBList = new ArrayList<String>();
        String[] refList = new String[1];
        if (psbName.contains(",")) {
            refList = psbName.split(",");
            int i = 0;
            while (i < refList.length) {
                refPSBList.add(refList[i]);
                ++i;
            }
        } else {
            refPSBList.add(psbName);
        }
        return refPSBList;
    }

    private boolean findDBDInProjectTree(String dbdName) {
        boolean dbdFound = false;
        try {
            String projectName = this.getProjectName();
            dbdFound = ProjectTreeFileHelper.checkDBDFileInProjectTree((String)projectName, (String)dbdName);
        }
        catch (CoreException e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "findDBDInProjectTree()", (Throwable)e);
            logger.error((Throwable)e);
        }
        return dbdFound;
    }

    private boolean findPSBInProjectTree(String psbName) {
        boolean psbFound = false;
        try {
            String projectName = this.getProjectName();
            psbFound = ProjectTreeFileHelper.checkPSBFileInProjectTree((String)projectName, (String)psbName);
        }
        catch (CoreException e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "findPSBInProjectTree()", (Throwable)e);
            logger.error((Throwable)e);
        }
        return psbFound;
    }

    private FileDialog browse() {
        Shell shell = new Shell();
        FileDialog fDialog = new FileDialog(shell, 2);
        fDialog.open();
        return fDialog;
    }

    private boolean isFileExtValid(String fileName) {
        boolean fileValid = true;
        if (fileName.contains(".")) {
            String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            FileExtConstant[] fileExtConstantArray = FileExtConstant.values();
            int n = fileExtConstantArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileExtConstant fExt = fileExtConstantArray[n2];
                if (fileExt.equalsIgnoreCase(fExt.value())) {
                    fileValid = false;
                    break;
                }
                ++n2;
            }
        }
        return fileValid;
    }

    private void addDbdTableItem(Table t, String name, String refName, String path) {
        TableItem tabItem = new TableItem(t, 0);
        tabItem.setText(0, name);
        tabItem.setText(1, refName);
        if (path == null) {
            tabItem.setText(2, "");
        } else {
            tabItem.setText(2, path);
        }
    }

    private void addPsbOrNeedTableItem(Table t, String name, String pathOrRefName) {
        TableItem tabItem = new TableItem(t, 0);
        tabItem.setText(0, name);
        if (pathOrRefName == null) {
            tabItem.setText(1, "");
        } else {
            tabItem.setText(1, pathOrRefName);
        }
    }

    private String formatString(String str) {
        String tempStr = new String();
        if (str.contains(",,")) {
            tempStr = str.replace(",,", ",");
        } else if (str.endsWith(",")) {
            int index = str.lastIndexOf(",");
            tempStr = str.substring(0, index);
        } else {
            tempStr = str.startsWith(",") ? str.substring(1) : str;
        }
        return tempStr;
    }

    private boolean compareString(String str1, String str2) {
        boolean strFound = false;
        if (str1.contains(".")) {
            str1 = str1.substring(0, str1.lastIndexOf("."));
        }
        if (str2.equalsIgnoreCase(str1)) {
            strFound = true;
        }
        return strFound;
    }

    public void setVisible(boolean visible) {
        try {
            super.setVisible(visible);
            if (visible) {
                this.addPSBButton.setFocus();
                ImportSourceType type = this.getImportSourceType();
                if (type == ImportSourceType.ZOS) {
                    this.setTitle(WorkbenchPlugin.labels.getString("WB605"));
                } else if (type == ImportSourceType.LOCAL) {
                    this.setTitle(WorkbenchPlugin.labels.getString("WB604"));
                } else {
                    this.setTitle(WorkbenchPlugin.labels.getString("WB611"));
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
            logger.error(e);
        }
    }

    private String getProjectName() {
        String retVal = null;
        IWizard wiz = this.getWizard();
        retVal = wiz instanceof ImportIMSSourceWizard ? ((ImportIMSSourceWizard)wiz).getProjectName() : ((IMSWorkbenchNewProjectWizard)wiz).getProjectName();
        return retVal;
    }

    private void calculateNumWorkedPerFileOpen() {
        if (this.sourceType == ImportSourceType.ZOS) {
            this.numWorkedPerFileOpen = 1000 / this.zOSFiles.length;
        } else if (this.sourceType == ImportSourceType.LOCAL) {
            this.numWorkedPerFileOpen = 1000 / this.files.length;
        }
    }

    private void calculateNumWorkedPerModelCreated() {
        this.numWorkedPerModelCreated = 7000 / this.sSets.size();
    }

    private void createStatementSets(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.sSets = new ArrayList();
        IMSSourceImporter importer = new IMSSourceImporter();
        if (this.sourceType == ImportSourceType.ZOS) {
            logger.fine("Number of files selected for import: " + this.zOSFiles.length);
            logger.fine("dirPath: " + this.dirPath);
            i = 0;
            while (this.zOSFiles != null && i < this.zOSFiles.length) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                String resourceFilePath = this.dirPath + "." + this.zOSFiles[i].getFileName();
                monitor.setTaskName(WorkbenchPlugin.labels.getString("IMPORT_WIZARD001") + ": " + resourceFilePath);
                try {
                    ArrayList sSetsForCurrFile = importer.createStatementSets(this.zOSFiles[i].getContents(), resourceFilePath);
                    this.sSets.addAll(sSetsForCurrFile);
                    logger.finest("In file: " + resourceFilePath + " there are " + sSetsForCurrFile.size() + " StatementSets.");
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
                catch (ImporterException e) {
                    if (this.importerExceptions == null) {
                        this.importerExceptions = new Vector();
                    }
                    this.importerExceptions.add(e);
                }
                monitor.worked(this.numWorkedPerFileOpen);
                this.currNumWorked += this.numWorkedPerFileOpen;
                ++i;
            }
        } else if (this.sourceType == ImportSourceType.LOCAL) {
            logger.fine("Number of files selected for import: " + this.files.length);
            logger.fine("dirPath: " + this.dirPath);
            i = 0;
            while (this.files != null && i < this.files.length) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                String resourceFilePath = this.dirPath + File.separator + this.files[i];
                monitor.setTaskName(WorkbenchPlugin.labels.getString("IMPORT_WIZARD001") + ": " + resourceFilePath);
                try {
                    ArrayList sSetsForCurrFile = importer.createStatementSets(resourceFilePath);
                    this.sSets.addAll(sSetsForCurrFile);
                    logger.finest("In file: " + resourceFilePath + " there are " + sSetsForCurrFile.size() + " StatementSets.");
                }
                catch (IOException e) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "createStatementSets(IProgressMonitor monitor)", (Throwable)e);
                    if (i == 0) {
                        logger.fine("FileDialag returned a missing file name.");
                        if (this.importerExceptions == null) {
                            this.importerExceptions = new Vector();
                        }
                        Object[] inserts = new Object[]{resourceFilePath};
                        this.importerExceptions.add(new ImporterException(WorkbenchPlugin.errors.getString("IMPORT_WIZ_005", inserts)));
                    } else {
                        logger.fine("FileDialag returned an incomplete file name. The last successfully imported file was: " + this.files[i - 1]);
                        FileNumExceededMsgRunner msgDialogRunner = new FileNumExceededMsgRunner(this.files[i - 1]);
                        this.getShell().getDisplay().asyncExec((Runnable)msgDialogRunner);
                    }
                    break;
                }
                catch (ImporterException e) {
                    if (this.importerExceptions == null) {
                        this.importerExceptions = new Vector();
                    }
                    this.importerExceptions.add(e);
                }
                monitor.worked(this.numWorkedPerFileOpen);
                this.currNumWorked += this.numWorkedPerFileOpen;
                ++i;
            }
        }
        if (this.currNumWorked < 1000) {
            int diff = 1000 - this.currNumWorked;
            monitor.worked(diff);
            this.currNumWorked = 1000;
        }
    }

    private void createModelsAndPopulateDatastructures(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IMSSourceImporter importer = new IMSSourceImporter();
        int psbCounter = 0;
        int dbdCounter = 0;
        int badSSetCounter = 0;
        StatementSet sSet = null;
        int numSSets = this.sSets.size();
        if (this.referenceMap == null) {
            this.referenceMap = new HashMap(numSSets * 2);
        }
        if (this.psbToImportList == null) {
            this.psbToImportList = new HashMap(numSSets);
        }
        if (this.dbdToImportList == null) {
            this.dbdToImportList = new HashMap(numSSets);
        }
        try {
            int i = 0;
            while (i < numSSets) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                sSet = this.sSets.get(i);
                IImsResourceModel resModel = importer.processStatementSet(sSet);
                if (resModel != null) {
                    if (resModel.isPSB()) {
                        PsbModel psbModel = (PsbModel)resModel;
                        String newPsbName = psbModel.getPsbName();
                        monitor.subTask("Finished reading in PSB: " + newPsbName);
                        if (this.psbToImportList.containsKey(newPsbName)) {
                            if (this.importerExceptions == null) {
                                this.importerExceptions = new Vector();
                            }
                            inserts = new Object[]{"PSB", newPsbName};
                            this.importerExceptions.add(new ImporterException(WorkbenchPlugin.errors.getString("IMPORT_WIZ_004", inserts)));
                            this.removePsb(newPsbName);
                        }
                        this.updateReferenceMapForPSB(psbModel);
                        this.psbToImportList.put(newPsbName, new PsbToImport(newPsbName, sSet));
                        ++psbCounter;
                    } else {
                        DbdModel dbdModel = (DbdModel)resModel;
                        String newDbdName = dbdModel.getDBDName();
                        monitor.subTask("Finished reading in DBD: " + newDbdName);
                        if (this.dbdToImportList.containsKey(newDbdName)) {
                            if (this.importerExceptions == null) {
                                this.importerExceptions = new Vector();
                            }
                            inserts = new Object[]{"DBD", newDbdName};
                            this.importerExceptions.add(new ImporterException(WorkbenchPlugin.errors.getString("IMPORT_WIZ_004", inserts)));
                            this.removeDbd(newDbdName);
                        }
                        this.updateReferenceMapForDBD(dbdModel);
                        this.dbdToImportList.put(newDbdName, new DbdToImport(newDbdName, sSet));
                        ++dbdCounter;
                    }
                } else {
                    if (this.importerExceptions == null) {
                        this.importerExceptions = new Vector();
                    }
                    ++badSSetCounter;
                    logger.fine("resModel is null for sSet with type: " + ((Statement)sSet.statements.get((int)0)).type + " in file: " + sSet.filePath);
                    String stmtContents = ((Statement)sSet.statements.get(0)).getStatementContents();
                    Object[] inserts = new Object[]{stmtContents};
                    this.importerExceptions.add(new ImporterException(WorkbenchPlugin.errors.getString("IMPORT_WIZ_006", inserts)));
                }
                monitor.worked(this.numWorkedPerModelCreated);
                this.currNumWorked += this.numWorkedPerModelCreated;
                ++i;
            }
            logger.fine(psbCounter + " PSBs added. " + dbdCounter + " DBDs added.");
            logger.fine("In file: " + sSet.filePath + " there were " + badSSetCounter + " StatementSets that were neither a valid PSB nor DBD.");
            if (this.currNumWorked < 8000) {
                int diff = 8000 - this.currNumWorked;
                monitor.worked(diff);
                this.currNumWorked = 8000;
            }
        }
        catch (ImporterException e) {
            if (this.importerExceptions == null) {
                this.importerExceptions = new Vector();
            }
            this.importerExceptions.add(e);
        }
        catch (ModelException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void createModelsAndDirectlySaveToDisk(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IMSSourceImporter importer = new IMSSourceImporter();
        this.psbCounter = 0;
        this.dbdCounter = 0;
        String projectName = this.getProjectName();
        StatementSet sSet = null;
        int badSSetCounter = 0;
        if (this.psbToImportList == null) {
            this.psbToImportList = new HashMap(500);
        }
        if (this.dbdToImportList == null) {
            this.dbdToImportList = new HashMap(500);
        }
        try {
            int i = 0;
            while (i < this.sSets.size()) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                sSet = this.sSets.get(i);
                IImsResourceModel resModel = importer.processStatementSet(sSet);
                if (resModel != null) {
                    if (resModel.isPSB()) {
                        PsbModel psbModel = (PsbModel)resModel;
                        String psbName = psbModel.getPsbName();
                        if (this.psbToImportList.containsKey(psbName)) {
                            if (this.importerExceptions == null) {
                                this.importerExceptions = new Vector();
                            }
                            inserts = new Object[]{"PSB", psbName};
                            this.importerExceptions.add(new ImporterException(WorkbenchPlugin.errors.getString("IMPORT_WIZ_004", inserts)));
                        } else {
                            this.psbToImportList.put(psbName, null);
                        }
                        PsbToImport psbToImport = new PsbToImport(psbModel, sSet);
                        this.marshallSinglePsb(projectName, psbToImport, monitor);
                        ++this.psbCounter;
                    } else {
                        DbdModel dbdModel = (DbdModel)resModel;
                        String dbdName = dbdModel.getDBDName();
                        if (this.dbdToImportList.containsKey(dbdName)) {
                            if (this.importerExceptions == null) {
                                this.importerExceptions = new Vector();
                            }
                            inserts = new Object[]{"DBD", dbdName};
                            this.importerExceptions.add(new ImporterException(WorkbenchPlugin.errors.getString("IMPORT_WIZ_004", inserts)));
                        } else {
                            this.dbdToImportList.put(dbdName, null);
                        }
                        DbdToImport dbdToImport = new DbdToImport(dbdModel, sSet);
                        this.marshallSingleDBD(projectName, dbdToImport, monitor);
                        ++this.dbdCounter;
                    }
                } else {
                    ++badSSetCounter;
                    logger.fine("resModel is null for sSet with type: " + ((Statement)sSet.statements.get((int)0)).type + " in file: " + sSet.filePath);
                }
                monitor.worked(this.numWorkedPerModelCreated);
                this.currNumWorked += this.numWorkedPerModelCreated;
                ++i;
            }
            if (this.currNumWorked < 8000) {
                int diff = 8000 - this.currNumWorked;
                monitor.worked(diff);
                this.currNumWorked = 8000;
            }
            logger.fine(this.psbCounter + " PSBs added. " + this.dbdCounter + " DBDs added.");
            logger.fine("In file: " + sSet.filePath + " there were " + badSSetCounter + " StatementSets that were neither a valid PSB nor DBD.");
        }
        catch (ImporterException e) {
            if (this.importerExceptions == null) {
                this.importerExceptions = new Vector();
            }
            this.importerExceptions.add(e);
        }
        catch (ModelException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void resetPsbAndDbdLists() {
        this.psbTab.removeAll();
        this.psbToImportList = null;
        this.updateRemoveButtonState(this.psbTab);
        this.dbdTab.removeAll();
        this.dbdToImportList = null;
        this.updateRemoveButtonState(this.dbdTab);
        this.needDBDTab.removeAll();
        this.needDBDTab.setVisible(false);
        this.needImportlbl.setVisible(false);
        this.needImportlbl2.setVisible(false);
        this.warningImgLbl.setVisible(false);
        this.psbCounter = 0;
        this.dbdCounter = 0;
        this.zOSFiles = null;
        this.referenceMap = null;
        this.fileHashTable = new Hashtable();
        this.importerExceptions = null;
    }

    private void recursiveSearchForReferencedDbds(File topDirPath, IMSSourceImporter importer, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Vector<ReferencedDbd> dbdsNeedingSearch = this.getDbdsNeedingSearch();
        if (dbdsNeedingSearch.size() == 0) {
            return;
        }
        int i = 0;
        while (i < dbdsNeedingSearch.size()) {
            ReferencedDbd refDbd = dbdsNeedingSearch.get(i);
            refDbd.setSearchAlreadyDone(true);
            String currDbdName = refDbd.getDbdName();
            boolean dbdInImportList = this.dbdToImportList.containsKey(currDbdName);
            boolean dbdInProjectTree = this.findDBDInProjectTree(currDbdName);
            if (!dbdInImportList && !dbdInProjectTree && this.sourceType == ImportSourceType.LOCAL) {
                try {
                    monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD002") + ": " + currDbdName);
                    this.recursiveDBDFileSearch(currDbdName, topDirPath, importer, monitor);
                    monitor.subTask("");
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
                catch (ImporterException e) {
                    if (this.importerExceptions == null) {
                        this.importerExceptions = new Vector();
                    }
                    this.importerExceptions.add(e);
                }
                catch (ModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
            ++i;
        }
        monitor.worked(this.numWorkedPerSearchIter);
        this.recursiveSearchForReferencedDbds(topDirPath, importer, monitor);
    }

    private Vector<ReferencedDbd> getDbdsNeedingSearch() {
        Vector<ReferencedDbd> retVal = new Vector<ReferencedDbd>();
        for (ReferencedDbd refDbd : this.referenceMap.values()) {
            if (refDbd.isSearchAlreadyDone()) continue;
            retVal.add(refDbd);
        }
        return retVal;
    }

    private void createProjectIfNotThereYet() throws IOException {
        IWizard wiz = this.getWizard();
        if (wiz instanceof IMSWorkbenchNewProjectWizard) {
            String projectName = this.getProjectName();
            try {
                ((IMSWorkbenchNewProjectWizard)wiz).createNewProject(projectName);
            }
            catch (CoreException e1) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "run(IProgressMonitor monitor)", (Throwable)e1);
                logger.error((Throwable)e1);
            }
        }
    }

    private boolean isLargeImport() {
        int totalSSetsBeingAdded = this.sSets.size();
        logger.fine("Total number of StatementSets being added: " + totalSSetsBeingAdded + ". The threshold is: 500");
        return totalSSetsBeingAdded > 500;
    }

    private void doEndProcessing(long startTime) {
        long endTime = System.currentTimeMillis();
        long elapsedTime = (endTime - startTime) / 1000L;
        long mins = elapsedTime / 60L;
        long seconds = elapsedTime % 60L;
        logger.fine("Add process took: " + mins + " mins and " + seconds + " seconds.");
    }

    private boolean isPsbInList(List<PsbModel> listPsb, String psbName) {
        boolean retVal = false;
        int i = 0;
        while (i < listPsb.size()) {
            PsbModel psb = listPsb.get(i);
            if (psb.getPsbName().equalsIgnoreCase(psbName)) {
                retVal = true;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private ImportSourceType getImportSourceType() {
        ImportSourceType retVal = null;
        if (this.getWizard() instanceof ImportIMSSourceWizard) {
            ImportIMSSourceWizard wiz = (ImportIMSSourceWizard)this.getWizard();
            retVal = wiz.importIMSSourcePage.getImportSourceType();
        } else {
            IMSWorkbenchNewProjectWizard wiz = (IMSWorkbenchNewProjectWizard)this.getWizard();
            retVal = wiz.getImportIMSSourceWizardPage().getImportSourceType();
        }
        return retVal;
    }

    protected ImportSourceType getCurrentImportSourceType() {
        return this.type;
    }

    private void marshallGeneratedDbviews(String projectName, List<PsbModel> listPsb, IProgressMonitor monitor) throws InvocationTargetException {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("explorer_enable_ims_jdbc")) {
            DatabaseViewGeneratorExceptionHelper helper = new DatabaseViewGeneratorExceptionHelper();
            int i = 0;
            while (i < listPsb.size()) {
                try {
                    PsbModel currPsb = listPsb.get(i);
                    monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD003") + ": " + currPsb.getPsbName());
                    helper.addExceptions(ProjectTreeFileHelper.marshallGeneratedDbView((String)projectName, (PsbModel)currPsb));
                    monitor.worked(1);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                ++i;
            }
            boolean skipWarnings = store.getBoolean("explorer_wizard_skip_warning_flag");
            String message = helper.getExceptionMessage(skipWarnings);
            if (message != null) {
                try {
                    if (!store.getBoolean("explorer_wizard_skip_warning_flag")) {
                        Warnings warnings = new Warnings(this.getShell(), WorkbenchPlugin.errors.getString("EISRC27"), null, WorkbenchPlugin.errors.getString("EISRC28"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                        warnings.setWarnings(message);
                        MessageDialogRunner runner = new MessageDialogRunner(warnings);
                        this.getShell().getDisplay().asyncExec((Runnable)runner);
                    }
                }
                catch (Throwable e) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "run()", e);
                    logger.error(e);
                }
            }
        }
    }

    class FileNumExceededMsgRunner
    implements Runnable {
        private String lastGoodFileName;

        public FileNumExceededMsgRunner(String lastGoodFileName) {
            this.lastGoodFileName = lastGoodFileName;
        }

        @Override
        public void run() {
            Object[] inserts = new Object[]{this.lastGoodFileName};
            try {
                MessageDialog infoDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.errors.getString("EISRC27"), null, WorkbenchPlugin.errors.getString("IMPORT_WIZ_002", inserts), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                infoDialog.open();
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "run()", e);
                logger.error(e);
            }
        }
    }

    class ImportSource
    implements IRunnableWithProgress {
        ImportSource() {
        }

        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
            long startTime = System.currentTimeMillis();
            int totalMonitorUnits = 9000;
            if (ImportIMSSourceWizardPage2.this.sourceType == ImportSourceType.LOCAL) {
                totalMonitorUnits += 1000;
            }
            monitor.beginTask("Opening Files...", totalMonitorUnits);
            ImportIMSSourceWizardPage2.this.currNumWorked = 0;
            ImportIMSSourceWizardPage2.this.calculateNumWorkedPerFileOpen();
            ImportIMSSourceWizardPage2.this.createStatementSets(monitor);
            if (ImportIMSSourceWizardPage2.this.sSets.size() == 0) {
                if (ImportIMSSourceWizardPage2.this.importerExceptions == null) {
                    ImportIMSSourceWizardPage2.this.importerExceptions = new Vector();
                }
                ImportIMSSourceWizardPage2.this.importerExceptions.add(new ImporterException(WorkbenchPlugin.errors.getString("IMPORT_WIZ_003")));
                return;
            }
            monitor.setTaskName("Reading in model information...");
            ImportIMSSourceWizardPage2.this.calculateNumWorkedPerModelCreated();
            if (ImportIMSSourceWizardPage2.this.isLargeImport()) {
                try {
                    ImportIMSSourceWizardPage2.this.createProjectIfNotThereYet();
                }
                catch (IOException e1) {
                    logger.throwing(this.getClass().getName(), "run()", (Throwable)e1);
                    logger.error((Throwable)e1);
                }
                ImportIMSSourceWizardPage2.this.createModelsAndDirectlySaveToDisk(monitor);
                ImportIMSSourceWizardPage2.this.doEndProcessing(startTime);
                Object[] inserts = new Object[]{ImportIMSSourceWizardPage2.this.psbCounter, ImportIMSSourceWizardPage2.this.dbdCounter, ImportIMSSourceWizardPage2.this.getProjectName()};
                try {
                    MessageDialog infoDialog = new MessageDialog(ImportIMSSourceWizardPage2.this.getShell(), WorkbenchPlugin.errors.getString("EISRC25"), null, WorkbenchPlugin.errors.getString("IMPORT_WIZ_001", inserts), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    MessageDialogRunner runner = new MessageDialogRunner(infoDialog);
                    ImportIMSSourceWizardPage2.this.getShell().getDisplay().asyncExec((Runnable)runner);
                }
                catch (Throwable e2) {
                    logger.throwing(this.getClass().getName(), "run()", e2);
                    logger.error(e2);
                }
                return;
            }
            ImportIMSSourceWizardPage2.this.createModelsAndPopulateDatastructures(monitor);
            if (ImportIMSSourceWizardPage2.this.sourceType == ImportSourceType.LOCAL) {
                monitor.setTaskName("Searching for referenced DBDs...");
                File root = new File(ImportIMSSourceWizardPage2.this.dirPath);
                if (root == null || !root.isDirectory()) {
                    ImportIMSSourceWizardPage2.this.setErrorMessage(String.valueOf(root) + " " + WorkbenchPlugin.errors.getString("EISRC3"));
                } else {
                    String[] fileNames = root.list();
                    int numFilesInDir = fileNames.length;
                    logger.fine("Number of files in current directory: " + numFilesInDir + ". The threshold is: 100");
                    if (numFilesInDir < 100) {
                        IMSSourceImporter importer = new IMSSourceImporter();
                        ImportIMSSourceWizardPage2.this.recursiveSearchForReferencedDbds(root, importer, monitor);
                    }
                }
            }
            ImportIMSSourceWizardPage2.this.doEndProcessing(startTime);
        }
    }

    protected class ListViewerProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        protected ListViewerProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object o, int columnIndex) {
            return null;
        }

        public Object[] getElements(Object o) {
            if (o instanceof Collection) {
                return ((Collection)o).toArray();
            }
            return new Object[0];
        }
    }

    class MarshallCatalogResources
    implements IRunnableWithProgress {
        MarshallCatalogResources() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                byte[] xml;
                IImsDbConnection imsConn;
                Iterator<Object> iter;
                ArrayList<PsbModel> listPsb = new ArrayList<PsbModel>();
                ArrayList<String> listImportedDbdNames = new ArrayList<String>();
                ArrayList<String> listImportedPsbNames = new ArrayList<String>();
                String projectName = ImportIMSSourceWizardPage2.this.getProjectName();
                int numResources = 0;
                if (ImportIMSSourceWizardPage2.this.psbToImportList != null && ImportIMSSourceWizardPage2.this.psbToImportList.size() > 0) {
                    numResources = ImportIMSSourceWizardPage2.this.psbToImportList.size() * 2;
                }
                if (ImportIMSSourceWizardPage2.this.dbdToImportList != null && ImportIMSSourceWizardPage2.this.dbdToImportList.size() > 0) {
                    numResources += ImportIMSSourceWizardPage2.this.dbdToImportList.size();
                }
                monitor.beginTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD007"), numResources);
                if (ImportIMSSourceWizardPage2.this.dbdToImportList != null && !ImportIMSSourceWizardPage2.this.dbdToImportList.isEmpty()) {
                    iter = ImportIMSSourceWizardPage2.this.dbdToImportList.values().iterator();
                    imsConn = ImsDbUtils.getConnectionById((String)ImportIMSSourceWizardPage2.this.connProfileNameUsed, (boolean)true);
                    while (iter.hasNext()) {
                        String currEncoding;
                        DbdModel dbdModel;
                        String currXMLSchemaVersion;
                        DbdToImport dbdToImport = (DbdToImport)iter.next();
                        if (dbdToImport == null) continue;
                        String dbdName = dbdToImport.getDbdName();
                        xml = imsConn.getDbdXml(dbdName);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("XML string for DBD=" + dbdName + " from GUR: " + new String(xml, "Cp1047"));
                        }
                        if ((currXMLSchemaVersion = (dbdModel = new DbdModel((InputStream)new ByteArrayInputStream(xml))).getXMLSchemaVersion()) == null || currXMLSchemaVersion.isEmpty()) {
                            dbdModel.setXMLSchemaVersion("1");
                        }
                        if ((currEncoding = dbdModel.getEncoding()) == null || currEncoding.isEmpty()) {
                            String defaultEncoding = WorkbenchPlugin.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection");
                            dbdModel.setEncoding(defaultEncoding);
                        }
                        dbdToImport.setDbdModel(dbdModel);
                        dbdToImport.setImporter(new IMSSourceImporter());
                        listImportedDbdNames.add(dbdModel.getDBDName());
                        ImportIMSSourceWizardPage2.this.marshallSingleDBD(projectName, dbdToImport, monitor);
                        monitor.worked(1);
                    }
                }
                if (ImportIMSSourceWizardPage2.this.psbToImportList != null && !ImportIMSSourceWizardPage2.this.psbToImportList.isEmpty()) {
                    iter = ImportIMSSourceWizardPage2.this.psbToImportList.values().iterator();
                    imsConn = ImsDbUtils.getConnectionById((String)ImportIMSSourceWizardPage2.this.connProfileNameUsed, (boolean)true);
                    while (iter.hasNext()) {
                        PsbToImport psbToImport = (PsbToImport)iter.next();
                        if (psbToImport == null) continue;
                        String psbName = psbToImport.getName();
                        xml = imsConn.getPsbXml(psbName);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("XML string for PSB=" + psbName + " from GUR: " + new String(xml, "Cp1047"));
                        }
                        PsbModel psbModel = new PsbModel((InputStream)new ByteArrayInputStream(xml));
                        psbToImport.setPsbModel(psbModel);
                        listImportedPsbNames.add(psbModel.getPsbName());
                        ImportIMSSourceWizardPage2.this.marshallSinglePsb(projectName, psbToImport, monitor);
                        monitor.worked(1);
                    }
                }
                if (listImportedDbdNames != null && listImportedDbdNames.size() > 0) {
                    try {
                        listPsb.addAll(ProjectTreeFileHelper.findRelatedPSBs((String)projectName, listImportedDbdNames));
                    }
                    catch (FileNotFoundException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (ModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                if (listImportedPsbNames != null) {
                    int i = 0;
                    while (i < listImportedPsbNames.size()) {
                        String psbName = (String)listImportedPsbNames.get(i);
                        if (!ImportIMSSourceWizardPage2.this.isPsbInList(listPsb, psbName)) {
                            try {
                                IFile psbFile = ProjectTreeFileHelper.getPsbMetadataFile((String)projectName, (String)psbName);
                                if (psbFile.exists()) {
                                    PsbModel psb = new PsbModel(psbFile.getContents());
                                    listPsb.add(psb);
                                }
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (ModelException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        ++i;
                    }
                }
                ImportIMSSourceWizardPage2.this.marshallGeneratedDbviews(projectName, listPsb, monitor);
                monitor.done();
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "run()", e);
                logger.error(e);
            }
        }
    }

    class MarshallResources
    implements IRunnableWithProgress {
        MarshallResources() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            long startTime = System.currentTimeMillis();
            StringBuffer buf = new StringBuffer();
            String projectName = ImportIMSSourceWizardPage2.this.getProjectName();
            ArrayList<PsbModel> listPsb = new ArrayList<PsbModel>();
            List<String> listImportedDbdNames = null;
            List<String> listImportedPsbNames = null;
            int numResources = ImportIMSSourceWizardPage2.this.psbToImportList.size() * 2;
            monitor.beginTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD007"), numResources += ImportIMSSourceWizardPage2.this.dbdToImportList.size());
            try {
                if (!ImportIMSSourceWizardPage2.this.psbToImportList.isEmpty()) {
                    listImportedPsbNames = ImportIMSSourceWizardPage2.this.marshallAllPsbs(projectName, monitor);
                }
                if (!ImportIMSSourceWizardPage2.this.dbdToImportList.isEmpty()) {
                    listImportedDbdNames = ImportIMSSourceWizardPage2.this.marshallAllDbds(projectName, monitor);
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            if (ImportIMSSourceWizardPage2.this.importerExceptions != null && ImportIMSSourceWizardPage2.this.importerExceptions.size() > 0) {
                int i = 0;
                while (i < ImportIMSSourceWizardPage2.this.importerExceptions.size()) {
                    buf.append(ImportIMSSourceWizardPage2.this.importerExceptions.get(i).getMessage());
                    buf.append("\n\n");
                    ++i;
                }
                try {
                    IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                    if (!store.getBoolean("explorer_wizard_skip_warning_flag")) {
                        Warnings warnings = new Warnings(ImportIMSSourceWizardPage2.this.getShell(), WorkbenchPlugin.errors.getString("EISRC27"), null, WorkbenchPlugin.errors.getString("DHB1753"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                        warnings.setWarnings(buf.toString());
                        MessageDialogRunner runner = new MessageDialogRunner(warnings);
                        ImportIMSSourceWizardPage2.this.getShell().getDisplay().asyncExec((Runnable)runner);
                    }
                }
                catch (Throwable e) {
                    logger.throwing(this.getClass().getName(), "run()", e);
                    logger.error(e);
                }
            }
            if (listImportedDbdNames != null && listImportedDbdNames.size() > 0) {
                try {
                    monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD010"));
                    listPsb.addAll(ProjectTreeFileHelper.findRelatedPSBs((String)projectName, listImportedDbdNames));
                }
                catch (FileNotFoundException e) {
                    throw new InvocationTargetException(e);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (ModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
            if (listImportedPsbNames != null) {
                boolean createReplacement = false;
                int i = 0;
                while (i < listImportedPsbNames.size()) {
                    Runnable runner;
                    String psbName = listImportedPsbNames.get(i);
                    if (!createReplacement) {
                        String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
                        String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
                        if (!JavaConventions.validateIdentifier((String)psbName, (String)sourceLevel, (String)complianceLevel).isOK()) {
                            MessageDialog messageDialog = new MessageDialog(ImportIMSSourceWizardPage2.this.getShell(), WorkbenchPlugin.labels.getString("MANAGE_TEMPLATE_7"), null, WorkbenchPlugin.errors.getString("IMPORT_WIZ_011"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                            runner = new MessageDialogRunner(messageDialog);
                            ImportIMSSourceWizardPage2.this.getShell().getDisplay().syncExec(runner);
                            boolean bl = createReplacement = messageDialog.getReturnCode() == 0;
                        }
                    }
                    if (createReplacement) {
                        try {
                            ManageTemplateController controller = new ManageTemplateController(projectName);
                            ManageTemplateWizard wizard = new ManageTemplateWizard(controller);
                            WizardDialog dialog = new WizardDialog(ImportIMSSourceWizardPage2.this.getShell(), (IWizard)wizard);
                            runner = new WizardDialogRunner(dialog);
                            ImportIMSSourceWizardPage2.this.getShell().getDisplay().syncExec(runner);
                            if (dialog.getReturnCode() == 1) {
                                createReplacement = false;
                            }
                        }
                        catch (ModelException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    if (!ImportIMSSourceWizardPage2.this.isPsbInList(listPsb, psbName)) {
                        try {
                            IFile psbFile = ProjectTreeFileHelper.getPsbMetadataFile((String)projectName, (String)psbName);
                            if (psbFile.exists()) {
                                PsbModel psb = new PsbModel(psbFile.getContents());
                                listPsb.add(psb);
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (ModelException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    ++i;
                }
            }
            ImportIMSSourceWizardPage2.this.marshallGeneratedDbviews(projectName, listPsb, monitor);
            monitor.done();
            long endTime = System.currentTimeMillis();
            long elapsedTime = (endTime - startTime) / 1000L;
            long mins = elapsedTime / 60L;
            long seconds = elapsedTime % 60L;
            logger.fine("Marshalling process took: " + mins + " mins and " + seconds + " seconds.");
        }
    }
}

