/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.importWizards;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.importWizards.ImportIMSSourceWizardPage;
import com.ibm.im.ims.workbench.importWizards.ImportIMSSourceWizardPage2;
import com.ibm.im.ims.workbench.project.wizard.IMSWorkbenchNewProjectWizardPage;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ImportIMSSourceWizard
extends Wizard
implements INewWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IMSWorkbenchNewProjectWizardPage wbNewProjectPage;
    ImportIMSSourceWizardPage importIMSSourcePage;
    private ImportIMSSourceWizardPage2 importIMSSourcePage2;
    private IStructuredSelection selection;
    private static final String PLUGIN_ID = "com.ibm.im.ims.workbench";
    private String projectName = null;

    public ImportIMSSourceWizard() {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB001"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        try {
            this.wbNewProjectPage = new IMSWorkbenchNewProjectWizardPage("Page0", this.selection);
            this.importIMSSourcePage = new ImportIMSSourceWizardPage("Page1");
            this.importIMSSourcePage2 = new ImportIMSSourceWizardPage2("Page2");
            this.addPage((IWizardPage)this.wbNewProjectPage);
            this.addPage((IWizardPage)this.importIMSSourcePage);
            this.addPage((IWizardPage)this.importIMSSourcePage2);
            this.wbNewProjectPage.setUsage(0);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public boolean canFinish() {
        boolean retVal = false;
        try {
            if (this.importIMSSourcePage2.isPageComplete()) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
        return retVal;
    }

    public boolean performFinish() {
        try {
            String containerName = this.wbNewProjectPage.getProjectName();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember((IPath)new Path(containerName));
            if (!resource.exists() || !(resource instanceof IContainer)) {
                Object[] inserts = new Object[]{containerName};
                String msg = WorkbenchPlugin.errors.getString("IOGWB0301", inserts);
                this.throwCoreException(msg);
            }
            this.importIMSSourcePage2.marshallResources();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        return true;
    }

    public String getProjectName() {
        if (this.projectName == null) {
            this.projectName = this.wbNewProjectPage.getProjectName();
        }
        return this.projectName;
    }

    public boolean performCancel() {
        return true;
    }

    public void init(IWorkbench wb, IStructuredSelection selection) {
        this.selection = selection;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, PLUGIN_ID, 0, message, null);
        throw new CoreException((IStatus)status);
    }
}

