/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.importWizards;

import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionWidgetManager;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.internal.ConnectionStatus;
import com.ibm.cics.eclipse.common.ui.EnsureUppercaseListener;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.eclipse.common.ui.fieldassist.HistoryDropDown;
import com.ibm.cics.zos.comm.IZOSConstants;
import com.ibm.cics.zos.model.DataEntry;
import com.ibm.cics.zos.model.IZOSConnectable;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.SequentialDataSet;
import com.ibm.cics.zos.ui.ZOSCoreUIMessages;
import com.ibm.cics.zos.ui.ZOSUIUtilities;
import com.ibm.cics.zos.ui.views.DataEntryLabelDecorator;
import com.ibm.cics.zos.ui.views.DataEntryLabelProvider;
import com.ibm.cics.zos.ui.views.DataSetRequestFilter;
import com.ibm.cics.zos.ui.views.TreeAsynchronousMediator;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.utilities.Utility;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class ImportDataSetWizardPage
extends WizardPage
implements IZOSConstants {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IZOSConnectable zOSConnectable;
    private Text filterText;
    private Label searchLabel;
    private Tree tree;
    private DataEntryLabelProvider dataSetLabelProvider;
    private TreeAsynchronousMediator treeMediator;
    DataEntry[] selectedDataSetsItems;
    private ConnectionServiceListener connectionServiceListener;
    private Composite composite;

    public ImportDataSetWizardPage() {
        super("Import from data set wizard");
        this.setTitle(WorkbenchPlugin.labels.getString("WB606"));
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB60A"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("import_zos")));
        this.zOSConnectable = (IZOSConnectable)ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.zos.comm.connection");
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.setControl((Control)this.composite);
        GridLayout gridLayout = new GridLayout(3, false);
        this.composite.setLayout((Layout)gridLayout);
        this.createConnectableArea(this.composite);
        this.createDataSetsArea(this.composite);
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.getConnectionServiceListener());
    }

    public boolean isPageComplete() {
        return this.selectedDataSetsItems != null && this.selectedDataSetsItems[0] != null;
    }

    private void createDataSetsArea(Composite c) {
        Label l = new Label(c, 0);
        l.setText(WorkbenchPlugin.labels.getString("WB608"));
        GridData data = new GridData(0, 0x1000000, false, false);
        data.horizontalIndent = 5;
        l.setLayoutData((Object)data);
        this.filterText = new Text(c, 2048);
        EnsureUppercaseListener.attach((Text)this.filterText);
        data = new GridData(4, 0x1000000, true, false);
        this.filterText.setLayoutData((Object)data);
        this.filterText.setEnabled(false);
        this.filterText.setData("ERROR_NAME", (Object)ZOSCoreUIMessages.DataSetsExplorer_dataSetQualifier);
        this.filterText.setToolTipText(ZOSCoreUIMessages.DataSetsExplorer_specifyAFilter);
        final HistoryDropDown historyDropDown = HistoryDropDown.attachContentAssist((Text)this.filterText, (String)"com.ibm.cics.eclipse.common.datasethistory");
        this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportDataSetWizardPage.this.validateSearchText();
                historyDropDown.addValue(ImportDataSetWizardPage.this.filterText.getText());
                ImportDataSetWizardPage.this.refresh();
            }
        });
        this.searchLabel = new Label(c, 0);
        data = new GridData(0x1000008, 0x1000000, false, false);
        data.horizontalIndent = HistoryDropDown.getIndentSpace();
        this.searchLabel.setLayoutData((Object)data);
        this.tree = new Tree(c, 268437506);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 3;
        this.tree.setLayoutData((Object)gd);
        this.tree.setEnabled(false);
        this.dataSetLabelProvider = new DataEntryLabelProvider();
        this.treeMediator = new TreeAsynchronousMediator(this.tree, null, (ILabelProvider)this.dataSetLabelProvider){

            protected void updateItemCount() {
                ImportDataSetWizardPage.this.updateItemCount();
                super.updateItemCount();
            }
        };
        this.treeMediator.setLabelDecorator((ILabelDecorator)new DataEntryLabelDecorator());
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataEntry[] selectedTreeItems = new DataEntry[ImportDataSetWizardPage.this.tree.getSelectionCount()];
                int i = 0;
                TreeItem[] treeItemArray = ImportDataSetWizardPage.this.tree.getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem selectedTreeItem = treeItemArray[n2];
                    if (selectedTreeItem.getData() instanceof Member || selectedTreeItem.getData() instanceof SequentialDataSet) {
                        selectedTreeItems[i] = (DataEntry)selectedTreeItem.getData();
                        ++i;
                    }
                    ++n2;
                }
                ImportDataSetWizardPage.this.setSelectedItems(selectedTreeItems);
            }
        });
    }

    private void setSelectedItems(DataEntry ... selectedTreeItems) {
        this.selectedDataSetsItems = selectedTreeItems;
        this.getContainer().updateButtons();
    }

    private void updateItemCount() {
        int itemCount = this.tree.getItemCount();
        if (this.tree.getItemCount() == 1 && this.tree.getItem(0).getData() instanceof PendingUpdateAdapter) {
            itemCount = 0;
        }
        if (itemCount == 0) {
            this.clearSearchCount();
        } else {
            this.setSearchCount(itemCount);
        }
    }

    private void clearSearchCount() {
        this.searchLabel.setVisible(true);
        this.setSearchCount(0);
    }

    private void setSearchCount(int searchCount) {
        this.searchLabel.setVisible(true);
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(String.valueOf(searchCount));
        sb.append(")");
        this.searchLabel.setText(sb.toString());
        this.searchLabel.getParent().layout();
    }

    private void refresh() {
        this.searchLabel.setVisible(false);
        this.treeMediator.setRoot((Object)this.getRoot());
    }

    private DataSetRequestFilter getRoot() {
        if (this.zOSConnectable != null) {
            return new DataSetRequestFilter(this.filterText.getText(), this.zOSConnectable);
        }
        return null;
    }

    private void validateSearchText() {
        String textValue = this.filterText.getText();
        if (Utilities.hasContent((String)this.filterText.getText())) {
            textValue = ZOSUIUtilities.removeInvalidDataSetFilterCharacters((String)this.filterText.getText());
        }
        if (!Utilities.hasContent((String)textValue) && this.zOSConnectable.isConnected()) {
            textValue = this.zOSConnectable.getConnection().getConfiguration().getUserID();
        }
        this.filterText.setText(textValue);
    }

    private void createConnectableArea(Composite c) {
        Label l = new Label(c, 0);
        l.setText(WorkbenchPlugin.labels.getString("WB609"));
        ConnectionWidgetManager connectionWidgetManager = new ConnectionWidgetManager(ConnectionsPlugin.getDefault().getConnectionService());
        ConnectionStatus connectionStatus = new ConnectionStatus(c, 0, connectionWidgetManager.getConnectionStatusController());
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        connectionStatus.setLayoutData((Object)data);
        connectionWidgetManager.setCurrentCategory("com.ibm.cics.zos.comm.connection");
    }

    private void setConnectable(IZOSConnectable aZOSConnectable) {
        this.zOSConnectable = aZOSConnectable;
        this.selectedDataSetsItems = null;
        if (this.filterText == null) {
            return;
        }
        if (this.zOSConnectable == null) {
            this.treeMediator.setRoot(null);
            this.filterText.setEnabled(false);
            this.tree.setEnabled(false);
            this.searchLabel.setVisible(false);
        } else {
            aZOSConnectable.getConnection();
            this.filterText.setEnabled(true);
            this.tree.setEnabled(true);
            if (!Utilities.hasContent((String)this.filterText.getText())) {
                this.filterText.setText(aZOSConnectable.getConnection().getConfiguration().getUserID());
            }
            this.refresh();
        }
        this.getWizard().getContainer().updateButtons();
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        if (this.connectionServiceListener == null) {
            this.connectionServiceListener = new ConnectionServiceListener(){

                public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
                    if (event.getConnectionCategoryId().equals("com.ibm.cics.zos.comm.connection")) {
                        ImportDataSetWizardPage.this.composite.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                                    ImportDataSetWizardPage.this.setConnectable(null);
                                    ImportDataSetWizardPage.this.setErrorMessage(((ConnectionServiceListener.ExceptionEvent)event).getException().getMessage());
                                } else if (!(event instanceof ConnectionServiceListener.ConnectingEvent)) {
                                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                                        ImportDataSetWizardPage.this.setConnectable((IZOSConnectable)event.getConnectable());
                                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                                        ImportDataSetWizardPage.this.setConnectable(null);
                                    }
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.connectionServiceListener;
    }
}

