/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.importWizards;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.zos.model.DataEntry;
import com.ibm.cics.zos.model.PermissionDeniedException;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.importWizards.DataEntryWithData;
import com.ibm.im.ims.workbench.importWizards.ImportDataSetWizardPage;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.FileNotFoundException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class ImportDataSetWizard
extends Wizard
implements IWorkbenchWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NUM_WORKED_SEARCH_REF_PER_FILE = 100;
    public static final int NUM_WORKED_PARSE_PER_FILE = 100;
    private ImportDataSetWizardPage importDataSetWizardPage = new ImportDataSetWizardPage();
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    ImportDataSetRunnable importer = null;
    boolean interrupted = false;

    public ImportDataSetWizard() {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB001"));
    }

    public void addPages() {
        this.addPage((IWizardPage)this.importDataSetWizardPage);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        boolean success = true;
        try {
            this.importer = new ImportDataSetRunnable(this.importDataSetWizardPage.selectedDataSetsItems);
            this.interrupted = false;
            Shell activeShell = this.getContainer().getShell();
            this.interrupted = false;
            new ProgressMonitorDialog(activeShell).run(true, true, (IRunnableWithProgress)this.importer);
            if (this.interrupted) {
                success = false;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        return success;
    }

    public DataEntryWithData[] getDataEntries() {
        if (this.importer == null) {
            return null;
        }
        return this.importer.getDataEntries();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    class ImportDataSetRunnable
    implements IRunnableWithProgress {
        DataEntryWithData[] dataEntries;

        public ImportDataSetRunnable(DataEntry[] someDataEntries) {
            int i = 0;
            this.dataEntries = new DataEntryWithData[someDataEntries.length];
            DataEntry[] dataEntryArray = someDataEntries;
            int n = someDataEntries.length;
            int n2 = 0;
            while (n2 < n) {
                DataEntry dataEntry = dataEntryArray[n2];
                this.dataEntries[i] = new DataEntryWithData(dataEntry);
                ++i;
                ++n2;
            }
        }

        public DataEntryWithData[] getDataEntries() {
            return this.dataEntries;
        }

        public void run(IProgressMonitor monitor) {
            try {
                this.runFunc(monitor);
            }
            catch (InterruptedException interruptedException) {
                ImportDataSetWizard.this.interrupted = true;
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "run(IProgressMonitor monitor)", e);
                logger.error(e);
            }
        }

        public void runFunc(IProgressMonitor monitor) throws ImporterException, InterruptedException, ConnectionException {
            String name = null;
            String path = null;
            try {
                monitor.beginTask(WorkbenchPlugin.labels.getString("WB822") + WorkbenchPlugin.colon.getString("COLON") + this.dataEntries[0].getFileName(), this.dataEntries.length * 200);
                DataEntryWithData[] dataEntryWithDataArray = this.dataEntries;
                int n = this.dataEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    DataEntryWithData dataEntry = dataEntryWithDataArray[n2];
                    name = dataEntry.getFileName();
                    path = dataEntry.getParentPath();
                    dataEntry.retrieveData();
                    monitor.setTaskName(WorkbenchPlugin.labels.getString("WB822") + WorkbenchPlugin.colon.getString("COLON") + name);
                    if (monitor.isCanceled()) {
                        this.dataEntries = null;
                        throw new InterruptedException();
                    }
                    monitor.worked(100);
                    ++n2;
                }
            }
            catch (FileNotFoundException e) {
                Object[] error = new String[]{name, path};
                ImporterException db = new ImporterException(WorkbenchPlugin.errors.getString("DHB1754", error));
                db.initCause((Throwable)e);
                logger.throwing(this.getClass().getName(), "run(IProgressMonitor monitor) ", (Throwable)db);
            }
            catch (PermissionDeniedException e) {
                Object[] error = new String[]{name, path};
                ImporterException db = new ImporterException(WorkbenchPlugin.errors.getString("DHB1756", error));
                db.initCause((Throwable)e);
                logger.throwing(this.getClass().getName(), "run(IProgressMonitor monitor) ", (Throwable)db);
            }
            monitor.done();
        }
    }
}

