/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.importWizards;

import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.IMSSourceImporter;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.StatementSet;
import java.io.ByteArrayOutputStream;

public class DbdToImport {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String dbdName;
    private StatementSet sSet;
    private DbdModel dbdModel = null;
    private IMSSourceImporter importer = null;

    public DbdToImport(String dbdName, StatementSet sSet) throws ModelException {
        this.dbdName = dbdName;
        this.sSet = sSet;
    }

    public DbdToImport(DbdModel dbdModel, StatementSet sSet) throws ModelException {
        this.dbdModel = dbdModel;
        this.sSet = sSet;
    }

    public String getDbdName() {
        if (this.dbdModel == null) {
            return this.dbdName;
        }
        return this.dbdModel.getDBDName();
    }

    public String getPath() {
        if (this.sSet == null) {
            return null;
        }
        return this.sSet.filePath;
    }

    public String toString() {
        return this.dbdName;
    }

    public DbdModel getDbdModel() throws ImporterException, ModelException {
        DbdModel retVal = null;
        if (this.dbdModel == null) {
            this.importer = new IMSSourceImporter();
            retVal = (DbdModel)this.importer.processStatementSet(this.sSet);
        } else {
            retVal = this.dbdModel;
        }
        return retVal;
    }

    public void setDbdModel(DbdModel dbdModel) {
        this.dbdModel = dbdModel;
    }

    public ByteArrayOutputStream getContents() {
        return this.sSet.contents;
    }

    public IMSSourceImporter getImporter() {
        return this.importer;
    }

    public void setImporter(IMSSourceImporter importer) {
        this.importer = importer;
    }
}

