/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.wizards;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.wizards.ManageSecondaryIxWizard;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.lang.invoke.CallSite;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SysRelFieldsWizardPage1
extends WizardPage
implements Listener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    int fieldType;
    ManageSecondaryIxWizard wiz;
    Text fieldNameText;
    Text bytesText;
    Text startText;
    Text ckInfoText;

    protected SysRelFieldsWizardPage1(String pageName, int fieldType, ManageSecondaryIxWizard wiz) {
        super(pageName);
        this.fieldType = fieldType;
        this.wiz = wiz;
        this.setTitle(WorkbenchPlugin.descriptions.getString("WB117"));
        if (fieldType == 1) {
            this.setDescription(WorkbenchPlugin.descriptions.getString("WB118"));
        } else {
            this.setDescription(WorkbenchPlugin.descriptions.getString("WB119"));
        }
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            UIHelper uih = new UIHelper();
            uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            composite.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            Label labelSegName = this.fieldType == 1 ? uih.genLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB334"), uih.black, fd) : uih.genLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB333"), uih.black, fd);
            labelSegName.setEnabled(true);
            fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)labelSegName, 5), new FormAttachment(100, -80));
            this.fieldNameText = uih.genTextField(composite, 2052, "", 5, fd, (Listener)this, 24);
            fd = uih.genFormData(new FormAttachment((Control)labelSegName, 20), null, new FormAttachment(0, 0), null);
            if (this.fieldType == 1) {
                Label labelStart = uih.genLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB214"), uih.black, fd);
                labelStart.setEnabled(true);
                fd = uih.genFormData(new FormAttachment((Control)labelSegName, 20), null, new FormAttachment((Control)labelStart, 20), new FormAttachment(100, -80));
                this.startText = uih.genTextField(composite, 2052, "", 6, fd, (Listener)this, 24);
                fd = uih.genFormData(new FormAttachment((Control)labelStart, 20), null, new FormAttachment(0, 0), null);
                Label labelBytes = uih.genLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB215"), uih.black, fd);
                labelBytes.setEnabled(true);
                fd = uih.genFormData(new FormAttachment((Control)labelStart, 20), null, new FormAttachment((Control)labelBytes, 20), new FormAttachment(100, -80));
                this.bytesText = uih.genTextField(composite, 2052, "", 6, fd, (Listener)this, 24);
                fd = uih.genFormData(new FormAttachment((Control)labelBytes, 20), null, new FormAttachment(0, 0), null);
                Label labelCKInfo = uih.genLabel(composite, 16384, "/CK information", uih.black, fd);
                labelCKInfo.setEnabled(true);
                fd = uih.genFormData(new FormAttachment((Control)labelBytes, 20), new FormAttachment(100, -20), new FormAttachment((Control)labelBytes, 20), new FormAttachment(100, -20));
                this.ckInfoText = uih.genTextField(composite, 2882, "", 100000, fd, (Listener)this, 24);
                this.ckInfoText.setEditable(false);
                this.ckInfoText.setText(this.createCKInfoText());
                Font font = new Font(null, "Fixedsys", 8, 0);
                this.ckInfoText.setFont(font);
            }
            this.setControl((Control)composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private String createCKInfoText() throws ModelException {
        SegmentModel sourceSeg;
        Object retVal = "";
        SegmentModel currSeg = sourceSeg = this.wiz.getSourceSegment();
        Stack<CallSite> fieldNames = new Stack<CallSite>();
        Stack<Integer> fieldLengths = new Stack<Integer>();
        while (currSeg != null) {
            Vector fields = currSeg.getFieldList(true, false);
            int i = 0;
            while (i < fields.size()) {
                FieldModel field = (FieldModel)fields.get(i);
                if (field.getSeqType() == DBDConstants.U) {
                    String segName = currSeg.getImsName() + "." + field.getImsName();
                    fieldNames.push((CallSite)((Object)segName));
                    fieldLengths.push(field.getBytes());
                }
                ++i;
            }
            currSeg = currSeg.getParent();
        }
        Integer startIx = 1;
        while (!fieldNames.isEmpty() && !fieldLengths.isEmpty()) {
            Integer currLength = (Integer)fieldLengths.pop();
            String startStr = "Start: " + startIx.toString();
            retVal = (String)retVal + startStr;
            int spacesToAdd = 10 - startStr.length();
            int i = 0;
            while (i < spacesToAdd) {
                retVal = (String)retVal + " ";
                ++i;
            }
            String lengthStr = " Length: " + currLength.toString();
            retVal = (String)retVal + lengthStr;
            spacesToAdd = 12 - lengthStr.length();
            int i2 = 0;
            while (i2 < spacesToAdd) {
                retVal = (String)retVal + " ";
                ++i2;
            }
            retVal = (String)retVal + " Key field: " + (String)fieldNames.pop() + "\n";
            startIx = startIx + currLength;
        }
        retVal = (String)retVal + "\nKey feedback area total length: " + (startIx - 1);
        return retVal;
    }

    public void handleEvent(Event event) {
    }
}

