/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.wizards;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.wizards.ManageSecondaryIxWizard;
import com.ibm.im.ims.workbench.editors.wizards.SysRelFieldsWizard;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ManageSecondaryIxWizardPage2
extends WizardPage
implements Listener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Label labelFldName;
    private Label labelSrcSeg;
    Text inputFldName;
    Combo inputSrcSeg;
    private Button srchMoveUpBut;
    private Button srchMoveDownBut;
    private Button subSeqMoveUpBut;
    private Button subSeqMoveDownBut;
    private Button editSXBut;
    private Button editCKBut;
    private UIHelper uih;
    Table srchTab;
    private Table subSeqTab;
    Group srchFieldsGrp;
    Group subseqGrp;
    private boolean widgetsInitialized = false;
    public static final String PAGE_NAME = "SECINDEX2";
    private final String sxFieldStr = "/SX";
    private final String ckFieldStr = "/CK";

    public ManageSecondaryIxWizardPage2(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public ManageSecondaryIxWizardPage2(String pageName) {
        super(PAGE_NAME);
        this.setTitle(WorkbenchPlugin.labels.getString("WB307"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            this.setPageComplete(false);
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            this.uih = new UIHelper();
            this.uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            composite.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.labelFldName = this.uih.genLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB304") + " " + WorkbenchPlugin.noxlatlabels.getString("WB044") + WorkbenchPlugin.colon.getString("COLON"), this.uih.black, fd);
            this.labelFldName.setEnabled(true);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.labelFldName, 20), new FormAttachment(100, -80));
            this.inputFldName = this.uih.genTextField(composite, 2052, "", 8, fd, (Listener)this, 24);
            this.inputFldName.setEnabled(false);
            fd = this.uih.genFormData(new FormAttachment((Control)this.labelFldName, 10), null, new FormAttachment(0, 0), null);
            this.labelSrcSeg = this.uih.genLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB308") + " " + WorkbenchPlugin.noxlatlabels.getString("WB301") + WorkbenchPlugin.colon.getString("COLON"), this.uih.black, fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.labelFldName, 10), null, new FormAttachment((Control)this.inputFldName, 0, 16384), new FormAttachment(100, -80));
            this.inputSrcSeg = new Combo(composite, 12);
            this.inputSrcSeg.setLayoutData((Object)fd);
            this.inputSrcSeg.addListener(13, (Listener)this);
            FormLayout srchFieldsGroupFL = new FormLayout();
            srchFieldsGroupFL.marginHeight = 5;
            srchFieldsGroupFL.marginWidth = 5;
            FormData searchFieldsFD = this.uih.genFormData(new FormAttachment((Control)this.labelSrcSeg, 20), null, new FormAttachment(0, 0), null);
            this.srchFieldsGrp = new Group(composite, 0);
            this.srchFieldsGrp.setText(WorkbenchPlugin.labels.getString("WB309") + " " + WorkbenchPlugin.noxlatlabels.getString("WB302"));
            this.srchFieldsGrp.setLayout((Layout)srchFieldsGroupFL);
            this.srchFieldsGrp.setLayoutData((Object)searchFieldsFD);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), new FormAttachment(40, 0));
            this.srchTab = new Table((Composite)this.srchFieldsGrp, 2848);
            this.srchTab.setLayoutData((Object)fd);
            this.srchTab.addListener(13, (Listener)this);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.srchTab, 20), new FormAttachment(100, -140));
            this.srchMoveUpBut = new Button((Composite)this.srchFieldsGrp, 8);
            this.srchMoveUpBut.setText(WorkbenchPlugin.labels.getString("WB340"));
            this.computeButtonSize(this.srchMoveUpBut);
            this.srchMoveUpBut.setLayoutData((Object)fd);
            this.srchMoveUpBut.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    ManageSecondaryIxWizardPage2.this.moveUp(ManageSecondaryIxWizardPage2.this.srchTab);
                }
            });
            fd = this.uih.genFormData(new FormAttachment((Control)this.srchMoveUpBut, 10), null, new FormAttachment((Control)this.srchTab, 20), new FormAttachment(100, -140));
            this.srchMoveDownBut = new Button((Composite)this.srchFieldsGrp, 8);
            this.srchMoveDownBut.setText(WorkbenchPlugin.labels.getString("WB341"));
            this.computeButtonSize(this.srchMoveDownBut);
            this.srchMoveDownBut.setLayoutData((Object)fd);
            this.srchMoveDownBut.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    ManageSecondaryIxWizardPage2.this.moveDown(ManageSecondaryIxWizardPage2.this.srchTab);
                }
            });
            FormLayout subseqGroupFL = new FormLayout();
            subseqGroupFL.marginHeight = 5;
            subseqGroupFL.marginWidth = 5;
            FormData subseqFD = this.uih.genFormData(new FormAttachment((Control)this.srchFieldsGrp, 20), null, new FormAttachment(0, 0), null);
            this.subseqGrp = new Group(composite, 0);
            this.subseqGrp.setText(WorkbenchPlugin.labels.getString("WB329") + " " + WorkbenchPlugin.noxlatlabels.getString("WB305"));
            this.subseqGrp.setLayout((Layout)subseqGroupFL);
            this.subseqGrp.setLayoutData((Object)subseqFD);
            fd = this.uih.genFormData(new FormAttachment(0, 0), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment(40, 0));
            this.subSeqTab = new Table((Composite)this.subseqGrp, 2848);
            this.subSeqTab.setLayoutData((Object)fd);
            this.subSeqTab.addListener(13, (Listener)this);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.subSeqTab, 20), new FormAttachment(100, -140));
            this.subSeqMoveUpBut = new Button((Composite)this.subseqGrp, 8);
            this.subSeqMoveUpBut.setText(WorkbenchPlugin.labels.getString("WB340"));
            this.computeButtonSize(this.subSeqMoveUpBut);
            this.subSeqMoveUpBut.setLayoutData((Object)fd);
            this.subSeqMoveUpBut.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    ManageSecondaryIxWizardPage2.this.moveUp(ManageSecondaryIxWizardPage2.this.subSeqTab);
                }
            });
            fd = this.uih.genFormData(new FormAttachment((Control)this.subSeqMoveUpBut, 10), null, new FormAttachment((Control)this.subSeqTab, 20), new FormAttachment(100, -140));
            this.subSeqMoveDownBut = new Button((Composite)this.subseqGrp, 8);
            this.subSeqMoveDownBut.setText(WorkbenchPlugin.labels.getString("WB341"));
            this.computeButtonSize(this.subSeqMoveDownBut);
            this.subSeqMoveDownBut.setLayoutData((Object)fd);
            this.subSeqMoveDownBut.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    ManageSecondaryIxWizardPage2.this.moveDown(ManageSecondaryIxWizardPage2.this.subSeqTab);
                }
            });
            fd = this.uih.genFormData(new FormAttachment((Control)this.subSeqMoveDownBut, 10), null, new FormAttachment((Control)this.subSeqTab, 20), new FormAttachment(100, -140));
            this.editCKBut = new Button((Composite)this.subseqGrp, 8);
            this.editCKBut.setText(WorkbenchPlugin.labels.getString("WB331"));
            this.computeButtonSize(this.editCKBut);
            this.editCKBut.setLayoutData((Object)fd);
            this.editCKBut.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    logger.finest("editCKBut pushed");
                    Shell shell = new Shell();
                    SysRelFieldsWizard wizard = new SysRelFieldsWizard(1, ManageSecondaryIxWizardPage2.this.getWiz());
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.open();
                }
            });
            fd = this.uih.genFormData(new FormAttachment((Control)this.editCKBut, 10), null, new FormAttachment((Control)this.subSeqTab, 20), new FormAttachment(100, -140));
            this.editSXBut = new Button((Composite)this.subseqGrp, 8);
            this.editSXBut.setText(WorkbenchPlugin.labels.getString("WB332"));
            this.computeButtonSize(this.editSXBut);
            this.editSXBut.setLayoutData((Object)fd);
            this.editSXBut.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    logger.finest("editSXBut pushed");
                    Shell shell = new Shell();
                    SysRelFieldsWizard wizard = new SysRelFieldsWizard(0, ManageSecondaryIxWizardPage2.this.getWiz());
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.open();
                }
            });
            this.setControl((Control)composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void moveUp(Table table) {
        this.uih.moveUp(table, this);
    }

    private void moveDown(Table table) {
        this.uih.moveDown(table, this);
    }

    public String getSrcSeg() {
        return this.inputSrcSeg.getText();
    }

    public Vector<String> getCheckedSubSeqFields() {
        return this.uih.getCheckedTableValues(this.subSeqTab);
    }

    private void initContents() throws CoreException, ModelException {
        this.inputFldName.setText(this.getWiz().getLchild().getXdfldName());
        this.populateCombo();
        if (this.srchTab.getItemCount() <= 0) {
            this.populateSrchTable();
            if (this.getWiz().getWizAction() != 1) {
                this.setCheckBoxesForSearchFields();
            }
        }
        if (this.subSeqTab.getItemCount() <= 0) {
            this.populateSubseqTable();
            if (this.getWiz().getWizAction() != 1) {
                this.setCheckBoxesForSubSeq();
            }
        }
        if (this.getWiz().getWizAction() == 3) {
            this.srchTab.setEnabled(false);
            this.subSeqTab.setEnabled(false);
        } else {
            this.srchTab.setEnabled(true);
            this.subSeqTab.setEnabled(true);
        }
        this.updateButtons();
        this.widgetsInitialized = true;
    }

    private void updateButtons() {
        if (this.getWiz().getWizAction() == 3) {
            this.subSeqMoveUpBut.setEnabled(false);
            this.subSeqMoveDownBut.setEnabled(false);
            this.srchMoveUpBut.setEnabled(false);
            this.srchMoveDownBut.setEnabled(false);
            this.editCKBut.setEnabled(false);
            this.editSXBut.setEnabled(false);
        } else {
            int selectedIx;
            this.editCKBut.setEnabled(true);
            this.editSXBut.setEnabled(true);
            int selectionIndex = this.subSeqTab.getSelectionIndex();
            TableItem[] items = this.subSeqTab.getItems();
            if (items.length > 0) {
                int i = 0;
                while (i < items.length) {
                    if (items[i].getText().substring(0, 3).equals("/SX") && i != selectionIndex) {
                        this.editSXBut.setEnabled(false);
                        break;
                    }
                    ++i;
                }
            }
            if ((selectedIx = this.subSeqTab.getSelectionIndex()) < 0) {
                this.subSeqMoveUpBut.setEnabled(false);
                this.subSeqMoveDownBut.setEnabled(false);
            } else {
                this.subSeqMoveUpBut.setEnabled(true);
                this.subSeqMoveDownBut.setEnabled(true);
            }
            selectedIx = this.srchTab.getSelectionIndex();
            if (selectedIx < 0) {
                this.srchMoveUpBut.setEnabled(false);
                this.srchMoveDownBut.setEnabled(false);
            } else {
                this.srchMoveUpBut.setEnabled(true);
                this.srchMoveDownBut.setEnabled(true);
            }
        }
    }

    private void setCheckBoxesForSubSeq() {
        TableItem[] items;
        LogicalChildModel lChild = this.getWiz().getLchild();
        List subSeq = lChild.getSubsequence();
        if (subSeq != null && (items = this.subSeqTab.getItems()).length > 0) {
            int i = 0;
            while (i < items.length) {
                int j = 0;
                while (j < subSeq.size()) {
                    if (items[i].getText().equalsIgnoreCase((String)subSeq.get(j))) {
                        items[i].setChecked(true);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void newSourceSegmentWasSelected() {
        this.clearTables();
        this.setPageComplete(false);
        this.widgetsInitialized = false;
    }

    private void clearTables() {
        this.srchTab.removeAll();
        this.subSeqTab.removeAll();
    }

    public void newSecondaryIxWasSelected() {
        this.clearTables();
        this.setPageComplete(false);
        this.widgetsInitialized = false;
    }

    private void setCheckBoxesForSearchFields() {
        LogicalChildModel lChild = this.getWiz().getLchild();
        List searchFields = lChild.getSearch();
        TableItem[] items = this.srchTab.getItems();
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                int j = 0;
                while (j < searchFields.size()) {
                    if (items[i].getText().equalsIgnoreCase((String)searchFields.get(j))) {
                        items[i].setChecked(true);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void populateCombo() {
        ManageSecondaryIxWizard wiz = this.getWiz();
        LogicalChildModel lchild = wiz.getLchild();
        SegmentGEFModel gefSeg = wiz.getGefSegment();
        Vector<SegmentGEFModel> gefSegs = gefSeg.getDbGEFModel().getSegmentGEFModels();
        String sourceSegName = lchild.getXfldSourceSegment();
        if (gefSegs != null && gefSegs.size() > 0) {
            String[] inputOptions = new String[gefSegs.size()];
            int i = 0;
            while (i < gefSegs.size()) {
                String currSourcSegName;
                inputOptions[i] = currSourcSegName = gefSegs.elementAt(i).getSegmentName();
                ++i;
            }
            this.inputSrcSeg.setItems(inputOptions);
            if (sourceSegName == null || sourceSegName.equals("")) {
                sourceSegName = gefSeg.getSegmentName();
            }
            this.inputSrcSeg.setText(sourceSegName);
        }
        if (this.getWiz().getWizAction() == 3) {
            this.inputSrcSeg.setEnabled(false);
        } else {
            this.inputSrcSeg.setEnabled(true);
        }
    }

    private void populateTablesWithNewSourceSeg() throws ModelException {
        SegmentGEFModel gefSourceSeg = null;
        ManageSecondaryIxWizard wiz = this.getWiz();
        SegmentGEFModel gefSeg = wiz.getGefSegment();
        Vector<SegmentGEFModel> gefSegs = gefSeg.getDbGEFModel().getSegmentGEFModels();
        String selectedSourceSegName = this.inputSrcSeg.getText();
        int i = 0;
        while (i < gefSegs.size()) {
            String currSourcSegName = gefSegs.elementAt(i).getSegmentName();
            if (currSourcSegName.equalsIgnoreCase(selectedSourceSegName)) {
                gefSourceSeg = gefSegs.elementAt(i);
                break;
            }
            ++i;
        }
        if (gefSourceSeg != null) {
            this.srchTab.removeAll();
            this.subSeqTab.removeAll();
            Vector fields = gefSourceSeg.getSegmentModel().getFieldList(true, false);
            int i2 = 0;
            while (i2 < fields.size()) {
                TableItem item = new TableItem(this.srchTab, 0);
                TableItem subSeqTableItem = new TableItem(this.subSeqTab, 0);
                item.setText(((FieldModel)fields.get(i2)).getImsName());
                subSeqTableItem.setText(((FieldModel)fields.get(i2)).getImsName());
                subSeqTableItem.addListener(13, (Listener)this);
                ++i2;
            }
        }
    }

    private void populateSrchTable() throws ModelException {
        LogicalChildModel lChild;
        List searchFields;
        if (this.getWiz().getWizAction() != 1 && (searchFields = (lChild = this.getWiz().getLchild()).getSearch()) != null) {
            int j = 0;
            while (j < searchFields.size()) {
                TableItem item = new TableItem(this.srchTab, 0);
                item.setText((String)searchFields.get(j));
                ++j;
            }
        }
        TableItem[] items = this.srchTab.getItems();
        SegmentGEFModel gefSourceSeg = null;
        ManageSecondaryIxWizard wiz = this.getWiz();
        SegmentGEFModel gefSeg = wiz.getGefSegment();
        Vector<SegmentGEFModel> gefSegs = gefSeg.getDbGEFModel().getSegmentGEFModels();
        String selectedSourceSegName = this.inputSrcSeg.getText();
        int i = 0;
        while (i < gefSegs.size()) {
            String currSourcSegName = gefSegs.elementAt(i).getSegmentName();
            if (currSourcSegName.equalsIgnoreCase(selectedSourceSegName)) {
                gefSourceSeg = gefSegs.elementAt(i);
                break;
            }
            ++i;
        }
        if (gefSourceSeg != null) {
            Vector fields = gefSourceSeg.getSegmentModel().getFieldList(true, false);
            int i2 = 0;
            while (i2 < fields.size()) {
                boolean alreadyInList = false;
                int j = 0;
                while (j < items.length) {
                    if (items[j].getText().equalsIgnoreCase(((FieldModel)fields.get(i2)).getImsName())) {
                        alreadyInList = true;
                        break;
                    }
                    ++j;
                }
                if (!alreadyInList) {
                    TableItem item = new TableItem(this.srchTab, 0);
                    item.setText(((FieldModel)fields.get(i2)).getImsName());
                }
                ++i2;
            }
        }
    }

    public boolean isWidgetsInitialized() {
        return this.widgetsInitialized;
    }

    private void populateSubseqTable() throws ModelException {
        LogicalChildModel lChild;
        List subseqFields;
        if (this.getWiz().getWizAction() != 1 && (subseqFields = (lChild = this.getWiz().getLchild()).getSubsequence()) != null) {
            int j = 0;
            while (j < subseqFields.size()) {
                TableItem item = new TableItem(this.subSeqTab, 0);
                item.setText((String)subseqFields.get(j));
                ++j;
            }
        }
        TableItem[] items = this.subSeqTab.getItems();
        SegmentGEFModel gefSourceSeg = null;
        ManageSecondaryIxWizard wiz = this.getWiz();
        SegmentGEFModel gefSeg = wiz.getGefSegment();
        Vector<SegmentGEFModel> gefSegs = gefSeg.getDbGEFModel().getSegmentGEFModels();
        String selectedSourceSegName = this.inputSrcSeg.getText();
        int i = 0;
        while (i < gefSegs.size()) {
            String currSourcSegName = gefSegs.elementAt(i).getSegmentName();
            if (currSourcSegName.equalsIgnoreCase(selectedSourceSegName)) {
                gefSourceSeg = gefSegs.elementAt(i);
            }
            ++i;
        }
        if (gefSourceSeg != null) {
            Vector fields = gefSourceSeg.getSegmentModel().getFieldList(true, false);
            int i2 = 0;
            while (i2 < fields.size()) {
                boolean alreadyInList = false;
                int j = 0;
                while (j < items.length) {
                    if (items[j].getText().equalsIgnoreCase(((FieldModel)fields.get(i2)).getImsName())) {
                        alreadyInList = true;
                        break;
                    }
                    ++j;
                }
                if (!alreadyInList) {
                    TableItem item = new TableItem(this.subSeqTab, 0);
                    item.setText(((FieldModel)fields.get(i2)).getImsName());
                    item.addListener(13, (Listener)this);
                }
                ++i2;
            }
        }
    }

    private ManageSecondaryIxWizard getWiz() {
        return (ManageSecondaryIxWizard)this.getWizard();
    }

    private void handleSrchTableEvent() {
        this.updateButtons();
        this.setPageComplete(this.validatePage());
    }

    public Vector<String> getCheckedSrchFields() {
        return this.uih.getCheckedTableValues(this.srchTab);
    }

    private void handleComboEvent(Event e) throws ModelException {
        this.srchTab.removeAll();
        this.subSeqTab.removeAll();
        this.getWiz().resetDdataTable();
        this.populateTablesWithNewSourceSeg();
        this.setPageComplete(this.validatePage());
    }

    private void computeButtonSize(Button button) {
        Point buttonSize = button.computeSize(-1, -1);
        button.setSize(buttonSize);
    }

    public void handleEvent(Event event) {
        if (logger.isLoggable(Level.FINER)) {
            Object[] parms = new Object[]{event, event.widget};
            logger.entering(((Object)((Object)this)).getClass().getName(), "handleEvent(Event e)", parms);
        }
        try {
            if (event.widget == this.srchTab) {
                this.handleSrchTableEvent();
            } else if (event.widget == this.subSeqTab) {
                this.handleSubseqTableEvent(event);
            } else if (event.widget == this.inputSrcSeg) {
                this.handleComboEvent(event);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "handleEvent(Event e)", new Object[0]);
        }
    }

    private void handleSubseqTableEvent(Event e) {
        if (((TableItem)e.item).getText().equals("/SX") && ((TableItem)e.item).getChecked()) {
            logger.finest("/SX field is being selected");
        }
        if (((TableItem)e.item).getText().equals("/CK") && ((TableItem)e.item).getChecked()) {
            logger.finest("/CK field is being selected");
        }
        this.updateButtons();
        this.setPageComplete(this.validatePage());
    }

    public void setVisible(boolean visible) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", new Object[]{visible});
        }
        try {
            if (visible) {
                try {
                    this.initContents();
                }
                catch (Throwable e) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
                    logger.error(e);
                }
            } else {
                LogicalChildModel lchild = this.getWiz().getLchild();
                lchild.setXfldSourceSegment(this.inputSrcSeg.getText());
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
            logger.error(e);
        }
        super.setVisible(visible);
        this.setPageComplete(this.validatePage());
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", new Object[0]);
        }
    }

    private boolean validatePage() {
        boolean itemChecked = false;
        TableItem[] checkedItems = this.srchTab.getItems();
        int i = 0;
        while (i < checkedItems.length) {
            if (checkedItems[i].getChecked()) {
                itemChecked = true;
                break;
            }
            ++i;
        }
        return itemChecked;
    }
}

