/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.wizards;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.wizards.ManageSecondaryIxWizard;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ManageSecondaryIxWizardPage1
extends WizardPage
implements Listener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Label labelSegName;
    private Label labelNewFldName;
    private Label labelExistFldName;
    private Label labelRemoveFldName;
    private Text inputTargetSegName;
    private Text inputNewXdfldName;
    private Combo inputExistFldName;
    private Combo inputRemoveFldName;
    private Button createNewIxButton;
    private Button editOldIxButton;
    private Button removeOldIxButton;
    private UIHelper uih;
    public static final String PAGE_NAME = "SECINDEX1";
    private TextVerifyListener inputNewFldNameVerifier;
    boolean isError = false;

    public ManageSecondaryIxWizardPage1(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public ManageSecondaryIxWizardPage1(String pageName) {
        super(PAGE_NAME);
        this.setTitle(WorkbenchPlugin.labels.getString("WB302"));
        this.uih = new UIHelper();
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            this.setPageComplete(false);
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            composite.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.labelSegName = this.uih.genLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB303"), this.uih.black, fd);
            this.labelSegName.setEnabled(true);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.labelSegName, 20), new FormAttachment(100, -80));
            this.inputTargetSegName = this.uih.genTextField(composite, 2052, "", 8, fd, (Listener)this, 24);
            this.inputTargetSegName.setEnabled(true);
            this.inputTargetSegName.setEditable(false);
            Button[] radios = new Button[3];
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.labelSegName, 20);
            radios[0] = this.createNewIxButton = new Button(composite, 16);
            if (this.getWiz().getWizAction() == 1) {
                this.createNewIxButton.setSelection(true);
            }
            this.createNewIxButton.setText(WorkbenchPlugin.labels.getString("WB305"));
            this.createNewIxButton.addListener(13, (Listener)this);
            this.createNewIxButton.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)radios[0], 10), null, new FormAttachment(0, 16), null);
            this.labelNewFldName = this.uih.genRequiredLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB304") + " " + WorkbenchPlugin.noxlatlabels.getString("WB044") + WorkbenchPlugin.colon.getString("COLON"), this.uih.black, fd);
            fd = this.uih.genFormData(new FormAttachment((Control)radios[0], 10), null, new FormAttachment((Control)this.labelNewFldName, 20), new FormAttachment(100, -80));
            this.inputNewXdfldName = this.uih.genTextField(composite, 2052, "", 8, fd, (Listener)this, 24);
            this.inputNewXdfldName.setText(this.inputNewXdfldName.getText().toUpperCase());
            this.inputNewFldNameVerifier = new TextVerifyListener();
            this.inputNewXdfldName.addVerifyListener((VerifyListener)this.inputNewFldNameVerifier);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.labelNewFldName, 10);
            radios[1] = this.editOldIxButton = new Button(composite, 16);
            if (this.getWiz().getWizAction() == 2) {
                this.editOldIxButton.setSelection(true);
            }
            this.editOldIxButton.setText(WorkbenchPlugin.labels.getString("WB306"));
            this.editOldIxButton.addListener(13, (Listener)this);
            this.editOldIxButton.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)radios[1], 10), null, new FormAttachment(0, 16), null);
            this.labelExistFldName = this.uih.genLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB304") + " " + WorkbenchPlugin.noxlatlabels.getString("WB044") + WorkbenchPlugin.colon.getString("COLON"), this.uih.black, fd);
            this.labelExistFldName.setEnabled(false);
            fd = this.uih.genFormData(new FormAttachment((Control)radios[1], 10), null, new FormAttachment((Control)this.inputNewXdfldName, 0, 16384), new FormAttachment(100, -80));
            this.inputExistFldName = new Combo(composite, 12);
            this.inputExistFldName.setLayoutData((Object)fd);
            this.inputExistFldName.addListener(13, (Listener)this);
            this.inputExistFldName.setEnabled(false);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.labelExistFldName, 10);
            radios[2] = this.removeOldIxButton = new Button(composite, 16);
            if (this.getWiz().getWizAction() == 3) {
                this.removeOldIxButton.setSelection(true);
            }
            this.removeOldIxButton.setText(WorkbenchPlugin.labels.getString("WB324"));
            this.removeOldIxButton.addListener(13, (Listener)this);
            this.removeOldIxButton.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)radios[2], 10), null, new FormAttachment(0, 16), null);
            this.labelRemoveFldName = this.uih.genLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB304") + " " + WorkbenchPlugin.noxlatlabels.getString("WB044") + WorkbenchPlugin.colon.getString("COLON"), this.uih.black, fd);
            this.labelRemoveFldName.setEnabled(false);
            fd = this.uih.genFormData(new FormAttachment((Control)radios[2], 10), null, new FormAttachment((Control)this.inputExistFldName, 0, 16384), new FormAttachment(100, -80));
            this.inputRemoveFldName = new Combo(composite, 12);
            this.inputRemoveFldName.setLayoutData((Object)fd);
            this.inputRemoveFldName.addListener(13, (Listener)this);
            this.inputRemoveFldName.setEnabled(false);
            this.setControl((Control)composite);
            this.initContents();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    public String getExistingFldName() {
        return this.inputExistFldName.getText();
    }

    public String getRemoveFldName() {
        return this.inputRemoveFldName.getText();
    }

    private void updateErrorMessage() {
        if (this.inputNewFldNameVerifier.isCharError()) {
            this.setErrorMessage(WorkbenchPlugin.errors.getString("EISRC8"));
        } else {
            this.setErrorMessage(null);
        }
    }

    public void setVisible(boolean visible) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", new Object[]{visible});
        }
        try {
            if (visible) {
                if (this.getWiz().getWizAction() == 1) {
                    this.inputNewXdfldName.setFocus();
                }
            } else {
                logger.finest("**User is leaving page1");
                try {
                    this.getWiz().populateLocalMetadata();
                }
                catch (Throwable e) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
                    logger.error(e);
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
            logger.error(e);
        }
        super.setVisible(visible);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", new Object[0]);
        }
    }

    private void initContents() {
        ManageSecondaryIxWizard wiz = this.getWiz();
        SegmentGEFModel gefSeg = wiz.getGefSegment();
        this.inputTargetSegName.setText(gefSeg.getSegmentName());
        SegmentModel seg = gefSeg.getSegmentModel();
        List lchildList = seg.getLogicalChildList();
        if (lchildList != null && lchildList.size() > 0) {
            String[] inputOptions = new String[lchildList.size()];
            int i = 0;
            while (i < lchildList.size()) {
                LogicalChildModel lchild = (LogicalChildModel)lchildList.get(i);
                inputOptions[i] = lchild.getXdfldName();
                ++i;
            }
            this.inputExistFldName.setItems(inputOptions);
            this.inputExistFldName.setText(inputOptions[0]);
            this.inputRemoveFldName.setItems(inputOptions);
            this.inputRemoveFldName.setText(inputOptions[0]);
        }
    }

    private boolean validatePage() {
        boolean retVal = false;
        if (this.getWiz().getWizAction() == 1) {
            if (this.inputNewXdfldName.getText() != null && !this.inputNewXdfldName.getText().equals("") && !this.isError) {
                retVal = true;
            }
        } else {
            retVal = true;
        }
        return retVal;
    }

    public void handleEvent(Event e) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "handleEvent(Event e)", new Object[]{e});
        }
        try {
            Widget widget = e.widget;
            if (widget instanceof Button) {
                logger.finest("Selection: " + ((Button)e.widget).getSelection());
                this.doSelection((Button)e.widget);
            }
            if (widget instanceof Button || widget instanceof Combo) {
                this.getWiz().newSecondaryIxWasSelected();
            }
            boolean pageComplete = this.validatePage();
            this.setPageComplete(pageComplete);
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(((Object)((Object)this)).getClass().getName(), "handleEvent(Event e)", new Object[0]);
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event e)", err);
            logger.error(err);
        }
    }

    private ManageSecondaryIxWizard getWiz() {
        return (ManageSecondaryIxWizard)this.getWizard();
    }

    private void doSelection(Button button) {
        if (button.getSelection()) {
            if (button == this.createNewIxButton) {
                this.getWiz().setWizAction(1);
                this.labelNewFldName.setEnabled(true);
                this.inputNewXdfldName.setEnabled(true);
                this.labelExistFldName.setEnabled(false);
                this.inputExistFldName.setEnabled(false);
                this.labelRemoveFldName.setEnabled(false);
                this.inputRemoveFldName.setEnabled(false);
            } else if (button == this.editOldIxButton) {
                this.getWiz().setWizAction(2);
                this.labelExistFldName.setEnabled(true);
                this.inputExistFldName.setEnabled(true);
                this.labelNewFldName.setEnabled(false);
                this.inputNewXdfldName.setEnabled(false);
                this.labelRemoveFldName.setEnabled(false);
                this.inputRemoveFldName.setEnabled(false);
            } else if (button == this.removeOldIxButton) {
                this.getWiz().setWizAction(3);
                this.labelRemoveFldName.setEnabled(true);
                this.inputRemoveFldName.setEnabled(true);
                this.labelNewFldName.setEnabled(false);
                this.inputNewXdfldName.setEnabled(false);
                this.labelExistFldName.setEnabled(false);
                this.inputExistFldName.setEnabled(false);
            }
        }
    }

    public String getNewXdfldName() {
        return this.inputNewXdfldName.getText();
    }

    class TextVerifyListener
    implements VerifyListener {
        private boolean charError = false;

        TextVerifyListener() {
        }

        public boolean isCharError() {
            return this.charError;
        }

        public void verifyText(VerifyEvent event) {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(this.getClass().getName(), "verifyText(VerifyEvent event)", new Object[]{event});
            }
            if (event.character >= 'a' && event.character <= 'z') {
                String upperCaseChar;
                event.text = upperCaseChar = event.text.toUpperCase();
            }
            if (Utility.hasSpecialChar(ManageSecondaryIxWizardPage1.this.inputNewXdfldName.getText(), event)) {
                ManageSecondaryIxWizardPage1.this.isError = true;
                this.charError = true;
            } else {
                ManageSecondaryIxWizardPage1.this.isError = false;
                this.charError = false;
            }
            ManageSecondaryIxWizardPage1.this.updateErrorMessage();
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "verifyText(VerifyEvent event)", new Object[0]);
            }
        }
    }
}

