/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.wizards;

import com.ibm.im.ims.metadata.dbd.DbTypeType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.wizards.ManageSecondaryIxWizardPage1;
import com.ibm.im.ims.workbench.editors.wizards.ManageSecondaryIxWizardPage2;
import com.ibm.im.ims.workbench.editors.wizards.ManageSecondaryIxWizardPage2a;
import com.ibm.im.ims.workbench.editors.wizards.ManageSecondaryIxWizardPage3;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ManageSecondaryIxWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    ManageSecondaryIxWizardPage1 page1;
    ManageSecondaryIxWizardPage2 page2;
    ManageSecondaryIxWizardPage2a page2a;
    ManageSecondaryIxWizardPage3 page3;
    DbdModel newSecondaryIxDbd = null;
    private LogicalChildModel newLchild = null;
    DbdModel selectedSecondaryIxDbd = null;
    private LogicalChildModel selectedLchild = null;
    public static final int CREATE_NEW_IX = 1;
    public static final int EDIT_EXISTING_IX = 2;
    public static final int DELETE_EXISTING_IX = 3;
    private int wizAction = 1;
    private static final String PLUGIN_ID = "com.ibm.im.ims.workbench";
    private SegmentGEFModel gefSegment;

    public ManageSecondaryIxWizard() {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB301"));
        this.setHelpAvailable(false);
    }

    public SegmentGEFModel getGefSegment() {
        return this.gefSegment;
    }

    public void setGefSegment(SegmentGEFModel gefSegment) {
        this.gefSegment = gefSegment;
    }

    public void populateLocalMetadata() throws CoreException, ModelException {
        if (this.getWizAction() == 1) {
            if (this.newLchild == null) {
                this.newLchild = new LogicalChildModel();
                this.newLchild.createXdfld();
                this.newLchild.setXdfldName(this.page1.getNewXdfldName());
            }
        } else {
            if (this.selectedLchild == null) {
                this.readInLchild();
            }
            if (this.selectedSecondaryIxDbd == null) {
                this.readInSecondaryIx();
            }
        }
    }

    private void readInLchild() {
        String xdfldName = null;
        if (this.getWizAction() == 2) {
            xdfldName = this.page1.getExistingFldName();
        } else if (this.getWizAction() == 3) {
            xdfldName = this.page1.getRemoveFldName();
        }
        this.selectedLchild = new LogicalChildModel();
        this.selectedLchild.createXdfld();
        this.copyLchildAttrsFromMetadata(this.selectedLchild, xdfldName);
    }

    private void copyLchildAttrsFromMetadata(LogicalChildModel lchild, String xdfldName) {
        List ddataFlds;
        List subseqFlds;
        LogicalChildModel metadataLchild = this.getMetadataLchild(xdfldName);
        lchild.setXdfldName(metadataLchild.getXdfldName());
        lchild.setDbd(metadataLchild.getDbd());
        lchild.setName(metadataLchild.getName());
        lchild.setXfldSourceSegment(metadataLchild.getXfldSourceSegment());
        lchild.setXfldNullval(metadataLchild.getXfldNullval());
        lchild.setXfldIndexExitRoutine(metadataLchild.getXfldIndexExitRoutine());
        lchild.setXfldConst(metadataLchild.getXfldConst());
        List srchFlds = metadataLchild.getSearch();
        if (srchFlds != null) {
            int i = 0;
            while (i < srchFlds.size()) {
                lchild.addSearchField((String)srchFlds.get(i));
                ++i;
            }
        }
        if ((subseqFlds = metadataLchild.getSubsequence()) != null) {
            int i = 0;
            while (i < subseqFlds.size()) {
                lchild.addSubsequenceField((String)subseqFlds.get(i));
                ++i;
            }
        }
        if ((ddataFlds = metadataLchild.getDuplicateData()) != null) {
            int i = 0;
            while (i < ddataFlds.size()) {
                lchild.addDuplicateDataField((String)ddataFlds.get(i));
                ++i;
            }
        }
    }

    private void copyLchildAttrsBackToMetadata(LogicalChildModel lchild) {
        List ddataFlds;
        List subseqFlds;
        String xdfldName = lchild.getXdfldName();
        LogicalChildModel metadataLchild = this.getMetadataLchild(xdfldName);
        metadataLchild.setXdfldName(lchild.getXdfldName());
        metadataLchild.setDbd(lchild.getDbd());
        metadataLchild.setName(lchild.getName());
        metadataLchild.setXfldSourceSegment(lchild.getXfldSourceSegment());
        metadataLchild.setXfldNullval(lchild.getXfldNullval());
        metadataLchild.setXfldIndexExitRoutine(lchild.getXfldIndexExitRoutine());
        metadataLchild.setXfldConst(lchild.getXfldConst());
        List srchFlds = lchild.getSearch();
        if (srchFlds != null) {
            metadataLchild.clearSearchFields();
            int i = 0;
            while (i < srchFlds.size()) {
                metadataLchild.addSearchField((String)srchFlds.get(i));
                ++i;
            }
        }
        if ((subseqFlds = lchild.getSubsequence()) != null) {
            metadataLchild.clearSubsequenceFields();
            int i = 0;
            while (i < subseqFlds.size()) {
                metadataLchild.addSubsequenceField((String)subseqFlds.get(i));
                ++i;
            }
        }
        if ((ddataFlds = lchild.getDuplicateData()) != null) {
            metadataLchild.clearDuplicateDataFields();
            int i = 0;
            while (i < ddataFlds.size()) {
                metadataLchild.addDuplicateDataField((String)ddataFlds.get(i));
                ++i;
            }
        }
    }

    public LogicalChildModel getLchild() {
        LogicalChildModel retVal = null;
        if (this.wizAction == 1) {
            if (this.newLchild != null) {
                retVal = this.newLchild;
            } else {
                this.newLchild = new LogicalChildModel();
                this.newLchild.createXdfld();
                this.newLchild.setXdfldName(this.page1.getNewXdfldName());
                retVal = this.newLchild;
            }
        } else if (this.wizAction == 2 || this.wizAction == 3) {
            if (this.selectedLchild == null) {
                this.readInLchild();
            }
            retVal = this.selectedLchild;
        }
        return retVal;
    }

    public int getWizAction() {
        return this.wizAction;
    }

    public void setWizAction(int newAction) {
        this.wizAction = newAction;
    }

    private void readInSecondaryIx() throws CoreException, ModelException {
        LogicalChildModel lchild = this.getLchild();
        String secondaryIxDBDName = lchild.getDbd();
        if (this.selectedSecondaryIxDbd == null) {
            this.selectedSecondaryIxDbd = new DbdModel("");
        }
        this.copySecondaryIxAttrsFromMetadata(this.selectedSecondaryIxDbd, secondaryIxDBDName);
    }

    private void copySecondaryIxAttrsFromMetadata(DbdModel ixDbd, String secondaryIxDBDName) throws CoreException, ModelException {
        String projectName = this.gefSegment.getDbGEFModel().getProjectName();
        DbdModel metadataSecondaryIxDbd = ProjectTreeFileHelper.unmarshalDbd((String)secondaryIxDBDName, (String)projectName);
        ixDbd.setDbdName(metadataSecondaryIxDbd.getDBDName());
        ixDbd.setAccessType(DbTypeType.INDEX.toString());
        ixDbd.setProt(metadataSecondaryIxDbd.getProt());
        ixDbd.setDoscomp(metadataSecondaryIxDbd.getDoscomp());
        ixDbd.setDatxexit(metadataSecondaryIxDbd.getDatxexit());
        ixDbd.setPassword(metadataSecondaryIxDbd.getPassword());
        ixDbd.getRootSegment().setName(metadataSecondaryIxDbd.getRootSegment().getName());
    }

    public boolean canFinish() {
        boolean retVal = false;
        try {
            if (this.page1.isPageComplete() && this.page2.isPageComplete() && this.page2a.isPageComplete()) {
                retVal = true;
            }
            if (this.getWizAction() == 3) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
        return retVal;
    }

    public boolean performFinish() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        if (this.getWizAction() == 1) {
            seg = this.gefSegment.getSegmentModel();
            seg.addLogicalChild(this.getLchild());
            this.updateLchildWithUserInput(this.getLchild());
            try {
                this.updateSecondaryIxDBD();
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
                logger.error(e);
            }
        } else if (this.getWizAction() == 2) {
            this.updateLchildWithUserInput(this.getLchild());
            this.copyLchildAttrsBackToMetadata(this.getLchild());
            try {
                this.updateSecondaryIxDBD();
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
                logger.error(e);
            }
        } else if (this.getWizAction() == 3) {
            if (this.selectedSecondaryIxDbd == null) {
                try {
                    this.readInSecondaryIx();
                }
                catch (Throwable e) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
                    logger.error(e);
                }
            }
            seg = this.gefSegment.getSegmentModel();
            LogicalChildModel lchildForRemoval = this.getMetadataLchild(this.page1.getRemoveFldName());
            seg.removeLogicalChild(lchildForRemoval);
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        ManageSecondaryIxWizard.this.doFinish(monitor);
                    }
                    catch (Throwable e) {
                        logger.throwing(this.getClass().getName(), "performFinish()", e);
                        logger.error(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", (Throwable)e);
            logger.error((Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", (Throwable)e);
            logger.error((Throwable)e);
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        return true;
    }

    private void doFinish(IProgressMonitor monitor) throws CoreException, IOException, ModelException, JAXBException {
        monitor.beginTask(WorkbenchPlugin.labels.getString("WB002"), 1);
        String projectName = this.gefSegment.getDbGEFModel().getProjectName();
        this.marshallResource(projectName, this.gefSegment.getDbGEFModel().getDbdModel(), monitor);
        if (this.getWizAction() == 1 || this.getWizAction() == 2) {
            this.marshallResource(projectName, this.getSecondaryIxDbd(), monitor);
        } else {
            ProjectTreeFileHelper.deleteDbdMetadataFile((String)projectName, (String)this.selectedSecondaryIxDbd.getDBDName());
        }
        monitor.worked(1);
    }

    private LogicalChildModel getMetadataLchild(String xdfldName) {
        LogicalChildModel retVal = null;
        SegmentGEFModel gefSeg = this.getGefSegment();
        SegmentModel seg = gefSeg.getSegmentModel();
        List lchildList = seg.getLogicalChildList();
        if (lchildList != null && lchildList.size() > 0) {
            int i = 0;
            while (i < lchildList.size()) {
                LogicalChildModel lchild = (LogicalChildModel)lchildList.get(i);
                if (xdfldName.equalsIgnoreCase(lchild.getXdfldName())) {
                    retVal = lchild;
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    public SegmentModel getSourceSegment() {
        String srcSegName = this.page2.getSrcSeg();
        if (this.gefSegment.getSegmentName().equalsIgnoreCase(srcSegName)) {
            return this.gefSegment.getSegmentModel();
        }
        DbdModel dbd = this.gefSegment.getSegmentModel().getDbdModel();
        return dbd.getSegment(srcSegName);
    }

    public void newSecondaryIxWasSelected() {
        this.page2.newSecondaryIxWasSelected();
        this.page2a.newSecondaryIxWasSelected();
        this.page3.newSecondaryIxWasSelected();
        this.selectedLchild = null;
        this.selectedSecondaryIxDbd = null;
    }

    public DbdModel getSecondaryIxDbd() throws ModelException, CoreException {
        DbdModel retVal = null;
        if (this.getWizAction() == 1) {
            if (this.newSecondaryIxDbd == null) {
                this.newSecondaryIxDbd = new DbdModel(this.page2a.getIxDBDName());
                this.newSecondaryIxDbd.setAccessType(DbTypeType.INDEX.toString());
            }
            retVal = this.newSecondaryIxDbd;
        } else {
            if (this.selectedSecondaryIxDbd == null) {
                this.readInSecondaryIx();
            }
            retVal = this.selectedSecondaryIxDbd;
        }
        return retVal;
    }

    private void updateSecondaryIxDBD() throws ModelException, CoreException {
        DbdModel secondaryIxDbd = this.getSecondaryIxDbd();
        if (secondaryIxDbd.getAccessType() == null) {
            secondaryIxDbd.setAccessType(DbTypeType.INDEX.toString());
        }
        if (this.page2a.isWidgetsInitialized()) {
            secondaryIxDbd.setDbdName(this.page2a.getIxDBDName());
            secondaryIxDbd.getRootSegment().setImsName(this.page2a.getPointerSegName());
            secondaryIxDbd.getRootSegment().setName(this.page2a.getPointerSegName());
            secondaryIxDbd.setProt(this.page2a.getProt());
            secondaryIxDbd.setDoscomp(this.page2a.getDoscomp());
            secondaryIxDbd.setDatxexit(this.page2a.getDataXexit());
            secondaryIxDbd.setPassword(this.page2a.getPassword());
        }
    }

    public void resetDdataTable() {
        this.getLchild().clearDuplicateDataFields();
        if (this.page3.isWidgetsInitialized()) {
            this.page3.resetDdataTable();
        }
    }

    private void updateLchildWithUserInput(LogicalChildModel lChild) {
        Vector<String> ddataFields;
        Vector<String> subseqFields;
        if (this.getWizAction() == 1) {
            lChild.createXdfld();
            lChild.setXdfldName(this.page1.getNewXdfldName());
        }
        if (this.page2a.isWidgetsInitialized()) {
            lChild.setDbd(this.page2a.getIxDBDName());
            lChild.setName(this.page2a.getPointerSegName());
        }
        lChild.setPointer(DBDConstants.INDX);
        Vector<String> searchFields = this.page2.getCheckedSrchFields();
        if (searchFields != null && this.page2.isWidgetsInitialized()) {
            lChild.clearSearchFields();
            int i = 0;
            while (i < searchFields.size()) {
                lChild.addSearchField(searchFields.elementAt(i));
                ++i;
            }
        }
        if ((subseqFields = this.page2.getCheckedSubSeqFields()) != null && this.page2.isWidgetsInitialized()) {
            lChild.clearSubsequenceFields();
            if (subseqFields != null && this.page2.isWidgetsInitialized()) {
                int i = 0;
                while (i < subseqFields.size()) {
                    lChild.addSubsequenceField(subseqFields.elementAt(i));
                    ++i;
                }
            }
        }
        if ((ddataFields = this.page3.getDdataItems()) != null && this.page3.isWidgetsInitialized()) {
            lChild.clearDuplicateDataFields();
            int i = 0;
            while (i < ddataFields.size()) {
                lChild.addDuplicateDataField(ddataFields.elementAt(i));
                ++i;
            }
        }
        if (this.page2.isWidgetsInitialized()) {
            lChild.setXfldSourceSegment(this.page2.getSrcSeg());
        }
        if (this.page3.isWidgetsInitialized()) {
            lChild.setXfldIndexExitRoutine(this.page3.getExtRtn());
            lChild.setXfldNullval(this.page3.getNullVal());
            lChild.setXfldConst(this.page3.getConst());
        }
    }

    private void marshallResource(String projectName, DbdModel dbdModel, IProgressMonitor monitor) throws IOException, ModelException, CoreException {
        ByteArrayOutputStream dbdOutputStream = new ByteArrayOutputStream();
        dbdModel.marshall(dbdOutputStream);
        ByteArrayInputStream dbdInputStream = new ByteArrayInputStream(dbdOutputStream.toByteArray());
        IFile dbdMetadataFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdModel.getDBDName());
        if (!dbdMetadataFile.exists()) {
            dbdMetadataFile.create((InputStream)dbdInputStream, true, monitor);
        } else {
            dbdMetadataFile.setContents((InputStream)dbdInputStream, true, true, monitor);
        }
    }

    public void addPages() {
        try {
            this.page1 = new ManageSecondaryIxWizardPage1("SECINDEX1");
            this.page2 = new ManageSecondaryIxWizardPage2("SECINDEX2");
            this.page2a = new ManageSecondaryIxWizardPage2a("SECINDEX2A");
            this.page3 = new ManageSecondaryIxWizardPage3("SECINDEX3");
            this.addPage((IWizardPage)this.page1);
            this.addPage((IWizardPage)this.page2);
            this.addPage((IWizardPage)this.page2a);
            this.addPage((IWizardPage)this.page3);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }
}

