/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.wizards;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.wizards.ManageLogicalRelWizard;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;

public class ManageLogicalRelWizardPage1
extends WizardPage
implements Listener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Label labelDBDChild;
    private Label labelSeg;
    private Label labelDBDParent;
    private Text inputDBDChild;
    private Text inputSeg;
    private Text inputDBDParent;
    private Combo inputSegCombo;
    private Button browseBut;
    private Group logChildGrp;
    private Group logParentGrp;
    private UIHelper uih;
    private DbdModel lParentDbd = null;
    private String lParentSegName = null;
    public static final String PAGE_NAME = "LOGREL1";

    public ManageLogicalRelWizardPage1(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public ManageLogicalRelWizardPage1(String pageName) {
        super(PAGE_NAME);
        this.setTitle(WorkbenchPlugin.labels.getString("WB313"));
        this.uih = new UIHelper();
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            this.setPageComplete(false);
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            composite.setLayoutData((Object)fd);
            FormLayout logChildFL = new FormLayout();
            logChildFL.marginHeight = 5;
            logChildFL.marginWidth = 5;
            FormData logChildFD = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            this.logChildGrp = new Group(composite, 0);
            this.logChildGrp.setText(WorkbenchPlugin.labels.getString("WB314"));
            this.logChildGrp.setLayout((Layout)logChildFL);
            this.logChildGrp.setLayoutData((Object)logChildFD);
            logChildFD = this.uih.genFormData(new FormAttachment((Control)this.logChildGrp, 10), null, new FormAttachment(0, 0), null);
            this.labelDBDChild = this.uih.genLabel((Composite)this.logChildGrp, 16384, WorkbenchPlugin.labels.getString("WB022"), this.uih.black, logChildFD);
            logChildFD = this.uih.genFormData(new FormAttachment((Control)this.logChildGrp, 10), null, new FormAttachment((Control)this.labelDBDChild, 40), new FormAttachment(60, -40));
            this.inputDBDChild = this.uih.genTextField((Composite)this.logChildGrp, 2052, "", 8, logChildFD, (Listener)this, 24);
            this.inputDBDChild.setEditable(false);
            logChildFD = this.uih.genFormData(new FormAttachment((Control)this.labelDBDChild, 10), null, new FormAttachment(0, 0), null);
            this.labelSeg = this.uih.genLabel((Composite)this.logChildGrp, 16384, WorkbenchPlugin.labels.getString("WB315"), this.uih.black, logChildFD);
            logChildFD = this.uih.genFormData(new FormAttachment((Control)this.labelDBDChild, 10), null, new FormAttachment((Control)this.inputDBDChild, 0, 16384), new FormAttachment(60, -40));
            this.inputSeg = this.uih.genTextField((Composite)this.logChildGrp, 2052, "", 8, logChildFD, (Listener)this, 24);
            this.inputSeg.setEditable(false);
            FormLayout logParentFL = new FormLayout();
            logParentFL.marginHeight = 5;
            logParentFL.marginWidth = 5;
            FormData logParentFD = this.uih.genFormData(new FormAttachment((Control)this.logChildGrp, 10), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            this.logParentGrp = new Group(composite, 0);
            this.logParentGrp.setText(WorkbenchPlugin.labels.getString("WB316"));
            this.logParentGrp.setLayout((Layout)logParentFL);
            this.logParentGrp.setLayoutData((Object)logParentFD);
            logParentFD = this.uih.genFormData(new FormAttachment((Control)this.logParentGrp, 10), null, new FormAttachment(0, 0), null);
            this.labelDBDParent = this.uih.genLabel((Composite)this.logParentGrp, 16384, WorkbenchPlugin.labels.getString("WB022"), this.uih.black, logParentFD);
            logParentFD = this.uih.genFormData(new FormAttachment((Control)this.logChildGrp, 10), null, new FormAttachment((Control)this.labelDBDParent, 40), new FormAttachment(60, -40));
            this.inputDBDParent = this.uih.genTextField((Composite)this.logParentGrp, 2052, "", 8, logParentFD, (Listener)this, 24);
            this.inputDBDParent.setText(this.inputDBDParent.getText().toUpperCase());
            logParentFD = this.uih.genFormData(new FormAttachment((Control)this.logParentGrp, 10), null, new FormAttachment((Control)this.inputDBDParent, 20), new FormAttachment(100, -80));
            this.browseBut = new Button((Composite)this.logParentGrp, 8);
            this.computeButtonSize(this.browseBut);
            this.browseBut.setText(WorkbenchPlugin.labels.getString("WB512"));
            this.browseBut.setLayoutData((Object)logParentFD);
            this.browseBut.addSelectionListener((SelectionListener)this);
            logParentFD = this.uih.genFormData(new FormAttachment((Control)this.labelDBDParent, 10), null, new FormAttachment(0, 0), null);
            this.labelSeg = this.uih.genLabel((Composite)this.logParentGrp, 16384, WorkbenchPlugin.labels.getString("WB315"), this.uih.black, logParentFD);
            logParentFD = this.uih.genFormData(new FormAttachment((Control)this.labelDBDParent, 10), null, new FormAttachment((Control)this.inputDBDParent, 0, 16384), new FormAttachment(60, -40));
            this.inputSegCombo = new Combo((Composite)this.logParentGrp, 12);
            this.inputSegCombo.setLayoutData((Object)logParentFD);
            this.inputSegCombo.addSelectionListener((SelectionListener)this);
            this.setControl((Control)composite);
            this.initContents();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void initContents() {
        ManageLogicalRelWizard wiz = this.getWiz();
        SegmentGEFModel gefSeg = wiz.getGefSegment();
        this.inputDBDChild.setText(gefSeg.getDbGEFModel().getDbdName());
        this.inputSeg.setText(gefSeg.getSegmentName());
    }

    public void handleEvent(Event e) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "handleEvent(Event e)", new Object[]{e});
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "handleEvent(Event e)", new Object[0]);
        }
    }

    public DbdModel getLParentDbd() {
        return this.lParentDbd;
    }

    public String getLParentSegName() {
        return this.lParentSegName;
    }

    private void performBrowse() throws CoreException, ModelException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "performBrowse()", new Object[0]);
        }
        Shell shell = new Shell();
        ListDialog browseDialog = new ListDialog(shell);
        ManageLogicalRelWizard wiz = this.getWiz();
        String projectName = wiz.getGefSegment().getDbGEFModel().getProjectName();
        Vector dbdNames = ProjectTreeFileHelper.getDbdNamesInProject((String)projectName);
        browseDialog.setInput((Object)dbdNames);
        browseDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        browseDialog.setLabelProvider((ILabelProvider)new LabelProvider());
        int retCode = browseDialog.open();
        if (retCode == 0) {
            Object[] result = browseDialog.getResult();
            logger.info("DBD selected: " + String.valueOf(result[0]), new Object[0]);
            this.inputDBDParent.setText((String)result[0]);
            this.lParentDbd = ProjectTreeFileHelper.unmarshalDbd((String)((String)result[0]), (String)projectName);
            Vector segs = this.lParentDbd.getSegments();
            String[] items = new String[segs.size()];
            int i = 0;
            while (i < items.length) {
                items[i] = ((SegmentModel)segs.get(i)).getImsName();
                ++i;
            }
            this.inputSegCombo.setItems(items);
        }
        this.setPageComplete(this.validatePage());
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "performBrowse()", new Object[0]);
        }
    }

    private ManageLogicalRelWizard getWiz() {
        return (ManageLogicalRelWizard)this.getWizard();
    }

    private void computeButtonSize(Button button) {
        Point buttonSize = button.computeSize(-1, -1);
        button.setSize(buttonSize);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent event)", new Object[]{event});
        }
        try {
            if (event.widget == this.browseBut) {
                this.performBrowse();
            } else if (event.widget == this.inputSegCombo) {
                this.lParentSegName = this.inputSegCombo.getText();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", new Object[0]);
        }
    }

    private boolean validatePage() {
        boolean retVal = false;
        if (this.inputDBDParent.getText() != null && !this.inputDBDParent.getText().equals("")) {
            retVal = true;
        }
        return retVal;
    }
}

