/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.wizards;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.wizards.ManageLogicalRelWizardPage1;
import com.ibm.im.ims.workbench.editors.wizards.ManageLogicalRelWizardPage2;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ManageLogicalRelWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SegmentGEFModel gefSegment;
    private ManageLogicalRelWizardPage1 page1;
    private ManageLogicalRelWizardPage2 page2;

    public ManageLogicalRelWizard() {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB312"));
        this.setHelpAvailable(false);
    }

    public void setGefSegment(SegmentGEFModel gefSegment) {
        this.gefSegment = gefSegment;
    }

    public boolean performFinish() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        ManageLogicalRelWizard.this.doFinish(monitor);
                    }
                    catch (Throwable e) {
                        logger.throwing(this.getClass().getName(), "performFinish()", e);
                        logger.error(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", (Throwable)e);
            logger.error((Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", (Throwable)e);
            logger.error((Throwable)e);
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        return true;
    }

    private void doFinish(IProgressMonitor monitor) throws CoreException, IOException, ModelException, JAXBException {
        monitor.beginTask(WorkbenchPlugin.labels.getString("WB002"), 1);
        DbdModel lParentDbd = this.page1.getLParentDbd();
        String lParentSegName = this.page1.getLParentSegName();
        SegmentModel lParentSeg = lParentDbd.getSegment(lParentSegName);
        LogicalChildModel lchild = new LogicalChildModel();
        lchild.setDbd(this.gefSegment.getDbGEFModel().getDbdName());
        lchild.setName(this.gefSegment.getSegmentName());
        lchild.setPointer(DBDConstants.DBLE);
        lchild.setPair("dummy");
        lParentSeg.addLogicalChild(lchild);
        SegmentModel vlcSeg = new SegmentModel(lParentSeg, lParentDbd);
        vlcSeg.setName("dummy");
        vlcSeg.setImsName("dummy");
        vlcSeg.setSegmentSourceDbname(this.gefSegment.getDbGEFModel().getDbdName());
        vlcSeg.setSegmentSourceSegName(this.gefSegment.getSegmentName());
        vlcSeg.setSegmentSourceData(DBDConstants.Y);
        lParentSeg.addNewSegment(vlcSeg);
        SegmentModel lChildSeg = this.gefSegment.getSegmentModel();
        lChildSeg.setLogicalParentDbdName(lParentDbd.getDBDName());
        lChildSeg.setLogicalParentName(lParentSeg.getImsName());
        lChildSeg.setLogicalParentLpck(DBDConstants.VIRTUAL);
        lChildSeg.setLtwinbwd(DBDConstants.Y);
        String projectName = this.gefSegment.getDbGEFModel().getProjectName();
        this.marshallResource(projectName, lParentDbd, monitor);
        this.marshallResource(projectName, this.gefSegment.getDbGEFModel().getDbdModel(), monitor);
        monitor.worked(1);
    }

    public SegmentGEFModel getGefSegment() {
        return this.gefSegment;
    }

    private void marshallResource(String projectName, DbdModel dbdModel, IProgressMonitor monitor) throws IOException, ModelException, CoreException {
        ByteArrayOutputStream dbdOutputStream = new ByteArrayOutputStream();
        dbdModel.marshall(dbdOutputStream);
        ByteArrayInputStream dbdInputStream = new ByteArrayInputStream(dbdOutputStream.toByteArray());
        IFile dbdMetadataFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdModel.getDBDName());
        if (!dbdMetadataFile.exists()) {
            dbdMetadataFile.create((InputStream)dbdInputStream, true, monitor);
        } else {
            dbdMetadataFile.setContents((InputStream)dbdInputStream, true, true, monitor);
        }
    }

    public boolean canFinish() {
        boolean retVal = false;
        try {
            if (this.page1.isPageComplete()) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
        return retVal;
    }

    public void addPages() {
        try {
            this.page1 = new ManageLogicalRelWizardPage1("LOGREL1");
            this.page2 = new ManageLogicalRelWizardPage2("LOGREL2");
            this.addPage((IWizardPage)this.page1);
            this.addPage((IWizardPage)this.page2);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }
}

