/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.properties;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.utilities.DBDSourceGenerator;
import java.util.Vector;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class XdfldProperties
implements IPropertySource {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private LogicalChildModel logicalChildModel;
    private DBDConstants accessType;
    private static final String XDNAME = WorkbenchPlugin.labels.getString("WB304") + " " + WorkbenchPlugin.noxlatlabels.getString("WB001").substring(0, 6);
    private static final String SEGMENT = WorkbenchPlugin.labels.getString("WB463") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB447") + ")";
    private static final String CONST = WorkbenchPlugin.labels.getString("WB339") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB448") + ")";
    private static final String SRCH = WorkbenchPlugin.labels.getString("WB309") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB449") + ")";
    private static final String SUBSEQ = WorkbenchPlugin.labels.getString("WB329") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB450") + ")";
    private static final String DDATA = WorkbenchPlugin.labels.getString("WB330") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB451") + ")";
    private static final String NULLVAR = WorkbenchPlugin.labels.getString("WB327") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB452") + ")";
    private static final String EXTRTN = WorkbenchPlugin.labels.getString("WB328") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB453") + ")";
    private static final String REMARKS = WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")";

    public XdfldProperties(LogicalChildModel logicalChildModel, DBDConstants accessType) {
        this.logicalChildModel = logicalChildModel;
        this.accessType = accessType;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Vector<String> xdfldProperties = new Vector<String>();
        xdfldProperties.add(XDNAME);
        xdfldProperties.add(SEGMENT);
        xdfldProperties.add(SRCH);
        xdfldProperties.add(SUBSEQ);
        xdfldProperties.add(DDATA);
        xdfldProperties.add(NULLVAR);
        xdfldProperties.add(EXTRTN);
        xdfldProperties.add(REMARKS);
        if (this.accessType.equals((Object)DBDConstants.HSAM) || this.accessType.equals((Object)DBDConstants.HDAM) || this.accessType.equals((Object)DBDConstants.HIDAM)) {
            xdfldProperties.add(CONST);
        }
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[xdfldProperties.size()];
        PropertyDescriptor descriptor = null;
        int i = 0;
        while (i < xdfldProperties.size()) {
            descriptor = new PropertyDescriptor(xdfldProperties.get(i), (String)xdfldProperties.get(i));
            descriptor.setCategory(WorkbenchPlugin.labels.getString("WB484"));
            descriptors[i] = descriptor;
            ++i;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object property) {
        if (property.equals(XDNAME)) {
            return this.logicalChildModel.getXdfldName();
        }
        if (property.equals(SEGMENT)) {
            return this.logicalChildModel.getXfldSourceSegment();
        }
        if (property.equals(CONST)) {
            return this.logicalChildModel.getXfldConst();
        }
        if (property.equals(SRCH)) {
            return DBDSourceGenerator.getXdfldSRCHString((LogicalChildModel)this.logicalChildModel);
        }
        if (property.equals(SUBSEQ)) {
            return DBDSourceGenerator.getXdfldSUBSEQString((LogicalChildModel)this.logicalChildModel);
        }
        if (property.equals(DDATA)) {
            return DBDSourceGenerator.getXdfldDDATAString((LogicalChildModel)this.logicalChildModel);
        }
        if (property.equals(NULLVAR)) {
            return this.logicalChildModel.getXfldNullval();
        }
        if (property.equals(EXTRTN)) {
            return this.logicalChildModel.getXfldIndexExitRoutine();
        }
        if (property.equals(REMARKS)) {
            return this.logicalChildModel.getXdfld() != null ? this.logicalChildModel.getXdfld().getRemarks() : "";
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

