/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.properties;

import com.ibm.im.ims.metadata.dbd.RelType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.properties.LchildProperties;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.HidamDataSetModel;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.DBDSourceGenerator;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SegmentProperties
implements IPropertySource {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SegmentGEFModel segmentGEFModel;
    private HashMap<String, FieldGEFModel> fieldMap = new HashMap();
    private HashMap<String, LogicalChildModel> lchildMap = new HashMap();
    private String dd1;
    private String dd2;
    private String ovflw;
    private String block;
    private String size;
    private String record;
    private String recfm;
    private String scan;
    private String frspc;
    private String searcha;
    private String rel;
    private String label;
    private String device;
    private String remarks;
    private static final String[] sensegProperties = new String[]{WorkbenchPlugin.labels.getString("WB450") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB415") + ")", WorkbenchPlugin.labels.getString("WB451") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB433") + ")", WorkbenchPlugin.labels.getString("WB423") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB423") + ")", WorkbenchPlugin.labels.getString("WB452") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB434") + ")", WorkbenchPlugin.labels.getString("WB453") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB435") + ")"};
    private static final String NAME = WorkbenchPlugin.labels.getString("WB450") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB415") + ")";
    private static final String PARENT = WorkbenchPlugin.labels.getString("WB451") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB433") + ")";
    private static final String BYTES = WorkbenchPlugin.labels.getString("WB013A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB055").substring(0, 7);
    private static final String SOURCE = WorkbenchPlugin.labels.getString("WB463") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB437") + ")";
    private static final String FREQ = WorkbenchPlugin.labels.getString("WB474") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB438") + ")";
    private static final String POINTER = WorkbenchPlugin.labels.getString("WB475") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB439") + ")";
    private static final String RULES = WorkbenchPlugin.labels.getString("WB476") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB440") + ")";
    private static final String EXIT = WorkbenchPlugin.labels.getString("WB477") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB441") + ")";
    private static final String COMPRTN = WorkbenchPlugin.labels.getString("WB478") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB442") + ")";
    private static final String DSGROUP = WorkbenchPlugin.labels.getString("WB479") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB443") + ")";
    private static final String TYPE = WorkbenchPlugin.labels.getString("WB480") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB444") + ")";
    private static final String SSPTR = WorkbenchPlugin.labels.getString("WB481") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB434") + ")";
    private static final String ALIAS = WorkbenchPlugin.labels.getString("WB211") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB479") + ")";
    private static final String ENCODING = WorkbenchPlugin.labels.getString("WB027A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB477") + ")";
    private static final String REMARKS = WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")";
    private static final String LABEL = WorkbenchPlugin.labels.getString("WB495P");
    private static final String DATASET = WorkbenchPlugin.labels.getString("WB495") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB458") + ")";
    private static final String DD1 = WorkbenchPlugin.labels.getString("WB495A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB460") + ")";
    private static final String DEVICE = WorkbenchPlugin.labels.getString("WB052") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB461") + ")";
    private static final String DD2 = WorkbenchPlugin.labels.getString("WB495B") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB462") + ")";
    private static final String OVFLW = WorkbenchPlugin.labels.getString("WB495C") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB463") + ")";
    private static final String BLOCK = WorkbenchPlugin.labels.getString("WB495D") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB464") + ")";
    private static final String SIZE = WorkbenchPlugin.labels.getString("WB495E") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB465") + ")";
    private static final String RECORD = WorkbenchPlugin.labels.getString("WB495F") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB466") + ")";
    private static final String RECFM = WorkbenchPlugin.labels.getString("WB495G") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB467") + ")";
    private static final String SCAN = WorkbenchPlugin.labels.getString("WB495H") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB468") + ")";
    private static final String FRSPC = WorkbenchPlugin.labels.getString("WB495I") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB469") + ")";
    private static final String SEARCHA = WorkbenchPlugin.labels.getString("WB495J") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB470") + ")";
    private static final String REL = WorkbenchPlugin.labels.getString("WB495K") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB471") + ")";
    private static final String REMARKS1 = WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ") ";

    public SegmentProperties(SegmentGEFModel segmentGEFModel) {
        this.segmentGEFModel = segmentGEFModel;
        SegmentModel segmentModel = segmentGEFModel.getSegmentModel();
        DBDConstants accessType = segmentModel.getDbdModel().getAccessType();
        if (accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.HIDAM)) {
            this.label = segmentModel.getDatasetLabel();
            ArrayList hdamDatasets = segmentModel.getDbdModel().getHidamDataset();
            int i = 0;
            while (i < hdamDatasets.size()) {
                HidamDataSetModel datasetModel = (HidamDataSetModel)hdamDatasets.get(i);
                if (datasetModel.getLabel() != null && datasetModel.getLabel().equals(this.label) || datasetModel.getGeneratedLabel() != null && datasetModel.getGeneratedLabel().equals(this.label)) {
                    this.dd1 = datasetModel.getDdname1();
                    this.block = datasetModel.getSize0() >= 0 ? String.valueOf(datasetModel.getSize0()) : "";
                    this.size = datasetModel.getSize1() >= 0 ? String.valueOf(datasetModel.getSize1()) : "";
                    this.scan = datasetModel.getCyls() >= 0 ? String.valueOf(datasetModel.getCyls()) : "";
                    this.frspc = "(" + String.valueOf(datasetModel.getFbff()) + "," + String.valueOf(datasetModel.getFspf()) + ")";
                    this.searcha = String.valueOf(datasetModel.getSearcha());
                    this.device = datasetModel.getDevice();
                    this.remarks = datasetModel.getDataSet().getRemarks();
                    return;
                }
                ++i;
            }
        } else {
            DbdModel dbdModel = segmentModel.getDbdModel();
            this.dd1 = dbdModel.getDataSetDdname1();
            this.dd2 = dbdModel.getDdname2();
            this.ovflw = DBDSourceGenerator.getOVFLWString((DbdModel)dbdModel);
            this.block = DBDSourceGenerator.getBLOCKString((DbdModel)dbdModel);
            this.size = DBDSourceGenerator.getSizeString((DbdModel)dbdModel);
            this.record = DBDSourceGenerator.getRECORDString((DbdModel)dbdModel);
            if (dbdModel.getRecfm() != null) {
                this.recfm = dbdModel.getRecfm().value();
            }
            this.rel = this.getLongName(dbdModel);
            this.device = dbdModel.getDevice();
            this.remarks = dbdModel.getDatasetRemarks();
        }
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        try {
            SensegModel sensegModel = this.segmentGEFModel.getSenSeg();
            Vector<FieldGEFModel> fieldList = this.segmentGEFModel.getFieldsList();
            int numberOfFields = fieldList.size();
            if (!this.isPsb() || sensegModel == null) {
                try {
                    int j;
                    int length;
                    PropertyDescriptor descriptor;
                    SegmentModel segmentModel = this.segmentGEFModel.getSegmentModel();
                    final DBDConstants accessType = this.segmentGEFModel.getDbGEFModel().getDbdModel().getAccessType();
                    Vector<String> segmentProperties = new Vector<String>();
                    segmentProperties.add(ALIAS);
                    segmentProperties.add(NAME);
                    segmentProperties.add(ENCODING);
                    segmentProperties.add(REMARKS);
                    if (accessType.equals((Object)DBDConstants.MSDB)) {
                        segmentProperties.add(BYTES);
                    } else if (accessType.equals((Object)DBDConstants.LOGICAL)) {
                        segmentProperties.add(PARENT);
                        segmentProperties.add(SOURCE);
                    } else if (accessType.equals((Object)DBDConstants.PSINDEX)) {
                        segmentProperties.add(PARENT);
                        segmentProperties.add(BYTES);
                    } else if (accessType.equals((Object)DBDConstants.INDEX) || accessType.equals((Object)DBDConstants.HSAM)) {
                        segmentProperties.add(PARENT);
                        segmentProperties.add(BYTES);
                        segmentProperties.add(FREQ);
                    } else if (accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.HIDAM)) {
                        segmentProperties.add(PARENT);
                        if (segmentModel.getSegmentSourceSegName() == null) {
                            segmentProperties.add(BYTES);
                        } else {
                            segmentProperties.add(SOURCE);
                        }
                        segmentProperties.add(POINTER);
                        segmentProperties.add(RULES);
                        segmentProperties.add(EXIT);
                        segmentProperties.add(COMPRTN);
                    } else if (accessType.equals((Object)DBDConstants.HISAM) || accessType.equals((Object)DBDConstants.SHSAM) || accessType.equals((Object)DBDConstants.SHISAM)) {
                        segmentProperties.add(PARENT);
                        if (segmentModel.getSegmentSourceSegName() == null) {
                            segmentProperties.add(BYTES);
                        } else {
                            segmentProperties.add(SOURCE);
                        }
                        segmentProperties.add(FREQ);
                        segmentProperties.add(POINTER);
                        segmentProperties.add(RULES);
                        segmentProperties.add(EXIT);
                        segmentProperties.add(COMPRTN);
                    } else if (accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.PHIDAM)) {
                        segmentProperties.add(PARENT);
                        segmentProperties.add(BYTES);
                        segmentProperties.add(POINTER);
                        segmentProperties.add(RULES);
                        segmentProperties.add(EXIT);
                        segmentProperties.add(COMPRTN);
                        segmentProperties.add(DSGROUP);
                    } else if (accessType.equals((Object)DBDConstants.DEDB)) {
                        segmentProperties.add(PARENT);
                        segmentProperties.add(BYTES);
                        segmentProperties.add(RULES);
                        segmentProperties.add(EXIT);
                        segmentProperties.add(COMPRTN);
                        segmentProperties.add(TYPE);
                        segmentProperties.add(SSPTR);
                    }
                    Vector<String> datasetProperties = new Vector<String>();
                    datasetProperties.add(REMARKS1);
                    if (accessType != DBDConstants.DEDB && accessType != DBDConstants.PSINDEX && accessType != DBDConstants.PHDAM && accessType != DBDConstants.PHIDAM) {
                        if (accessType.equals((Object)DBDConstants.HSAM) || accessType.equals((Object)DBDConstants.SHSAM)) {
                            datasetProperties.add(DD1);
                            datasetProperties.add(DD2);
                            datasetProperties.add(BLOCK);
                            datasetProperties.add(RECORD);
                            datasetProperties.add(DEVICE);
                        } else if (accessType.equals((Object)DBDConstants.GSAM)) {
                            datasetProperties.add(DD1);
                            datasetProperties.add(DD2);
                            datasetProperties.add(BLOCK);
                            datasetProperties.add(RECORD);
                            datasetProperties.add(SIZE);
                            datasetProperties.add(RECFM);
                            datasetProperties.add(DEVICE);
                        } else if (accessType.equals((Object)DBDConstants.INDEX) || accessType.equals((Object)DBDConstants.HISAM) || accessType.equals((Object)DBDConstants.SHISAM)) {
                            datasetProperties.add(DD1);
                            datasetProperties.add(BLOCK);
                            datasetProperties.add(RECORD);
                            datasetProperties.add(SIZE);
                            datasetProperties.add(OVFLW);
                            datasetProperties.add(DEVICE);
                        } else if (accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.HIDAM)) {
                            datasetProperties.add(LABEL);
                            datasetProperties.add(DD1);
                            datasetProperties.add(BLOCK);
                            datasetProperties.add(SIZE);
                            datasetProperties.add(SCAN);
                            datasetProperties.add(FRSPC);
                            datasetProperties.add(SEARCHA);
                            datasetProperties.add(DEVICE);
                        } else if (accessType.equals((Object)DBDConstants.MSDB)) {
                            datasetProperties.add(REL);
                            datasetProperties.add(DEVICE);
                        } else if (accessType.equals((Object)DBDConstants.LOGICAL) && this.segmentGEFModel.getSegmentModel().getSegmentSourceData() != null) {
                            datasetProperties.add("");
                        }
                    }
                    int numberOfLchilds = segmentModel.getLogicalChildList().size();
                    IPropertyDescriptor[] descriptors = new IPropertyDescriptor[segmentProperties.size() + datasetProperties.size() + numberOfLchilds + numberOfFields];
                    int i = 0;
                    while (i < segmentProperties.size()) {
                        descriptor = new PropertyDescriptor(segmentProperties.get(i), (String)segmentProperties.get(i));
                        descriptor.setCategory("1 - " + WorkbenchPlugin.labels.getString("WB454") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB445") + ")");
                        descriptors[i] = descriptor;
                        ++i;
                    }
                    int prefix = 2;
                    if (datasetProperties.size() > 0) {
                        int j2 = 0;
                        while (j2 < datasetProperties.size()) {
                            descriptor = new PropertyDescriptor(datasetProperties.get(j2), (String)datasetProperties.get(j2));
                            descriptor.setCategory(String.valueOf(prefix) + " - " + DATASET + (String)(accessType.equals((Object)DBDConstants.LOGICAL) ? " " + String.valueOf(DBDConstants.LOGICAL) : ""));
                            descriptors[i] = descriptor;
                            descriptors[i++] = descriptor;
                            ++j2;
                        }
                        ++prefix;
                    }
                    String key = null;
                    if (numberOfLchilds > 0) {
                        length = String.valueOf(numberOfLchilds).length();
                        j = 0;
                        while (j < numberOfLchilds) {
                            final LogicalChildModel logicalChildModel = (LogicalChildModel)segmentModel.getLogicalChildList().get(j);
                            key = logicalChildModel.getName();
                            this.lchildMap.put(key, logicalChildModel);
                            descriptor = new PropertyDescriptor((Object)key, String.format(WorkbenchPlugin.labels.getString("WB493") + " %0" + String.valueOf(length) + "d", j + 1));
                            descriptor.setCategory(String.valueOf(prefix) + " - " + WorkbenchPlugin.labels.getString("WB488") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB454") + ")");
                            descriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                                public String getText(Object label) {
                                    String lchildName = DBDSourceGenerator.getLchildNAME((LogicalChildModel)logicalChildModel);
                                    if (accessType.equals((Object)DBDConstants.DEDB)) {
                                        lchildName = DBDSourceGenerator.getFPLchildNAME((LogicalChildModel)logicalChildModel);
                                    }
                                    return "[" + lchildName + "]";
                                }
                            });
                            descriptors[i++] = descriptor;
                            ++j;
                        }
                        ++prefix;
                    }
                    length = String.valueOf(numberOfFields).length();
                    j = 0;
                    while (j < numberOfFields) {
                        final FieldGEFModel fieldGEFModel = this.segmentGEFModel.getFieldsList().get(j);
                        key = fieldGEFModel.getIMSName();
                        if (key == null || key.isEmpty()) {
                            key = fieldGEFModel.getAlias();
                        }
                        this.fieldMap.put(key, fieldGEFModel);
                        descriptor = new PropertyDescriptor((Object)key, String.format(WorkbenchPlugin.labels.getString("WB458") + " %0" + String.valueOf(length) + "d", j + 1));
                        descriptor.setCategory(String.valueOf(prefix) + " - " + WorkbenchPlugin.labels.getString("WB456") + " " + WorkbenchPlugin.noxlatlabels.getString("WB051"));
                        descriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                            public String getText(Object label) {
                                if (fieldGEFModel.getAlias().indexOf("/") > -1) {
                                    return "[" + WorkbenchPlugin.labels.getString("WB473") + "]";
                                }
                                return "[" + fieldGEFModel.getStartPos() + " - " + (fieldGEFModel.getStartPos() + fieldGEFModel.getBytes() - 1) + "]";
                            }
                        });
                        descriptors[i++] = descriptor;
                        ++j;
                    }
                    return descriptors;
                }
                catch (Exception e) {
                    logger.throwing(this.getClass().getName(), "getPropertyDescriptors()", (Throwable)e);
                    logger.error((Throwable)e);
                }
            } else if (sensegModel != null) {
                PropertyDescriptor descriptor;
                IPropertyDescriptor[] descriptors = new IPropertyDescriptor[sensegProperties.length + numberOfFields];
                int i = 0;
                while (i < sensegProperties.length) {
                    descriptor = new PropertyDescriptor((Object)sensegProperties[i], sensegProperties[i]);
                    descriptor.setCategory("1 - " + WorkbenchPlugin.labels.getString("WB449") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB472") + ")");
                    descriptors[i] = descriptor;
                    ++i;
                }
                int length = String.valueOf(numberOfFields).length();
                int k = 1;
                int j = 0;
                while (j < this.segmentGEFModel.getFieldsList().size()) {
                    final FieldGEFModel fieldGEFModel = this.segmentGEFModel.getFieldsList().get(j);
                    if (fieldGEFModel != null && fieldGEFModel.isSenfld()) {
                        String key = fieldGEFModel.getIMSName();
                        if (key == null || key.length() == 0) {
                            key = fieldGEFModel.getAlias();
                        }
                        this.fieldMap.put(key, fieldGEFModel);
                        descriptor = new PropertyDescriptor((Object)key, String.format(WorkbenchPlugin.labels.getString("WB457") + " %0" + String.valueOf(length) + "d", k++));
                        descriptor.setCategory("2 - " + WorkbenchPlugin.labels.getString("WB455") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB473") + ")");
                        descriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                            public String getText(Object label) {
                                return "[" + fieldGEFModel.getStartPos() + " - " + (fieldGEFModel.getStartPos() + fieldGEFModel.getBytes() - 1) + "]";
                            }
                        });
                        descriptors[i] = descriptor;
                        if (i < descriptors.length - 1) {
                            ++i;
                        }
                    }
                    ++j;
                }
                return descriptors;
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "", e);
            logger.error(e);
        }
        return null;
    }

    public Object getPropertyValue(Object property) {
        SensegModel sensegModel = this.segmentGEFModel.getSenSeg();
        SegmentModel segmentModel = this.segmentGEFModel.getSegmentModel();
        int segType = this.segmentGEFModel.getSegmentType();
        if (!this.isPsb() || sensegModel == null) {
            if (property.equals(ALIAS)) {
                return segmentModel.getName();
            }
            if (property.equals(NAME)) {
                return segmentModel.getImsName();
            }
            if (property.equals(ENCODING)) {
                return segmentModel.getEncoding();
            }
            if (property.equals(REMARKS)) {
                return segmentModel.getRemarks();
            }
            if (property.equals(REMARKS1)) {
                return this.remarks;
            }
            if (property.equals(PARENT)) {
                return DBDSourceGenerator.getPARENTString((SegmentModel)segmentModel);
            }
            if (property.equals(BYTES)) {
                Object length = "VLC";
                if (segType == 2) {
                    int len1 = this.segmentGEFModel.getLogicalChildSourceGEFSegment().getSegLen();
                    length = String.valueOf(len1 += this.segmentGEFModel.getTargetParentSourceGEFSegment().getSegLen());
                } else {
                    int len1 = segmentModel.getMaxBytes();
                    if (len1 < 0) {
                        if (this.segmentGEFModel.getLogicalChildSourceGEFSegment() != null) {
                            len1 = this.segmentGEFModel.getLogicalChildSourceGEFSegment().getSegLen();
                        }
                        if (this.segmentGEFModel.getTargetParentSourceGEFSegment() != null) {
                            len1 += this.segmentGEFModel.getTargetParentSourceGEFSegment().getSegLen();
                        }
                        if (len1 < 0) {
                            len1 = 0;
                            int i = 0;
                            while (i < this.segmentGEFModel.getFieldsList().size()) {
                                len1 += this.segmentGEFModel.getFieldsList().get(i).getBytes();
                                ++i;
                            }
                        }
                        length = String.valueOf(len1);
                    } else {
                        length = segmentModel.getMinBytes() > 0 ? "(" + String.valueOf(len1) + "," + String.valueOf(segmentModel.getMinBytes()) + ")" : String.valueOf(len1);
                    }
                }
                return length;
            }
            if (property.equals(SOURCE)) {
                String sourceName = DBDSourceGenerator.getSOURCEString((SegmentModel)segmentModel);
                return sourceName.indexOf("null") > -1 ? "" : sourceName;
            }
            if (property.equals(FREQ)) {
                return DBDSourceGenerator.getFREQString((SegmentModel)segmentModel);
            }
            if (property.equals(POINTER)) {
                return DBDSourceGenerator.getPOINTERString((SegmentModel)segmentModel);
            }
            if (property.equals(RULES)) {
                return DBDSourceGenerator.getRULESString((SegmentModel)segmentModel);
            }
            if (property.equals(EXIT)) {
                return DBDSourceGenerator.getEXITString((SegmentModel)segmentModel);
            }
            if (property.equals(COMPRTN)) {
                return DBDSourceGenerator.getCOMPRTNString((SegmentModel)segmentModel);
            }
            if (property.equals(DSGROUP)) {
                return DBDSourceGenerator.getDSGROUPString((SegmentModel)segmentModel);
            }
            if (property.equals(TYPE)) {
                return DBDSourceGenerator.getTYPEString((SegmentModel)segmentModel);
            }
            if (property.equals(SSPTR)) {
                return DBDSourceGenerator.getSSPTRString((SegmentModel)segmentModel);
            }
            if (property.equals(DD1)) {
                return this.dd1;
            }
            if (property.equals(DD2)) {
                return this.dd2;
            }
            if (property.equals(LABEL)) {
                return this.label;
            }
            if (property.equals(OVFLW)) {
                return this.ovflw;
            }
            if (property.equals(BLOCK)) {
                return this.block;
            }
            if (property.equals(SIZE)) {
                return this.size;
            }
            if (property.equals(RECORD)) {
                return this.record;
            }
            if (property.equals(RECFM)) {
                return this.recfm;
            }
            if (property.equals(SCAN)) {
                return this.scan;
            }
            if (property.equals(FRSPC)) {
                return this.frspc;
            }
            if (property.equals(SEARCHA)) {
                return this.searcha;
            }
            if (property.equals(REL)) {
                return this.rel;
            }
            if (property.equals(DEVICE)) {
                return this.device;
            }
            LogicalChildModel logicalChildModel = this.lchildMap.get(property);
            if (logicalChildModel != null) {
                return new LchildProperties(logicalChildModel, segmentModel.getDbdModel().getAccessType());
            }
            FieldGEFModel field = this.fieldMap.get(property);
            if (field != null) {
                return this.segmentGEFModel.getFieldProperty(field, null);
            }
        } else if (sensegModel != null) {
            if (property.equals(sensegProperties[0])) {
                return sensegModel.getName();
            }
            if (property.equals(sensegProperties[1])) {
                return sensegModel.getParent() == null ? "0" : sensegModel.getParent().getName();
            }
            if (property.equals(sensegProperties[2])) {
                return sensegModel.getProcopt();
            }
            if (property.equals(sensegProperties[3])) {
                int numSsptrs = sensegModel.getSsptrListSize();
                if (numSsptrs > 0) {
                    Object returnValue = "(";
                    int i = 0;
                    while (i < numSsptrs) {
                        returnValue = (String)returnValue + "(" + (i + 1) + "," + sensegModel.getSsptrSensitivity(i) + ")";
                        if (i < numSsptrs - 1) {
                            returnValue = (String)returnValue + ",";
                        }
                        ++i;
                    }
                    returnValue = (String)returnValue + ")";
                    return returnValue;
                }
            } else if (property.equals(sensegProperties[4])) {
                List indices = sensegModel.getIndices();
                if (indices != null && indices.size() > 0) {
                    Object returnValue = "(";
                    int i = 0;
                    while (i < indices.size()) {
                        returnValue = (String)returnValue + (String)indices.get(i);
                        if (i < indices.size() - 1) {
                            returnValue = (String)returnValue + ",";
                        }
                        ++i;
                    }
                    returnValue = (String)returnValue + ")";
                    return returnValue;
                }
            } else {
                FieldGEFModel field = this.fieldMap.get(property);
                if (field != null) {
                    return this.segmentGEFModel.getFieldProperty(field, null);
                }
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    private String getLongName(DbdModel dbdModel) {
        Object longName = dbdModel.getRelType();
        if (longName != null) {
            Object fldnm = dbdModel.getRelFldnm();
            fldnm = fldnm == null ? "" : "," + (String)fldnm;
            if (((String)longName).equalsIgnoreCase(RelType.NO.value())) {
                longName = (String)longName + (String)fldnm + " (" + WorkbenchPlugin.labels.getString("WB495L") + ")";
            } else if (((String)longName).equalsIgnoreCase(RelType.TERM.value())) {
                longName = (String)longName + (String)fldnm + " (" + WorkbenchPlugin.labels.getString("WB495M") + ")";
            } else if (((String)longName).equalsIgnoreCase(RelType.FIXED.value())) {
                longName = (String)longName + (String)fldnm + " (" + WorkbenchPlugin.labels.getString("WB495N") + ")";
            } else if (((String)longName).equalsIgnoreCase(RelType.DYNAMIC.value())) {
                longName = (String)longName + (String)fldnm + " (" + WorkbenchPlugin.labels.getString("WB495O") + ")";
            }
        }
        return longName;
    }

    private boolean isPsb() {
        return this.segmentGEFModel.getDbGEFModel().isPsb();
    }
}

