/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.properties;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PcbProperties
implements IPropertySource {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private DbGEFModel dliPcbModel;
    private static final String[] properties = new String[]{WorkbenchPlugin.labels.getString("WB430") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB420") + ")", WorkbenchPlugin.labels.getString("WB422") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB422") + ")", WorkbenchPlugin.labels.getString("WB423") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB423") + ")", WorkbenchPlugin.labels.getString("WB425") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB425") + ")", WorkbenchPlugin.labels.getString("WB428") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB428") + ")", WorkbenchPlugin.labels.getString("WB424") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB424") + ")", WorkbenchPlugin.labels.getString("WB427") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB427") + ")", WorkbenchPlugin.labels.getString("WB429") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB429") + ")", WorkbenchPlugin.labels.getString("WB421") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB421") + ")"};

    public PcbProperties(DbGEFModel dliPcbModel) {
        this.dliPcbModel = dliPcbModel;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[properties.length];
        int i = 0;
        while (i < properties.length) {
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)properties[i], properties[i]);
            descriptor.setCategory(WorkbenchPlugin.labels.getString("WB432") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB432") + ")");
            descriptors[i] = descriptor;
            ++i;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object property) {
        PcbDBModel pcbModel = this.dliPcbModel.getPcbModel();
        if (property.equals(properties[0])) {
            return pcbModel.getPcbName() != null && pcbModel.getPcbName().length() > 0 ? pcbModel.getPcbName() : pcbModel.getLabel();
        }
        if (property.equals(properties[1])) {
            return pcbModel.getDbdName();
        }
        if (property.equals(properties[2])) {
            return pcbModel.getProcopt();
        }
        if (property.equals(properties[3])) {
            return pcbModel.getKeyLength();
        }
        if (property.equals(properties[4])) {
            return pcbModel.getProcSequence();
        }
        if (property.equals(properties[5])) {
            return this.getLongName(pcbModel.getSb());
        }
        if (property.equals(properties[6])) {
            return this.getLongName(pcbModel.getPos());
        }
        if (property.equals(properties[7])) {
            return pcbModel.getView() != null ? this.getLongName(DBDConstants.Y) : this.getLongName(DBDConstants.N);
        }
        if (property.equals(properties[8])) {
            return this.getLongName(pcbModel.getList());
        }
        return null;
    }

    private String getLongName(DBDConstants shortName) {
        if (shortName == null) {
            return "";
        }
        if (shortName.equals((Object)DBDConstants.Y)) {
            return WorkbenchPlugin.labels.getString("YES");
        }
        if (shortName.equals((Object)DBDConstants.N) || shortName.equals((Object)DBDConstants.NO)) {
            return WorkbenchPlugin.labels.getString("NO");
        }
        if (shortName.equals((Object)DBDConstants.S)) {
            return WorkbenchPlugin.labels.getString("SINGLE");
        }
        if (shortName.equals((Object)DBDConstants.M)) {
            return WorkbenchPlugin.labels.getString("MULTIPLE");
        }
        if (shortName.equals((Object)DBDConstants.COND)) {
            return WorkbenchPlugin.labels.getString("YES_CONDITIONALLY");
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

