/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.properties;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.properties.XdfldProperties;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.utilities.DBDSourceGenerator;
import java.util.Vector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class LchildProperties
implements IPropertySource {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private LogicalChildModel logicalChildModel;
    private DBDConstants accessType;
    private static final String NAME = WorkbenchPlugin.labels.getString("WB494") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB415") + ")";
    private static final String POINTER = WorkbenchPlugin.labels.getString("WB475") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB439") + ")";
    private static final String PAIR = WorkbenchPlugin.labels.getString("WB489") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB455") + ")";
    private static final String RULES = WorkbenchPlugin.labels.getString("WB490") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB440") + ")";
    private static final String INDEX = WorkbenchPlugin.labels.getString("WB491") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB456") + ")";
    private static final String RKSIZE = WorkbenchPlugin.labels.getString("WB492") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB457") + ")";
    private static final String XDNAME = WorkbenchPlugin.labels.getString("WB484") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB446") + ")";
    private static final String REMARKS = WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")";
    private static final String MULTISEG = WorkbenchPlugin.labels.getString("WB498T") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB482") + ")";

    public LchildProperties(LogicalChildModel logicalChildModel, DBDConstants accessType) {
        this.logicalChildModel = logicalChildModel;
        this.accessType = accessType;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Vector<String> lchildProperties = new Vector<String>();
        lchildProperties.add(NAME);
        lchildProperties.add(POINTER);
        lchildProperties.add(REMARKS);
        if (this.accessType.equals((Object)DBDConstants.HISAM) || this.accessType.equals((Object)DBDConstants.HDAM) || this.accessType.equals((Object)DBDConstants.PHDAM) || this.accessType.equals((Object)DBDConstants.PHIDAM) || this.accessType.equals((Object)DBDConstants.HIDAM)) {
            lchildProperties.add(PAIR);
            lchildProperties.add(RULES);
        } else if (this.accessType.equals((Object)DBDConstants.INDEX) || this.accessType.equals((Object)DBDConstants.PSINDEX)) {
            lchildProperties.add(INDEX);
            if (this.accessType.equals((Object)DBDConstants.PSINDEX)) {
                lchildProperties.add(RKSIZE);
            }
        } else if (this.accessType.equals((Object)DBDConstants.DEDB)) {
            lchildProperties.add(MULTISEG);
        }
        if (this.logicalChildModel.hasXdfld()) {
            lchildProperties.add(XDNAME);
        }
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[lchildProperties.size()];
        PropertyDescriptor descriptor = null;
        int i = 0;
        while (i < lchildProperties.size()) {
            descriptor = new PropertyDescriptor(lchildProperties.get(i), (String)lchildProperties.get(i));
            descriptor.setCategory(WorkbenchPlugin.labels.getString("WB488"));
            if (this.logicalChildModel.hasXdfld() && i == lchildProperties.size() - 1) {
                final String xdfldName = this.logicalChildModel.getXdfldName();
                descriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object label) {
                        return xdfldName == null ? "" : "[" + xdfldName + "]";
                    }
                });
            }
            descriptors[i] = descriptor;
            ++i;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object property) {
        if (property.equals(NAME)) {
            if (this.accessType.equals((Object)DBDConstants.DEDB)) {
                return DBDSourceGenerator.getFPLchildNAME((LogicalChildModel)this.logicalChildModel);
            }
            return DBDSourceGenerator.getLchildNAME((LogicalChildModel)this.logicalChildModel);
        }
        if (property.equals(POINTER)) {
            return this.logicalChildModel.getPointer();
        }
        if (property.equals(PAIR)) {
            return this.logicalChildModel.getPair();
        }
        if (property.equals(RULES)) {
            return this.logicalChildModel.getRules();
        }
        if (property.equals(INDEX)) {
            return this.logicalChildModel.getIndex();
        }
        if (property.equals(RKSIZE)) {
            return this.logicalChildModel.getRootKeySize();
        }
        if (property.equals(REMARKS)) {
            return this.logicalChildModel.getLchildRemarks();
        }
        if (property.equals(XDNAME)) {
            return new XdfldProperties(this.logicalChildModel, this.accessType);
        }
        if (property.equals(MULTISEG)) {
            return this.getLongName(this.logicalChildModel.getMultiSeg());
        }
        return null;
    }

    private String getLongName(String shortName) {
        if (shortName != null && !shortName.isEmpty()) {
            if (shortName.substring(0, 1).toUpperCase().equals("Y")) {
                return WorkbenchPlugin.labels.getString("YES");
            }
            return WorkbenchPlugin.labels.getString("NO");
        }
        return WorkbenchPlugin.labels.getString("NO");
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

