/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.properties;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.properties.FieldApplicationDataTypeProperties;
import com.ibm.im.ims.workbench.editors.properties.FieldPhysicalDataTypeProperties;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FieldProperties
implements IPropertySource {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected FieldGEFModel fieldGEFModel;
    private static final String[] properties = new String[]{WorkbenchPlugin.labels.getString("WB010A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB415") + ")", WorkbenchPlugin.labels.getString("WB011A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB052").substring(0, 5), WorkbenchPlugin.labels.getString("WB012A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB054").substring(0, 7), WorkbenchPlugin.labels.getString("WB013A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB055").substring(0, 7), WorkbenchPlugin.labels.getString("WB020A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB053").substring(0, 6), WorkbenchPlugin.labels.getString("WB004A"), WorkbenchPlugin.labels.getString("WB211") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB479") + ")", WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")", WorkbenchPlugin.labels.getString("WB017A"), WorkbenchPlugin.labels.getString("WB018A"), WorkbenchPlugin.labels.getString("WB027A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB477") + ")"};
    private static final String[] senfieldProperties = new String[]{WorkbenchPlugin.labels.getString("WB010A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB415") + ")", WorkbenchPlugin.labels.getString("WB012A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB054").substring(0, 7), WorkbenchPlugin.labels.getString("WB460") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB436") + ")", WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")"};
    private static final String[] fieldTypes = new String[]{WorkbenchPlugin.labels.getString("IMS_FIELD"), WorkbenchPlugin.labels.getString("USER_DEFINED_FIELD")};
    private String[] seqTypes = new String[]{DBDConstants.M.value() + " " + WorkbenchPlugin.descriptions.getString("WB08A"), DBDConstants.U.value() + " " + WorkbenchPlugin.descriptions.getString("WB07A")};
    public static int FIELD_IMS_NAME = 0;
    public static int FIELD_ALIAS = 1;
    public static int FIELD_START_POS = 2;
    public static int FIELD_LENGTH = 3;
    public static int FIELD_XML_TYPE = 4;
    public static int FIELD_JAVA_TYPE = 5;
    public static int FIELD_TYPE_QUALIFIER = 6;
    public static int DATABASE_NAME_LENGTH = 8;
    private static final String vfkProperties = WorkbenchPlugin.labels.getString("WB497A");
    private String category = null;

    public FieldProperties(FieldGEFModel fieldGEFModel) {
        this.fieldGEFModel = fieldGEFModel;
    }

    public FieldProperties(FieldGEFModel fieldGEFModel, String category) {
        this.fieldGEFModel = fieldGEFModel;
        this.category = category;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.fieldGEFModel.isSenfld()) {
            if (this.fieldGEFModel.isVirtualKey()) {
                IPropertyDescriptor[] descriptors = new IPropertyDescriptor[1];
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)vfkProperties, vfkProperties);
                descriptors[0] = descriptor;
                return descriptors;
            }
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[senfieldProperties.length];
            int i = 0;
            while (i < senfieldProperties.length) {
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)senfieldProperties[i], senfieldProperties[i]);
                if (this.category != null) {
                    descriptor.setCategory(this.category);
                }
                descriptors[i] = descriptor;
                ++i;
            }
            return descriptors;
        }
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[properties.length];
        int i = 0;
        while (i < properties.length) {
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)properties[i], properties[i]);
            if (this.category != null) {
                descriptor.setCategory(this.category);
            }
            if (i == 8 && this.fieldGEFModel.getAppDatatype() != null && (this.fieldGEFModel.getAppDatatype().equals("DATE") || this.fieldGEFModel.getAppDatatype().equals("TIME") || this.fieldGEFModel.getAppDatatype().equals("TIMESTAMP"))) {
                descriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object label) {
                        if (FieldProperties.this.fieldGEFModel.getIMSName().indexOf("/") > -1) {
                            return "";
                        }
                        return FieldProperties.this.fieldGEFModel.getAppDatatype();
                    }
                });
            } else if (i == 9 && this.fieldGEFModel.getPhysicalDataType() != null && (this.fieldGEFModel.getPhysicalDataType().equals("CHAR") || this.fieldGEFModel.getPhysicalDataType().equals("PACKEDDECIMAL") || this.fieldGEFModel.getPhysicalDataType().equals("ZONEDDECIMAL") || this.fieldGEFModel.getPhysicalDataType().equals("XML_CLOB") || this.fieldGEFModel.getPhysicalDataType().equals("USER"))) {
                descriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object label) {
                        if (FieldProperties.this.fieldGEFModel.getIMSName().indexOf("/") > -1) {
                            return "";
                        }
                        return FieldProperties.this.fieldGEFModel.getPhysicalDataType();
                    }
                });
            }
            descriptors[i] = descriptor;
            ++i;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object propName) {
        if (this.fieldGEFModel.isSenfld()) {
            if (this.fieldGEFModel.isVirtualKey()) {
                if (propName.equals(vfkProperties)) {
                    String vfkFieldName = this.fieldGEFModel.getAlias();
                    int index = vfkFieldName.lastIndexOf("_");
                    String segmentName = vfkFieldName.substring(0, index);
                    String fieldName = vfkFieldName.substring(index + 1);
                    Object[] messageArguments = new Object[]{vfkFieldName, fieldName, segmentName};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.descriptions.getString("WB447"));
                    return formatter.format(messageArguments);
                }
            } else {
                SenfieldModel senfieldModel = this.fieldGEFModel.getSenfld();
                if (senfieldModel != null) {
                    if (propName.equals(senfieldProperties[0])) {
                        return senfieldModel.getName();
                    }
                    if (propName.equals(senfieldProperties[1])) {
                        return senfieldModel.getStart();
                    }
                    if (propName.equals(senfieldProperties[2])) {
                        return this.getLongName(senfieldModel.getReplace());
                    }
                    if (propName.equals(senfieldProperties[3])) {
                        return senfieldModel.getRemarks();
                    }
                }
            }
        } else {
            FieldModel fieldModel = this.fieldGEFModel.getField();
            if (propName.equals(properties[0])) {
                return fieldModel.getImsName() != null ? fieldModel.getImsName() : "";
            }
            if (propName.equals(properties[1])) {
                if (fieldModel.getSeqType() == null) {
                    return "";
                }
                if (fieldModel.getSeqType().equals((Object)DBDConstants.M)) {
                    return this.seqTypes[0];
                }
                if (fieldModel.getSeqType().equals((Object)DBDConstants.U)) {
                    return this.seqTypes[1];
                }
            } else {
                if (propName.equals(properties[2])) {
                    if (fieldModel.getImsName().indexOf("/") > -1 && fieldModel.getStartPos() == 0) {
                        return "";
                    }
                    return fieldModel.getStartPos();
                }
                if (propName.equals(properties[3])) {
                    if (fieldModel.getImsName().indexOf("/") > -1 && fieldModel.getBytes() == 0) {
                        return "";
                    }
                    return fieldModel.getBytes() > 0 ? fieldModel.getBytes() : fieldModel.getMaxBytes();
                }
                if (propName.equals(properties[4])) {
                    if (fieldModel.getImsName().indexOf("/") > -1 || fieldModel.getImsDatatype() == null) {
                        return "";
                    }
                    if (fieldModel.getImsDatatype().equals((Object)DBDConstants.C)) {
                        return DBDConstants.C.toString() + " " + WorkbenchPlugin.descriptions.getString("WB11A");
                    }
                    if (fieldModel.getImsDatatype().equals((Object)DBDConstants.X)) {
                        return DBDConstants.X.toString() + " " + WorkbenchPlugin.descriptions.getString("WB09A");
                    }
                    if (fieldModel.getImsDatatype().equals((Object)DBDConstants.P)) {
                        return DBDConstants.P.toString() + " " + WorkbenchPlugin.descriptions.getString("WB10A");
                    }
                    if (fieldModel.getImsDatatype().equals((Object)DBDConstants.F)) {
                        return DBDConstants.F.toString() + " " + WorkbenchPlugin.descriptions.getString("WB13A");
                    }
                    if (fieldModel.getImsDatatype().equals((Object)DBDConstants.H)) {
                        return DBDConstants.H.toString() + " " + WorkbenchPlugin.descriptions.getString("WB12A");
                    }
                } else {
                    if (propName.equals(properties[5])) {
                        return fieldModel.getImsName() != null ? fieldTypes[0] : fieldTypes[1];
                    }
                    if (propName.equals(properties[6])) {
                        return fieldModel.getName();
                    }
                    if (propName.equals(properties[7])) {
                        return fieldModel.getRemarks();
                    }
                    if (propName.equals(properties[8])) {
                        if (fieldModel.getImsName().indexOf("/") > -1 || fieldModel.getAppDatatype() == null) {
                            return "";
                        }
                        if (fieldModel.getAppDatatype().equals((Object)DBDConstants.DATE) || fieldModel.getAppDatatype().equals((Object)DBDConstants.TIME) || fieldModel.getAppDatatype().equals((Object)DBDConstants.TIMESTAMP)) {
                            return new FieldApplicationDataTypeProperties(fieldModel);
                        }
                        return fieldModel.getAppDatatype().value();
                    }
                    if (propName.equals(properties[9])) {
                        if (fieldModel.getImsName().indexOf("/") > -1 || fieldModel.getPhysicalDataType() == null) {
                            return "";
                        }
                        if (fieldModel.getPhysicalDataType().equals((Object)DBDConstants.CHAR) || fieldModel.getPhysicalDataType().equals((Object)DBDConstants.PACKEDDECIMAL) || fieldModel.getPhysicalDataType().equals((Object)DBDConstants.ZONEDDECIMAL) || fieldModel.getPhysicalDataType().equals((Object)DBDConstants.XML_CLOB) || fieldModel.getPhysicalDataType().equals((Object)DBDConstants.USER)) {
                            return new FieldPhysicalDataTypeProperties(fieldModel);
                        }
                        return fieldModel.getPhysicalDataType().value();
                    }
                    if (propName.equals(properties[10])) {
                        return fieldModel.getEncoding();
                    }
                }
            }
        }
        return null;
    }

    private String getLongName(DBDConstants shortName) {
        if (shortName.equals((Object)DBDConstants.Y)) {
            return WorkbenchPlugin.labels.getString("YES");
        }
        if (shortName.equals((Object)DBDConstants.N) || shortName.equals((Object)DBDConstants.NO)) {
            return WorkbenchPlugin.labels.getString("NO");
        }
        return "";
    }

    public boolean isPropertySet(Object propName) {
        return false;
    }

    public void resetPropertyValue(Object propName) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

