/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.properties;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FieldPhysicalDataTypeProperties
implements IPropertySource {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String[] properties1 = new String[]{WorkbenchPlugin.labels.getString("WB027A"), "DBCS"};
    private static final String[] properties2 = new String[]{WorkbenchPlugin.labels.getString("WB028A"), WorkbenchPlugin.labels.getString("WB029A")};
    private static final String[] properties3 = new String[]{WorkbenchPlugin.labels.getString("WB030A"), WorkbenchPlugin.labels.getString("WB032A")};
    private static final String[] properties4 = new String[]{WorkbenchPlugin.labels.getString("WB023A"), WorkbenchPlugin.labels.getString("WB024A"), WorkbenchPlugin.labels.getString("WB025A"), WorkbenchPlugin.labels.getString("WB026A")};
    private FieldModel fieldModel = null;

    public FieldPhysicalDataTypeProperties(FieldModel fieldModel) {
        this.fieldModel = fieldModel;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.CHAR)) {
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[properties1.length];
            int i = 0;
            while (i < properties1.length) {
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)properties1[i], properties1[i]);
                descriptor.setCategory(this.fieldModel.getPhysicalDataType().value());
                descriptors[i] = descriptor;
                ++i;
            }
            return descriptors;
        }
        if (this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.XML_CLOB)) {
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[properties2.length];
            int i = 0;
            while (i < properties2.length) {
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)properties2[i], properties2[i]);
                descriptor.setCategory(this.fieldModel.getPhysicalDataType().value());
                descriptors[i] = descriptor;
                ++i;
            }
            return descriptors;
        }
        if (this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.USER)) {
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[properties3.length];
            int i = 0;
            while (i < properties3.length) {
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)properties3[i], properties3[i]);
                descriptor.setCategory(this.fieldModel.getPhysicalDataType().value());
                descriptors[i] = descriptor;
                ++i;
            }
            return descriptors;
        }
        if (this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.PACKEDDECIMAL) || this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.ZONEDDECIMAL)) {
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[properties4.length];
            int i = 0;
            while (i < properties4.length) {
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)properties4[i], properties4[i]);
                descriptor.setCategory(this.fieldModel.getPhysicalDataType().value());
                descriptors[i] = descriptor;
                ++i;
            }
            return descriptors;
        }
        return null;
    }

    public Object getPropertyValue(Object property) {
        if (this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.CHAR)) {
            if (property.equals(properties1[0])) {
                return this.fieldModel.getEncoding();
            }
            if (property.equals(properties1[1])) {
                if (this.fieldModel.getIsDbcs() == DBDConstants.Y) {
                    return WorkbenchPlugin.labels.getString("YES");
                }
                return WorkbenchPlugin.labels.getString("NO");
            }
        } else if (this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.XML_CLOB)) {
            if (property.equals(properties2[0])) {
                return this.fieldModel.getUrl();
            }
            if (property.equals(properties2[1])) {
                return this.fieldModel.getOverflow();
            }
        } else if (this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.USER)) {
            if (property.equals(properties3[0])) {
                return this.fieldModel.getUserTypeConverter();
            }
            if (property.equals(properties3[1])) {
                Object properties = "";
                int i = 0;
                while (i < this.fieldModel.getPropertyListSize()) {
                    String currentProperty = this.fieldModel.getPropertyName(i) + "=" + this.fieldModel.getPropertyValue(i);
                    properties = (String)properties + currentProperty;
                    if (i < this.fieldModel.getPropertyListSize() - 1) {
                        properties = (String)properties + ",";
                    }
                    ++i;
                }
                return properties;
            }
        } else if (this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.PACKEDDECIMAL) || this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.ZONEDDECIMAL)) {
            if (property.equals(properties4[0])) {
                return this.fieldModel.getPrecision();
            }
            if (property.equals(properties4[1])) {
                return this.fieldModel.getScale();
            }
            if (property.equals(properties4[2])) {
                return this.getLongName(this.fieldModel.getIsSigned());
            }
            if (property.equals(properties4[3])) {
                return this.getLongName(DBDConstants.Y);
            }
        }
        return null;
    }

    private String getLongName(DBDConstants shortName) {
        if (shortName.equals((Object)DBDConstants.Y)) {
            return WorkbenchPlugin.labels.getString("YES");
        }
        if (shortName.equals((Object)DBDConstants.N) || shortName.equals((Object)DBDConstants.NO)) {
            return WorkbenchPlugin.labels.getString("NO");
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

