/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.properties;

import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.properties.AreaProperties;
import com.ibm.im.ims.workbench.model.AreaStmt;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.DBDSourceGenerator;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class DbdProperties
implements IPropertySource {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private DbGEFModel dbdGEFModel;
    private HashMap<String, AreaStmt> areaMap = new HashMap();
    private static final String NAME = WorkbenchPlugin.labels.getString("WB022") + " " + WorkbenchPlugin.noxlatlabels.getString("WB001").substring(0, 6);
    private static final String ACCESS = WorkbenchPlugin.labels.getString("WB023") + " " + WorkbenchPlugin.noxlatlabels.getString("WB002").substring(0, 8);
    private static final String DATXEXIT = WorkbenchPlugin.labels.getString("WB019") + " " + WorkbenchPlugin.noxlatlabels.getString("WB011").substring(0, 19);
    private static final String PASSWD = WorkbenchPlugin.labels.getString("WB027") + " " + WorkbenchPlugin.noxlatlabels.getString("WB003").substring(0, 8);
    private static final String VERSION = WorkbenchPlugin.labels.getString("WB003") + " " + WorkbenchPlugin.noxlatlabels.getString("WB004").substring(0, 9);
    private static final String EXIT = WorkbenchPlugin.labels.getString("WB028") + " " + WorkbenchPlugin.noxlatlabels.getString("WB005");
    private static final String RMNAME = WorkbenchPlugin.labels.getString("WB041") + " " + WorkbenchPlugin.noxlatlabels.getString("WB007").substring(0, 8);
    private static final String PSNAME = WorkbenchPlugin.labels.getString("WB018") + " " + WorkbenchPlugin.noxlatlabels.getString("WB006").substring(0, 8);
    private static final String ENCODING = WorkbenchPlugin.labels.getString("WB027A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB477") + ")";
    private static final String REMARKS = WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")";
    private static final String DBVER = WorkbenchPlugin.labels.getString("WB120") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB500") + ")";
    private static final String TIMESTAMP = WorkbenchPlugin.labels.getString("WB121");

    public DbdProperties(DbGEFModel dbdGEFModel) {
        this.dbdGEFModel = dbdGEFModel;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        DbdModel dbdModel = this.dbdGEFModel.getDbdModel();
        DBDConstants accessType = dbdModel.getAccessType();
        String prefix = "";
        int numberOfAreas = 0;
        Vector<String> dbdProperties = new Vector<String>();
        dbdProperties.add(NAME);
        dbdProperties.add(TIMESTAMP);
        dbdProperties.add(ACCESS);
        dbdProperties.add(ENCODING);
        dbdProperties.add(REMARKS);
        try {
            PropertyDescriptor descriptor;
            if (accessType.equals((Object)DBDConstants.HIDAM) || accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.PHIDAM) || accessType.equals((Object)DBDConstants.DEDB)) {
                dbdProperties.add(DBVER);
            }
            if (accessType.equals((Object)DBDConstants.HSAM)) {
                dbdProperties.add(DATXEXIT);
            } else if (accessType.equals((Object)DBDConstants.INDEX) || accessType.equals((Object)DBDConstants.PSINDEX) || accessType.equals((Object)DBDConstants.GSAM)) {
                dbdProperties.add(DATXEXIT);
                dbdProperties.add(PASSWD);
            } else if (accessType.equals((Object)DBDConstants.HIDAM) || accessType.equals((Object)DBDConstants.HISAM) || accessType.equals((Object)DBDConstants.SHSAM) || accessType.equals((Object)DBDConstants.SHISAM)) {
                dbdProperties.add(DATXEXIT);
                dbdProperties.add(PASSWD);
                dbdProperties.add(EXIT);
                dbdProperties.add(VERSION);
            } else if (accessType.equals((Object)DBDConstants.DEDB)) {
                dbdProperties.add(EXIT);
                dbdProperties.add(VERSION);
                dbdProperties.add(RMNAME);
                if (dbdModel.getAreaList() != null) {
                    prefix = "1 - ";
                    numberOfAreas = dbdModel.getAreaList().size();
                }
            } else if (accessType.equals((Object)DBDConstants.HDAM)) {
                dbdProperties.add(DATXEXIT);
                dbdProperties.add(PASSWD);
                dbdProperties.add(EXIT);
                dbdProperties.add(VERSION);
                dbdProperties.add(RMNAME);
            } else if (accessType.equals((Object)DBDConstants.PHDAM)) {
                dbdProperties.add(DATXEXIT);
                dbdProperties.add(PASSWD);
                dbdProperties.add(EXIT);
                dbdProperties.add(VERSION);
                dbdProperties.add(RMNAME);
                dbdProperties.add(PSNAME);
            } else if (accessType.equals((Object)DBDConstants.PHIDAM)) {
                dbdProperties.add(DATXEXIT);
                dbdProperties.add(PASSWD);
                dbdProperties.add(EXIT);
                dbdProperties.add(VERSION);
                dbdProperties.add(PSNAME);
            }
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[dbdProperties.size() + numberOfAreas];
            int i = 0;
            i = 0;
            while (i < dbdProperties.size()) {
                descriptor = new PropertyDescriptor(dbdProperties.get(i), (String)dbdProperties.get(i));
                descriptor.setCategory(prefix + WorkbenchPlugin.labels.getString("WB448"));
                descriptors[i] = descriptor;
                ++i;
            }
            if (accessType.equals((Object)DBDConstants.DEDB) && numberOfAreas > 0) {
                int length = String.valueOf(numberOfAreas).length();
                int j = 0;
                while (j < numberOfAreas) {
                    AreaStmt areaStmt = (AreaStmt)dbdModel.getAreaList().get(j);
                    final String key = areaStmt.getDd1();
                    this.areaMap.put(key, areaStmt);
                    descriptor = new PropertyDescriptor((Object)key, String.format(WorkbenchPlugin.labels.getString("WB483") + " %0" + String.valueOf(length) + "d", j + 1));
                    descriptor.setCategory("2 - " + WorkbenchPlugin.labels.getString("WB482") + " " + WorkbenchPlugin.noxlatlabels.getString("WB018"));
                    descriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                        public String getText(Object label) {
                            return "[" + key + "]";
                        }
                    });
                    descriptors[i++] = descriptor;
                    ++j;
                }
            }
            return descriptors;
        }
        catch (Exception e) {
            logger.throwing(this.getClass().getName(), "getPropertyDescriptors()", (Throwable)e);
            logger.error((Throwable)e);
            return null;
        }
    }

    public Object getPropertyValue(Object property) {
        DbdModel dbdModel = this.dbdGEFModel.getDbdModel();
        if (property.equals(NAME)) {
            return dbdModel.getDBDName();
        }
        if (property.equals(ACCESS)) {
            return DBDSourceGenerator.getACCESSString((DbdModel)dbdModel);
        }
        if (property.equals(ENCODING)) {
            String encoding = dbdModel.getEncoding();
            if ((encoding == null || encoding.isEmpty()) && ((encoding = WorkbenchPlugin.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection")) == null || encoding.isEmpty())) {
                encoding = "Cp1047";
            }
            return encoding;
        }
        if (property.equals(REMARKS)) {
            return dbdModel.getRemarks();
        }
        if (property.equals(DATXEXIT)) {
            return this.getLongName(dbdModel.getDatxexit());
        }
        if (property.equals(PASSWD)) {
            return this.getLongName(dbdModel.getPassword());
        }
        if (property.equals(VERSION)) {
            return dbdModel.getVersion();
        }
        if (property.equals(EXIT)) {
            return DBDSourceGenerator.getDBDEXITString((DbdModel)dbdModel);
        }
        if (property.equals(RMNAME)) {
            if (dbdModel.getAccessType().equals((Object)DBDConstants.DEDB)) {
                return DBDSourceGenerator.getDedbRMNAMEString((DbdModel)dbdModel);
            }
            return DBDSourceGenerator.getHdamRMNAMEString((DbdModel)dbdModel);
        }
        if (property.equals(PSNAME)) {
            try {
                return dbdModel.getPsname();
            }
            catch (Exception exception) {
                return "";
            }
        }
        if (property.equals(DBVER)) {
            return dbdModel.getUserVersion();
        }
        if (property.equals(TIMESTAMP)) {
            String ts = dbdModel.getTimestamp();
            if (ts == null || ts.isEmpty()) {
                return ts;
            }
            return this.convertTimeStamp(dbdModel.getTimestamp());
        }
        AreaStmt areaStmt = this.areaMap.get(property);
        if (areaStmt != null) {
            return new AreaProperties(areaStmt);
        }
        return null;
    }

    private String getLongName(YesnoType shortName) {
        if (shortName != null) {
            if (shortName.equals((Object)YesnoType.Y)) {
                return WorkbenchPlugin.labels.getString("YES");
            }
            return WorkbenchPlugin.labels.getString("NO");
        }
        return "";
    }

    private String convertTimeStamp(String ts) {
        String retVal = "";
        try {
            Date date = new SimpleDateFormat("yyDDDHHmmssSS").parse(ts);
            retVal = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault()).format(date);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return retVal;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

