/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.properties;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.ConnectionGEFModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.SegmentModel;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ConnectionProperties
implements IPropertySource {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ConnectionGEFModel connectionModel;
    private static final String[] properties = new String[]{WorkbenchPlugin.labels.getString("WB485"), WorkbenchPlugin.labels.getString("WB486"), WorkbenchPlugin.labels.getString("WB465")};

    public ConnectionProperties(ConnectionGEFModel connectionModel) {
        this.connectionModel = connectionModel;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[properties.length];
        int i = 0;
        while (i < properties.length) {
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)properties[i], properties[i]);
            descriptor.setCategory(WorkbenchPlugin.labels.getString("WB464"));
            descriptors[i] = descriptor;
            ++i;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object property) {
        if (property.equals(properties[0])) {
            return this.connectionModel.getParent().getSegmentName();
        }
        if (property.equals(properties[1])) {
            return this.connectionModel.getChild().getSegmentName();
        }
        if (property.equals(properties[2])) {
            SegmentModel segmentModel = this.connectionModel.getChild().getSegmentModel();
            if (segmentModel.getPaired() == DBDConstants.Y) {
                return WorkbenchPlugin.labels.getString("WB467");
            }
            if (segmentModel.getPaired() == DBDConstants.N && segmentModel.getLogicalPointer() == null) {
                return WorkbenchPlugin.labels.getString("WB466");
            }
            if (segmentModel.getLogicalPointer() == DBDConstants.LTWIN || segmentModel.getLogicalPointer() == DBDConstants.LTWINBWD) {
                return WorkbenchPlugin.labels.getString("WB468");
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

