/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.properties;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.AreaStmt;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class AreaProperties
implements IPropertySource {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AreaStmt areaStmt;
    private static final String DD1 = WorkbenchPlugin.labels.getString("WB051") + " " + WorkbenchPlugin.noxlatlabels.getString("WB019").substring(0, 5);
    private static final String DEVICE = WorkbenchPlugin.labels.getString("WB052") + " " + WorkbenchPlugin.noxlatlabels.getString("WB020").substring(0, 8);
    private static final String SIZE = WorkbenchPlugin.labels.getString("WB053") + " " + WorkbenchPlugin.noxlatlabels.getString("WB021").substring(0, 6);
    private static final String UOW = WorkbenchPlugin.labels.getString("WB055") + " " + WorkbenchPlugin.noxlatlabels.getString("WB022");
    private static final String ROOT = WorkbenchPlugin.labels.getString("WB057") + " " + WorkbenchPlugin.noxlatlabels.getString("WB025");
    private static final String REMARKS = WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")";
    private static final String[] properties = new String[]{DD1, DEVICE, SIZE, UOW, ROOT, REMARKS};

    public AreaProperties(AreaStmt areaStmt) {
        this.areaStmt = areaStmt;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[properties.length];
        int i = 0;
        while (i < properties.length) {
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)properties[i], properties[i]);
            descriptors[i] = descriptor;
            ++i;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object property) {
        if (property.equals(DD1)) {
            return this.areaStmt.getDd1();
        }
        if (property.equals(DEVICE)) {
            return this.areaStmt.getDevice();
        }
        if (property.equals(SIZE)) {
            return this.areaStmt.getSize();
        }
        if (property.equals(ROOT)) {
            return "(" + this.areaStmt.getRootNumber2() + "," + this.areaStmt.getRootOverflow2() + ")";
        }
        if (property.equals(UOW)) {
            return "(" + this.areaStmt.getUowNumber1() + "," + this.areaStmt.getUowOverflow1() + ")";
        }
        if (property.equals(REMARKS)) {
            return this.areaStmt.getJaxbArea() != null ? this.areaStmt.getJaxbArea().getRemarks() : "";
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

