/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.preferences;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class GetNodePreferences {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<String, Color> nameToColorMap = new HashMap<String, Color>();
    private static Map<String, Font> nameToFontMap = new HashMap<String, Font>();

    public static Color fetchPreferenceColor(String colorKey) {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        String colorName = store.getString(colorKey);
        Color color = nameToColorMap.get(colorName);
        if (color == null) {
            if (colorName == null || colorName.isEmpty()) {
                color = new Color(null, 128, 128, 128);
            } else {
                RGB rgb = StringConverter.asRGB((String)colorName);
                color = new Color(null, rgb);
            }
            nameToColorMap.put(colorName, color);
        }
        return color;
    }

    public static Font fetchPreferenceFont(String fontKey) {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)store, (String)fontKey);
        Font font = nameToFontMap.get(fontKey);
        if (font == null) {
            font = new Font(null, fontData);
            nameToFontMap.put(fontKey, font);
        }
        return font;
    }

    public static void dispose() {
        for (Color color : nameToColorMap.values()) {
            color.dispose();
        }
        nameToColorMap.clear();
        for (Font font : nameToFontMap.values()) {
            font.dispose();
        }
        nameToFontMap.clear();
    }
}

