/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.preferences;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EnWPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
    private Table warningsTable;
    private Button selectAllButton;
    private Button deselectAllButton;
    private static final String PREFIX = "PPEW_";
    public static final String EDITORS_READ_ONLY = "EDITORS_READ_ONLY";
    public static final String WFM_DS_IMPORT_WARNING = "WFM_DS_IMPORT_WARNING";
    public static final String EDITORS_SENSEG_WARNING = "EDITORS_SENSEG_WARNING";
    public static final String DDL_SUCCESSFULLY_RAN = "DDL_SUCCESSFULLY_RAN";
    public static final String GSAM_NO_SEGM = "GSAM_NO_SEGM";
    String[] indices = new String[]{"EDITORS_READ_ONLY", "WFM_DS_IMPORT_WARNING", "EDITORS_SENSEG_WARNING", "DDL_SUCCESSFULLY_RAN", "GSAM_NO_SEGM", "MISSING_CONV_INFO", "SEGS_WITHOUT_USER_FIELDS", "BAD_PSB_NAME", "BAD_PCB_NAME", "PCB_WITHOUT_NAME", "PSB_MISSING_DBD", "FIELDS_DO_NOT_FIT", "NO_PCBS_HAVE_NAMES", "ALL_DBDS_MISSING"};

    public EnWPreferencesPage() {
        this.setPreferenceStore(this.store);
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(1808);
        Composite top = new Composite(parent, 0);
        top.setLayoutData((Object)gridData);
        top.setLayout((Layout)layout);
        Group warningsGroup = new Group(top, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        warningsGroup.setLayout((Layout)layout);
        gridData = new GridData(1808);
        warningsGroup.setLayoutData((Object)gridData);
        warningsGroup.setText(WorkbenchPlugin.labels.getString("PPEW_GROUP_TITLE"));
        this.warningsTable = new Table((Composite)warningsGroup, 2848);
        gridData = new GridData(768);
        this.warningsTable.setLayoutData((Object)gridData);
        this.warningsTable.setHeaderVisible(true);
        String[] columnLabels = new String[]{WorkbenchPlugin.labels.getString("PPEW_COLUMN_NAME")};
        this.setColumns(this.warningsTable, columnLabels);
        this.populateWarningsTable();
        this.createButtons((Composite)warningsGroup);
        return top;
    }

    private void createButtons(Composite parent) {
        Composite buttonPanel = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        buttonPanel.setLayout((Layout)gl);
        int[] labelSizes = new int[]{Utility.getTextWidth((Composite)parent, (int)0, (String)WorkbenchPlugin.labels.getString("PPEW_SELECT_ALL")), Utility.getTextWidth((Composite)parent, (int)0, (String)WorkbenchPlugin.labels.getString("PPEW_DESELECT_ALL"))};
        int buttonWidth = Utility.getMaxSize((int[])labelSizes) + 5;
        GridData gd = new GridData(2);
        gd.widthHint = buttonWidth;
        this.selectAllButton = new Button(buttonPanel, 0);
        this.selectAllButton.setText(WorkbenchPlugin.labels.getString("PPEW_SELECT_ALL"));
        this.selectAllButton.addSelectionListener((SelectionListener)this);
        this.selectAllButton.setLayoutData((Object)gd);
        gd = new GridData(2);
        gd.widthHint = buttonWidth;
        this.deselectAllButton = new Button(buttonPanel, 0);
        this.deselectAllButton.setText(WorkbenchPlugin.labels.getString("PPEW_DESELECT_ALL"));
        this.deselectAllButton.addSelectionListener((SelectionListener)this);
        this.deselectAllButton.setLayoutData((Object)gd);
    }

    private void populateWarningsTable() {
        int i = 0;
        while (i < this.indices.length) {
            String currWarnTypeStr = this.indices[i];
            TableItem ti = new TableItem(this.warningsTable, 0);
            ti.setText(WorkbenchPlugin.noxlatlabels.getString("EAWC_" + currWarnTypeStr) + " - " + WorkbenchPlugin.errors.getString(PREFIX + currWarnTypeStr) + ".");
            boolean currBool = this.store.getBoolean(currWarnTypeStr);
            ti.setChecked(currBool);
            ++i;
        }
        TableColumn[] cols = this.warningsTable.getColumns();
        int i2 = 0;
        while (i2 < cols.length) {
            cols[i2].pack();
            ++i2;
        }
    }

    public boolean performOk() {
        this.savePreferences();
        return super.performOk();
    }

    private void savePreferences() {
        TableItem[] items = this.warningsTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                this.store.setValue(this.indices[i], true);
            } else {
                this.store.setValue(this.indices[i], false);
            }
            ++i;
        }
    }

    private void doAllSelection(boolean selected) {
        TableItem[] items = this.warningsTable.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(selected);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void setColumn(Table table, String columnLabel) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
    }

    private void setColumns(Table table, String[] columnsLabels) {
        int i = 0;
        while (i < columnsLabels.length) {
            this.setColumn(table, columnsLabels[i]);
            ++i;
        }
    }

    public void init(IWorkbench arg0) {
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            if (e.widget == this.selectAllButton) {
                this.doAllSelection(true);
            } else if (e.widget == this.deselectAllButton) {
                this.doAllSelection(false);
            }
        }
        catch (Throwable err) {
            logger.error(err);
        }
    }
}

